/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.nokia.mid.ui.FullCanvas;
import game.SceneGame;
import java.io.DataInputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import logo.Logo;
import main.ExeMIDlet;
import menu.SceneMenu;
import util.CustomFont;
import util.GraphicsTool;
import util.Key;
import util.Load;
import util.MathTool;
import util.Scene;
import util.SoundManager;
import util.TextUtil;
import util.Utility;

public class MainCanvas
extends FullCanvas
implements Runnable {
    public static boolean m_GamePaused = false;
    public static boolean allPaused = false;
    public static boolean GameRunning = true;
    public static final int MAX_FPS_TIME = 100;
    public static String[] m_text = null;
    public static CustomFont m_font = null;
    public static Font font = null;
    public static int FontHeight = 0;
    public static int SND_MENUBACK = 0;
    public static int SND_WIN = 1;
    public static int SND_LOGO = 2;
    public String[] SND_CONTENT = new String[]{"/m.mid", "/logo.mid", "/win.mid"};
    public int[][] TOTAL_SOUND = new int[][]{{SND_MENUBACK, 0, 0}, {SND_WIN, 0, 0}, {SND_LOGO, 0, 1}};
    public boolean[] NEED_RESUME = new boolean[]{true, true, false};
    public static SoundManager m_music = null;
    public static Image img_arrow;
    public static Image img_db;
    public static Image img_db1;
    public static Image img_black;
    public static int corner_w;
    public static int corner_h;
    public static int bar_perw;
    public static int bar_perh;
    public static int contentmax;
    public static int arrow_height;
    public static int arrow_width;
    public static final int ARROW_UP = 0;
    public static final int ARROW_DOWN = 1;
    public static final int ARROW_LEFT = 2;
    public static final int ARROW_RIGHT = 3;
    public int primex = 0;
    public int primeanchor = 0;
    public int secondx = 0;
    public int secondanchor = 0;
    public static final int RECT_X = 0;
    public static final int RECT_Y = 1;
    public static final int RECT_W = 2;
    public static final int RECT_H = 3;
    Scene m_currentScene = null;
    public static int missionid;
    public static int areaid;
    public static int max_area;
    public static int MissionOpened;
    public static final int MAX_MISSION = 3;
    public static boolean hasSavedGame;
    public Load load = null;
    public Thread GameThread = null;
    public static MainCanvas m_instance;
    public ExeMIDlet m_midlet = null;
    public long FrameStart = 0L;

    public void ThreadStart() {
        this.GameThread = new Thread(this);
        this.GameThread.start();
    }

    public void ThreadStop() {
        this.GameThread = null;
        Utility.doGC();
    }

    public MainCanvas(ExeMIDlet mid) {
        try {
            this.m_midlet = mid;
            m_instance = this;
            this.primex = 0;
            this.secondx = 240;
            this.primeanchor = 4;
            this.secondanchor = 8;
            m_font = new CustomFont(Font.getFont((int)64, (int)0, (int)8));
            FontHeight = m_font.getFontHeight();
            font = Font.getFont((int)64, (int)0, (int)8);
            img_arrow = Image.createImage((String)"/arrow.png");
            img_db = Image.createImage((String)"/box.png");
            img_black = Image.createImage((String)"/240.png");
            corner_h = bar_perw = img_db.getWidth();
            corner_w = bar_perw;
            bar_perh = img_db.getHeight() - corner_w;
            arrow_width = img_arrow.getWidth() >> 2;
            arrow_height = img_arrow.getHeight();
            contentmax = 236 - (img_db.getWidth() << 1);
            m_music = new SoundManager(this.SND_CONTENT, this.TOTAL_SOUND, this.NEED_RESUME, true);
            this.changeScene(1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        try {
            if (allPaused) {
                g.setColor(0);
                g.fillRect(0, 0, 240, 320);
                TextUtil.Font_RenderStringsVectorSingle(g, TextUtil.Font_SplitString(MainCanvas.getString(24), m_font, contentmax), m_font, 120, 310, 33, 0xFFFFFF);
                return;
            }
            if (this.m_currentScene != null) {
                this.m_currentScene.render(g);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void run() {
        try {
            this.FrameStart = Utility.GetTime();
            while (GameRunning) {
                this.update((int)(Utility.GetTime() - this.FrameStart));
                this.FrameStart = Utility.GetTime();
                this.repaint();
                Utility.ThreadSleep(70L);
            }
            this.QuitApp();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void update(int TimeTaken) {
        try {
            if (allPaused) {
                return;
            }
            Key.UpdateKey();
            if (this.m_currentScene != null) {
                this.m_currentScene.processKeys();
                this.m_currentScene.update();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadTexts(String res) {
        try {
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(res));
            if (dis == null) {
                return;
            }
            int length = dis.readShort();
            m_text = new String[length];
            for (int i = 0; i < length; ++i) {
                MainCanvas.m_text[i] = dis.readUTF();
            }
            MainCanvas.m_text[25] = "\u66f4\u591a\u6e38\u620f";
            MainCanvas.m_text[11] = "\u53e4\u60d1\u82f1\u96c4\u4e4b\u8857\u5934\u6fc0\u6218\n\u7248\u672cv1.0\n\n\u8fd0\u8425\u5546\uff1a\n\u5e7f\u5dde\u8be0\u661f\u7f51\u7edc\u79d1\u6280\u6709\u9650\u516c\u53f8\n\n\u5ba2\u670d\u7535\u8bdd\uff1a95105518\n\u5ba2\u670d\u90ae\u7bb1\uff1acs@rockmobile.com.cn\n\n\u5185\u5bb9\u63d0\u4f9b\u5546\uff1a\n\u6df1\u5733\u5e02\u5fb7\u4f73\u4fe1\u606f\u79d1\u6280\u6709\u9650\u516c\u53f8\n\n";
            dis.close();
            dis = null;
            Utility.doGC();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getString(int id) {
        if (id >= 0 && id < m_text.length) {
            return m_text[id];
        }
        return "";
    }

    public void changeScene(int sceneID) {
        this.changeScene(sceneID, -1);
    }

    public void changeScene(int sceneID, int state) {
        Key.ClearKey();
        if (this.m_currentScene != null) {
            this.m_currentScene.end();
        }
        this.m_currentScene = null;
        Utility.doGC();
        switch (sceneID) {
            case 2: {
                this.m_currentScene = new SceneMenu(this, state);
                break;
            }
            case 1: {
                this.m_currentScene = new Logo(this, state);
                break;
            }
            case 3: {
                this.m_currentScene = new SceneGame(this, state);
                break;
            }
        }
        this.m_currentScene.loadScene();
        Key.ClearKey();
        this.repaint();
        this.serviceRepaints();
    }

    public void QuitApp() {
        try {
            this.m_currentScene.end();
            Utility.doGC();
            if (m_music != null) {
                m_music.Close();
                m_music = null;
            }
            this.ThreadStop();
            this.m_midlet.destroyApp(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void keyPressed(int KeyCode) {
        if (allPaused) {
            if (m_music != null) {
                m_music.Resume();
            }
            allPaused = false;
            return;
        }
        Key.keyPressed(KeyCode);
    }

    public void keyReleased(int KeyCode) {
        Key.keyReleased(KeyCode);
    }

    public void hideNotify() {
        try {
            this.Suspend();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void showNotify() {
        try {
            this.Resume();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void Suspend() {
        if (this.m_currentScene != null) {
            this.m_currentScene.pause();
        }
    }

    public void Resume() {
        if (this.m_currentScene != null) {
            this.m_currentScene.resume();
        }
        this.repaint();
        this.serviceRepaints();
    }

    public static boolean collision(int[] rect_1, int[] rect_2) {
        int radius_x1 = rect_1[2] >> 1;
        int radius_y1 = rect_1[3] >> 1;
        int radius_x2 = rect_2[2] >> 1;
        int radius_y2 = rect_2[3] >> 1;
        int cx1 = rect_1[0] + radius_x1;
        int cy1 = rect_1[1] + radius_y1;
        int cx2 = rect_2[0] + radius_x2;
        int cy2 = rect_2[1] + radius_y2;
        int dx = MathTool.getAbs(cx2 - cx1);
        int dy = MathTool.getAbs(cy2 - cy1);
        return dx <= radius_x1 + radius_x2 && dy <= radius_y1 + radius_y2;
    }

    public static boolean IsBlinking() {
        return Utility.GetTime() / 200L % 2L != 0L;
    }

    public static void drawArrow(Graphics g, int id, int x, int y, int anchor) {
        GraphicsTool.DrawRegion(g, img_arrow, arrow_width * id, 0, arrow_width, arrow_height, x, y, anchor);
    }

    public static final void drawblack(Graphics g) {
        int perw = img_black.getWidth();
        int perh = img_black.getHeight();
        int nw = 240 / perw + 1;
        int nh = 320 / perh + 1;
        for (int i = 0; i < nw; ++i) {
            for (int j = 0; j < nh; ++j) {
                GraphicsTool.DrawRegion(g, img_black, 0, 0, perw, perh, perw * i, perh * j, 20);
            }
        }
        GraphicsTool.ClipAll(g);
    }

    public static void drawBox(Graphics g, int bar_nw, int bar_nh, int start_x, int start_y, int bar_x, int bar_y, int cb_w, int cb_h, boolean canup, boolean candown, int arrow_x, int y_arrowup, int y_arrowdown) {
        int i;
        for (i = 0; i < bar_nw; ++i) {
            GraphicsTool.DrawRegion(g, img_db, 0, corner_h, bar_perw, bar_perh, bar_x + bar_perw * i, start_y, 20);
            GraphicsTool.ClipAll(g);
            GraphicsTool.DrawRegion(g, img_db, 0, corner_h, bar_perw, bar_perh, bar_x + bar_perw * i, start_y + cb_h, 1, 36);
            GraphicsTool.ClipAll(g);
        }
        for (i = 0; i < bar_nh; ++i) {
            GraphicsTool.DrawRegion(g, img_db, 0, corner_h, bar_perw, bar_perh, start_x, bar_y + bar_perw * i, 6, 20);
            GraphicsTool.ClipAll(g);
            GraphicsTool.DrawRegion(g, img_db, 0, corner_h, bar_perw, bar_perh, start_x + cb_w, bar_y + bar_perw * i, 5, 24);
            GraphicsTool.ClipAll(g);
        }
        GraphicsTool.DrawRegion(g, img_db, 0, 0, corner_w, corner_h, start_x, start_y, 20);
        GraphicsTool.ClipAll(g);
        GraphicsTool.DrawRegion(g, img_db, 0, 0, corner_w, corner_h, start_x + cb_w, start_y, 2, 24);
        GraphicsTool.ClipAll(g);
        GraphicsTool.DrawRegion(g, img_db, 0, 0, corner_w, corner_h, start_x, start_y + cb_h, 1, 36);
        GraphicsTool.ClipAll(g);
        GraphicsTool.DrawRegion(g, img_db, 0, 0, corner_w, corner_h, start_x + cb_w, start_y + cb_h, 3, 40);
        GraphicsTool.ClipAll(g);
        if (canup) {
            MainCanvas.drawArrow(g, 0, arrow_x, y_arrowup, 33);
        }
        if (candown) {
            MainCanvas.drawArrow(g, 1, arrow_x, y_arrowdown, 17);
        }
    }

    static {
        img_db1 = null;
        img_black = null;
        corner_w = 0;
        corner_h = 0;
        bar_perw = 0;
        bar_perh = 0;
        contentmax = 0;
        arrow_height = 0;
        arrow_width = 0;
        missionid = 0;
        areaid = 0;
        max_area = 0;
        MissionOpened = 0;
        hasSavedGame = false;
        m_instance = null;
    }
}

