/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsTool {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;

    public static void FillRect(Graphics g, int FillColor, int StartX, int StartY, int FillWidth, int FillHeight) {
        g.setColor(FillColor);
        g.fillRect(StartX, StartY, FillWidth, FillHeight);
    }

    public static void DrawRect(Graphics g, int Color, int StartX, int StartY, int FillWidth, int FillHeight) {
        g.setColor(Color);
        g.drawRect(StartX, StartY, FillWidth, FillHeight);
    }

    public static void ClipArea(Graphics g, int x, int y, int w, int h) {
        g.setClip(x, y, w, h);
    }

    public static void ClipAll(Graphics g) {
        GraphicsTool.ClipArea(g, 0, 0, 240, 320);
    }

    public static void DrawRegion(Graphics g, Image m_image, int distx, int disty, int w, int h, int x, int y, int anchor) {
        if ((anchor & 8) == 8) {
            x -= w;
        } else if ((anchor & 1) == 1) {
            x -= w >> 1;
        }
        if ((anchor & 0x20) == 32) {
            y -= h;
        } else if ((anchor & 2) == 2) {
            y -= h >> 1;
        }
        GraphicsTool.ClipArea(g, x, y, w, h);
        g.drawImage(m_image, x - distx, y - disty, 20);
    }

    public static void DrawRegion(Graphics g, Image m_image, int distx, int disty, int w, int h, int x, int y, int trans, int anchor) {
        if (trans == 0) {
            GraphicsTool.DrawRegion(g, m_image, distx, disty, w, h, x, y, anchor);
        } else {
            int newx = 0;
            int newy = 0;
            int neww = 0;
            int newh = 0;
            switch (trans) {
                case 2: {
                    newx = m_image.getWidth() - w - distx;
                    newy = disty;
                    neww = w;
                    newh = h;
                    trans = 8192;
                    break;
                }
                case 1: {
                    newx = distx;
                    newy = m_image.getHeight() - h - disty;
                    neww = w;
                    newh = h;
                    trans = 16384;
                    break;
                }
                case 3: {
                    newx = m_image.getWidth() - w - distx;
                    newy = m_image.getHeight() - h - disty;
                    neww = w;
                    newh = h;
                    trans = 180;
                    break;
                }
                case 5: {
                    newx = m_image.getHeight() - h - disty;
                    newy = distx;
                    neww = h;
                    newh = w;
                    trans = 270;
                    break;
                }
                case 6: {
                    newx = disty;
                    newy = m_image.getWidth() - w - distx;
                    neww = h;
                    newh = w;
                    trans = 90;
                    break;
                }
                default: {
                    newx = distx;
                    newy = disty;
                    neww = w;
                    newh = h;
                    trans = 0;
                }
            }
            if ((anchor & 8) == 8) {
                x -= neww;
            } else if ((anchor & 1) == 1) {
                x -= neww >> 1;
            }
            if ((anchor & 0x20) == 32) {
                y -= newh;
            } else if ((anchor & 2) == 2) {
                y -= newh >> 1;
            }
            GraphicsTool.ClipArea(g, x, y, neww, newh);
            DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
            dg.drawImage(m_image, x - newx, y - newy, 20, trans);
            GraphicsTool.ClipAll(g);
        }
    }
}

