/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class SoundManager {
    public boolean SOUND_ON = true;
    private String[] snd_content = null;
    private int[][] total_sound = null;
    private static final int SND_INDEX = 0;
    private static final int SND_TYPE = 1;
    private static final int SND_USE = 2;
    private static final int SND_SIZE = 3;
    private boolean[] resume = null;
    public static final int TYPE_MIDI = 0;
    public static final int TYPE_AMR = 1;
    public static final int TYPE_MMF = 2;
    public static final int TYPE_WAV = 3;
    private static final String[] TYPE_CONTENT = new String[]{"audio/midi", "audio/amr", "audio/mmf", "audio/x-wav"};
    private Player[] m_multisound = null;
    private Player m_singlesound = null;
    private boolean IsSinglePlayer = false;
    public int m_cursoundID = -1;
    public int m_curLoop = -1;

    public SoundManager(String[] content, int[][] total, boolean[] needresume, boolean single) {
        this.snd_content = content;
        this.total_sound = total;
        this.resume = needresume;
        this.IsSinglePlayer = single;
        if (!this.IsSinglePlayer) {
            this.LoadSounds();
        }
    }

    private void LoadSounds() {
        try {
            this.m_multisound = new Player[this.total_sound.length];
            for (int i = 0; i < this.total_sound.length; ++i) {
                this.CreatePlayer(this.total_sound[i][0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void CreatePlayer(int id) {
        try {
            if (this.total_sound[id][2] == 1) {
                return;
            }
            InputStream is = null;
            is = this.getClass().getResourceAsStream(this.snd_content[this.total_sound[id][0]]);
            if (is == null) {
                return;
            }
            if (!this.IsSinglePlayer) {
                this.m_multisound[id] = Manager.createPlayer((InputStream)is, (String)TYPE_CONTENT[this.total_sound[id][1]]);
                this.m_multisound[id].realize();
                this.m_multisound[id].prefetch();
            } else {
                this.m_singlesound = Manager.createPlayer((InputStream)is, (String)TYPE_CONTENT[this.total_sound[id][1]]);
                this.m_singlesound.realize();
                this.m_singlesound.prefetch();
            }
            is.close();
            is = null;
            System.gc();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void PlaySound(int id, int loop) {
        try {
            block18: {
                block15: {
                    block17: {
                        block16: {
                            if (!this.SOUND_ON) {
                                return;
                            }
                            if (id == -1) {
                                return;
                            }
                            System.out.println("this is Sound Eorror ====================> " + this.SOUND_ON);
                            if (this.total_sound[id][2] == 1) {
                                return;
                            }
                            if (this.IsSinglePlayer) break block15;
                            if (this.m_multisound[id] == null) break block16;
                            this.m_multisound[id];
                            if (this.m_multisound[id].getState() == 0) break block17;
                        }
                        this.ChangePlayer(id);
                    }
                    if (id != this.m_cursoundID && this.m_cursoundID != -1) {
                        this.StopSound(this.m_cursoundID);
                    }
                    this.m_multisound[id];
                    if (this.m_multisound[id].getState() != 400) {
                        this.m_multisound[id].prefetch();
                        this.m_multisound[id].setLoopCount(loop);
                        this.m_multisound[id].start();
                    }
                    break block18;
                }
                if (this.m_singlesound == null) ** GOTO lbl-1000
                if (this.m_singlesound.getState() == 0) lbl-1000:
                // 2 sources

                {
                    this.CreatePlayer(id);
                } else if (id != this.m_cursoundID && this.m_cursoundID != -1) {
                    this.ChangePlayer(id);
                }
                if (this.m_singlesound.getState() != 400) {
                    this.m_singlesound.prefetch();
                    this.m_singlesound.setLoopCount(loop);
                    this.m_singlesound.start();
                }
            }
            this.m_cursoundID = id;
            this.m_curLoop = loop;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void StopCurrentSound() {
        this.StopSound(this.m_cursoundID);
    }

    private void StopSound(int id) {
        try {
            if (id == -1) {
                return;
            }
            if (this.total_sound[id][2] == 1) {
                return;
            }
            if (this.IsSinglePlayer) {
                if (this.m_singlesound == null) {
                    return;
                }
                if (this.m_singlesound.getState() == 400) {
                    this.m_singlesound.stop();
                }
            } else {
                if (this.m_multisound[id] == null) {
                    return;
                }
                Player cfr_ignored_0 = this.m_multisound[id];
                if (this.m_multisound[id].getState() == 400) {
                    this.m_multisound[id].stop();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void ChangePlayer(int id) {
        try {
            this.ReleaseSound(id);
            this.CreatePlayer(id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void SwitchControl() {
        this.SetSwitchStatus(!this.SOUND_ON);
        if (!this.SOUND_ON) {
            this.StopCurrentSound();
        } else {
            this.PlaySound(this.m_cursoundID, this.m_curLoop);
        }
    }

    public void SetSwitchStatus(boolean flag) {
        this.SOUND_ON = flag;
    }

    public boolean GetSwitchStatus() {
        return this.SOUND_ON;
    }

    private void ReleaseSound(int id) {
        try {
            this.StopSound(id);
            if (this.IsSinglePlayer) {
                if (this.m_singlesound != null) {
                    this.m_singlesound.deallocate();
                    this.m_singlesound.close();
                    this.m_singlesound = null;
                }
            } else if (this.m_multisound[id] != null) {
                this.m_multisound[id].deallocate();
                this.m_multisound[id].close();
                this.m_multisound[id] = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void ReleaseAllSounds() {
        if (this.IsSinglePlayer) {
            return;
        }
        for (int i = 0; i < this.total_sound.length; ++i) {
            this.ReleaseSound(i);
        }
    }

    public void Close() {
        if (this.IsSinglePlayer) {
            this.ReleaseSound(0);
        } else {
            this.ReleaseAllSounds();
        }
        System.gc();
    }

    public void Suspend() {
        this.StopCurrentSound();
    }

    public void Resume() {
        if (this.m_cursoundID != -1 && this.resume[this.m_cursoundID]) {
            this.PlaySound(this.m_cursoundID, this.m_curLoop);
        }
    }
}

