/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import util.CustomFont;

public class TextUtil {
    public static int Font_GetStringWidth(CustomFont font, String _str) {
        return font.stringWidth(_str);
    }

    public static Vector Font_SplitString(String _in, CustomFont font, int _width) {
        if (null == font) {
            return null;
        }
        Vector<String> out = new Vector<String>();
        int begin = 0;
        int end = 0;
        int linewidth = 0;
        int strlen = _in.length();
        int i = 0;
        while (i <= strlen) {
            boolean cut = false;
            char ch = '\n';
            if (i < strlen) {
                ch = _in.charAt(i);
            }
            if (ch == '\n') {
                cut = true;
            } else if (linewidth + font.getCharacterWidth(ch) >= _width) {
                cut = true;
            } else {
                linewidth += font.getCharacterWidth(ch);
            }
            if (cut) {
                end = i++;
                if (ch == '\n') {
                    // empty if block
                }
                out.addElement(_in.substring(begin, end));
                begin = i;
                linewidth = 0;
                continue;
            }
            ++i;
        }
        return out;
    }

    public static final void Font_RenderString(Graphics _Graphics, String _String, CustomFont _font, int _x, int _y, int _Flags, int _TextColor) {
        if (_font == null) {
            return;
        }
        int TextWidth = _font.stringWidth(_String);
        int TextHeight = _font.getFontHeight();
        if ((_Flags & 1) != 0) {
            _x -= TextWidth >> 1;
        }
        if ((_Flags & 8) != 0) {
            _x -= TextWidth;
        }
        if ((_Flags & 2) != 0) {
            _y -= TextHeight >> 1;
        }
        if ((_Flags & 0x20) != 0) {
            _y -= TextHeight;
        }
        _font.setFont(_Graphics);
        _Graphics.setColor(_TextColor);
        _Graphics.drawString(_String, _x, _y, 20);
    }

    public static final void Font_RenderString(Graphics _Graphics, String _String, CustomFont _font, int _x, int _y, int _Flags, int _TextColor, int _OutlineColor) {
        if (_font == null) {
            return;
        }
        int TextWidth = _font.stringWidth(_String);
        int TextHeight = _font.getFontHeight();
        if ((_Flags & 1) != 0) {
            _x -= TextWidth >> 1;
        }
        if ((_Flags & 8) != 0) {
            _x -= TextWidth;
        }
        if ((_Flags & 2) != 0) {
            _y -= TextHeight >> 1;
        }
        if ((_Flags & 0x20) != 0) {
            _y -= TextHeight;
        }
        _font.setFont(_Graphics);
        _Graphics.setColor(_OutlineColor);
        _Graphics.drawString(_String, _x - 1, _y, 20);
        _Graphics.drawString(_String, _x + 1, _y, 20);
        _Graphics.drawString(_String, _x, _y - 1, 20);
        _Graphics.drawString(_String, _x, _y + 1, 20);
        _Graphics.setColor(_TextColor);
        _Graphics.drawString(_String, _x, _y, 20);
    }

    static final String Font_Sprintf(String _FmtString, Object[] _Values) {
        String Result = new String(_FmtString);
        if (null == _Values) {
            return Result;
        }
        for (int i = _Values.length - 1; i >= 0; --i) {
            String Tmp = "%" + (i + 1);
            int Idx = Result.indexOf(Tmp);
            if (Idx < 0) continue;
            Tmp = Result.substring(Idx + Tmp.length());
            String Value = null == _Values[i] ? "null" : _Values[i].toString();
            Result = Result.substring(0, Idx) + Value + Tmp;
        }
        return Result;
    }

    public static final void Font_RenderStringsVector(Graphics _Graphics, Vector _Vector, CustomFont _font, int _x, int _y, int _Flags, int _TextColor, int _OutlineColor) {
        if (_font == null) {
            return;
        }
        int TotalTextHeight = _font.getLineHeight() * _Vector.size();
        if ((_Flags & 2) != 0) {
            _y -= TotalTextHeight / 2;
            _y += _font.getLineHeight() / 2;
        }
        if ((_Flags & 0x20) != 0) {
            _y -= TotalTextHeight;
            _y += _font.getLineHeight();
        }
        for (int line = 0; line < _Vector.size(); ++line) {
            TextUtil.Font_RenderString(_Graphics, (String)_Vector.elementAt(line), _font, _x, _y + line * _font.getLineHeight(), _Flags, _TextColor, _OutlineColor);
        }
    }

    public static final void Font_RenderStringsVectorSingle(Graphics _Graphics, Vector _Vector, CustomFont _font, int _x, int _y, int _Flags, int _TextColor) {
        if (_font == null) {
            return;
        }
        int TotalTextHeight = _font.getLineHeight() * _Vector.size();
        if ((_Flags & 2) != 0) {
            _y -= TotalTextHeight / 2;
            _y += _font.getLineHeight() / 2;
        }
        if ((_Flags & 0x20) != 0) {
            _y -= TotalTextHeight;
            _y += _font.getLineHeight();
        }
        for (int line = 0; line < _Vector.size(); ++line) {
            TextUtil.Font_RenderString(_Graphics, (String)_Vector.elementAt(line), _font, _x, _y + line * _font.getLineHeight(), _Flags, _TextColor);
        }
    }
}

