/*
 * Decompiled with CFR 0.152.
 */
package com.game.cannonball;

import com.game.cannonball.ICannonball;
import com.game.cannonball.RectCoordinate;
import com.game.monster.Monster;
import com.game.sprite.SpriteX;
import com.game.util.Graphics2D;
import javax.microedition.lcdui.Image;

public class CannonballCherry
extends SpriteX
implements ICannonball {
    private int hp;
    private int cannonballId;
    private int state;
    private RectCoordinate rect = null;
    private int speed;

    public CannonballCherry(byte[] file, Image img, int id) {
        super(file, img);
        this.setAction(0);
        this.rect = new RectCoordinate();
        this.rect.setHeight(20);
        this.rect.setWidth(this.getWidth());
        this.cannonballId = id;
    }

    public int getCannonballId() {
        return this.cannonballId;
    }

    public void logic() {
        if (this.getY() <= -70) {
            this.state = 1;
        }
        switch (this.state) {
            case 0: {
                this.move(0, -this.speed);
                break;
            }
            case 4: {
                if (this.getFrame() < this.getSequenceLength() - 1) break;
                this.setVisible(false);
                this.setState(1);
            }
        }
    }

    public final void paint(Graphics2D g) {
        super.paint(g);
    }

    public void setBallPosition(int x, int y) {
        this.setPosition(x, y);
    }

    public boolean collisionWithMonster(Monster monster, int monsterIndex) {
        this.rect.setX(this.getX() - this.getWidth() / 2);
        this.rect.setY(this.getY() - this.getHeight() / 2);
        if (!this.rect.collisionWithMonster(monster.getRect())) {
            return false;
        }
        this.setState(4);
        this.setAction(1);
        monster.changeState(4);
        return true;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setHp(int hp) {
        this.hp = hp;
    }

    public int getHp() {
        return this.hp;
    }
}

