/*
 * Decompiled with CFR 0.152.
 */
package com.game.cannonball;

import com.game.ManagerConture;
import com.game.cannonball.ICannonball;
import com.game.cannonball.RectCoordinate;
import com.game.cannonball.WateBoom;
import com.game.monster.Monster;
import com.game.rms.GameRms;
import com.game.sprite.SpriteX;
import com.game.util.Graphics2D;
import javax.microedition.lcdui.Image;

public class CannonballWate
extends SpriteX
implements ICannonball {
    private int hp;
    private int speed;
    private int cannonballId;
    private int state;
    private RectCoordinate rect = null;
    private boolean isBoom = true;
    private Image img = null;
    private int shotY = 0;

    public CannonballWate(byte[] path, Image img, int id, int y) {
        super(path, img);
        this.img = img;
        this.setAction(0);
        this.rect = new RectCoordinate();
        this.rect.setWidth(this.getWidth());
        this.rect.setHeight(30);
        this.cannonballId = id;
        this.shotY = 320 - y - 74;
    }

    public int getCannonballId() {
        return this.cannonballId;
    }

    public void logic() {
        if (this.getY() <= -70) {
            this.state = 1;
        }
        switch (this.state) {
            case 0: {
                this.move(0, -this.speed);
                break;
            }
            case 4: {
                if (this.getFrame() < this.getSequenceLength() - 1) break;
                this.state = 1;
                if (GameRms.rmsIce == 1) {
                    ManagerConture.listWate.add(new WateBoom("/res/cannonball/ice/icexigua.sprite", this.img, this.getX(), this.getY(), this.hp));
                    break;
                }
                ManagerConture.listWate.add(new WateBoom("/res/cannonball/wate.sprite", this.img, this.getX(), this.getY(), this.hp));
            }
        }
        if (Math.abs(this.getY() - 320) > this.shotY + 72 && this.isBoom) {
            this.isBoom = false;
            this.setState(4);
            this.setAction(1);
        }
        if (!this.isBoom) {
            if (this.getFrame() == 2) {
                return;
            }
            this.updateNxet();
        }
    }

    public final void paint(Graphics2D g) {
        if (!this.visible) {
            return;
        }
        this.paint(g, this.x + this.offsetX, this.y + this.offsetY);
        if (Math.abs(this.getY() - 320) > 72 + this.getFrame() * (this.shotY / 10) && this.getFrame() != this.getSequenceLength() - 1) {
            this.setFrame(this.getFrame() + 1);
        }
    }

    public void setBallPosition(int x, int y) {
        this.setPosition(x, y);
    }

    public boolean collisionWithMonster(Monster monster, int monsterIndex) {
        return true;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setHp(int hp) {
        this.hp = hp;
    }

    public int getHp() {
        return this.hp;
    }
}

