/*
 * Decompiled with CFR 0.152.
 */
package com.game.rms;

import com.game.ManagerConture;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;

public final class GameRms {
    private static final String gameName = "CrazyDog";
    private static final String RECORDNAME = "CrazyDog_record";
    public static final byte SEND = 1;
    private static final byte GAME = 2;
    private static final String GAMENAME = "CrazyDog_game";
    public static int rmsIce = 0;
    public static int rmsCherry = 0;
    public static int rmsGrape = 0;
    public static int rmsMealie = 0;
    public static int rmsPineApple = 0;
    public static int rmsWate = 0;
    public static int rmsBigGun = 0;
    public static int rmsYuanZiDanCount = 0;
    public static int rmsBarrier = 0;
    public static int rmsFireLever = 1;
    public static int rmsMoney = 0;
    public static int rmsFenShu = 0;
    public static int rmsCurGate = 1;
    public static int rmsCurModel = 0;
    public static int rmsDogHp;

    private static final void writeRMS(byte[] data, String recordName, int index) {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)recordName, (boolean)true);
            if (rs.getNumRecords() < index) {
                for (int i = 1; i < index; ++i) {
                    byte[] tem = null;
                    try {
                        tem = rs.getRecord(i);
                    }
                    catch (Exception ex) {
                        tem = null;
                    }
                    if (tem == null) {
                        rs.addRecord(new byte[]{0}, 0, 1);
                        continue;
                    }
                    if (tem.length < 1) continue;
                }
                rs.addRecord(data, 0, data.length);
            } else {
                rs.setRecord(index, data, 0, data.length);
            }
            rs.closeRecordStore();
            rs = null;
        }
        catch (Exception ex) {
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                    rs = null;
                }
                ex.printStackTrace();
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
    }

    private static final byte[] readRMS(String recordName, int index) {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)recordName, (boolean)true);
            String[] tem = RecordStore.listRecordStores();
            if (tem == null && rs.getNumRecords() < index) {
                return null;
            }
            byte[] data = null;
            try {
                data = rs.getRecord(index);
            }
            catch (Exception ex) {
                data = null;
            }
            rs.closeRecordStore();
            if (data == null) {
                return null;
            }
            if (data.length == 1) {
                return null;
            }
            return data;
        }
        catch (Exception ex) {
            try {
                if (rs != null) {
                    rs = null;
                }
                ex.printStackTrace();
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            return null;
        }
    }

    public static final void writeRecord(byte[] data, int index) {
        try {
            GameRms.writeRMS(data, RECORDNAME, index + 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final byte[] readRecord(int index) {
        try {
            return GameRms.readRMS(GAMENAME, index + 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static final void writeGameData(byte[] data, int index) {
        try {
            GameRms.writeRMS(data, GAMENAME, index + 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final byte[] readGameData(int index) {
        try {
            return GameRms.readRMS(GAMENAME, index + 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePlayerInfo() {
        byte[] bData = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream bos = new DataOutputStream(baos);
        try {
            bos.writeInt(rmsIce);
            bos.writeInt(rmsCherry);
            bos.writeInt(rmsGrape);
            bos.writeInt(rmsMealie);
            bos.writeInt(rmsPineApple);
            bos.writeInt(rmsWate);
            bos.writeInt(rmsBigGun);
            bos.writeInt(rmsYuanZiDanCount);
            bos.writeInt(rmsBarrier);
            bos.writeInt(rmsFireLever);
            bos.writeInt(rmsMoney);
            bos.writeInt(rmsFenShu);
            bos.writeInt(rmsCurGate);
            bos.writeInt(rmsDogHp);
            bos.writeInt(rmsCurModel);
            bData = baos.toByteArray();
            GameRms.writeGameData(bData, 0);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                bos.close();
                baos.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readPlayerInfo() {
        byte[] bData = GameRms.readGameData(0);
        ByteArrayInputStream in = new ByteArrayInputStream(bData, 0, bData.length);
        DataInputStream dIn = new DataInputStream(in);
        try {
            rmsIce = dIn.readInt();
            rmsCherry = dIn.readInt();
            rmsGrape = dIn.readInt();
            rmsMealie = dIn.readInt();
            rmsPineApple = dIn.readInt();
            rmsWate = dIn.readInt();
            rmsBigGun = dIn.readInt();
            rmsYuanZiDanCount = dIn.readInt();
            rmsBarrier = dIn.readInt();
            rmsFireLever = dIn.readInt();
            rmsMoney = dIn.readInt();
            rmsFenShu = dIn.readInt();
            rmsCurGate = dIn.readInt();
            rmsDogHp = dIn.readInt();
            rmsCurModel = dIn.readInt();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                dIn.close();
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void initRms(int model) {
        rmsCherry = 0;
        rmsGrape = 0;
        rmsMealie = 0;
        rmsPineApple = 0;
        rmsWate = 0;
        rmsBigGun = 0;
        rmsYuanZiDanCount = 1;
        rmsBarrier = 0;
        rmsFireLever = 1;
        rmsMoney = 100000;
        rmsFenShu = 0;
        rmsCurGate = 1;
        rmsIce = 0;
        rmsDogHp = 10;
        switch (model) {
            case 0: {
                rmsCurModel = 0;
                rmsMoney = 30000;
                break;
            }
            case 1: {
                rmsCurModel = 1;
                rmsMoney = 10000;
                break;
            }
            case 2: {
                rmsCurModel = 2;
                rmsMoney = 1000;
                break;
            }
            case 3: {
                rmsCurModel = 1;
                rmsMoney = 10000;
                rmsCurGate = 15;
                ManagerConture.isWuXian = true;
            }
        }
    }
}

