/*
 * Decompiled with CFR 0.152.
 */
package com.game.sprite;

import com.game.sprite.ILayer;
import com.game.util.Graphics2D;

public final class LayerManager {
    private ILayer[] layers = new ILayer[5];
    private int size;
    private int viewX;
    private int viewY;
    private boolean visible = true;

    public final void append(ILayer l) {
        if (this.size == this.layers.length) {
            ILayer[] newLayers = new ILayer[this.size + 1];
            System.arraycopy(this.layers, 0, newLayers, 0, this.size);
            this.layers = newLayers;
        }
        this.layers[this.size] = l;
        ++this.size;
    }

    public final void insert(ILayer l, int index) {
        ILayer[] source;
        if (index > this.size) {
            throw new IndexOutOfBoundsException("unable to insert layer at index [" + index + "] when the size is [" + this.size + "].");
        }
        this.remove(l);
        if (index > this.size) {
            index = this.size;
        }
        if (this.size == (source = this.layers).length || index == source.length) {
            ILayer[] newLayers = new ILayer[this.size + 4];
            System.arraycopy(this.layers, 0, newLayers, 0, this.size);
            source = newLayers;
        }
        for (int i = this.size; i > index; --i) {
            source[i] = source[i - 1];
        }
        source[index] = l;
        this.layers = source;
        ++this.size;
    }

    public final ILayer getLayerAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("unable to get layer at [" + index + "] of LayerManager with a size of [" + this.size + "] layers.");
        }
        return this.layers[index];
    }

    public final int getSize() {
        return this.size;
    }

    public final void removeAll() {
        this.layers = null;
        this.layers = new ILayer[5];
        this.size = 0;
    }

    public final void remove(ILayer l) {
        ILayer[] source = this.layers;
        boolean layerFound = false;
        for (int i = 0; i < this.size; ++i) {
            ILayer layer = source[i];
            if (layerFound) {
                source[i] = source[i + 1];
                continue;
            }
            if (layer != l) continue;
            layerFound = true;
            --this.size;
            if (i == this.size) continue;
            source[i] = source[i + 1];
        }
        if (layerFound) {
            source[this.size] = null;
        }
    }

    public final void paint(Graphics2D g) {
        if (!this.visible) {
            return;
        }
        if (this.size <= 0) {
            return;
        }
        g.translate(this.viewX, this.viewY);
        for (int i = 0; i < this.size; ++i) {
            ILayer layer = this.layers[i];
            if (layer == null) continue;
            if (layer.isRemove()) {
                this.remove(layer);
                if (this.size == 0) break;
                --i;
                continue;
            }
            layer.paint(g);
        }
        g.translate(-this.viewX, -this.viewY);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final void setViewWindow(int x, int y) {
        this.viewX = x;
        this.viewY = y;
    }
}

