/*
 * Decompiled with CFR 0.152.
 */
package com.linkyun.screen;

import com.linkyun.config.DeviceConfig;
import com.linkyun.midlet.MainMidlet;
import com.linkyun.screen.InterruptScreen;
import com.linkyun.screen.LogoScreen;
import com.linkyun.screen.StandardScreen;
import com.linkyun.tools.MusicPlayer;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class ScreenManage
extends Canvas
implements Runnable {
    private static ScreenManage m_ScreenManage = null;
    private static StandardScreen m_CurrentScreen = null;
    private static StandardScreen m_ReturnScreen = null;
    private static final byte m_bytInterval = 100;
    private static int m_nFrameCounter = 0;
    private static boolean m_bInterrupt = false;
    private static boolean m_bPause = false;
    private static boolean m_bRefresh = true;
    private static int m_nKeyCode = -999;
    private static boolean m_bRepeatedKeyCode = false;
    public static boolean m_bPointerDragged = false;
    private static int m_nPointerX = -1;
    private static int m_nPointerY = -1;
    private static String m_sUrl = null;
    private static boolean m_bExit;

    public ScreenManage() {
        this.setFullScreenMode(true);
        this.init();
    }

    private void init() {
        m_ScreenManage = this;
        m_CurrentScreen = new LogoScreen();
        ScreenManage.setCurrentScreen(m_CurrentScreen);
    }

    public void start() {
        new Thread(this).start();
    }

    public void run() {
        while (!m_bExit) {
            if (m_bInterrupt || m_CurrentScreen == null) {
                if (!Thread.currentThread().isAlive()) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {}
                continue;
            }
            long tmp_lInterval = System.currentTimeMillis();
            this.input();
            this.logic();
            if (m_bRefresh) {
                this.repaint();
                this.serviceRepaints();
            }
            ++m_nFrameCounter;
            tmp_lInterval = System.currentTimeMillis() - tmp_lInterval;
            tmp_lInterval = tmp_lInterval < 100L ? 100L - tmp_lInterval : 1L;
            try {
                Thread.sleep(tmp_lInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        MainMidlet.exit(m_sUrl);
    }

    public void click(int x, int y) {
        if (m_nPointerX != -1 || m_nPointerY != -1) {
            m_CurrentScreen.click(x, y);
            if (!m_bPointerDragged) {
                m_nPointerX = -1;
                m_nPointerY = -1;
            }
        }
    }

    public void input() {
        if (m_nKeyCode != -999) {
            m_CurrentScreen.input(m_nKeyCode);
            if (!m_bRepeatedKeyCode) {
                m_nKeyCode = -999;
            }
        }
    }

    public void logic() {
        m_CurrentScreen.logic();
    }

    protected void paint(Graphics g) {
        g.setClip(0, 0, 240, 320);
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        g.setFont(DeviceConfig.FONT);
        m_CurrentScreen.paint(g);
    }

    protected void keyPressed(int key) {
        m_nKeyCode = key;
    }

    protected void keyRepeated(int key) {
        m_bRepeatedKeyCode = true;
        m_nKeyCode = key;
    }

    protected void keyReleased(int key) {
        if (m_bRepeatedKeyCode) {
            m_bRepeatedKeyCode = false;
            m_nKeyCode = -999;
        }
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
        m_bPointerDragged = true;
        m_nPointerX = x;
        m_nPointerY = y;
    }

    protected void pointerReleased(int x, int y) {
        if (m_bPointerDragged) {
            m_bPointerDragged = false;
            m_nPointerX = -1;
            m_nPointerY = -1;
        } else {
            m_nPointerX = x;
            m_nPointerY = y;
        }
    }

    public void hideNotify() {
        m_bInterrupt = true;
        if (MusicPlayer.m_bSound) {
            MusicPlayer.pauseMusic();
        }
        ScreenManage.setCurrentScreen(new InterruptScreen());
    }

    public void showNotify() {
        m_bInterrupt = false;
    }

    public static StandardScreen getCurrentScreen() {
        return m_CurrentScreen;
    }

    public static void setCurrentScreen(StandardScreen _StandardScreen) {
        if (m_CurrentScreen != null && ScreenManage.m_CurrentScreen.m_bIsClearRes) {
            m_CurrentScreen.clearRes();
            m_CurrentScreen = null;
            System.gc();
        }
        if (!(_StandardScreen instanceof InterruptScreen)) {
            m_ReturnScreen = _StandardScreen;
        }
        m_CurrentScreen = _StandardScreen;
    }

    public static StandardScreen getReturnScreen() {
        return m_ReturnScreen;
    }

    public static int getFrameCount() {
        return m_nFrameCounter;
    }

    public static boolean isM_bPause() {
        return m_bInterrupt;
    }

    public static void setM_bPause(boolean aM_bPause) {
        m_bInterrupt = aM_bPause;
    }

    public static boolean isM_bRefresh() {
        return m_bRefresh;
    }

    public static void setM_bRefresh(boolean aM_bRefresh) {
        m_bRefresh = aM_bRefresh;
    }

    public static void exit(String url) {
        m_bExit = true;
        m_sUrl = url;
    }
}

