/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.customise.Function;
import com.sinaflying.database.DataTable;
import com.sinaflying.database.GameDB;
import com.sinaflying.engine.Avatar;
import com.sinaflying.engine.ResourceManager;
import com.sinaflying.game.Actor;
import com.sinaflying.game.Bomb;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.Scene;
import com.sinaflying.game.SceneUI;
import javax.microedition.lcdui.Graphics;

public class Device
extends Actor {
    private int _state;
    private int _time;
    private int _destX;
    private int _destY;
    private int _resoX;
    private int _resoY;
    private int[] _boxInfo;
    private int[] _numInfo;

    public Device(int n, Avatar avatar) {
        super(n, avatar);
    }

    public boolean init(byte[] byArray) {
        super.init(byArray);
        switch (this._type) {
            case 97: {
                this.boxInit();
                break;
            }
            case 98: {
                this.boardInit();
                break;
            }
            case 96: {
                break;
            }
            case 99: {
                this.exploderInit();
            }
        }
        return true;
    }

    public void init(int n, int n2, int n3) {
        super.init(n, n2, n3);
        switch (this._type) {
            case 97: {
                this._numInfo = new int[5];
                this._boxInfo = new int[4];
            }
        }
    }

    public void ai() {
        switch (this._type) {
            case 97: {
                break;
            }
            case 98: {
                this.boardAi();
                break;
            }
            case 96: {
                break;
            }
            case 99: {
                this.exploderAi();
            }
        }
    }

    public void step() {
        super.step();
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        super.draw(graphics, n, n2, n3, n4);
        this.drawActorInfo(graphics, n, n2);
    }

    private void drawActorInfo(Graphics graphics, int n, int n2) {
        switch (this._type) {
            case 97: {
                this.drawBoxMoneyInfo(graphics, n, n2);
            }
        }
    }

    private void boxInit() {
        this._numInfo = new int[5];
        this._boxInfo = new int[4];
        this._boxInfo[0] = Scene._actorInitData[this._id][7];
        this._boxInfo[1] = Scene._actorInitData[this._id][8];
        this._boxInfo[2] = Scene._actorInitData[this._id][9];
        this._boxInfo[3] = Scene._actorInitData[this._id][10] * 100;
    }

    public void collideBoxProcess() {
        switch (this._action) {
            case 0: {
                this.boxStarProcess();
                break;
            }
            case 1: {
                this.boxCommanProcess();
                break;
            }
            case 2: {
                this.boxMoneyProcess();
            }
        }
    }

    public void setCommanBox(int n, int n2, int n3) {
        this._boxInfo[0] = n;
        this._boxInfo[1] = n2;
        this._boxInfo[2] = n3;
        this.changeAction(1);
    }

    public void setMoneyBox(int n) {
        this._boxInfo[3] = n * 100;
        this.changeAction(2);
    }

    private void boxStarProcess() {
        this.changeAction(Function.Random(2) > 0 ? 1 : 2);
    }

    private void boxCommanProcess() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        DataTable dataTable = GameDB.getGameDataBase().getData(this._boxInfo[0], this._boxInfo[1]);
        switch (this._boxInfo[0]) {
            case 5: {
                roleTeamData.consumeEquip(this._boxInfo[1], this._boxInfo[2]);
                this._numInfo[1] = dataTable.getIntItem(8);
                break;
            }
            case 3: {
                roleTeamData.consumeWeapon(this._boxInfo[1], this._boxInfo[2]);
                this._numInfo[1] = dataTable.getIntItem(7);
                break;
            }
            case 4: {
                roleTeamData.consumeBomb(this._boxInfo[1], this._boxInfo[2]);
                this._numInfo[1] = dataTable.getIntItem(12);
                break;
            }
            case 2: {
                roleTeamData.consumeTool(this._boxInfo[1], this._boxInfo[2]);
                this._numInfo[1] = dataTable.getIntItem(8);
            }
        }
        SceneUI.getInstance().toolMenuInfo();
        this._numInfo[0] = 0;
        this._numInfo[2] = this._boxInfo[2];
        this._numInfo[3] = 5;
        this._numInfo[4] = 5;
        this.changeAction(this._actionNum - 1);
    }

    private void boxMoneyProcess() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        roleTeamData.consumeMoney(this._boxInfo[3]);
        this._numInfo[0] = 1;
        this._numInfo[1] = 93;
        this._numInfo[2] = this._boxInfo[3];
        this._numInfo[3] = 5;
        this._numInfo[4] = 5;
        this.changeAction(this._actionNum - 1);
    }

    private void drawBoxMoneyInfo(Graphics graphics, int n, int n2) {
        if (this._numInfo[3] <= 0) {
            if (this._action == this._actionNum - 1) {
                this.disActive();
            }
            return;
        }
        int n3 = (this._x >> 10) - n;
        int n4 = (this._y >> 10) - n2;
        int n5 = Function.countOffsetX(this._numInfo[2], 0, 10);
        int n6 = 40 + (5 - this._numInfo[3]) * this._numInfo[4];
        if (this._numInfo[1] == 93) {
            ResourceManager._spts[80].draw(graphics, n3 - 16, n4 - n6, this._numInfo[1], 0, 4 | 0x10);
            Function.drawSignNumer(graphics, n3 + n5, n4 - n6 - 2, this._numInfo[2], 4, -1);
        } else {
            ResourceManager._avats[60].draw(graphics, n3 - 16, n4 - n6 + 7, this._numInfo[1], 0, 0);
            Function.drawSignNumer(graphics, n3 + n5 + 5, n4 - n6, this._numInfo[2], 4, 82);
        }
        this._numInfo[3] = this._numInfo[3] - 1;
    }

    private void boardInit() {
        this._destX = Scene._actorInitData[this._id][7];
        this._destY = Scene._actorInitData[this._id][8];
        this._resoX = (this._x >> 10) / this._scene._bk.tw;
        this._resoY = (this._y >> 10) / this._scene._bk.th;
    }

    private void boardAi() {
        switch (this._state) {
            case 0: {
                this.boardCommProcess();
                break;
            }
            case 1: {
                this.boardMoveProcess();
            }
        }
    }

    private void boardCommProcess() {
    }

    private void boardMoveProcess() {
        int n = (this._x >> 10) / this._scene._bk.tw;
        int n2 = (this._y >> 10) / this._scene._bk.tw;
        this._vx = n == this._destX ? 0 : this._vx;
        int n3 = this._vy = n2 == this._destY ? 0 : this._vy;
        if (this._vx == 0 && this._vy == 0) {
            int n4 = this._destX;
            this._destX = this._resoX;
            this._resoX = n4;
            n4 = this._destY;
            this._destY = this._resoY;
            this._resoY = n4;
            this._state = 0;
        }
    }

    public boolean canBoardMove() {
        return this._state != 1;
    }

    public void changeBoardMove() {
        switch (this._state) {
            case 1: {
                return;
            }
        }
        this._state = 1;
        int n = Math.abs(((this._destX - this._resoX) * this._scene._bk.tw << 10) / 4096);
        int n2 = Math.abs(((this._destY - this._resoY) * this._scene._bk.tw << 10) / 4096);
        int n3 = Math.max(n, n2);
        this._vx = ((this._destX - this._resoX) * this._scene._bk.tw << 10) / n3;
        this._vy = ((this._destY - this._resoY) * this._scene._bk.tw << 10) / n3;
    }

    private void exploderInit() {
        this._state = 0;
    }

    private void exploderAi() {
        switch (this._state) {
            case 0: {
                break;
            }
            case 1: {
                this.exploderFireProcess();
            }
        }
    }

    private void exploderFireProcess() {
        if (--this._time < 0) {
            this.disActive();
        }
    }

    public void changeExploderFire() {
        switch (this._state) {
            case 1: {
                return;
            }
        }
        this._state = 1;
        this.changeAction(this._actionNum - 1);
        this.creatBomb();
    }

    private void creatBomb() {
        int[] nArray = new int[18];
        nArray[0] = 61;
        nArray[2] = this._x;
        nArray[3] = this._y;
        nArray[12] = this._type;
        nArray[17] = 15;
        nArray[15] = 100;
        Bomb bomb = (Bomb)Scene.fetchActorForBomb(nArray[0]);
        bomb.initBomb(nArray);
        bomb._bombing = true;
        this._time = 20;
    }
}

