/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.customise.Function;
import com.sinaflying.database.DataTable;
import com.sinaflying.database.GameDB;
import com.sinaflying.engine.KeyCode;
import com.sinaflying.engine.ResourceManager;
import com.sinaflying.game.GameMessageBox;
import com.sinaflying.game.MainActor;
import com.sinaflying.game.MessageBoxHandler;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.Scene;
import javax.microedition.lcdui.Graphics;

public class SceneUI
implements MessageBoxHandler {
    private boolean _countDown;
    private boolean _gridLMove;
    private boolean _gridRMove;
    private boolean _callMessage;
    private boolean _closeToolGrid;
    private int _gridX;
    private int _gridY;
    private int _gridS;
    private int _gridCurOffsetX;
    private int _gridMaxOffsetX;
    private int _gridBase;
    private int _gridMax;
    private int _gridIndex;
    private int _gridOffsetX;
    private int _count;
    private int _state;
    private int _wind;
    private int _appointCount;
    private boolean _leftDisplay;
    private boolean _rightDisplay;
    private String _curRoleName;
    private boolean[] _teaching;
    private int _toolTeachIndex;
    private boolean _toolTeaching;
    private int[] _info;
    private int[][] _gridInfo;
    private String[] _gridName;
    private static SceneUI _instance;
    private static GameMessageBox _message;

    public static SceneUI getInstance() {
        if (_instance == null) {
            _instance = new SceneUI();
            SceneUI._instance._state = 0;
            SceneUI._instance._teaching = new boolean[3];
            SceneUI._instance._gridInfo = new int[8][3];
            _instance.toolMenuInitPos();
            _instance.restToolMenu();
            _instance.toolMenuInfo();
            SceneUI._instance._toolTeachIndex = -1;
            SceneUI._instance._closeToolGrid = false;
            _message = GameMessageBox.getInstance(_instance);
        }
        return _instance;
    }

    public void changeInfo(int[] nArray) {
        this._info = nArray;
    }

    public void update() {
        this.appointCount();
        this.countDownProcess();
        if (this._callMessage) {
            _message.update();
            return;
        }
        switch (this._state) {
            case 0: {
                break;
            }
            case 1: {
                this.toolMenuProcess();
            }
        }
    }

    public void paint(Graphics graphics) {
        this.toolMenuDraw(graphics);
        Function.drawBattleLeftRightKey(graphics, true, true);
        this.windDraw(graphics);
        this.roleNameDraw(graphics);
        this.countDownDraw(graphics);
        if (this._callMessage) {
            _message.draw(graphics);
        }
    }

    private void toolMenuInitPos() {
        this._gridX = 2;
        this._gridY = 271;
        this._gridS = 26;
        this._gridCurOffsetX = 0;
        this._gridMaxOffsetX = 26;
        this._gridBase = 0;
        this._gridOffsetX = 0;
    }

    private void toolMenuProcess() {
        int n = KeyCode.getCurKey();
        switch (n) {
            case 16: {
                this.toolUse();
                KeyCode.resetCurKey();
                break;
            }
            case 1: {
                this._gridRMove = this._gridLMove || this._gridRMove ? this._gridRMove : true;
                KeyCode.resetCurKey();
                break;
            }
            case 2: {
                this._gridLMove = this._gridLMove || this._gridRMove ? this._gridLMove : true;
                KeyCode.resetCurKey();
                break;
            }
            case 512: {
                this.changeState();
                KeyCode.resetCurKey();
            }
        }
        switch (n) {
            case 1: {
                this._leftDisplay = true;
                break;
            }
            case 2: {
                this._rightDisplay = true;
                break;
            }
            default: {
                this._leftDisplay = false;
                this._rightDisplay = false;
            }
        }
        if (this._gridLMove) {
            this._gridCurOffsetX = Math.max(this._gridCurOffsetX - 7, -this._gridMaxOffsetX);
            this._gridLMove = this._gridCurOffsetX != -this._gridMaxOffsetX;
            int n2 = this._gridCurOffsetX = !this._gridLMove ? 0 : this._gridCurOffsetX;
            if (this._gridCurOffsetX == 0) {
                int n3 = this._gridBase = ++this._gridBase >= this._gridInfo.length ? 0 : this._gridBase;
            }
        }
        if (this._gridRMove) {
            this._gridCurOffsetX = Math.min(this._gridCurOffsetX + 7, this._gridMaxOffsetX);
            this._gridRMove = this._gridCurOffsetX != this._gridMaxOffsetX;
            int n4 = this._gridCurOffsetX = !this._gridRMove ? 0 : this._gridCurOffsetX;
            if (this._gridCurOffsetX == 0) {
                this._gridBase = --this._gridBase < 0 ? this._gridInfo.length - 1 : this._gridBase;
            }
        }
    }

    public void restToolMenu() {
        this._gridBase = 0;
    }

    public void toolMenuInfo() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        boolean[] blArray = roleTeamData.getPackageExist(3);
        int[] nArray = roleTeamData.getPackageInfo(3);
        this._gridMax = 0;
        int n = 0;
        while (n < blArray.length) {
            if (blArray[n] && n <= 19) {
                this._gridMax += Function.countGridNumber(nArray[n]);
            }
            ++n;
        }
        this._gridInfo = new int[this._gridMax > 8 ? this._gridMax : 8][3];
        this._gridName = new String[this._gridMax > 8 ? this._gridMax : 8];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2] && n2 <= 19) {
                n4 = nArray[n2] / 99;
                n4 = nArray[n2] < 99999 ? (n4 += nArray[n2] % 99 > 0 ? 1 : 0) + n3 : 1 + n3;
                while (n3 < n4) {
                    this._gridInfo[n3][0] = n2;
                    this._gridInfo[n3][2] = n3 < n4 - 1 ? 99 : nArray[n2] % 99;
                    this._gridInfo[n3][2] = nArray[n2] % 99 == 0 ? 99 : this._gridInfo[n3][2];
                    this._gridInfo[n3][2] = nArray[n2] == 99999 ? nArray[n2] : this._gridInfo[n3][2];
                    this.creatGridInfo(this._gridInfo[n3][0], this._gridInfo[n3], this._gridName, n3);
                    ++n3;
                }
            }
            ++n2;
        }
        int n5 = this._gridMax;
        while (n5 < 8) {
            this._gridInfo[n5][0] = -1;
            ++n5;
        }
    }

    private void creatGridInfo(int n, int[] nArray, String[] stringArray, int n2) {
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(2, n);
        nArray[1] = dataTable.getIntItem(8);
        stringArray[n2] = dataTable.getStringItem(1);
    }

    private void toolUse() {
        if (this._gridInfo[this._gridBase][0] < 0) {
            return;
        }
        if (this._toolTeaching) {
            if (this._gridInfo[this._gridBase][0] != this._toolTeachIndex) {
                return;
            }
            this._toolTeaching = false;
            Scene.getInstance().closeSceneTeachOne();
            Scene.getInstance().getFocusActor().setAI(false);
        }
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        GameDB gameDB = GameDB.getGameDataBase();
        if (this._gridInfo[this._gridBase][0] <= 3) {
            MainActor mainActor;
            this._callMessage = true;
            _message = GameMessageBox.getInstance(this);
            int n = 0;
            int n2 = 0;
            while (n2 < 3) {
                if (roleTeamData.getExistFlag(n2) && (mainActor = Scene.getInstance().getMainActor(n2)) != null && !mainActor.isDeathState()) {
                    ++n;
                }
                ++n2;
            }
            String[] stringArray = new String[n];
            int n3 = 0;
            int n4 = 0;
            while (n3 < 3) {
                if (roleTeamData.getExistFlag(n3) && (mainActor = Scene.getInstance().getMainActor(n3)) != null && !mainActor.isDeathState()) {
                    DataTable dataTable = gameDB.getData(1, n3);
                    stringArray[n4] = dataTable.getStringItem(1);
                    ++n4;
                }
                ++n3;
            }
            _message.initChooseStyle(stringArray);
            return;
        }
        if (this._gridInfo[this._gridBase][0] <= 5) {
            MainActor mainActor;
            this._callMessage = true;
            _message = GameMessageBox.getInstance(this);
            int n = 0;
            int n5 = 0;
            while (n5 < 3) {
                if (roleTeamData.getExistFlag(n5) && (mainActor = Scene.getInstance().getMainActor(n5)) != null && mainActor.isDeathState()) {
                    ++n;
                }
                ++n5;
            }
            if (n == 0) {
                this._callMessage = false;
                return;
            }
            String[] stringArray = new String[n];
            int n6 = 0;
            int n7 = 0;
            while (n6 < 3) {
                if (roleTeamData.getExistFlag(n6) && (mainActor = Scene.getInstance().getMainActor(n6)) != null && mainActor.isDeathState()) {
                    DataTable dataTable = gameDB.getData(1, n6);
                    stringArray[n7] = dataTable.getStringItem(1);
                    ++n7;
                }
                ++n6;
            }
            _message.initChooseStyle(stringArray);
            return;
        }
        MainActor mainActor = (MainActor)Scene.getInstance().getFocusActor();
        switch (this._gridInfo[this._gridBase][0]) {
            case 6: 
            case 7: {
                int n = 0;
                while (n < 3) {
                    if (roleTeamData.getExistFlag(n)) {
                        mainActor = Scene.getInstance().getMainActor(n);
                        mainActor.setUesTool(this._gridInfo[this._gridBase][0]);
                    }
                    ++n;
                }
                break;
            }
            case 16: {
                RoleTeamData.getInstance().getRoleData(mainActor._mainActorInfo[1]).obtainLevel();
                break;
            }
            default: {
                mainActor.setUesTool(this._gridInfo[this._gridBase][0]);
            }
        }
        this.consumeTool();
    }

    private void consumeTool() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        roleTeamData.consumeTool(this._gridInfo[this._gridBase][0], -1);
        this.toolMenuInfo();
        this.changeState();
    }

    private void toolMenuDraw(Graphics graphics) {
        int n;
        ResourceManager._spts[81].draw(graphics, this._gridOffsetX + 0, 271, 0, 0, 4 | 0x20);
        ResourceManager._spts[81].draw(graphics, this._gridOffsetX + 0, 320, 7, 0, 4 | 0x20);
        ResourceManager._spts[81].draw(graphics, this._gridOffsetX + 0, 295, 5, 0, 4 | 0x20);
        ResourceManager._spts[81].draw(graphics, 240 - this._gridOffsetX, 295, 38, 0, 8 | 0x20);
        if (this._leftDisplay) {
            ResourceManager._spts[81].draw(graphics, this._gridOffsetX + 14, 288, 36, 0, 4 | 0x20);
        }
        if (this._rightDisplay) {
            ResourceManager._spts[81].draw(graphics, this._gridOffsetX + 240 - 14, 288, -2147483612, 0, 4 | 0x20);
        }
        if (this._teaching[0] && this._appointCount % 7 > 3) {
            Function.drawRect(graphics, this._gridOffsetX + 9, 295, 108, 6, 0xFF0000);
        }
        if (this._teaching[1] && this._appointCount % 7 > 3) {
            Function.drawRect(graphics, this._gridOffsetX + 121, 295, 108, 6, 0xFF0000);
        }
        if (this._teaching[2] && this._appointCount % 7 > 3) {
            Function.drawRect(graphics, this._gridOffsetX + 46, 308, 142, 6, 0xFF0000);
        }
        graphics.setClip(0, 0, 240, 320);
        Function.fillScreen(graphics, this._gridOffsetX + 12, 297, 105 * (100 - this._info[13] << 10) / 100 >> 10, 4, 2557697);
        Function.fillScreen(graphics, this._gridOffsetX + 227 - (104 * (100 - this._info[4] << 10) / 100 >> 10), 297, 104 * (100 - this._info[4] << 10) / 100 >> 10, 4, 2557697);
        Function.fillScreen(graphics, this._gridOffsetX + 48 + (139 * (this._info[8] << 10) / 99 >> 10), 310, 139 - (139 * (this._info[8] << 10) / 99 >> 10), 4, 2557697);
        graphics.setClip(0, 0, 240, 320);
        if (this._info != null && this._info[14] == 100) {
            ResourceManager._spts[81].draw(graphics, this._gridOffsetX + 0, 289, 3, 0, 4 | 0x10);
        }
        if (this._info != null && this._info[5] > 0) {
            ResourceManager._spts[81].draw(graphics, 240 - this._gridOffsetX, 289, 4, 0, 8 | 0x10);
        }
        if (this._info != null) {
            Function.drawNumer(graphics, 201 - this._gridOffsetX, 307, this._info[8], 0, 0);
        }
        graphics.setClip(0, 0, 240, 320);
        ResourceManager._spts[81].draw(graphics, this._gridOffsetX + 46 + (139 * (this._info[7] << 10) / 99 >> 10), 320, 9, 0, 4 | 0x20);
        this._gridIndex = this._gridBase;
        int n2 = 4;
        while (n2 < 9) {
            ResourceManager._spts[81].drawPart(graphics, this._gridOffsetX + this._gridX + n2 * this._gridS + this._gridCurOffsetX, this._gridY, 6, 0, 4 | 0x10, this._gridOffsetX + 29, 181 - this._gridOffsetX * 2);
            int n3 = this._gridIndex = this._gridIndex >= this._gridInfo.length ? 0 : this._gridIndex;
            if (this._gridInfo[this._gridIndex][0] < 0) {
                ++this._gridIndex;
            } else {
                if (this._toolTeaching && this._gridInfo[this._gridIndex][0] == this._toolTeachIndex && this._appointCount % 7 > 3) {
                    Function.drawRect(graphics, this._gridOffsetX + this._gridX + n2 * this._gridS + this._gridCurOffsetX + 1, this._gridY, 24, 23, 0xFF0000);
                }
                ResourceManager._avats[60].drawClip(graphics, this._gridOffsetX + this._gridX + n2 * this._gridS + this._gridCurOffsetX + 17, this._gridY + 12, this._gridInfo[this._gridIndex][1], 0, 0, this._gridOffsetX + 29, 181 - this._gridOffsetX * 2);
                if (this._gridInfo[this._gridIndex][2] != 0) {
                    graphics.setClip(this._gridOffsetX + 29, 0, 181 - this._gridOffsetX * 2, 320);
                    n = Function.countOffsetX(this._gridInfo[this._gridIndex][2], 0, 7) - 15;
                    if (this._gridInfo[this._gridIndex][2] > 99) {
                        ResourceManager._spts[80].draw(graphics, this._gridOffsetX + this._gridX + n2 * this._gridS + this._gridCurOffsetX + 1, this._gridY + 15, 109, 0, 4 | 0x10);
                    } else {
                        Function.drawNumer(graphics, this._gridOffsetX + this._gridX + n2 * this._gridS + this._gridCurOffsetX + n + 14, this._gridY + 15, this._gridInfo[this._gridIndex][2], 0, 0);
                    }
                    ++this._gridIndex;
                }
            }
            ++n2;
        }
        this._gridIndex = this._gridBase;
        int n4 = 3;
        while (n4 > -1) {
            ResourceManager._spts[81].drawPart(graphics, this._gridOffsetX + this._gridX + n4 * this._gridS + this._gridCurOffsetX, this._gridY, 6, 0, 4 | 0x10, this._gridOffsetX + 29, 181 - this._gridOffsetX * 2);
            int n5 = this._gridIndex = --this._gridIndex < 0 ? this._gridInfo.length - 1 : this._gridIndex;
            if (this._gridInfo[this._gridIndex][0] >= 0) {
                if (this._toolTeaching && this._gridInfo[this._gridIndex][0] == this._toolTeachIndex && this._appointCount % 7 > 3) {
                    Function.drawRect(graphics, this._gridOffsetX + this._gridX + n4 * this._gridS + this._gridCurOffsetX + 1, this._gridY + 1, 24, 23, 0xFF0000);
                }
                ResourceManager._avats[60].drawClip(graphics, this._gridOffsetX + this._gridX + n4 * this._gridS + this._gridCurOffsetX + 17, this._gridY + 12, this._gridInfo[this._gridIndex][1], 0, 0, this._gridOffsetX + 29, 181 - this._gridOffsetX * 2);
                if (this._gridInfo[this._gridIndex][2] != 0) {
                    graphics.setClip(this._gridOffsetX + 29, 0, 181 - this._gridOffsetX * 2, 320);
                    n = Function.countOffsetX(this._gridInfo[this._gridIndex][2], 0, 7) - 15;
                    if (this._gridInfo[this._gridIndex][2] > 99) {
                        ResourceManager._spts[80].draw(graphics, this._gridOffsetX + this._gridX + n4 * this._gridS + this._gridCurOffsetX + 1, this._gridY + 15, 109, 0, 4 | 0x10);
                    } else {
                        Function.drawNumer(graphics, this._gridOffsetX + this._gridX + n4 * this._gridS + this._gridCurOffsetX + n + 14, this._gridY + 15, this._gridInfo[this._gridIndex][2], 0, 0);
                    }
                }
            }
            --n4;
        }
        if (this._closeToolGrid) {
            graphics.setClip(0, 0, 240, 320);
            Function.drawPanelX(graphics, this._gridOffsetX + 120 - 14 - 0, 270, 26, 25, 0xFF0000);
        }
        if (this._state != 1) {
            return;
        }
        graphics.setClip(0, 0, 240, 320);
        ResourceManager._spts[81].draw(graphics, 105, 297, 37, 0, 4 | 0x20);
        if (this._gridName[this._gridBase] == null) {
            return;
        }
        graphics.setClip(0, 0, 240, 320);
        Function.drawNamePanel(graphics, this._gridOffsetX + 120 - Function.C_WORD_W * 4, 236, Function.C_WORD_W * 8, Function.C_WORD_H + 2, 0xFFFFFF);
        graphics.setColor(0);
        graphics.drawString(this._gridName[this._gridBase], this._gridOffsetX + 120, 237, 1 | 0x10);
    }

    public void changeWind() {
        this._wind = Function.Random(11, false);
    }

    public int getWind() {
        return this._wind;
    }

    private void windDraw(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        int n = this._wind >= 0 ? 1 : 0;
        int n2 = this._appointCount % ResourceManager._avats[81].getActFrmNum(n);
        ResourceManager._avats[81].draw(graphics, 198, 32, n, n2, 0);
        Function.drawKindNumer(graphics, 194, 28, Math.abs(this._wind));
    }

    public boolean isCountDownZero() {
        return this._countDown && this._count <= 0;
    }

    public void openCountDown() {
        this._count = 459;
        this._countDown = true;
    }

    public void closeCountDown() {
        this._count = 0;
        this._countDown = false;
    }

    public void countDownProcess() {
        if (!this._countDown) {
            return;
        }
        if (!Scene.getInstance().isScriptEnd()) {
            return;
        }
        this._count = Math.max(--this._count, 0);
    }

    public void countDownDraw(Graphics graphics) {
        if (!this._countDown) {
            return;
        }
        ResourceManager._spts[81].draw(graphics, this._gridOffsetX, 0, 35, 0, 4 | 0x10);
        ResourceManager._spts[81].draw(graphics, 240 - this._gridOffsetX, 0, -2147483613, 0, 4 | 0x10);
        Function.drawNumer(graphics, 129, 5, this._count / 10, 0, 1);
    }

    public void setRoleName(String string) {
        this._curRoleName = string;
    }

    private void roleNameDraw(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        Function.draw3DString(graphics, this._curRoleName, 60, 22, 1 | 0x10, 0, 0xFFFFFF);
    }

    public void changeState() {
        switch (this._state) {
            case 0: {
                this._state = 1;
                break;
            }
            case 1: {
                if (this._toolTeaching) break;
                this._state = 0;
            }
        }
    }

    public void closeSceneUI() {
        this._state = 0;
        this._callMessage = false;
        _message.dispose();
    }

    public boolean isOpen() {
        return this._state == 1;
    }

    public void setCloseToolGrid(boolean bl) {
        this._closeToolGrid = bl;
    }

    public boolean getClosToolGrid() {
        return this._closeToolGrid;
    }

    private void appointCount() {
        ++this._appointCount;
        this._appointCount = this._appointCount >= 100 ? 0 : this._appointCount;
    }

    public void teaching(int n, int n2) {
        this._teaching[n] = n2 > 0;
    }

    public void toolTeaching(int n) {
        this._toolTeaching = true;
        this._toolTeachIndex = n;
    }

    public void teachingDialog(String string) {
        int n = Scene.getInstance().getFocusActor().getXSceen(Scene._camx) >> 10;
        int n2 = Math.abs(Scene.getInstance().getFocusActor().getYSceen(Scene._camy) >> 10) - 62;
        this._callMessage = true;
        _message = GameMessageBox.getInstance(this);
        _message.initDialogStyle(n, n2, null, string);
    }

    public void finishHandle() {
        this._callMessage = false;
        Scene.getInstance().closeSceneTeachOne();
    }

    public void resultHandle(int n) {
        this._callMessage = false;
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n2 = Scene.getInstance().getFocusActor()._x;
        int n3 = Scene.getInstance().getFocusActor()._y;
        int n4 = 0;
        int n5 = 0;
        while (n4 < 3) {
            if (roleTeamData.getExistFlag(n4)) {
                MainActor mainActor = Scene.getInstance().setHpForMainActor(n4);
                if (this._gridInfo[this._gridBase][0] <= 3) {
                    if (!mainActor.isDeathState()) {
                        if (n5 == n) {
                            mainActor.setUesTool(this._gridInfo[this._gridBase][0]);
                            this.consumeTool();
                            return;
                        }
                        ++n5;
                    }
                } else if (this._gridInfo[this._gridBase][0] <= 5 && mainActor != null && mainActor.isDeathState()) {
                    if (n5 == n) {
                        mainActor.setPos(n2, n3);
                        mainActor.setUesTool(this._gridInfo[this._gridBase][0]);
                        this.consumeTool();
                        return;
                    }
                    ++n5;
                }
            }
            ++n4;
        }
    }

    public void shopResultHandle(int n) {
    }

    public void cancelHandle() {
        this._callMessage = false;
    }
}

