/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Tools {
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_SOFT_LEFT = -6;
    public static final int KEY_SOFT_RIGHT = -7;
    public static final int KEY_UP = -1;
    public static final int KEY_DOWN = -2;
    public static final int KEY_LEFT = -3;
    public static final int KEY_RIGHT = -4;
    public static final int KEY_MID = -5;
    public static final int KEY_CALL = -10;
    private static Random random = new Random();
    public static final int WIDTH = 240;
    public static final int HEIGHT = 320;
    public static final Font DEF_F = Font.getDefaultFont();
    public static final Font SMAL_F = Font.getFont((int)0, (int)0, (int)8);
    public static final byte KEY_LS = -6;
    public static final byte KEY_RS = -7;
    public static final int STRING_COLOR = 0xFF0000;
    public static final int BUTTON_COLOR = 0xFF0000;
    public static final String[] about = new String[0];

    private Tools() {
    }

    public static Image getImage(String path) {
        Image temp = null;
        try {
            temp = Image.createImage((String)path);
        }
        catch (Exception e) {
            System.out.println("path" + path);
            temp = null;
        }
        return temp;
    }

    public static final void drawString(Graphics g, String[] str, int start, int end, int y, Font f) {
        int x = (240 - Tools.getMaxLength(str, start, end, f)) / 2;
        int height = f.getHeight();
        g.setColor(0xFF0000);
        g.setFont(f);
        int i = start;
        int j = 0;
        while (i < end && i < str.length) {
            if (str[i].indexOf("T") != -1) {
                String s = str[i].substring(1, str[i].length());
                g.drawString(s, (240 - f.stringWidth(s)) / 2, y + j * height, 0);
            } else {
                g.drawString(str[i], x, y + j * height, 0);
            }
            ++i;
            ++j;
        }
    }

    private static final int getMaxLength(String[] str, int start, int end, Font f) {
        int len = 0;
        for (int i = start; i < end && i < str.length; ++i) {
            if (str[i].indexOf("T") != -1 || len >= f.stringWidth(str[i])) continue;
            len = f.stringWidth(str[i]);
        }
        return len;
    }

    public static final void drawClip(Graphics g, Image img, int x, int y, int clipX, int clipY, int clipW, int clipH) {
        g.setClip(x, y, clipW, clipH);
        g.drawImage(img, x - clipX, y - clipY, 0);
        g.setClip(0, 0, 240, 320);
    }

    public static final void clipTurn(Graphics g, Image img, int x, int y, int clipX, int clipY, int clipW, int clipH) {
        for (int i = 0; i < clipW; ++i) {
            g.setClip(x + i, y, 1, clipH);
            g.drawImage(img, x + i - clipX - clipW + i + 1, y - clipY, 0);
        }
        g.setClip(0, 0, 240, 320);
    }

    public static int getInt(int start, int end) {
        int min;
        int max;
        if (start == end) {
            return start;
        }
        if (start > end) {
            max = start;
            min = end;
        } else {
            max = end;
            min = start;
        }
        return Math.abs(random.nextInt()) % (max - min + 1) - (0 - min);
    }

    public static void drawRegion(Graphics g, Image src, int srcX, int srcY, int width, int height, int destX, int destY) {
        int tarX = destX - srcX;
        int tarY = destY - srcY;
        g.setClip(destX, destY, width, height);
        g.drawImage(src, tarX, tarY, 0);
        g.setClip(0, 0, 240, 320);
    }

    public static void drawNum(Graphics g, Image src, int num, int destX, int destY) {
        if (num > 100) {
            num -= 100;
        }
        if (num > 10) {
            num -= 10;
        }
        int srcX = 8 * num;
        int srcY = 0;
        int width = 8;
        int height = 12;
        Tools.drawRegion(g, src, srcX, srcY, width, height, destX, destY);
    }

    public static void sort(int[] num, int count, boolean order) {
        for (int i = 0; i < count - 1; ++i) {
            int index = i;
            for (int j = i; j < count; ++j) {
                if (order && num[j] > num[index]) {
                    index = j;
                    continue;
                }
                if (order || num[j] >= num[index]) continue;
                index = j;
            }
            int tmp = num[i];
            num[i] = num[index];
            num[index] = tmp;
        }
    }
}

