/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.game;

import cn.g9.j2me.game.GraphicsBase;
import cn.g9.j2me.game.Sprite;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class Animation {
    public static final int BOX_L = 0;
    public static final int BOX_T = 1;
    public static final int BOX_R = 2;
    public static final int BOX_B = 3;
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int INT = 2;
    public static final byte EXTEND_PER_ACTION = 2;
    public static final byte EXTEND_PER_MODULE = 5;
    public static final byte EXTEND_PER_SPRITE = 4;
    public static final byte EXTEND_PER_COLBOX = 4;
    public static final byte EXTEND_PER_ATTBOX = 4;
    public static final byte EXTEND_PER_MECH_MODULE = 5;
    public static final int FRAME_ID = 0;
    public static final int ACTION_ID = 1;
    public static final int PAGE_ID = 2;
    public static final int DELAY_COUNT = 3;
    public String file;
    private String[] names;
    private short[] mods;
    private short[][] frms;
    private short[][] acts;
    private short[][] aBox;
    private short[][] cBox;
    private byte[] frmN;
    private byte[] mechModel;
    public int flags;
    public int[] imageID;

    public void read(String file) throws IOException {
        int j;
        int j2;
        this.file = file;
        DataInputStream dis = new DataInputStream(file.getClass().getResourceAsStream(file));
        int imgCount = Animation.read(dis, 0, true);
        int modFormat = Animation.read(dis, 0, true);
        int modCount = Animation.read(dis, 1, true);
        int boxFormat = Animation.read(dis, 0, true);
        int frmCount = Animation.read(dis, 1, true);
        int sptFormat = Animation.read(dis, 0, true);
        int actFormat = Animation.read(dis, 0, true);
        int actCount = Animation.read(dis, 1, true);
        int mechModuleFormat = Animation.read(dis, 0, true);
        this.names = new String[imgCount];
        int i = 0;
        while (i < imgCount) {
            this.names[i] = dis.readUTF();
            ++i;
        }
        this.mods = new short[modCount * 5];
        i = 0;
        while (i < modCount * 5) {
            this.mods[i] = (short)Animation.read(dis, modFormat, true);
            ++i;
        }
        this.frms = new short[frmCount][];
        this.aBox = new short[frmCount][];
        this.cBox = new short[frmCount][];
        i = 0;
        while (i < frmCount) {
            int boxFlag = Animation.read(dis, 0, false);
            this.aBox[i] = new short[4];
            this.cBox[i] = new short[4];
            if ((boxFlag >> 4 & 0xFF) > 0) {
                j2 = 0;
                while (j2 < 4) {
                    this.aBox[i][j2] = (short)Animation.read(dis, boxFormat, false);
                    ++j2;
                }
            }
            if ((boxFlag & 0xF) > 0) {
                j2 = 0;
                while (j2 < 4) {
                    this.cBox[i][j2] = (short)Animation.read(dis, boxFormat, false);
                    ++j2;
                }
            }
            int sptN = Animation.read(dis, 1, true);
            this.frms[i] = new short[sptN * 4];
            j = 0;
            while (j < sptN * 4) {
                this.frms[i][j] = j % 4 == 0 ? (short)Animation.read(dis, 0, true) : (short)Animation.read(dis, sptFormat, false);
                ++j;
            }
            ++i;
        }
        this.acts = new short[actCount][];
        this.frmN = new byte[actCount];
        this.mechModel = new byte[actCount * 5];
        i = 0;
        while (i < actCount) {
            int actN = Animation.read(dis, 1, false);
            this.frmN[i] = (byte)actN;
            this.acts[i] = new short[actN * 2];
            j2 = 0;
            while (j2 < actN) {
                this.acts[i][j2 * 2] = (short)Animation.read(dis, actFormat, false);
                this.acts[i][j2 * 2 + 1] = (short)Animation.read(dis, 0, false);
                ++j2;
            }
            int mmFlag = Animation.read(dis, 0, false);
            this.mechModel[i * 5 + 0] = (byte)((mmFlag & 0xF0) >> 4);
            if ((mmFlag & 0xF) != 0) {
                j = 1;
                while (j < 5) {
                    this.mechModel[i * 5 + j] = (byte)Animation.read(dis, mechModuleFormat, false);
                    ++j;
                }
            }
            ++i;
        }
        dis.close();
        dis = null;
        System.gc();
    }

    public void read(DataInputStream dis) throws Exception {
        int j;
        int j2;
        this.flags = dis.readInt();
        int modFormat = Animation.read(dis, 0, true);
        int modCount = Animation.read(dis, 1, true);
        int boxFormat = Animation.read(dis, 0, true);
        int frmCount = Animation.read(dis, 1, true);
        int sptFormat = Animation.read(dis, 0, true);
        int actFormat = Animation.read(dis, 0, true);
        int actCount = Animation.read(dis, 1, true);
        int mechModuleFormat = Animation.read(dis, 0, true);
        int imgCount = Animation.read(dis, 0, true);
        this.imageID = new int[imgCount];
        int i = 0;
        while (i < imgCount) {
            this.imageID[i] = dis.readUnsignedShort();
            ++i;
        }
        this.mods = new short[modCount * 5];
        i = 0;
        while (i < modCount * 5) {
            this.mods[i] = (short)Animation.read(dis, modFormat, true);
            ++i;
        }
        this.frms = new short[frmCount][];
        this.aBox = new short[frmCount][];
        this.cBox = new short[frmCount][];
        i = 0;
        while (i < frmCount) {
            int boxFlag = Animation.read(dis, 0, false);
            this.aBox[i] = new short[4];
            this.cBox[i] = new short[4];
            if ((boxFlag >> 4 & 0xFF) > 0) {
                j2 = 0;
                while (j2 < 4) {
                    this.aBox[i][j2] = (short)Animation.read(dis, boxFormat, false);
                    ++j2;
                }
            }
            if ((boxFlag & 0xF) > 0) {
                j2 = 0;
                while (j2 < 4) {
                    this.cBox[i][j2] = (short)Animation.read(dis, boxFormat, false);
                    ++j2;
                }
            }
            int sptN = Animation.read(dis, 1, true);
            this.frms[i] = new short[sptN * 4];
            j = 0;
            while (j < sptN * 4) {
                this.frms[i][j] = j % 4 == 0 ? (short)Animation.read(dis, 0, true) : (short)Animation.read(dis, sptFormat, false);
                ++j;
            }
            ++i;
        }
        this.acts = new short[actCount][];
        this.frmN = new byte[actCount];
        this.mechModel = new byte[actCount * 5];
        i = 0;
        while (i < actCount) {
            int actN = Animation.read(dis, 1, false);
            this.frmN[i] = (byte)actN;
            this.acts[i] = new short[actN * 2];
            j2 = 0;
            while (j2 < actN) {
                this.acts[i][j2 * 2] = (short)Animation.read(dis, actFormat, false);
                this.acts[i][j2 * 2 + 1] = (short)Animation.read(dis, 0, false);
                ++j2;
            }
            int mmFlag = Animation.read(dis, 0, false);
            this.mechModel[i * 5 + 0] = (byte)((mmFlag & 0xF0) >> 4);
            if ((mmFlag & 0xF) != 0) {
                j = 1;
                while (j < 5) {
                    this.mechModel[i * 5 + j] = (byte)Animation.read(dis, mechModuleFormat, false);
                    ++j;
                }
            }
            ++i;
        }
    }

    private static int read(DataInputStream dis, int format, boolean isUnsigned) throws IOException {
        if (format == 0) {
            if (isUnsigned) {
                return dis.readUnsignedByte();
            }
            return dis.readByte();
        }
        if (format == 1) {
            if (isUnsigned) {
                return dis.readUnsignedShort();
            }
            return dis.readShort();
        }
        return dis.readInt();
    }

    public int getFrame(int actionId, int pageId) {
        return this.acts[actionId][pageId << 1] & 0xFF;
    }

    public boolean nextFrame(int[] actions, boolean isCycle) {
        actions[3] = actions[3] + 1;
        if (actions[3] < this.acts[actions[1]][(actions[2] << 1) + 1]) {
            return false;
        }
        actions[2] = actions[2] + 1;
        boolean isActionOver = false;
        if (actions[2] > this.frmN[actions[1]] - 1) {
            actions[2] = isCycle ? 0 : actions[2] - 1;
            isActionOver = true;
        }
        actions[0] = this.getFrame(actions[1], actions[2]);
        actions[3] = 0;
        return isActionOver;
    }

    public void drawFrame(GraphicsBase gb, Image[] imgs, int x, int y, int frameIndex, boolean isFlipX, boolean isFlipY) {
        short[] s = this.frms[frameIndex];
        int dgflag = 0;
        int clipWidth = gb.g.getClipWidth();
        int clipHeight = gb.g.getClipHeight();
        int i = 0;
        while (i < s.length) {
            int modID = s[i + 1] * 5;
            int flag = s[i] & 0xFF;
            short modImgId = this.mods[modID];
            short modX = this.mods[modID + 1];
            short modY = this.mods[modID + 2];
            short modW = this.mods[modID + 3];
            short modH = this.mods[modID + 4];
            boolean flipXs = isFlipX ^ (flag & 1) != 0;
            boolean flipYs = isFlipY ^ (flag & 2) != 0;
            boolean rot = (flag & 4) != 0;
            int sptX = isFlipX ? x - s[i + 2] : x + s[i + 2];
            int sptY = isFlipY ? y - s[i + 3] : y + s[i + 3];
            short modWInRot = rot ? modH : modW;
            short modHInRot = rot ? modW : modH;
            if (Sprite.intersectRect(sptX -= flipXs ^ rot ? modWInRot : (short)0, sptY -= flipYs ? modHInRot : (short)0, modW, modH, 0, 0, clipWidth, clipHeight)) {
                dgflag = rot ? (flipXs ? 0 : 1) + (flipYs ? 2 : 0) + 4 : (flipXs ? 2 : 0) + (flipYs ? 1 : 0);
                gb.drawRegion(imgs[modImgId], modX, modY, modW, modH, dgflag, sptX, sptY, 0);
            }
            i += 4;
        }
    }

    public short[][] getABox() {
        return this.aBox;
    }

    public short[][] getActs() {
        return this.acts;
    }

    public short[][] getCBox() {
        return this.cBox;
    }

    public byte[] getFrmNumber() {
        return this.frmN;
    }

    public short[][] getFrms() {
        return this.frms;
    }

    public byte[] getMechModel() {
        return this.mechModel;
    }

    public short[] getMods() {
        return this.mods;
    }

    public short getAttBox(int frame, int border, boolean isFlipX) {
        if (isFlipX) {
            if (border == 0) {
                return -this.aBox[frame][2];
            }
            if (border == 2) {
                return -this.aBox[frame][0];
            }
            return this.aBox[frame][border];
        }
        return this.aBox[frame][border];
    }

    public short getColBox(int frame, int border, boolean isFlipX) {
        if (isFlipX) {
            if (border == 0) {
                return -this.cBox[frame][2];
            }
            if (border == 2) {
                return -this.cBox[frame][0];
            }
            return this.cBox[frame][border];
        }
        return this.cBox[frame][border];
    }
}

