/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.game;

public class Camera {
    private int width;
    private int height;
    private int vx;
    private int vy;
    private int ax;
    private int ay;
    private int tailX;
    private int tailY;
    public static final int DEF_VX = 4;
    public static final int DEF_VY = 4;
    private int maxVx = 30;
    private int maxVy = 30;
    private int camX;
    private int camY;
    private int centerX;
    private int centerY;
    int camLockX1;
    int camLockX2;
    int camLockY1;
    int camLockY2;
    private boolean isShake = false;
    private int shakeTime;
    private int shakeType;
    public static int SHAKE_Y = 0;
    public static int SHAKE_X = 1;
    public static int SHAKE_X_Y = 2;
    private int shakeRange = 2;
    private byte shakeOffsetX;
    private byte shakeOffsetY;
    private int[][] shake;

    public Camera(int x, int y, int width, int height, int centerX, int centerY) {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[2];
        nArray[1] = this.shakeRange;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = this.shakeRange;
        nArrayArray[1] = nArray2;
        nArrayArray[2] = new int[]{this.shakeRange, -this.shakeRange};
        this.shake = nArrayArray;
        this.width = width;
        this.height = height;
        this.centerX = centerX;
        this.centerY = centerY;
        this.focusX(x, 0, 0, true);
        this.focusY(y, 0, 0, true);
    }

    public void setLockArea(int x1, int y1, int x2, int y2) {
        this.camLockX1 = x1;
        this.camLockY1 = y1;
        this.camLockX2 = x2;
        this.camLockY2 = y2;
    }

    public void focusX(int x, int vx, int ax, boolean forceFocus) {
        this.tailX = x - this.centerX;
        this.vx = Math.abs(vx);
        this.ax = Math.abs(ax);
        if (forceFocus) {
            this.camX = x - this.centerX;
            if (this.camX < this.camLockX1) {
                this.camX = this.camLockX1;
            }
        }
        if (this.tailX < this.camLockX1) {
            this.tailX = this.camLockX1;
        } else if (this.tailX >= this.camLockX2 - this.width) {
            this.tailX = this.camLockX2 - this.width;
        }
        if (vx + ax == 0) {
            this.vx = 4;
            this.ax = 1;
        }
    }

    public void focusY(int y, int vy, int ay, boolean forceFocus) {
        this.tailY = y - this.centerY;
        this.vy = Math.abs(vy);
        this.ay = Math.abs(ay);
        if (forceFocus) {
            this.camY = y - this.centerY;
            if (this.camY < this.camLockY1) {
                this.camY = this.camLockY1;
            }
        }
        if (this.tailY < this.camLockY1) {
            this.tailY = this.camLockY1;
        } else if (this.tailY >= this.camLockY2 - this.height) {
            this.tailY = this.camLockY2 - this.height;
        }
        if (vy + ay == 0) {
            this.vy = 4;
            this.ay = 1;
        }
    }

    public boolean camera() {
        boolean focusXOk = false;
        if (this.camX < this.tailX) {
            this.camX += this.vx + this.ax;
            this.ax = (this.ax + 1) % this.maxVx;
            if (this.camX > this.tailX) {
                this.camX = this.tailX;
                this.ax = 0;
            }
        } else if (this.camX > this.tailX) {
            this.camX -= this.vx + this.ax;
            this.ax = (this.ax + 1) % this.maxVx;
            if (this.camX < this.tailX) {
                this.camX = this.tailX;
                this.ax = 0;
                this.vx = 0;
            }
        } else {
            this.camX = this.tailX;
            this.ax = 0;
            this.vx = 0;
        }
        if (this.camX <= this.camLockX1) {
            this.camX = this.camLockX1;
        } else if (this.camX >= this.camLockX2 - this.width) {
            this.camX = this.camLockX2 - this.width;
        }
        if (this.camX == this.tailX) {
            this.ax = 0;
            this.vx = 0;
            focusXOk = true;
        }
        boolean focusYOk = false;
        if (this.camY < this.tailY) {
            this.camY += this.vy + this.ay;
            this.ay = (this.ay + 1) % this.maxVy;
            if (this.camY > this.tailY) {
                this.camY = this.tailY;
                this.ay = 0;
            }
        } else if (this.camY > this.tailY) {
            this.camY -= this.vy + this.ay;
            this.ay = (this.ay + 1) % this.maxVy;
            if (this.camY < this.tailY) {
                this.camY = this.tailY;
                this.ay = 0;
                this.vy = 0;
            }
        } else {
            this.camY = this.tailY;
            this.ay = 0;
            this.vy = 0;
        }
        if (this.camY <= this.camLockY1) {
            this.camY = this.camLockY1;
        } else if (this.camY >= this.camLockY2 - this.height) {
            this.camY = this.camLockY2 - this.height;
        }
        if (this.camY == this.tailY) {
            this.ay = 0;
            this.vy = 0;
            focusYOk = true;
        }
        if (this.isShake) {
            --this.shakeTime;
            this.shakeOffsetX = (byte)(this.shakeOffsetX + (this.shakeTime % 2 == 0 ? this.shake[this.shakeType][0] : -this.shake[this.shakeType][0]));
            this.shakeOffsetY = (byte)(this.shakeOffsetY + (this.shakeTime % 2 == 0 ? this.shake[this.shakeType][1] : -this.shake[this.shakeType][1]));
            if (this.shakeTime < 0) {
                this.shakeTime = 0;
                this.isShake = false;
            }
        }
        return focusXOk && focusYOk;
    }

    public int getX() {
        return this.camX + this.shakeOffsetX;
    }

    public int getY() {
        return this.camY + this.shakeOffsetY;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isShakeEffect() {
        return this.isShake;
    }

    public void openShake(int duration, int type) {
        this.isShake = true;
        this.shakeTime = duration;
        this.shakeType = type;
    }

    public void closeShake() {
        this.isShake = false;
        this.shakeTime = 0;
        this.shakeOffsetY = 0;
        this.shakeOffsetX = 0;
    }

    public int getMaxVy() {
        return this.maxVy;
    }

    public void setMaxVy(int maxVy) {
        this.maxVy = maxVy;
    }

    public int getShakeTime() {
        return this.shakeTime;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getCamLockX1() {
        return this.camLockX1;
    }

    public int getCamLockX2() {
        return this.camLockX2;
    }

    public int getCamLockY1() {
        return this.camLockY1;
    }

    public int getCamLockY2() {
        return this.camLockY2;
    }

    public int getMaxVx() {
        return this.maxVx;
    }

    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }
}

