/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class GraphicsBase {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int LEFT_TOP = 20;
    public static final int LEFT_VCENTER = 6;
    public static final int LEFT_BOTTOM = 36;
    public static final int HCENTER_VCENTER = 3;
    public static final int HCENTER_BOTTOM = 33;
    public static final int HCENTER_TOP = 17;
    public static final int RIGHT_TOP = 24;
    public static final int RIGHT_VCENTER = 10;
    public static final int RIGHT_BOTTOM = 40;
    Graphics g;

    protected GraphicsBase(Graphics g) {
        this.g = g;
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public int getFontHeight() {
        return this.g.getFont().getHeight();
    }

    public int getFontWidth() {
        return this.getStringWidth("\u4e2d");
    }

    public int getFontWidthAsEn() {
        return this.getStringWidth("E");
    }

    public int getStringWidth(String s) {
        return this.g.getFont().stringWidth(s);
    }

    public abstract void drawRegion(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract void drawImage(Image var1, int var2, int var3, int var4, int var5);

    public abstract void drawFrame(int var1, Image var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public void drawString(Graphics g, Image img, String str, String fontStoreroom, int x, int y, int clipW, int clipH, int anchor, int space, int numDigit) {
        StringBuffer sb = new StringBuffer();
        sb.append(str);
        int i = sb.length();
        while (i < numDigit) {
            sb.insert(0, "0");
            ++i;
        }
        str = sb.toString();
        int strLength = str.length();
        int offset = GraphicsBase.getAnchorOffset(anchor, 0, strLength * clipW + space, clipH);
        x -= (offset & 0xFFFF0000) >> 16;
        y -= offset & 0xFFFF;
        int i2 = 0;
        while (i2 < strLength) {
            int charId = fontStoreroom.indexOf(str.charAt(i2));
            if (charId != -1) {
                this.drawRegion(img, charId * clipW, 0, clipW, clipH, 0, x, y, 0);
            }
            ++i2;
            x += clipW + space;
        }
    }

    public static int getAnchorOffset(int anchor, int transform, int w, int h) {
        int offX = 0;
        int offY = 0;
        if ((transform & 4) != 0) {
            int tW = w;
            w = h;
            h = tW;
        }
        if ((anchor & 0x40) != 0) {
            throw new IllegalArgumentException();
        }
        if ((anchor & 1) != 0) {
            offX = w >> 1;
        } else if ((anchor & 8) != 0) {
            offX = w;
        }
        if ((anchor & 2) != 0) {
            offY = h >> 1;
        } else if ((anchor & 0x20) != 0) {
            offY = h;
        }
        return offX << 16 | offY;
    }
}

