/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.game;

import cn.g9.j2me.game.GameFrameBase;
import cn.g9.j2me.game.GameFrameItem;
import cn.g9.j2me.game.GraphicsBase;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public abstract class GameCanvasBase
extends Canvas
implements Runnable {
    public static Font font = Font.getDefaultFont();
    public static int fontW = GameCanvasBase.getStringWidth(font, "\u4e2d");
    public static int fontW_E = GameCanvasBase.getStringWidth(font, "A");
    public static int fontH = font.getHeight();
    private Thread thread;
    public boolean pauseThread;
    GameFrameItem gfi = new GameFrameItem();
    private int sleepTime = 60;
    public static final int KEY_LEFT = 1;
    public static final int KEY_RIGHT = 2;
    public static final int KEY_UP = 4;
    public static final int KEY_DOWN = 8;
    public static final int KEY_FIRE = 16;
    public static final int KEY_SOFT_FIRE = 32;
    public static final int KEY_SOFT_CANCEL = 64;
    public static final int KEY_5 = 128;
    public static final int KEY_2 = 256;
    public static final int KEY_4 = 512;
    public static final int KEY_6 = 1024;
    public static final int KEY_8 = 2048;
    public static final int KEY_1 = 4096;
    public static final int KEY_3 = 8192;
    public static final int KEY_7 = 16384;
    public static final int KEY_9 = 32768;
    public static final int KEY_0 = 65536;
    public static final int KEY_SEND = 131072;
    public static final int KEY_END = 262144;
    public static final int KEY_STAR_ = 524288;
    public static final int KEY_POUND_ = 0x100000;
    private int keyState;
    private int keyPressed;
    private int keyReleased;

    public static int getStringWidth(Font font, String s) {
        return font.stringWidth(s);
    }

    protected GameCanvasBase(boolean fullCanvas) {
        if (fullCanvas) {
            this.setFullScreenMode(true);
        }
    }

    public int getHeight() {
        if (super.getHeight() == 144) {
            return 208;
        }
        return super.getHeight();
    }

    public void start() {
        this.pauseThread = false;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void pause() {
        this.pauseThread = true;
    }

    public void setSleep(int threadSleep) {
        this.sleepTime = threadSleep;
    }

    public GameFrameBase getLastFrame() {
        return this.gfi.getLastFrame();
    }

    public void addFrame(GameFrameBase gfb) {
        this.gfi.addFrame(gfb);
    }

    public GameFrameItem getGameFrameItem() {
        return this.gfi;
    }

    public void hideNotify() {
        this.gfi.getLastFrame().hideNotify();
    }

    public void showNotify() {
        this.gfi.getLastFrame().showNotify();
    }

    public void run() {
        try {
            while (!this.pauseThread) {
                long start = System.currentTimeMillis();
                this.tick();
                int i = this.gfi.getSize() - 1;
                while (i >= 0) {
                    this.gfi.getFrame(i).tick();
                    --i;
                }
                this.repaint();
                this.serviceRepaints();
                long end = System.currentTimeMillis();
                long sleep = start + (long)this.sleepTime - end - 5L;
                if (sleep > 0L) {
                    Thread.sleep(sleep);
                    continue;
                }
                Thread.yield();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void tick();

    public abstract void paint(GraphicsBase var1, Graphics var2);

    protected void paint(Graphics g) {
        GraphicsBase gb = this.getGameGraphics(g);
        int i = this.gfi.getSize() - 1;
        while (i >= 0) {
            this.gfi.getFrame(i).draw(gb, g);
            --i;
        }
        this.paint(gb, g);
        this.keyPressed = 0;
    }

    public abstract GraphicsBase getGameGraphics(Graphics var1);

    protected final void keyPressed(int keyCode) {
        int keyValue = this.getKeyValue(keyCode);
        this.keyState |= keyValue;
        this.keyPressed |= keyValue;
        this.keyDown(this.keyState, this.keyPressed);
        int i = this.gfi.getSize() - 1;
        while (i >= 0) {
            this.gfi.getFrame(i).pressed(this.keyState, this.keyPressed);
            --i;
        }
        this.keyPressed = 0;
    }

    public abstract void keyDown(int var1, int var2);

    protected final void keyReleased(int keyCode) {
        this.keyReleased = this.getKeyValue(keyCode);
        this.keyState &= ~this.keyReleased;
        this.keyUp(this.keyReleased);
        int i = this.gfi.getSize() - 1;
        while (i >= 0) {
            this.gfi.getFrame(i).released(this.keyState);
            --i;
        }
    }

    protected abstract void keyUp(int var1);

    public int getKeyState() {
        return this.keyState;
    }

    public int getKeyReleased() {
        return this.keyReleased;
    }

    public void clearKey() {
        this.keyState = 0;
        this.keyReleased = 0;
        int i = this.gfi.getSize() - 1;
        while (i >= 0) {
            this.gfi.getFrame(i).clearKey();
            --i;
        }
    }

    public void pointerPressed(int x, int y) {
        int i = this.gfi.getSize() - 1;
        while (i >= 0) {
            this.gfi.getFrame(i).pointerPressed(x, y);
            --i;
        }
    }

    public void pointerReleased(int x, int y) {
        int i = this.gfi.getSize() - 1;
        while (i >= 0) {
            this.gfi.getFrame(i).pointerReleased(x, y);
            --i;
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public static final boolean keyPressFire(int key) {
        return (key & 0x10) != 0 || (key & 0x80) != 0 || GameCanvasBase.keyPressSoftFire(key);
    }

    public static final boolean keyPressCancel(int key) {
        return (key & 0x40) != 0 || (key & 0x100000) != 0;
    }

    public static final boolean keyPressSoftFire(int key) {
        return (key & 0x20) != 0;
    }

    public static final boolean keyPressUp(int key) {
        return (key & 4) != 0 || (key & 0x100) != 0;
    }

    public static final boolean keyPressDown(int key) {
        return (key & 8) != 0 || (key & 0x800) != 0;
    }

    public static final boolean keyPressLeft(int key) {
        return (key & 1) != 0 || (key & 0x200) != 0;
    }

    public static final boolean keyPressRight(int key) {
        return (key & 2) != 0 || (key & 0x400) != 0;
    }

    private final int getPressedCode(int keyCode) {
        int keyTmp = keyCode;
        if ((keyCode = Math.abs(keyCode)) == 20 || keyCode == 5) {
            return 16;
        }
        if (keyCode == 22 || keyCode == 6) {
            return 32;
        }
        if (keyCode == 21 || keyCode == 7) {
            return 64;
        }
        if (this.getGameAction(keyTmp) == 2) {
            return 2;
        }
        if (this.getGameAction(keyTmp) == 5) {
            return 5;
        }
        if (this.getGameAction(keyTmp) == 1) {
            return 1;
        }
        if (this.getGameAction(keyTmp) == 6) {
            return 6;
        }
        if (keyCode == 48) {
            return 48;
        }
        if (keyCode == 49) {
            return 49;
        }
        if (keyCode == 50) {
            return 1;
        }
        if (keyCode == 51) {
            return 51;
        }
        if (keyCode == 52) {
            return 2;
        }
        if (keyCode == 53) {
            return 16;
        }
        if (keyCode == 54) {
            return 5;
        }
        if (keyCode == 55) {
            return 55;
        }
        if (keyCode == 56) {
            return 6;
        }
        if (keyCode == 57) {
            return 57;
        }
        if (keyCode == 35) {
            return 35;
        }
        if (keyCode == 42) {
            return 42;
        }
        return 0;
    }

    private final int getKeyValue(int keyCode) {
        int keyTmp = keyCode;
        if ((keyCode = Math.abs(keyCode)) == 20 || keyCode == 5) {
            return 16;
        }
        if (keyCode == 22 || keyCode == 6) {
            return 32;
        }
        if (this.getGameAction(keyTmp) == 2) {
            return 1;
        }
        if (this.getGameAction(keyTmp) == 5) {
            return 2;
        }
        if (this.getGameAction(keyTmp) == 1) {
            return 4;
        }
        if (this.getGameAction(keyTmp) == 6) {
            return 8;
        }
        if (keyCode == 21 || keyCode == 7) {
            return 64;
        }
        if (keyCode == 48) {
            return 65536;
        }
        if (keyCode == 49) {
            return 4096;
        }
        if (keyCode == 50) {
            return 4;
        }
        if (keyCode == 51) {
            return 8192;
        }
        if (keyCode == 52) {
            return 1;
        }
        if (keyCode == 53) {
            return 16;
        }
        if (keyCode == 54) {
            return 2;
        }
        if (keyCode == 55) {
            return 16384;
        }
        if (keyCode == 56) {
            return 8;
        }
        if (keyCode == 57) {
            return 32768;
        }
        if (keyCode == 35) {
            return 0x100000;
        }
        if (keyCode == 42) {
            return 524288;
        }
        return 0;
    }
}

