/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.game;

import cn.g9.j2me.game.Animation;
import cn.g9.j2me.game.GraphicsBase;
import javax.microedition.lcdui.Image;

public class Sprite {
    public int x;
    public int y;
    public int z;
    public Animation anim;
    private int frame = -1;
    private int[] actions = new int[4];
    private boolean isHide;
    private boolean isActionOver;
    public Image[] imgs;
    private boolean isHideBox;
    private boolean isCycle = true;
    private short[] attBoxTmp = new short[4];
    private short[] colBoxTmp = new short[4];
    private boolean isFirstFrame;

    public boolean isHideBox() {
        return this.isHideBox;
    }

    public void setHideBox(boolean isHideBox) {
        this.isHideBox = isHideBox;
    }

    public Sprite() {
    }

    public Sprite(Animation anim, Image[] imgs) {
        this.setAnimation(anim);
        this.setImgs(imgs);
    }

    public boolean isActionOver() {
        return this.isActionOver;
    }

    public void setAction(int actionId, boolean forceChange, boolean isCycle) {
        if (forceChange | actionId != this.actions[1]) {
            this.actions[1] = actionId;
            this.actions[3] = 0;
            this.actions[2] = 0;
            this.actions[0] = this.anim.getFrame(this.actions[1], this.actions[2]);
            this.isActionOver = false;
            this.frame = -1;
            this.isCycle = isCycle;
            this.isFirstFrame = true;
        }
    }

    public void nextFrame() {
        if (this.isFirstFrame) {
            this.isFirstFrame = false;
        } else {
            this.isActionOver = this.anim.nextFrame(this.actions, this.isCycle);
        }
    }

    public void draw(GraphicsBase gb, int x, int y, boolean isFlipX, boolean isFlipY) {
        if (!this.isHide) {
            this.drawFrame(gb, x, y, this.frame != -1 ? this.frame : this.actions[0], isFlipX, isFlipY);
        }
    }

    public void drawFrame(GraphicsBase gb, int x, int y, int frameIndex, boolean isFlipX, boolean isFlipY) {
        if (!this.isHide) {
            this.anim.drawFrame(gb, this.imgs, x, y, frameIndex, isFlipX, isFlipY);
        }
    }

    public Image[] getImgs() {
        return this.imgs;
    }

    public void setImgs(Image[] imgs) {
        this.imgs = imgs;
    }

    public void releaseImages() {
        this.imgs = null;
    }

    public void setAnimation(Animation anim) {
        this.anim = anim;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public int getActionID() {
        return this.actions[1];
    }

    public int getActionPage() {
        return this.actions[2];
    }

    public int getDelay() {
        return this.actions[3];
    }

    public int getFrame() {
        return this.actions[0];
    }

    public int getActionPageNum() {
        return this.anim.getFrmNumber()[this.actions[1]];
    }

    public int getAttBox(int border, boolean isFlipX) {
        return this.anim.getAttBox(this.actions[0], border, isFlipX);
    }

    public int getColBox(int border, boolean isFlipX) {
        return this.anim.getColBox(this.actions[0], border, isFlipX);
    }

    public short[] getAttBox(boolean isFlipX) {
        int frame = this.actions[0];
        this.attBoxTmp[0] = (short)(this.anim.getAttBox(frame, 0, isFlipX) + this.x);
        this.attBoxTmp[1] = (short)(this.anim.getAttBox(frame, 1, isFlipX) + this.y);
        this.attBoxTmp[2] = (short)(this.anim.getAttBox(frame, 2, isFlipX) + this.x);
        this.attBoxTmp[3] = (short)(this.anim.getAttBox(frame, 3, isFlipX) + this.y);
        return this.attBoxTmp;
    }

    public short[] getColBox(boolean isFlipX) {
        int frame = this.actions[0];
        this.colBoxTmp[0] = (short)(this.anim.getColBox(frame, 0, isFlipX) + this.x);
        this.colBoxTmp[1] = (short)(this.anim.getColBox(frame, 1, isFlipX) + this.y);
        this.colBoxTmp[2] = (short)(this.anim.getColBox(frame, 2, isFlipX) + this.x);
        this.colBoxTmp[3] = (short)(this.anim.getColBox(frame, 3, isFlipX) + this.y);
        return this.colBoxTmp;
    }

    public boolean collide(int aL, int aT, int aR, int aB, int bL, int bT, int bR, int bB) {
        if (this.isHideBox || this.isHide) {
            return false;
        }
        if (aL == aR && aT == aB || bL == bR && bT == bB) {
            return false;
        }
        return bL < aR && bT < aB && bR > aL && bB > aT;
    }

    public static boolean intersectRect(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return y2 + height2 >= y1 && y2 <= y1 + height1 && x2 + width2 >= x1 && x2 <= x1 + width1;
    }

    public static boolean inclusionRect(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return y2 >= y1 && y2 + height2 <= y1 + height1 && x2 >= x1 && x2 + width2 <= x1 + width1;
    }

    public boolean isCycle() {
        return this.isCycle;
    }

    public void setCycle(boolean isCycle) {
        this.isCycle = isCycle;
    }

    public int getActionSize() {
        return this.anim.getActs().length;
    }

    public void setActionOver(boolean isActionOver) {
        this.isActionOver = isActionOver;
    }

    public void resetActions() {
        this.actions[0] = 0;
        this.actions[1] = 0;
        this.actions[2] = 0;
        this.actions[3] = 0;
        this.isFirstFrame = false;
    }
}

