/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.util;

public class Arraylist {
    public int select = -1;
    private Object[] elementData;
    private int elementCount;

    public Arraylist() {
        this(10);
    }

    public Arraylist(int initialSize) {
        this.elementData = new Object[initialSize];
    }

    public Arraylist clone() {
        Arraylist al = new Arraylist();
        al.elementCount = this.elementCount;
        al.elementData = new Object[this.elementCount];
        this.copyInto(al.elementData);
        return al;
    }

    public void addElement(Object o) {
        if (o == null) {
            return;
        }
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = o;
    }

    public void insertElementAt(Object obj, int index) {
        if (index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.elementData;
            int newCapacity = oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public void setElementAt(Object obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public Object getLast() {
        return this.elementData[this.elementCount - 1];
    }

    public void removeElement(Object obj) {
        if (obj == null) {
            return;
        }
        int i = 0;
        while (i < this.elementCount) {
            if (this.elementData[i].equals(obj)) {
                this.removeElementAt(i);
                return;
            }
            ++i;
        }
    }

    public void removeElementAt(int index) {
        if (index < 0 || index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " index <> " + this.elementCount);
        }
        int i = this.elementCount - 1 - index;
        System.arraycopy(this.elementData, index + 1, this.elementData, index, i);
        this.elementData[--this.elementCount] = null;
    }

    public void removeAllElements() {
        int i = 0;
        while (i < this.elementData.length) {
            this.elementData[i] = null;
            ++i;
        }
        this.elementData = new Object[10];
        System.gc();
        this.elementCount = 0;
    }

    public final Object elementAt(int index) {
        if (index < 0 || index > this.elementCount) {
            return null;
        }
        return this.elementData[index];
    }

    public final int indexOf(Object obj) {
        int i = 0;
        while (i < this.size()) {
            if (this.elementData[i].equals(obj)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void copyInto(Object[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.elementCount);
    }

    public final int size() {
        return this.elementCount;
    }

    public void setSize(int newSize) {
        if (newSize > this.elementCount) {
            this.ensureCapacity(newSize);
        } else {
            int i = newSize;
            while (i < this.elementCount) {
                this.elementData[i] = null;
                ++i;
            }
        }
        this.elementCount = newSize;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public int toInt(int index) {
        try {
            return Integer.parseInt(this.toString(index));
        }
        catch (ClassCastException e) {
            try {
                return (Integer)this.elementAt(index);
            }
            catch (NumberFormatException ee) {
                throw new NumberFormatException("NumberIllegalFormat");
            }
        }
    }

    public String toString(int index) {
        try {
            return this.elementAt(index).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean toBoolean(int index) {
        try {
            return this.elementAt(index).toString().toLowerCase().equals("true");
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object[] toArray() {
        Object[] result = new Object[this.elementCount];
        this.copyInto(result);
        return result;
    }
}

