/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.util;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Utils {
    public static Random random = new Random(System.currentTimeMillis());

    public static int[] getRGB(Image srcImg) {
        int w = srcImg.getWidth();
        int h = srcImg.getHeight();
        int[] pixels = new int[w * h];
        Image img = DirectUtils.createImage((int)w, (int)h, (int)0);
        Graphics g = img.getGraphics();
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        dg.drawImage(srcImg, 0, 0, 0, 0);
        dg.getPixels(pixels, 0, w, 0, 0, w, h, 8888);
        return pixels;
    }

    public static Image createImg(int[] pixels, int width, int height) {
        Image img = DirectUtils.createImage((int)width, (int)height, (int)0);
        Graphics g = img.getGraphics();
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        dg.drawPixels(pixels, true, 0, width, 0, 0, width, height, 0, 8888);
        return img;
    }

    public static final String getBinaryString(int value) {
        StringBuffer sb = new StringBuffer(String.valueOf(Integer.toBinaryString(value)));
        int sbLen = sb.length();
        int i = 0;
        while (i < 32 - sbLen) {
            sb.insert(0, '0');
            ++i;
        }
        return sb.toString();
    }

    public static void replaceColor(byte[] imgData, int[] colors) {
        try {
            int paletteDataStartPos = 8;
            int paletteSize = 0;
            while (imgData[paletteDataStartPos + 4] != 80 && imgData[paletteDataStartPos + 5] != 76 && imgData[paletteDataStartPos + 6] != 84 && imgData[paletteDataStartPos + 7] != 69) {
                paletteSize = Utils.assembleInt(imgData, paletteDataStartPos);
                paletteDataStartPos += 8 + paletteSize + 4;
            }
            int paletteStart = 0;
            int CRCOff = 0;
            int paletteColors = paletteSize / 3;
            paletteStart = paletteDataStartPos + 8;
            CRCOff = paletteDataStartPos + 8 + paletteSize;
            int swapNum = colors.length >> 1;
            int swapI = 0;
            while (swapI < swapNum) {
                int newcolor = -1;
                int oldColors = colors[swapI << 1];
                byte rr = (byte)(oldColors >> 16 & 0xFF);
                byte gg = (byte)(oldColors >> 8 & 0xFF);
                byte bb = (byte)(oldColors & 0xFF);
                int i = 0;
                int offset = paletteStart;
                while (i < paletteColors) {
                    if (rr == imgData[offset] & gg == imgData[offset + 1] & bb == imgData[offset + 2]) {
                        int newColors = colors[(swapI << 1) + 1];
                        imgData[offset] = (byte)(newColors >> 16 & 0xFF);
                        imgData[offset + 1] = (byte)(newColors >> 8 & 0xFF);
                        imgData[offset + 2] = (byte)(newColors & 0xFF);
                    }
                    newcolor = Utils.pixelConvert(imgData[offset], newcolor);
                    newcolor = Utils.pixelConvert(imgData[offset + 1], newcolor);
                    newcolor = Utils.pixelConvert(imgData[offset + 2], newcolor);
                    ++i;
                    offset += 3;
                }
                imgData[CRCOff] = (byte)((newcolor ^= 0xFFFFFFFF) >> 24);
                imgData[CRCOff + 1] = (byte)(newcolor >> 16);
                imgData[CRCOff + 2] = (byte)(newcolor >> 8);
                imgData[CRCOff + 3] = (byte)newcolor;
                ++swapI;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int assembleInt(byte[] data, int offset) {
        return (data[offset] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
    }

    public static int pixelConvert(byte pixel, int color) {
        int tmp = pixel & 0xFF;
        color ^= tmp;
        int idx = 0;
        while (idx < 8) {
            color = (color & 1) != 0 ? color >>> 1 ^ 0xEDB88320 : (color >>>= 1);
            ++idx;
        }
        return color;
    }

    public static void sort(int[] object, int[] saveIndex, boolean isBig) {
        int len = object.length;
        if (len > 1) {
            int i;
            int temp = object[0];
            int tempIndex = 0;
            if (saveIndex[0] + saveIndex[1] == 0) {
                i = 0;
                while (i < len) {
                    saveIndex[i] = i;
                    ++i;
                }
            }
            i = 0;
            while (i < len - 1) {
                int j = i + 1;
                while (j < len) {
                    if (isBig ? object[i] < object[j] : object[i] > object[j]) {
                        temp = object[j];
                        tempIndex = saveIndex[j];
                        object[j] = object[i];
                        saveIndex[j] = saveIndex[i];
                        object[i] = temp;
                        saveIndex[i] = tempIndex;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static int getRandom(int min, int max) {
        int iRet = random.nextInt() >>> 1;
        iRet = iRet % (max + 1 - min) + min;
        return iRet;
    }

    public static final boolean isArcRectCollides(int arcX, int arcY, int arcR, int rectX, int rectY, int rectW, int rectH) {
        int arcOx = arcX + arcR;
        int arcOy = arcY + arcR;
        if ((rectX - arcOx) * (rectX - arcOx) + (rectY - arcOy) * (rectY - arcOy) <= arcR * arcR) {
            return true;
        }
        if ((rectX + rectW - arcOx) * (rectX + rectW - arcOx) + (rectY - arcOy) * (rectY - arcOy) <= arcR * arcR) {
            return true;
        }
        if ((rectX - arcOx) * (rectX - arcOx) + (rectY + rectH - arcOy) * (rectY + rectH - arcOy) <= arcR * arcR) {
            return true;
        }
        if ((rectX + rectW - arcOx) * (rectX + rectW - arcOx) + (rectY + rectH - arcOy) * (rectY + rectH - arcOy) <= arcR * arcR) {
            return true;
        }
        int minDisX = 0;
        if (arcOy >= rectY && arcOy <= rectY + rectH) {
            if (arcOx < rectX) {
                minDisX = rectX - arcOx;
            } else if (arcOx > rectX + rectW) {
                minDisX = arcOx - rectX - rectW;
            } else {
                return true;
            }
            if (minDisX <= arcR) {
                return true;
            }
        }
        int minDisY = 0;
        if (arcOx >= rectX && arcOx <= rectX + rectW) {
            if (arcOy < rectY) {
                minDisY = rectY - arcOy;
            } else if (arcOy > rectY + rectH) {
                minDisY = arcOy - rectY - rectH;
            } else {
                return true;
            }
            if (minDisY <= arcR) {
                return true;
            }
        }
        return false;
    }

    public static Image zoomInImage(Image img) {
        int[] rgbOutput = null;
        int width = 0;
        int height = 0;
        int[] rgbInput = null;
        try {
            width = img.getWidth();
            height = img.getHeight();
            rgbInput = new int[width * height];
            rgbOutput = new int[(width << 1) * (height << 1)];
            img.getRGB(rgbInput, 0, width, 0, 0, width, height);
            int k = 0;
            int i = 0;
            while (i < height << 1) {
                int j = 0;
                while (j < width << 1) {
                    rgbOutput[i * (width << 1) + j] = rgbInput[k];
                    rgbOutput[(i + 1) * (width << 1) + j] = rgbInput[k];
                    rgbOutput[i * (width << 1) + j + 1] = rgbInput[k];
                    rgbOutput[(i + 1) * (width << 1) + j + 1] = rgbInput[k];
                    ++k;
                    j += 2;
                }
                i += 2;
            }
            Image image = Image.createRGBImage((int[])rgbOutput, (int)(width << 1), (int)(height << 1), (boolean)true);
            return image;
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            Image image = img;
            return image;
        }
        finally {
            rgbOutput = null;
            rgbInput = null;
        }
    }
}

