/*
 * Decompiled with CFR 0.152.
 */
public class FastMath {
    static final long _sq2p1 = 2531486L;
    static final long _sq2m1 = 434334L;
    static final long _p4 = 16938320L;
    static final long _p3 = 281464512L;
    static final long _p2 = 1209038848L;
    static final long _p1 = 1866891392L;
    static final long _p0 = 940348224L;
    static final long _q4 = 61820864L;
    static final long _q3 = 562315008L;
    static final long _q2 = 1747749504L;
    static final long _q1 = 2180340736L;
    static final long _q0 = 940348224L;
    public static final long _PI = 3294198L;
    public static final long _PIO2 = 1647099L;
    static final long _a3 = 1647028L;
    static final long _a2 = 222417L;
    static final long _a1 = 77868L;
    static final long _a0 = 19639L;
    private static int[] SinCos = new int[]{0, 18300, 36594, 54878, 73144, 91389, 109606, 127789, 145933, 164033, 182083, 200077, 218011, 235878, 253673, 271391, 289026, 306573, 324027, 341382, 358634, 375776, 392803, 409711, 426494, 443147, 459665, 476043, 492276, 508359, 524288, 540056, 555660, 571095, 586356, 601438, 616337, 631048, 645567, 659890, 674011, 687927, 701634, 715127, 728402, 741455, 754282, 766879, 779243, 791370, 803255, 814896, 826289, 837430, 848315, 858943, 869308, 879409, 889242, 898805, 908093, 917105, 925837, 934288, 942453, 950332, 957921, 965219, 972222, 978930, 985339, 991448, 997255, 1002758, 1007955, 1012846, 1017428, 1021701, 1025662, 1029310, 1032645, 1035666, 1038371, 1040760, 1042831, 1044585, 1046021, 1047138, 1047937, 1048416, 1048575};
    public static int seed = (int)System.currentTimeMillis();
    public static final long PRECISION = 20L;
    public static final long PRECISION_SQUARE = 40L;
    public static final long PRECISION_ROOT = 10L;
    public static final long UNITAGE = 0x100000L;
    public static final long UNITAGE_SQUARE = 0x10000000000L;
    public static final long UNITAGE_ROOT = 1024L;
    public static final float _LONG_FLOAT = 9.536743E-7f;
    public static final long UNITAGE_MASK = 1048575L;
    public static final long UNITAGE_MASK_SQUARE = 0xFFFFFFFFFFL;
    public static final long UNITAGE_MASK_ROOT = 1023L;
    public static final long INT_MAX = Long.MAX_VALUE;
    public static final long MULT_LIMIT = 31L;
    public static final long __D2P = 18301L;
    public static final long __P2D = 60078991L;

    public static long sin(long l) {
        l = l * 60078991L >> 20;
        int n = (int)(l >> 20);
        long l2 = (l - (long)n * 0x100000L) * 18301L >> 20;
        long l3 = 0L;
        long l4 = 0L;
        if ((n %= 360) < 0) {
            n += 360;
        }
        if (n <= 90) {
            l3 = SinCos[n];
            l4 = SinCos[90 - n];
        } else if (n < 180) {
            l3 = SinCos[180 - n];
            l4 = -SinCos[n - 90];
        } else if (n < 270) {
            l3 = -SinCos[n - 180];
            l4 = -SinCos[270 - n];
        } else {
            l3 = -SinCos[360 - n];
            l4 = SinCos[n - 270];
        }
        return l3 * (0x100000L - ((l2 * l2 >> 20) * (524288L - l2 * l2 / 0x1800000L) >> 20)) + l4 * (l2 * (0x100000L - ((l2 * l2 >> 20) * (174762L + l2 * l2 / 0x7800000L) >> 20)) >> 20) >> 20;
    }

    public static long cos(long l) {
        l = l * 60078991L >> 20;
        int n = (int)(l >> 20);
        long l2 = (l - (long)n * 0x100000L) * 18301L >> 20;
        long l3 = 0L;
        long l4 = 0L;
        if ((n %= 360) < 0) {
            n += 360;
        }
        if (n <= 90) {
            l3 = SinCos[n];
            l4 = SinCos[90 - n];
        } else if (n < 180) {
            l3 = SinCos[180 - n];
            l4 = -SinCos[n - 90];
        } else if (n < 270) {
            l3 = -SinCos[n - 180];
            l4 = -SinCos[270 - n];
        } else {
            l3 = -SinCos[360 - n];
            l4 = SinCos[n - 270];
        }
        return l4 * (0x100000L - ((l2 * l2 >> 20) * (524288L - l2 * l2 / 0x1800000L) >> 20)) - l3 * (l2 * (0x100000L - ((l2 * l2 >> 20) * (174762L + l2 * l2 / 0x7800000L) >> 20)) >> 20) >> 20;
    }

    public static long tan(long l) {
        return (FastMath.sin(l) << 20) / FastMath.cos(l);
    }

    public static long acos(long l) {
        if (l >= 0x100000L) {
            return 0L;
        }
        if (l <= -1048576L) {
            return 3294198L;
        }
        boolean bl = l < 0L;
        l = Math.abs(l);
        FastMath.CheckMutl(19639L, l, "acos");
        long l2 = FastMath.fastSqrt(0x100000L - l << 20) * (1647028L - (l * (222417L - (l * (77868L - (19639L * l >> 20)) >> 20)) >> 20)) >> 20;
        if (bl) {
            return 3294198L - l2;
        }
        return l2;
    }

    public static long atan(long l) {
        if (l > 0L) {
            return FastMath.msatan(l);
        }
        return -FastMath.msatan(-l);
    }

    public static long sign(long l) {
        if (l < 0L) {
            return -1048576L;
        }
        return 0x100000L;
    }

    public static long atan2f(long l, long l2) {
        long l3;
        long l4;
        if (l2 == 0L) {
            if (l > 0L) {
                return 1647099L;
            }
            if (l == 0L) {
                return 0L;
            }
            return -1647099L;
        }
        FastMath.CheckMutl(l, 0x100000L, "atan2f");
        long l5 = (l << 20) / l2;
        long l6 = Math.abs(l5);
        if (l6 > Integer.MIN_VALUE) {
            long l7 = (l6 >> 31) + 1L;
            long l8 = l5 / l7;
            FastMath.CheckMutl(l8, l8, "sqad");
            long l9 = l8 * l8 >> 20;
            FastMath.CheckMutl(l9, l7);
            FastMath.CheckMutl(l9 * l7, l7);
            l4 = l9 * l7 * l7;
        } else {
            FastMath.CheckMutl(l5, l5, "sqad");
            l4 = l5 * l5 >> 20;
        }
        if (Math.abs(l5) < 0x100000L) {
            l3 = (l5 << 20) / (0x100000L + 28L * l4 / 100L);
            if (l2 < 0L) {
                if (l < 0L) {
                    return l3 - 3294198L;
                }
                return l3 + 3294198L;
            }
        } else {
            l3 = 1647099L - (l5 << 20) / (l4 + 293601L);
            if (l < 0L) {
                return l3 - 3294198L;
            }
        }
        return l3;
    }

    private static long mxatan(long l) {
        FastMath.CheckMutl(l, l, "mxatanA");
        FastMath.CheckMutl(l, l, "mxatanC");
        long l2 = l * l >> 20;
        FastMath.CheckMutl(l2, 16938320L, "mxatanD");
        long l3 = (((((((16938320L * l2 >> 20) + 281464512L) * l2 >> 20) + 1209038848L) * l2 >> 20) + 1866891392L) * l2 >> 20) + 940348224L;
        FastMath.CheckMutl(l3, 0x100000L, "mxatanE");
        l3 = (l3 << 20) / ((((((((61820864L * l2 >> 20) + 562315008L) * l2 >> 20) + 1747749504L) * l2 >> 20) + 2180340736L) * l2 >> 20) + 940348224L);
        FastMath.CheckMutl(l3, l, "maxtananG");
        return l3 * l >> 20;
    }

    private static long msatan(long l) {
        if (l < 434334L) {
            return FastMath.mxatan(l);
        }
        if (l > 2531486L) {
            return 1647099L - FastMath.mxatan(0x10000000000L / l);
        }
        return 823549L + FastMath.mxatan((l - 0x100000L << 20) / (l + 0x100000L));
    }

    public static long fastSqrt(long l) {
        long l2 = 0L;
        long l3 = l;
        for (long i = 0x4000000000000000L; i != 0L; i >>= 2) {
            long l4 = l2 + i;
            l2 >>= 1;
            if (l4 > l3) continue;
            l3 -= l4;
            l2 += i;
        }
        return l2;
    }

    public static int fastSqrt(int n) {
        int n2 = 0;
        int n3 = n;
        for (int i = 0x40000000; i != 0; i >>= 2) {
            int n4 = n2 + i;
            n2 >>= 1;
            if (n4 > n3) continue;
            n3 -= n4;
            n2 += i;
        }
        return n2;
    }

    public static int getNextInt() {
        seed = seed * 1664525 + 1013904223;
        return seed;
    }

    public static int GetRandom(int n) {
        int n2 = 0;
        if (n != 0) {
            n2 = Math.abs(FastMath.getNextInt());
            n2 %= n + 1;
        }
        return n2;
    }

    public static int _COMPUTE_BITS(long l) {
        if ((l = Math.abs(l)) == 0L) {
            return 0;
        }
        long l2 = Long.MIN_VALUE;
        int n = 64;
        while ((l & l2) == 0L) {
            l2 >>= 1;
            --n;
        }
        return n;
    }

    public static void CheckMutl(long l, long l2) {
        FastMath.CheckMutl(l, l2, "");
    }

    public static void CheckMutl(long l, long l2, String string) {
    }

    public static long mutl(long l, long l2) {
        long l3 = l >> 20;
        long l4 = l & 0xFFFFFL;
        long l5 = l2 >> 20;
        long l6 = l2 & 0xFFFFFL;
        FastMath.CheckMutl(l3, l5);
        FastMath.CheckMutl(l3 * l5, 0x100000L);
        FastMath.CheckMutl(l4, l5);
        FastMath.CheckMutl(l3, l6);
        long l7 = l3 * l5 << 20;
        long l8 = l4 * l6 >> 20;
        long l9 = l4 * l5;
        long l10 = l3 * l6;
        long l11 = l7 + l8 + l9 + l10;
        return l11;
    }
}

