/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsTools {
    private static int s_lastProcessedImage;
    private static int[] s_lastProcessedData;
    private static int MAX_TRANSLUCENTRECT_WIDTH;
    private static int MAX_TRANSLUCENTRECT_HEIGHT;
    private static int[] s_prevTranslucentData;
    private static int s_prevTranslucentColor;
    private static int s_prevTranslucentRectWidth;
    private static int s_prevTranslucentRectHeight;
    public static final int GRADIENT_TYPE_HORIZENTAL = 1;
    public static final int GRADIENT_TYPE_VERTICAL = 0;
    public static final int BOX_DRAWING_TYPE1 = 0;
    public static final int BOX_DRAWING_TYPE2 = 1;
    public static final int BOX_DRAWING_TYPE3 = 2;
    public static final int BOX_DRAWING_TYPE4 = 3;
    public static final int BOX_DIRECTION_HORIZONTAL = 0;
    public static final int BOX_DIRECTION_VERTICAL = 1;
    private static final int CLIPBUFFER_DEPTH = 5;
    private static int[][] s_clipBuffer;
    private static int s_clipBufferCursor;

    public static void rectangle(Graphics graphics, long l, int n, int n2, int n3, int n4) {
        long l2 = FastMath.sin(l);
        long l3 = FastMath.cos(l);
        int n5 = (int)(l3 >> 20);
        int n6 = (int)(l2 >> 20);
        int n7 = n5 * -(n3 /= 2) - n6 * (n4 /= 2) + n;
        int n8 = n6 * -n3 + n5 * n4 + n2;
        int n9 = n5 * n3 - n6 * n4 + n;
        int n10 = n6 * n3 + n5 * n4 + n2;
        int n11 = n5 * n3 - n6 * -n4 + n;
        int n12 = n6 * n3 + n5 * -n4 + n2;
        int n13 = n5 * -n3 - n6 * -n4 + n;
        int n14 = n6 * -n3 + n5 * -n4 + n2;
        graphics.drawLine(n7, n8, n9, n10);
        graphics.drawLine(n9, n10, n11, n12);
        graphics.drawLine(n11, n12, n13, n14);
        graphics.drawLine(n13, n14, n7, n8);
    }

    public static final int fade(int n, int n2, int n3) {
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = n2 >> 16 & 0xFF;
        int n8 = n2 >> 8 & 0xFF;
        int n9 = n2 & 0xFF;
        int n10 = n4 + (n7 - n4) * n3 / 100;
        int n11 = n5 + (n8 - n5) * n3 / 100;
        int n12 = n6 + (n9 - n6) * n3 / 100;
        return n10 << 16 | n11 << 8 | n12;
    }

    public static final Image createSubImage(Image image, int n, int n2, int n3, int n4) {
        if (image != null) {
            int n5 = n3 * n4;
            int[] nArray = new int[n5];
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            image.getRGB(nArray, 0, n3, n, n2, n3, n4);
            return Image.createRGBImage((int[])nArray, (int)n3, (int)n4, (boolean)true);
        }
        return null;
    }

    public static final Image createTranslucentImage(Image image, int n) {
        int[] nArray = GraphicsTools.getTranslucentRGB(image, n);
        if (nArray != null) {
            return Image.createRGBImage((int[])nArray, (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
        }
        return null;
    }

    public static final int[] getTranslucentRGB(Image image, int n) {
        if (image.hashCode() == s_lastProcessedImage) {
            return s_lastProcessedData;
        }
        int n2 = image.getWidth() * image.getHeight();
        s_lastProcessedData = new int[n2];
        image.getRGB(s_lastProcessedData, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3++;
            s_lastProcessedData[n4] = s_lastProcessedData[n4] & (n & 0xFFFFFFFF);
        }
        return s_lastProcessedData;
    }

    public static final void drawTranslucentRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (s_prevTranslucentData == null || n5 != s_prevTranslucentColor) {
            n7 = n3 / 10;
            if (n7 > MAX_TRANSLUCENTRECT_WIDTH) {
                n7 = MAX_TRANSLUCENTRECT_WIDTH;
            }
            if ((n6 = n4 / 10) > MAX_TRANSLUCENTRECT_HEIGHT) {
                n6 = MAX_TRANSLUCENTRECT_HEIGHT;
            }
            s_prevTranslucentData = new int[n7 * n6];
            s_prevTranslucentRectWidth = n7;
            s_prevTranslucentRectHeight = n6;
            s_prevTranslucentColor = n5;
            s_prevTranslucentData = GraphicsTools.getTranslucentRGB(n7, n6, n5);
        }
        for (n7 = 0; n7 < n3; n7 += s_prevTranslucentRectWidth) {
            for (n6 = 0; n6 < n4; n6 += s_prevTranslucentRectHeight) {
                graphics.drawRGB(s_prevTranslucentData, 0, s_prevTranslucentRectWidth, n + n7, n2 + n6, s_prevTranslucentRectWidth, s_prevTranslucentRectHeight, true);
            }
        }
    }

    public static final int[] getTranslucentRGB(int n, int n2, int n3) {
        int[] nArray = new int[n * n2];
        if ((n3 >> 24 & 0xFF) == 0) {
            n3 |= 0xFF000000;
        }
        for (int i = 0; i < n * n2; ++i) {
            nArray[i] = n3;
        }
        return nArray;
    }

    public static int[] getScaledRGB(Image image, int n, int n2) {
        if (image != null) {
            int n3 = image.getWidth();
            int n4 = image.getHeight();
            int n5 = n3 * n4;
            int[] nArray = new int[n5];
            image.getRGB(nArray, 0, n3, 0, 0, n3, n4);
            int n6 = n * n2;
            int[] nArray2 = new int[n6];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray2[i * n + j] = nArray[i * n4 / n2 * n3 + j * n3 / n];
                }
            }
            nArray = null;
            return nArray2;
        }
        return null;
    }

    public static Image scaleImage(Image image, int n, int n2) {
        int[] nArray = GraphicsTools.getScaledRGB(image, n, n2);
        if (nArray != null) {
            return Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)true);
        }
        return null;
    }

    public static void drawGradient(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        block3: {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            block2: {
                n13 = n5 >> 16 & 0xFF;
                n12 = n6 >> 16 & 0xFF;
                n11 = n5 >> 8 & 0xFF;
                n10 = n6 >> 8 & 0xFF;
                n9 = n5 & 0xFF;
                n8 = n6 & 0xFF;
                if (n7 != 1) break block2;
                for (int i = 0; i < n3; ++i) {
                    int n14 = (i << 16) / n3;
                    int n15 = n13 + (n14 * (n12 - n13) >> 16);
                    int n16 = n11 + (n14 * (n10 - n11) >> 16);
                    int n17 = n9 + (n14 * (n8 - n9) >> 16);
                    graphics.setColor(n15 << 16 | n16 << 8 | n17);
                    graphics.drawRect(n + i, n2, 0, n4 - 1);
                }
                break block3;
            }
            if (n7 != 0) break block3;
            for (int i = 0; i < n4; ++i) {
                int n18 = (i << 16) / n4;
                int n19 = n13 + (n18 * (n12 - n13) >> 16);
                int n20 = n11 + (n18 * (n10 - n11) >> 16);
                int n21 = n9 + (n18 * (n8 - n9) >> 16);
                graphics.setColor(n19 << 16 | n20 << 8 | n21);
                graphics.drawRect(n, n2 + i, n3 - 1, 0);
            }
        }
    }

    public static void clipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        int n9 = n > n5 ? n : n5;
        int n10 = n2 > n6 ? n2 : n6;
        int n11 = (n + n3 < n5 + n7 ? n + n3 : n5 + n7) - n9;
        int n12 = (n2 + n4 < n6 + n8 ? n2 + n4 : n6 + n8) - n10;
        graphics.setClip(n9, n10, n11, n12);
    }

    public static void drawBox(Graphics graphics, int n, Image[] imageArray, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        GraphicsTools.drawBox(graphics, n, imageArray, n2, n3, n4, n5, n6, nArray, 0);
    }

    public static void drawBox(Graphics graphics, int n, Image[] imageArray, int n2, int n3, int n4, int n5, int n6, int[] nArray, int n7) {
        if ((n6 & 1) != 0) {
            n2 -= n4 >> 1;
        } else if ((n6 & 8) != 0) {
            n2 -= n4;
        }
        if ((n6 & 2) != 0) {
            n3 -= n5 >> 1;
        } else if ((n6 & 0x20) != 0) {
            n3 -= n5;
        }
        if (n == 0 || n == 1) {
            graphics.drawImage(imageArray[0], n2, n3, 20);
            if (n7 == 0) {
                int n8 = imageArray[1].getWidth();
                int n9 = n2 + n4 - imageArray[n == 0 ? 0 : 2].getWidth();
                for (int i = n2 + imageArray[0].getWidth(); i <= n9 - n8; i += n8) {
                    graphics.drawImage(imageArray[1], i, n3, 20);
                }
                graphics.drawImage(imageArray[1], n9, n3, 24);
            } else if (n7 == 1) {
                int n10 = imageArray[1].getHeight();
                int n11 = n3 + n5 - imageArray[n == 0 ? 0 : 2].getHeight();
                for (int i = n3 + imageArray[0].getHeight(); i <= n11 - n10; i += n10) {
                    graphics.drawImage(imageArray[1], n2, i, 20);
                }
                graphics.drawImage(imageArray[1], n2, n11, 36);
            }
            if (n7 == 0) {
                if (n == 0) {
                    graphics.drawRegion(imageArray[0], 0, 0, imageArray[0].getWidth(), imageArray[0].getHeight(), 2, n2 + n4, n3, 24);
                } else if (n == 1) {
                    graphics.drawImage(imageArray[2], n2 + n4, n3, 24);
                }
            } else if (n7 == 1) {
                if (n == 0) {
                    graphics.drawRegion(imageArray[0], 0, 0, imageArray[0].getWidth(), imageArray[0].getHeight(), 1, n2 + n4, n3, 36);
                } else if (n == 1) {
                    graphics.drawImage(imageArray[2], n2, n3 + n5, 36);
                }
            }
        } else if (n == 2 || n == 3) {
            int n12;
            int n13 = imageArray[0].getWidth();
            int n14 = imageArray[0].getHeight();
            int n15 = n13;
            int n16 = n14;
            if (n == 3) {
                n15 = imageArray[3].getWidth();
                n16 = imageArray[3].getHeight();
            }
            for (n12 = n13; n12 < n4 - n13; n12 += imageArray[1].getWidth()) {
                graphics.drawImage(imageArray[1], n2 + n12, n3, 20);
            }
            for (n12 = n15; n12 < n4 - n15; n12 += imageArray[1].getWidth()) {
                graphics.drawImage(imageArray[1], n2 + n12, n3 + n5, 36);
            }
            for (n12 = n14; n12 < n5 - n16; n12 += imageArray[2].getHeight()) {
                graphics.drawImage(imageArray[2], n2, n3 + n12, 20);
                graphics.drawImage(imageArray[2], n2 + n4, n3 + n12, 24);
            }
            if (n == 2) {
                graphics.drawImage(imageArray[0], n2, n3, 20);
                graphics.drawRegion(imageArray[0], 0, 0, imageArray[0].getWidth(), imageArray[0].getHeight(), 2, n2 + n4, n3, 24);
                graphics.drawRegion(imageArray[0], 0, 0, imageArray[0].getWidth(), imageArray[0].getHeight(), 1, n2, n3 + n5, 36);
                graphics.drawRegion(imageArray[0], 0, 0, imageArray[0].getWidth(), imageArray[0].getHeight(), 3, n2 + n4, n3 + n5, 40);
            } else {
                graphics.drawImage(imageArray[0], n2, n3, 20);
                graphics.drawRegion(imageArray[0], 0, 0, imageArray[0].getWidth(), imageArray[0].getHeight(), 2, n2 + n4, n3, 24);
                graphics.drawImage(imageArray[3], n2, n3 + n5, 36);
                graphics.drawRegion(imageArray[3], 0, 0, imageArray[3].getWidth(), imageArray[3].getHeight(), 2, n2 + n4, n3 + n5, 40);
            }
        }
        if (nArray != null) {
            graphics.setColor(nArray[0]);
            graphics.fillRect(n2 + nArray[1], n3 + nArray[2], nArray[3], nArray[4]);
        }
    }

    private static void pushClip(Graphics graphics) {
        GraphicsTools.s_clipBuffer[GraphicsTools.s_clipBufferCursor][0] = graphics.getClipX();
        GraphicsTools.s_clipBuffer[GraphicsTools.s_clipBufferCursor][1] = graphics.getClipY();
        GraphicsTools.s_clipBuffer[GraphicsTools.s_clipBufferCursor][2] = graphics.getClipWidth();
        GraphicsTools.s_clipBuffer[GraphicsTools.s_clipBufferCursor][3] = graphics.getClipHeight();
        s_clipBufferCursor = (s_clipBufferCursor + 1) % 5;
    }

    private static void popClip(Graphics graphics) {
        if (--s_clipBufferCursor < 0) {
            s_clipBufferCursor = 4;
        }
        graphics.setClip(s_clipBuffer[s_clipBufferCursor][0], s_clipBuffer[s_clipBufferCursor][1], s_clipBuffer[s_clipBufferCursor][2], s_clipBuffer[s_clipBufferCursor][3]);
    }

    public static Image changeColor(Image image, int n, int n2) {
        if (n == n2) {
            return image;
        }
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        int[] nArray = new int[n3 * n4];
        image.getRGB(nArray, 0, n3, 0, 0, n3, n4);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            nArray[i] = n2;
        }
        return Image.createRGBImage((int[])nArray, (int)n3, (int)n4, (boolean)true);
    }

    static {
        MAX_TRANSLUCENTRECT_WIDTH = 32;
        MAX_TRANSLUCENTRECT_HEIGHT = 32;
        s_clipBuffer = new int[5][4];
    }
}

