/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public abstract class MOBCanvas
extends Canvas
implements Runnable {
    public static MIDlet midlet;
    private Thread thread;
    private boolean exitThread;
    private int maxMillisPerTick;
    private int minMillisPerTick;
    private long currTime;
    private long lastTime;
    private static final int SYSTEM_EVENT_NONE = -1;
    public static final int SYSTEM_EVENT_EXIT = 0;
    public static final int SYSTEM_EVENT_START = 1;
    public static final int SYSTEM_EVENT_INTERRUPT = 2;
    public static final int SYSTEM_EVENT_RESUME = 3;
    public static final int SYSTEM_EVENT_RESUME_AUDIO = 4;
    public static final int MOB_KEYBIT_NUM0 = 1;
    public static final int MOB_KEYBIT_NUM1 = 2;
    public static final int MOB_KEYBIT_NUM2 = 4;
    public static final int MOB_KEYBIT_NUM3 = 8;
    public static final int MOB_KEYBIT_NUM4 = 16;
    public static final int MOB_KEYBIT_NUM5 = 32;
    public static final int MOB_KEYBIT_NUM6 = 64;
    public static final int MOB_KEYBIT_NUM7 = 128;
    public static final int MOB_KEYBIT_NUM8 = 256;
    public static final int MOB_KEYBIT_NUM9 = 512;
    public static final int MOB_KEYBIT_POUND = 1024;
    public static final int MOB_KEYBIT_STAR = 2048;
    public static final int MOB_KEYBIT_LEFT = 4096;
    public static final int MOB_KEYBIT_RIGHT = 8192;
    public static final int MOB_KEYBIT_UP = 16384;
    public static final int MOB_KEYBIT_DOWN = 32768;
    public static final int MOB_KEYBIT_SELECT = 65536;
    public static final int MOB_KEYBIT_SOFTKEY_LEFT = 131072;
    public static final int MOB_KEYBIT_SOFTKEY_RIGHT = 262144;
    public static int applicationStatus;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_STARTED = 1;
    public static final int STATUS_RESUMED = 2;
    public static final int STATUS_PAUSED = 3;
    public static int CANVAS_WIDTH;
    public static int CANVAS_HEIGHT;
    public static boolean isPaused;
    private int eventToTreat;
    private int keyTypedStates;
    private int keyReleasedStates;
    public static int pointerCoordX;
    public static int pointerCoordY;
    private String[] stringPool;

    abstract void paintGameView(Graphics var1);

    abstract void tickGameLogic();

    abstract void exit();

    MOBCanvas(MIDlet mIDlet) {
        midlet = mIDlet;
        applicationStatus = 0;
        this.setFullScreenMode(true);
        CANVAS_WIDTH = this.getWidth();
        CANVAS_HEIGHT = this.getHeight();
        this.eventToTreat = 0;
        this.keyTypedStates = 0;
        this.keyReleasedStates = 0;
        pointerCoordX = -1;
        pointerCoordY = -1;
        this.postSystemEvent(1);
        this.exitThread = false;
        this.thread = new Thread(this);
        this.thread.start();
        menuGame.loadStringsAndFonts();
    }

    public void showNotify() {
        if (applicationStatus == 1 || applicationStatus == 0) {
            return;
        }
        this.postSystemEvent(3);
    }

    public void hideNotify() {
        if (gameTopLevel.gameState >= 6) {
            isPaused = true;
        }
        if (applicationStatus == 3 || applicationStatus == 0) {
            return;
        }
        this.onSystemEvent(2);
    }

    public void postSystemEvent(int n) {
        this.eventToTreat = n;
    }

    public void onSystemEvent(int n) {
        switch (n) {
            case 1: {
                applicationStatus = 1;
                break;
            }
            case 0: {
                break;
            }
            case 3: {
                applicationStatus = 2;
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                applicationStatus = 3;
            }
        }
        if (n == 0) {
            this.exitThread = true;
        }
        if (n == 3) {
            this.postSystemEvent(4);
        } else {
            this.eventToTreat = -1;
        }
    }

    public void run() {
        while (!this.exitThread) {
            try {
                this.currTime = System.currentTimeMillis();
                if (this.eventToTreat != -1) {
                    this.onSystemEvent(this.eventToTreat);
                }
                if (!isPaused) {
                    this.tickGameLogic();
                }
                this.repaint();
                this.serviceRepaints();
                long l = System.currentTimeMillis() - this.currTime;
                if (l < (long)this.maxMillisPerTick) {
                    try {
                        Thread.sleep((long)this.maxMillisPerTick - l);
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.eventToTreat != -1) {
                    this.onSystemEvent(this.eventToTreat);
                }
                this.lastTime = this.currTime;
            }
            catch (Exception exception) {}
        }
        midlet.notifyDestroyed();
    }

    public void paint(Graphics graphics) {
        try {
            if (isPaused) {
                int n = (this.getHeight() - (70 + 3 * menuGame.font.getHeight())) / 2;
                graphics.setColor(0, 0, 0);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                menuGame.drawBox(graphics, 15, n, this.getWidth() - 30, 70 + 3 * menuGame.font.getHeight());
                menuGame.drawTitle(graphics, this.getUtfText(11), (this.getWidth() - menuGame.getTitleWidth(this.getUtfText(11))) / 2, n + 25);
                graphics.setFont(menuGame.font);
                n += 50;
                for (int i = 0; i < 3; ++i) {
                    String string = this.getUtfText(244 + i);
                    graphics.setColor(0, 0, 0);
                    graphics.drawString(string, (this.getWidth() - menuGame.font.stringWidth(string)) / 2 + 1, n + 1, 0x10 | 4);
                    graphics.setColor(255, 255, 255);
                    graphics.drawString(string, (this.getWidth() - menuGame.font.stringWidth(string)) / 2, n, 0x10 | 4);
                    n += menuGame.font.getHeight();
                }
                graphics.drawRegion(gameTopLevel.imgSoftkey, 2 * (gameTopLevel.imgSoftkey.getWidth() / 5), 0, gameTopLevel.imgSoftkey.getWidth() / 5, gameTopLevel.imgSoftkey.getHeight(), 0, this.getWidth() - gameTopLevel.imgSoftkey.getWidth() / 5, this.getHeight() - gameTopLevel.imgSoftkey.getHeight(), 0x10 | 4);
            } else {
                this.paintGameView(graphics);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyPressed(int n) {
        if (isPaused && n == -7) {
            if (soundGame.soundBeingPlayedId != -1) {
                gameTopLevel.mediaManager.startMusic(0, soundGame.soundBeingPlayedId);
            }
            isPaused = false;
            return;
        }
        if (n == -6) {
            this.keyTypedStates |= 0x20000;
            return;
        }
        if (n == -7) {
            this.keyTypedStates |= 0x40000;
            return;
        }
        if (n >= 48 && n <= 57) {
            this.keyTypedStates |= 1 << n - 48;
            return;
        }
        if (n == 35) {
            this.keyTypedStates |= 0x400;
            return;
        }
        if (n == 42) {
            this.keyTypedStates |= 0x800;
            return;
        }
        try {
            int n2 = this.getGameAction(n);
            switch (n2) {
                case 1: {
                    this.keyTypedStates |= 0x4000;
                    break;
                }
                case 6: {
                    this.keyTypedStates |= 0x8000;
                    break;
                }
                case 2: {
                    this.keyTypedStates |= 0x1000;
                    break;
                }
                case 5: {
                    this.keyTypedStates |= 0x2000;
                    break;
                }
                case 8: {
                    this.keyTypedStates |= 0x10000;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyReleased(int n) {
        if (n == -6) {
            this.keyReleasedStates |= 0x20000;
            return;
        }
        if (n == -7) {
            this.keyReleasedStates |= 0x40000;
            return;
        }
        if (n >= 48 && n <= 57) {
            this.keyReleasedStates |= 1 << n - 48;
            return;
        }
        if (n == 35) {
            this.keyReleasedStates |= 0x400;
            return;
        }
        if (n == 38) {
            this.keyReleasedStates |= 0x800;
            return;
        }
        try {
            int n2 = this.getGameAction(n);
            switch (n2) {
                case 1: {
                    this.keyReleasedStates |= 0x4000;
                    break;
                }
                case 6: {
                    this.keyReleasedStates |= 0x8000;
                    break;
                }
                case 2: {
                    this.keyReleasedStates |= 0x1000;
                    break;
                }
                case 5: {
                    this.keyReleasedStates |= 0x2000;
                    break;
                }
                case 8: {
                    this.keyReleasedStates |= 0x10000;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pointerPressed(int n, int n2) {
    }

    public void pointerDragged(int n, int n2) {
    }

    public void pointerReleased(int n, int n2) {
    }

    public void setMaxMillisPerTick(int n) {
        this.maxMillisPerTick = n;
    }

    public void setMinMillisPerTick(int n) {
        this.minMillisPerTick = n;
    }

    public int getElapsedMillisSinceLastTick() {
        if (this.lastTime != 0L) {
            return (int)(this.currTime - this.lastTime);
        }
        return 0;
    }

    public void updateKeyStates() {
    }

    public int getKeyTypedStates() {
        return this.keyTypedStates;
    }

    public int getKeyReleasedStates() {
        return this.keyReleasedStates;
    }

    public void resetKeyStates() {
        this.keyTypedStates = 0;
        this.keyReleasedStates = 0;
    }

    public Image getResourceImage(String string) {
        Image image = null;
        for (int i = 0; i < 10; ++i) {
            try {
                image = Image.createImage((String)string);
                break;
            }
            catch (Exception exception) {
                System.gc();
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                continue;
            }
        }
        return image;
    }

    public Image getResourceImageSimple(String string) {
        Image image = null;
        try {
            image = Image.createImage((String)string);
        }
        catch (Exception exception) {
            image = null;
        }
        return image;
    }

    public Image getResourceImage(String string, byte[] byArray) {
        return null;
    }

    public byte[] getResourceBytes(String string) {
        byte[] byArray;
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        try {
            int n = inputStream.available();
            byArray = new byte[n];
            inputStream.read(byArray);
            inputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return byArray;
    }

    public short[] getResourceShort(String string) {
        short[] sArray;
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        try {
            int n = inputStream.available();
            sArray = new short[n / 2];
            for (n = 0; n < sArray.length; ++n) {
                sArray[n] = (short)((inputStream.read() << 8) + inputStream.read());
            }
            inputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return sArray;
    }

    public void imageDrawRegion(Image image, int n, int n2, int n3, int n4, Graphics graphics, int n5, int n6) {
        graphics.drawRegion(image, n, n2, n3, n4, 0, n5, n6, 0x10 | 4);
    }

    public void imageDrawRegionFlipX(Image image, int n, int n2, int n3, int n4, Graphics graphics, int n5, int n6) {
        graphics.drawRegion(image, n, n2, n3, n4, 2, n5, n6, 0x10 | 4);
    }

    public String getUtfText(int n) {
        return Textfont.text_font[n];
    }

    public int ubyte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    public void activateUtfTextsResource(String string) {
        DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream(string));
        try {
            int n;
            int n2 = this.ubyte(dataInputStream.readByte()) * 256;
            n2 += this.ubyte(dataInputStream.readByte());
            if (this.stringPool != null) {
                for (n = 0; n < this.stringPool.length; ++n) {
                    this.stringPool[n] = null;
                }
                this.stringPool = null;
            }
            this.stringPool = new String[n2];
            for (n = 0; n < this.stringPool.length; ++n) {
                this.stringPool[n] = dataInputStream.readUTF();
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] loadFromPersistentStore(int n) {
        byte[] byArray;
        RecordStore recordStore;
        try {
            recordStore = RecordStore.openRecordStore((String)"HeavyWeap", (boolean)true);
        }
        catch (Exception exception) {
            return null;
        }
        try {
            byArray = recordStore.getRecord(n);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
        return byArray;
    }

    public boolean saveToPersistentStore(int n, byte[] byArray) {
        RecordStore recordStore;
        try {
            RecordStore.deleteRecordStore((String)"HeavyWeap");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            recordStore = RecordStore.openRecordStore((String)"HeavyWeap", (boolean)true);
        }
        catch (Exception exception) {
            return false;
        }
        try {
            recordStore.addRecord(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    static {
        isPaused = false;
    }
}

