/*
 * Decompiled with CFR 0.152.
 */
public class soundGame {
    public static boolean[] soundAllocated;
    private static String[] soundResId;
    public static int soundBeingPlayedId;
    public static MediaManager mediaManager;

    public static void init(MediaManager mediaManager) {
        soundGame.mediaManager = mediaManager;
        soundBeingPlayedId = -1;
        soundAllocated = new boolean[15];
        for (int i = 0; i < soundAllocated.length; ++i) {
            soundGame.soundAllocated[i] = false;
        }
    }

    public static void loadSound(int n, int n2) {
        if (!soundAllocated[n]) {
            if (n2 == -1) {
                mediaManager.allocateMedia(n, soundResId[n], -1, 0);
                soundGame.soundAllocated[n] = true;
            } else {
                mediaManager.allocateMedia(n, soundResId[n], n2, 0);
            }
        }
    }

    public static void loadMusic(int n, int n2) {
        if (!soundAllocated[n]) {
            if (n2 == -1) {
                mediaManager.allocateMediaMusic(n, soundResId[n], -1, 0);
                soundGame.soundAllocated[n] = true;
            } else {
                mediaManager.allocateMediaMusic(n, soundResId[n], n2, 0);
            }
        }
    }

    public static void playSound(int n) {
        mediaManager.startChannel(0, n);
    }

    public static void stopSound(int n) {
        mediaManager.stopChannel();
    }

    public static void playMusic(int n) {
        mediaManager.startMusic(1, n);
        soundBeingPlayedId = n;
    }

    public static void stopMusic(int n) {
        soundBeingPlayedId = -1;
        mediaManager.stopMusic();
    }

    public static void releaseSound(int n) {
        mediaManager.freeMedia(n);
        soundGame.soundAllocated[n] = false;
    }

    static {
        soundResId = new String[]{"/heavyweapon.snd", "/swoosh.snd", "/prepare.snd", "/danger.snd", "/levelcomplete.snd", "/denied.wav", "/button.wav", "/getready.snd", "/gameover.snd", "/megalaser.snd", "/menu.mid", "/levelup.mid", "/boss.mid", "/death.mid", "/ingame.mid"};
    }
}

