/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CFont {
    public static boolean BORDER_ENABLED = false;
    public static final int MODE_BITMAP = 0;
    public static final int MODE_LATTICE = 1;
    public static final int POSFIELD_X = 0;
    public static final int POSFIELD_Y = 1;
    public static final int POSFIELD_WIDTH = 2;
    public static final int POSFIELD_NUM = 3;
    public static final int FLAG_CHARX_SHORT = 1;
    public static final int FLAG_CHARY_SHORT = 2;
    public static final int FLAG_CHARWIDTH_SHORT = 4;
    protected int m_nChars;
    protected char[] m_chars;
    protected short[] m_posData;
    protected Image m_image;
    protected int m_height;
    protected int m_maxCharWidth;
    protected int m_lineSpacing;
    protected int m_charSpacing;
    protected int m_wordSpacing = 5;
    protected char m_newlineChar = (char)10;
    protected int m_mode;
    protected short[][] m_lattice;
    protected int m_color;
    protected boolean m_loaded;
    private int m_borderColor = -1;
    protected short[] m_posDataBackup;
    protected short[][] m_latticeBackup;
    protected int m_heightBackup;
    protected int m_charWidthBackup;
    private int m_paintWidth = 1;

    public void load(InputStream inputStream) {
        try {
            int n;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.m_mode = dataInputStream.readUnsignedByte();
            this.m_nChars = dataInputStream.readShort();
            this.m_chars = new char[this.m_nChars];
            for (n = 0; n < this.m_nChars; ++n) {
                this.m_chars[n] = dataInputStream.readChar();
            }
            this.m_maxCharWidth = dataInputStream.readShort();
            this.m_height = dataInputStream.readShort();
            if (this.m_mode == 0) {
                n = dataInputStream.readByte();
                this.m_posData = new short[3 * this.m_nChars];
                for (int i = 0; i < this.m_posData.length; i += 3) {
                    this.m_posData[i] = dataInputStream.readShort();
                    this.m_posData[i + 0] = (n & 1) != 0 ? dataInputStream.readShort() : (short)dataInputStream.readByte();
                    this.m_posData[i + 1] = (n & 2) != 0 ? dataInputStream.readShort() : (short)dataInputStream.readByte();
                    this.m_posData[i + 2] = (n & 4) != 0 ? dataInputStream.readShort() : (short)dataInputStream.readByte();
                }
            } else if (this.m_mode == 1) {
                this.m_color = dataInputStream.readInt();
                this.m_posData = new short[this.m_nChars];
                for (n = 0; n < this.m_nChars; ++n) {
                    this.m_posData[n] = (short)dataInputStream.readUnsignedByte();
                }
                this.m_lattice = new short[this.m_nChars][];
                n = dataInputStream.readBoolean() ? 1 : 0;
                for (int i = 0; i < this.m_nChars; ++i) {
                    int n2 = n != 0 ? dataInputStream.readShort() : dataInputStream.readUnsignedByte();
                    this.m_lattice[i] = new short[n2 * 2];
                    for (int j = 0; j < n2; ++j) {
                        this.m_lattice[i][2 * j] = n != 0 ? dataInputStream.readShort() : (short)(dataInputStream.readUnsignedByte() & 0xFF);
                        this.m_lattice[i][2 * j + 1] = (short)(dataInputStream.readUnsignedByte() & 0xFF);
                    }
                }
            }
            this.m_loaded = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setBorderEnabled(boolean bl) {
        BORDER_ENABLED = bl;
    }

    public void setImage(Image image) {
        if (this.m_mode == 0) {
            this.m_image = image;
        }
    }

    public int findCharIndex(char c) {
        if (c < this.m_chars[0] || c > this.m_chars[this.m_nChars - 1]) {
            return -1;
        }
        int n = 0;
        int n2 = this.m_nChars;
        int n3;
        char c2;
        while ((c2 = this.m_chars[n3 = n + (n2 - n) / 2]) != c) {
            if (n == n2 || n3 == n || n3 == n2) {
                return -1;
            }
            if (c > c2) {
                n = n3;
                continue;
            }
            n2 = n3;
        }
        return n3;
    }

    public void setBorder(int n) {
        if (BORDER_ENABLED) {
            this.m_borderColor = n;
        }
    }

    public void scale(int n) {
        if (this.m_mode == 1) {
            if (this.m_posDataBackup == null) {
                int n2 = this.m_posData.length;
                this.m_posDataBackup = new short[n2];
                System.arraycopy(this.m_posData, 0, this.m_posDataBackup, 0, n2);
                n2 = this.m_lattice.length;
                this.m_latticeBackup = new short[n2][];
                for (int i = 0; i < n2; ++i) {
                    this.m_latticeBackup[i] = new short[this.m_lattice[i].length];
                    System.arraycopy(this.m_lattice[i], 0, this.m_latticeBackup[i], 0, this.m_lattice[i].length);
                }
                this.m_heightBackup = this.m_height;
                this.m_charWidthBackup = this.m_maxCharWidth;
            }
            short[] sArray = null;
            short[] sArray2 = null;
            int n3 = 0;
            for (int i = 0; i < this.m_nChars; ++i) {
                short s = this.m_posDataBackup[i];
                this.m_posData[i] = (short)(this.m_posDataBackup[i] * n >> 8);
                sArray = this.m_latticeBackup[i];
                sArray2 = this.m_lattice[i];
                int n4 = sArray2.length;
                for (int j = 0; j < n4; j += 2) {
                    n3 = sArray[j];
                    int n5 = n3 % s;
                    int n6 = n3 / s;
                    n5 = n5 * n >> 8;
                    n6 = n6 * n >> 8;
                    sArray2[j] = (short)(n6 * this.m_posData[i] + n5);
                    n3 = sArray[j + 1] & 0x7F;
                    n3 = n3 * n >> 8;
                    int n7 = j + 1;
                    sArray2[n7] = (short)(sArray2[n7] & 0x80);
                    int n8 = j + 1;
                    sArray2[n8] = (short)(sArray2[n8] | n3 & 0x7F);
                }
            }
            this.m_paintWidth = n >> 8;
            if (this.m_paintWidth == 0) {
                this.m_paintWidth = 1;
            }
            this.m_height = this.m_heightBackup * n >> 8;
            this.m_maxCharWidth = this.m_charWidthBackup * n >> 8;
        }
    }

    public void draw(Graphics graphics, String string, int n, int n2) {
        if (this.m_mode == 0 && this.m_image == null || !this.m_loaded || string == null) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.m_mode == 0) {
            n3 = graphics.getClipX();
            n4 = graphics.getClipY();
            n5 = graphics.getClipWidth();
            n6 = graphics.getClipHeight();
        }
        for (int i = 0; i < string.length(); ++i) {
            boolean bl;
            int n7;
            short s;
            int n8;
            int n9;
            short s2;
            int n10;
            short s3;
            int n11;
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') continue;
            if (c == ' ') {
                n += this.m_wordSpacing;
                continue;
            }
            int n12 = this.findCharIndex(c);
            if (n12 == -1) {
                graphics.setColor(0xFF0000);
                graphics.fillRect(n + 1, n2 + 1, this.m_wordSpacing * 2 - 2, this.m_height - 2);
                graphics.setColor(65280);
                graphics.fillRect(n + 2, n2 + 2, this.m_wordSpacing * 2 - 4, this.m_height - 4);
                n += 2 * this.m_wordSpacing + this.m_charSpacing;
                continue;
            }
            if (this.m_mode == 0) {
                n11 = this.m_posData[n12 * 3 + 0];
                s3 = this.m_posData[n12 * 3 + 1];
                n10 = this.m_posData[n12 * 3 + 2];
                graphics.setClip(n, n2, n10, this.m_height);
                graphics.drawImage(this.m_image, n - n11, n2 - s3, 20);
                n += n10 + this.m_charSpacing;
                continue;
            }
            if (this.m_mode != 1) continue;
            graphics.setColor(this.m_color);
            n11 = this.m_lattice[n12].length;
            s3 = this.m_posData[n12];
            if (BORDER_ENABLED && this.m_borderColor != -1) {
                for (n10 = 0; n10 < n11; n10 += 2) {
                    s2 = this.m_lattice[n12][n10];
                    n9 = s2 % s3;
                    n8 = s2 / s3;
                    s = this.m_lattice[n12][n10 + 1];
                    n7 = s & 0x7F;
                    bl = (s >> 7 & 1) != 0;
                    graphics.setColor(this.m_borderColor);
                    if (bl) {
                        graphics.fillRect(n + n9 - 1, n2 + n8 - 1, this.m_paintWidth + 2, n7 + 2);
                    } else {
                        graphics.fillRect(n + n9 - 1, n2 + n8 - 1, n7 + 2, this.m_paintWidth + 2);
                    }
                    graphics.setColor(this.m_color);
                }
            }
            for (n10 = 0; n10 < n11; n10 += 2) {
                s2 = this.m_lattice[n12][n10];
                n9 = s2 % s3;
                n8 = s2 / s3;
                s = this.m_lattice[n12][n10 + 1];
                n7 = s & 0x7F;
                boolean bl2 = bl = (s >> 7 & 1) != 0;
                if (bl) {
                    graphics.fillRect(n + n9, n2 + n8, this.m_paintWidth, n7);
                    continue;
                }
                graphics.fillRect(n + n9, n2 + n8, n7, this.m_paintWidth);
            }
            n += s3 + this.m_charSpacing + (this.m_borderColor == -1 ? 0 : 2);
        }
        if (this.m_mode == 0) {
            graphics.setClip(n3, n4, n5, n6);
        }
    }

    public void draw(Graphics graphics, String string, int n, int n2, int n3) {
        if (this.m_mode == 0 && this.m_image == null || !this.m_loaded || string == null) {
            return;
        }
        int n4 = this.stringWidth(string);
        if ((n3 & 1) != 0) {
            n -= n4 >> 1;
        } else if ((n3 & 8) != 0) {
            n -= n4;
        }
        if ((n3 & 2) != 0) {
            n2 -= this.m_height >> 1;
        } else if ((n3 & 0x20) != 0) {
            n2 -= this.m_height;
        }
        this.draw(graphics, string, n, n2);
    }

    public int stringWidth(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\r') continue;
            if (c == ' ') {
                n += this.m_wordSpacing;
                continue;
            }
            int n2 = this.findCharIndex(c);
            if (n2 == -1) {
                if (c == '\r' || c == '\n') continue;
                n += 2 * this.m_wordSpacing + this.m_charSpacing;
                continue;
            }
            short s = this.m_mode == 0 ? this.m_posData[n2 * 3 + 2] : this.m_posData[n2];
            n += s + this.m_charSpacing + (this.m_borderColor == -1 ? 0 : 2);
        }
        return n;
    }

    public Image getImage() {
        return this.m_image;
    }

    public short[] wrapString(String string, int n, boolean bl, boolean bl2) {
        String[] stringArray = this.splitString(string, n, bl, bl2);
        if (stringArray != null) {
            int n2 = stringArray.length + 3;
            short[] sArray = new short[n2];
            sArray[0] = (short)stringArray.length;
            int n3 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                sArray[i + 1] = (short)n3;
                n3 += stringArray[i].length();
            }
            sArray[n2 - 2] = (short)n3;
            sArray[n2 - 1] = (short)this.m_newlineChar;
            return sArray;
        }
        return null;
    }

    public String[] splitString(String string, int n, boolean bl, boolean bl2) {
        Object[] objectArray;
        if (string == null || string.length() == 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (++n3 > string.length()) break;
            if (bl && string.charAt(n3 - 1) == this.m_newlineChar) {
                vector.addElement(string.substring(n2, n3));
                n2 = n3;
                continue;
            }
            objectArray = string.substring(n2, n3);
            n4 = bl2 ? this.stringHeight((String)objectArray, 0) : this.stringWidth((String)objectArray);
            if (n4 <= n) continue;
            vector.addElement(objectArray.substring(0, objectArray.length() - 1));
            n2 = --n3;
        }
        vector.addElement(string.substring(n2, string.length()));
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public void drawWrappedString(Graphics graphics, String[] stringArray, int n, int n2) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.draw(graphics, stringArray[i], n, n2);
            n2 += this.m_height + this.m_lineSpacing;
        }
    }

    public void drawWrappedString(Graphics graphics, String[] stringArray, int n, int n2, int n3) {
        int n4 = stringArray.length * (this.m_height + this.m_lineSpacing) - this.m_lineSpacing;
        if ((n3 & 2) != 0) {
            n2 -= n4 >> 1;
            n3 &= 0xFFFFFFFD;
            n3 |= 0x10;
        } else if ((n3 & 0x20) != 0) {
            n2 -= n4;
            n3 &= 0xFFFFFFDF;
            n3 |= 0x10;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.draw(graphics, stringArray[i], n, n2, n3);
            n2 += this.m_height + this.m_lineSpacing;
        }
    }

    public void drawWrappedString(Graphics graphics, String string, short[] sArray, int n, int n2, int n3, int n4, int n5, int n6) {
        char c = this.m_newlineChar;
        this.m_newlineChar = (char)sArray[sArray[0] + 2];
        int n7 = n2 * (this.m_height + this.m_lineSpacing) - this.m_lineSpacing;
        if ((n5 & 2) != 0) {
            n4 -= n7 >> 1;
            n5 &= 0xFFFFFFFD;
            n5 |= 0x10;
        } else if ((n5 & 0x20) != 0) {
            n4 -= n7;
            n5 &= 0xFFFFFFDF;
            n5 |= 0x10;
        }
        for (int i = 0; i < n2; ++i) {
            String string2 = string.substring(sArray[n + i], sArray[n + i + 1]);
            while (string2.charAt(0) == this.m_newlineChar) {
                string2 = string2.substring(1);
            }
            int n8 = string2.length();
            while (string2.charAt(n8 - 1) == this.m_newlineChar) {
                string2 = string2.substring(0, n8 - 1);
                n8 = string2.length();
            }
            this.draw(graphics, string2, n3, n4, n5);
            n4 += this.m_height + this.m_lineSpacing;
        }
        this.m_newlineChar = c;
    }

    public int getLineSpacing() {
        return this.m_lineSpacing;
    }

    public void setLineSpacing(int n) {
        this.m_lineSpacing = n;
    }

    public void setCharSpacing(int n) {
        this.m_charSpacing = n;
    }

    public int getHeight() {
        return this.m_height;
    }

    public void drawVerticalString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5 = this.stringHeight(string, n4);
        if ((n3 & 2) != 0) {
            n3 &= 0xFFFFFFFD;
            n3 |= 0x10;
            n2 -= n5 >> 1;
        }
        if ((n3 & 0x20) != 0) {
            n3 &= 0xFFFFFFDF;
            n3 |= 0x10;
            n2 -= n5;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (this.m_mode == 0) {
            n6 = graphics.getClipX();
            n7 = graphics.getClipY();
            n8 = graphics.getClipWidth();
            n9 = graphics.getClipHeight();
        }
        for (int i = 0; i < string.length(); ++i) {
            boolean bl;
            int n10;
            short s;
            int n11;
            int n12;
            short s2;
            int n13;
            short s3;
            int n14;
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') continue;
            if (c == ' ') {
                n2 += this.m_wordSpacing + this.m_lineSpacing + n4;
                continue;
            }
            int n15 = n;
            int n16 = this.findCharIndex(c);
            if (n16 == -1) {
                if ((n3 & 1) != 0) {
                    n15 -= 2 * this.m_wordSpacing >> 1;
                } else if ((n3 & 8) != 0) {
                    n15 -= 2 * this.m_wordSpacing;
                }
                graphics.setColor(0xFF0000);
                graphics.fillRect(n15 + 1, n2 + 1, 2 * this.m_wordSpacing - 2, this.m_height - 2);
                graphics.setColor(65280);
                graphics.fillRect(n15 + 2, n2 + 2, 2 * this.m_wordSpacing - 4, this.m_height - 4);
                n2 += this.m_height + this.m_lineSpacing + n4;
                continue;
            }
            if (this.m_mode == 0) {
                n14 = this.m_posData[n16 * 3 + 0];
                s3 = this.m_posData[n16 * 3 + 1];
                n13 = this.m_posData[n16 * 3 + 2];
                if ((n3 & 1) != 0) {
                    n15 -= this.m_posData[5] >> 1;
                } else if ((n3 & 8) != 0) {
                    n15 -= this.m_posData[5];
                }
                graphics.setClip(n15, n2, n13, this.m_height);
                graphics.drawImage(this.m_image, n15 - n14, n2 - s3, 20);
                n2 += this.m_height + this.m_lineSpacing + n4;
                continue;
            }
            if (this.m_mode != 1) continue;
            if ((n3 & 1) != 0) {
                n15 -= this.m_posData[n16] >> 1;
            } else if ((n3 & 8) != 0) {
                n15 -= this.m_posData[n16];
            }
            graphics.setColor(this.m_color);
            n14 = this.m_lattice[n16].length;
            s3 = this.m_posData[n16];
            if (BORDER_ENABLED && this.m_borderColor != -1) {
                for (n13 = 0; n13 < n14; n13 += 2) {
                    s2 = this.m_lattice[n16][n13];
                    n12 = s2 % s3;
                    n11 = s2 / s3;
                    s = this.m_lattice[n16][n13 + 1];
                    n10 = s & 0x7F;
                    bl = (s >> 7 & 1) != 0;
                    graphics.setColor(this.m_borderColor);
                    if (bl) {
                        graphics.fillRect(n15 + n12 - 1, n2 + n11 - 1, this.m_paintWidth + 2, n10 + 2);
                    } else {
                        graphics.fillRect(n15 + n12 - 1, n2 + n11 - 1, n10 + 2, this.m_paintWidth + 2);
                    }
                    graphics.setColor(this.m_color);
                }
            }
            for (n13 = 0; n13 < n14; n13 += 2) {
                s2 = this.m_lattice[n16][n13];
                n12 = s2 % s3;
                n11 = s2 / s3;
                s = this.m_lattice[n16][n13 + 1];
                n10 = s & 0x7F;
                boolean bl2 = bl = (s >> 7 & 1) != 0;
                if (bl) {
                    graphics.fillRect(n15 + n12, n2 + n11, this.m_paintWidth, n10);
                    continue;
                }
                graphics.fillRect(n15 + n12, n2 + n11, n10, this.m_paintWidth);
            }
            n2 += this.m_height + this.m_lineSpacing + n4 + (this.m_borderColor == -1 ? 0 : 2);
        }
    }

    public int stringHeight(String string, int n) {
        if (string != null) {
            int n2 = 0;
            int n3 = 32;
            for (int i = 0; i < string.length(); ++i) {
                n3 = string.charAt(i);
                if (n3 == 13 || n3 == 10) continue;
                n2 += (n3 == 32 ? this.m_wordSpacing : this.m_height) + this.m_lineSpacing + n + (this.m_borderColor == -1 ? 0 : 2);
            }
            return n2;
        }
        return 0;
    }

    public int getCharSpacing() {
        return this.m_charSpacing;
    }

    public void setWordSpacing(int n) {
        this.m_wordSpacing = n;
    }

    public int getWordSpacing() {
        return this.m_wordSpacing;
    }

    public void setNewlineChar(char c) {
        this.m_newlineChar = c;
    }

    public char getNewlineChar() {
        return this.m_newlineChar;
    }

    public CFont createFont(String string, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        CFont cFont = new CFont();
        char[] cArray = null;
        if (string == null) {
            cArray = new char[this.m_nChars];
            System.arraycopy(this.m_chars, 0, cArray, 0, this.m_nChars);
        } else {
            cArray = CFont.calcCharacters(string, true);
        }
        cFont.m_nChars = cArray.length;
        cFont.m_chars = cArray;
        cFont.m_posData = new short[cFont.m_nChars * 3];
        cFont.m_lineSpacing = this.m_lineSpacing;
        cFont.m_charSpacing = this.m_charSpacing;
        cFont.m_wordSpacing = this.m_wordSpacing;
        cFont.m_newlineChar = this.m_newlineChar;
        cFont.m_loaded = true;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        cFont.m_height = n7 = this.m_height * n4 >> 8;
        short s = 0;
        int n11 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            n6 = this.findCharIndex(cArray[i]);
            if (n6 == -1) continue;
            if (this.m_posData[n6 * 3 + 0] < 0) {
                s = this.m_posData[n6 * 3 + 0];
            }
            if (this.m_posData[n6 * 3 + 1] < 0) {
                n11 = this.m_posData[n6 * 3 + 1];
            }
            if ((n8 += (n5 = this.m_posData[n6 * 3 + 2] * n4 >> 8)) > n3) {
                n9 += n7;
                n8 = n5;
                continue;
            }
            if (n10 >= n8) continue;
            n10 = n8;
        }
        n9 += n7;
        int[] nArray = new int[n10 * (n9 -= n11)];
        n8 = 0;
        n9 = -n11;
        for (n6 = 0; n6 < cArray.length; ++n6) {
            int n12;
            n5 = this.findCharIndex(cArray[n6]);
            if (n5 == -1) continue;
            System.out.println(this.m_posData[n5 * 3 + 0] + "," + this.m_posData[n5 * 3 + 1] + "," + this.m_posData[n5 * 3 + 2] + "," + this.m_height);
            Image image = GraphicsTools.createSubImage(this.m_image, this.m_posData[n5 * 3 + 0], this.m_posData[n5 * 3 + 1], this.m_posData[n5 * 3 + 2], this.m_height);
            if (n4 != 256) {
                image = GraphicsTools.scaleImage(image, n4 * this.m_posData[n5 * 3 + 2] >> 8, n4 * this.m_height >> 8);
            }
            if (n != n2) {
                image = GraphicsTools.changeColor(image, n, n2);
            }
            if (n8 + (n12 = image.getWidth()) > n10) {
                n8 = 0;
                n9 += n7;
            }
            cFont.m_posData[n6 * 3 + 0] = (short)n8;
            cFont.m_posData[n6 * 3 + 1] = (short)n9;
            cFont.m_posData[n6 * 3 + 2] = (short)n12;
            int[] nArray2 = new int[n12 * n7];
            image.getRGB(nArray2, 0, n12, 0, 0, n12, n7);
            for (int i = 0; i < n12; ++i) {
                for (int j = 0; j < n7; ++j) {
                    nArray[n10 * (n9 + j) + (n8 + i)] = nArray2[j * n12 + i];
                }
            }
            n8 += n12;
        }
        Image image = Image.createRGBImage((int[])nArray, (int)n10, (int)(n9 += n7), (boolean)true);
        cFont.setImage(image);
        return cFont;
    }

    public static final char[] calcCharacters(String string, boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            String string2 = string.charAt(n) + "";
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        if (bl) {
            for (int i = 0; i < cArray.length; ++i) {
                for (int j = i + 1; j < cArray.length; ++j) {
                    if (cArray[j] >= cArray[i]) continue;
                    char c = cArray[i];
                    cArray[i] = cArray[j];
                    cArray[j] = c;
                }
            }
        }
        return cArray;
    }

    public void setColor(int n) {
        this.m_color = n;
    }

    public int getMaxCharWidth() {
        return this.m_maxCharWidth;
    }
}

