/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TMap {
    private Image mapImage;
    private short[][] map_Data;
    private int cellW;
    private int cellH;
    private int screenW;
    private int screenH;
    private int x;
    private int y;
    private int mapW;
    private int mapH;
    private int imageCol;

    public TMap(Image image, short[][] sArray, int n2, int n3, int n4, int n5) {
        this.mapImage = image;
        this.map_Data = sArray;
        this.cellW = n2;
        this.cellH = n3;
        this.screenW = n4;
        this.screenH = n5;
        this.imageCol = image.getWidth() / n2;
        this.mapH = sArray.length * n3;
        this.mapW = sArray[0].length * n2;
    }

    public void paint(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        int n5 = -this.y / this.cellH;
        if (n5 <= 0) {
            n5 = 0;
        }
        if ((n4 = (-this.y + this.screenH) / this.cellH) >= this.map_Data.length) {
            n4 = this.map_Data.length - 1;
        }
        if ((n3 = -this.x / this.cellW) <= 0) {
            n3 = 0;
        }
        if ((n2 = (-this.x + this.screenW) / this.cellW) >= this.map_Data[0].length) {
            n2 = this.map_Data[0].length - 1;
        }
        for (int i2 = n4; i2 >= n5; --i2) {
            for (int i3 = n2; i3 >= n3; --i3) {
                if (this.map_Data[i2][i3] == -1) continue;
                graphics.setClip(0, 0, this.screenW, this.screenH);
                graphics.clipRect(this.x + i3 * this.cellW, this.y + i2 * this.cellH, this.cellW, this.cellH);
                short s2 = this.map_Data[i2][i3];
                int n6 = -(s2 % this.imageCol * this.cellW);
                int n7 = -(s2 / this.imageCol * this.cellH);
                graphics.drawImage(this.mapImage, this.x + i3 * this.cellW + n6, this.y + i2 * this.cellH + n7, 0);
            }
        }
        graphics.setClip(0, 0, this.screenW, this.screenH);
    }

    public int getMapH() {
        return this.mapH;
    }

    public void setMapH(int n2) {
        this.mapH = n2;
    }

    public int getMapW() {
        return this.mapW;
    }

    public void setMapW(int n2) {
        this.mapW = n2;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n2) {
        this.x = n2;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n2) {
        this.y = n2;
    }
}

