/*
 * Decompiled with CFR 0.152.
 */
package script;

import java.io.DataInputStream;
import java.util.Vector;
import script.ExeStruct;
import script.ScriptsManager;
import script.ScriptsRunner;
import script.Sentence;
import util.Consts;
import util.GE;
import util.SerializeAble;

public class Trigger
implements Consts,
SerializeAble {
    public short ID = 0;
    public boolean isPreLoad = false;
    public Sentence[] sentencesTrigger = null;
    public Sentence[] sentencesContext = null;
    public ExeStruct[] structsExecution = null;
    public static short idCounter = 0;
    private static int currentStructID = -1;

    public void readObject(DataInputStream dataInputStream) throws Exception {
        int n;
        this.ID = idCounter;
        idCounter = (short)(idCounter + 1);
        int n2 = 0;
        this.isPreLoad = GE.readBoolean(this.isPreLoad, dataInputStream);
        n2 = GE.readShort((short)n2, dataInputStream);
        this.sentencesTrigger = new Sentence[n2];
        for (n = 0; n < n2; ++n) {
            this.sentencesTrigger[n] = new Sentence(0);
            this.sentencesTrigger[n].readObject(dataInputStream);
        }
        n2 = GE.readShort((short)n2, dataInputStream);
        this.sentencesContext = new Sentence[n2];
        for (n = 0; n < n2; ++n) {
            this.sentencesContext[n] = new Sentence(1);
            this.sentencesContext[n].readObject(dataInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadExcutor(DataInputStream dataInputStream) {
        try {
            if (ScriptsManager.dataSplitted) {
                String string = "/res/script/te_" + this.ID + ".bin";
                dataInputStream = GE.getDataInputStream(string);
            }
            int n = 0;
            n = GE.readShort((short)n, dataInputStream);
            this.structsExecution = new ExeStruct[n];
            for (int i = 0; i < n; ++i) {
                this.structsExecution[i] = new ExeStruct();
                this.structsExecution[i].readObject(dataInputStream);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (ScriptsManager.dataSplitted && dataInputStream != null) {
                try {
                    dataInputStream.close();
                    dataInputStream = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void releaseExcutor() {
        if (this.structsExecution != null) {
            for (int i = 0; i < this.structsExecution.length; ++i) {
                this.structsExecution[i].releaseRes();
                this.structsExecution[i] = null;
            }
            this.structsExecution = null;
        }
    }

    public void releaseRes() {
        int n;
        if (this.sentencesTrigger != null) {
            for (n = 0; n < this.sentencesTrigger.length; ++n) {
                this.sentencesTrigger[n].releaseRes();
                this.sentencesTrigger[n] = null;
            }
            this.sentencesTrigger = null;
        }
        if (this.sentencesContext != null) {
            for (n = 0; n < this.sentencesContext.length; ++n) {
                this.sentencesContext[n].releaseRes();
                this.sentencesContext[n] = null;
            }
            this.sentencesContext = null;
        }
        if (this.structsExecution != null) {
            for (n = 0; n < this.structsExecution.length; ++n) {
                this.structsExecution[n].releaseRes();
                this.structsExecution[n] = null;
            }
            this.sentencesContext = null;
        }
    }

    public void startScript(int n) {
        if (n >= 0 && this.structsExecution != null && n < this.structsExecution.length) {
            currentStructID = n;
        }
    }

    public void exitScript() {
        if (currentStructID >= 0 || currentStructID < this.structsExecution.length) {
            this.structsExecution[currentStructID].exitScript();
        }
        currentStructID = -1;
    }

    public boolean loopLogic(ScriptsRunner scriptsRunner) {
        if (currentStructID < 0 || this.structsExecution == null || currentStructID >= this.structsExecution.length) {
            currentStructID = -1;
            return true;
        }
        if (!this.structsExecution[currentStructID].excuteEvent(scriptsRunner)) {
            return false;
        }
        for (int i = ++currentStructID; i < this.structsExecution.length; ++i) {
            if (this.structsExecution[i].excuteEvent(scriptsRunner)) continue;
            currentStructID = i;
            return false;
        }
        currentStructID = -1;
        this.releaseExcutor();
        return true;
    }

    public boolean activedTrigger(ScriptsRunner scriptsRunner, int n, Vector vector) {
        if (vector == null || n < 0 || n > ScriptsManager.funFormatsTrigger.length) {
            return false;
        }
        if (vector.size() != ScriptsManager.funFormatsTrigger[n].length) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.sentencesTrigger.length; ++i) {
            Sentence sentence = this.sentencesTrigger[i];
            if (sentence.functionID != n || sentence.vParams == null || sentence.vParams.size() != vector.size()) continue;
            for (int j = 0; j < vector.size() && sentence.vParams.elementAt(j).equals(vector.elementAt(j)); ++j) {
                if (j != vector.size() - 1) continue;
                bl = true;
            }
            if (bl) break;
        }
        if (!bl) {
            return false;
        }
        if (!Trigger.meetCondition(scriptsRunner, this.sentencesContext)) {
            return false;
        }
        if (this.structsExecution == null) {
            ScriptsManager.loadExcutors(new int[]{this.ID}, false);
        }
        currentStructID = 0;
        return true;
    }

    public static boolean meetCondition(ScriptsRunner scriptsRunner, Sentence[] sentenceArray) {
        if (scriptsRunner == null || sentenceArray == null) {
            return false;
        }
        for (int i = 0; i < sentenceArray.length; ++i) {
            Sentence sentence = sentenceArray[i];
            if (scriptsRunner.onCondition(sentence.functionID, sentence.vParams)) continue;
            return false;
        }
        return true;
    }
}

