/*
 * Decompiled with CFR 0.152.
 */
package d2;

import d2.ActorData;
import d2.Animation;
import javax.microedition.lcdui.Graphics;
import script.Property;
import util.GE;

public class Actor {
    public boolean isAlive = true;
    protected Property actorProperty = null;
    protected Animation animation = null;
    protected int actorID = 0;
    protected short actionID = 0;
    protected short frameID = (short)-1;
    protected short frameDelay = 0;
    public short npcID = (short)-1;
    protected ActorData actorData = null;
    protected int[] frameStay = null;
    public int posX = 0;
    public int posY = 0;
    public boolean posShifted = true;

    public void loadActorData() {
        this.animation.loadActorData(new int[]{this.actorID});
        this.actorData = this.animation.getActorData(this.actorID);
    }

    public Actor(Animation animation, int n, boolean bl) {
        this.actorID = n;
        if (animation != null) {
            this.animation = animation;
            this.actorData = this.animation.getActorData(n);
            if (this.actorData == null) {
                animation.loadActorData(new int[]{n});
                this.actorData = this.animation.getActorData(n);
                GE.println("actorData load:" + n);
            }
        }
        if (bl) {
            this.loadActorImgs();
        }
    }

    public void setActorID(int n, boolean bl, boolean bl2, boolean bl3) {
        this.actorID = n;
        if (this.animation != null) {
            this.actorData = this.animation.getActorData(this.actorID);
        }
        if (bl2) {
            this.setAction(0, false);
        }
        if (bl) {
            this.setFrame(0);
        }
        if (bl3) {
            this.loadActorImgs();
        }
    }

    public void loadActorImgs() {
        short[] sArray;
        ActorData actorData;
        if (this.animation != null && (actorData = this.animation.getActorData(this.actorID)) != null && (sArray = actorData.actorImgsUsedIndexs) != null) {
            this.animation.initImages(sArray);
        }
    }

    public void loadActionImgs(int n) {
        ActorData actorData;
        if (this.animation != null && (actorData = this.animation.getActorData(this.actorID)) != null) {
            if (actorData.actionFrames == null || n < 0 || actorData.actionImgsUsedIndexs == null || n >= actorData.actionImgsUsedIndexs.length) {
                return;
            }
            short[] sArray = actorData.actionImgsUsedIndexs[n];
            if (sArray != null) {
                this.animation.initImages(sArray);
            }
        }
    }

    public void releaseDataRes() {
        this.actorData = null;
        if (this.animation != null) {
            this.animation.releaseActorData(this.actorID);
        }
        this.animation = null;
    }

    public void releaseActorImgs() {
        if (this.animation != null && this.actorData != null && this.actorData.actorImgsUsedIndexs != null) {
            this.animation.releaseImgs(this.actorData.actorImgsUsedIndexs);
        }
    }

    public void releaseActionImgs() {
        if (this.animation != null && this.actorData != null && this.actorData.actionImgsUsedIndexs != null && this.actorData.actionImgsUsedIndexs[this.actionID] != null && this.actionID >= 0 && this.actionID < this.actorData.actionImgsUsedIndexs.length) {
            this.animation.releaseImgs(this.actorData.actionImgsUsedIndexs[this.actionID]);
        }
    }

    public boolean setAction(int n) {
        return this.setAction(n, false);
    }

    public boolean setActionDif(int n) {
        if (n == this.actionID) {
            return false;
        }
        return this.setAction(n, false);
    }

    public boolean setAction(int n, boolean bl) {
        if (this.actorData == null || this.actorData.actionFrames == null) {
            return false;
        }
        if (n >= 0 && n < this.actorData.actionFrames.length) {
            this.actionID = (short)n;
            this.setFrame(0);
            if (bl) {
                this.releaseActorImgs();
                this.loadActionImgs(this.actionID);
            }
            return true;
        }
        return false;
    }

    public boolean setFrame(int n) {
        if (this.actorData == null || this.actorData.actionFrames == null || this.actionID < 0 || this.actionID >= this.actorData.actionFrames.length) {
            return false;
        }
        if (n < this.actorData.actionFrames[this.actionID].length / this.animation.getActionFrameStep() && n >= 0) {
            short s = this.frameID;
            this.frameID = (short)n;
            this.frameDelay = 0;
            if (s != this.frameID) {
                this.checkSounds();
            }
            return true;
        }
        return false;
    }

    public boolean setDifFrame(int n) {
        if (n == this.frameID) {
            return false;
        }
        return this.setFrame(n);
    }

    public boolean nextFrame(boolean bl) {
        if (this.actorData == null || this.actorData.actionFrames == null) {
            return false;
        }
        short s = this.frameID;
        boolean bl2 = false;
        this.frameDelay = (short)(this.frameDelay + 1);
        if (this.frameDelay >= this.actorData.actionFrames[this.actionID][this.frameID * this.animation.getActionFrameStep() + 2]) {
            this.frameDelay = 0;
            this.frameID = (short)(this.frameID + 1);
            if (this.frameID >= this.actorData.actionFrames[this.actionID].length / this.animation.getActionFrameStep()) {
                if (bl) {
                    this.frameID = 0;
                } else {
                    this.frameID = (short)(this.frameID - 1);
                    this.frameDelay = (short)(this.actorData.actionFrames[this.actionID][this.frameID * this.animation.getActionFrameStep() + 2] - 1);
                }
                bl2 = true;
            }
        }
        if (s != this.frameID && this.frameDelay == 0) {
            this.checkSounds();
        }
        return bl2;
    }

    public boolean isInLastFrame(int n) {
        if (this.actorData == null || this.actorData.actionFrames == null) {
            return false;
        }
        return this.frameID >= this.actorData.actionFrames[this.actionID].length / this.animation.getActionFrameStep() - n;
    }

    public boolean isInFirstFrame(int n) {
        if (this.actorData == null || this.actorData.actionFrames == null) {
            return false;
        }
        return this.frameID < n;
    }

    public void setLastFrame(int n) {
        this.setFrame(this.actorData.actionFrames[this.actionID].length / this.animation.getActionFrameStep() - n);
    }

    public void checkSounds() {
    }

    public boolean atActionEnd() {
        return this.atActionEnd(-1);
    }

    public boolean atActionEnd(int n) {
        return this.frameID >= this.actorData.actionFrames[this.actionID].length - 1 - n;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public int getActorID() {
        return this.actorID;
    }

    public int getActionID() {
        return this.actionID;
    }

    public int getActionsCount() {
        if (this.actorData == null || this.actorData.actionFrames == null) {
            return 0;
        }
        return this.actorData.actionFrames.length;
    }

    public int getFrameID() {
        return this.frameID;
    }

    public int getFramesCount() {
        if (this.actorData == null || this.actionID < 0 || this.actionID >= this.getActionsCount()) {
            return 0;
        }
        return this.actorData.actionFrames[this.actionID].length / this.animation.getActionFrameStep();
    }

    public void setPosition(int n, int n2) {
        this.posX = n;
        this.posY = n2;
    }

    public void display(Graphics graphics) {
        this.display(graphics, 0, 0, false);
    }

    public void display(Graphics graphics, int n, int n2) {
        if (this.animation != null) {
            this.animation.drawKeyFrame(graphics, this.actorID, this.actionID, this.frameID, this.posX - n, this.posY - n2, false);
        }
    }

    public void display(Graphics graphics, int n, int n2, boolean bl) {
        if (this.animation != null) {
            this.animation.drawKeyFrame(graphics, this.actorID, this.actionID, this.frameID, this.posX - n, this.posY - n2, bl);
        }
    }

    public int getLogicBox(int[] nArray, int n, int n2, int n3) {
        if (this.animation != null) {
            return this.animation.getLogicBox(nArray, n, this.actorID, this.actionID, this.frameID, this.posX - n2, this.posY - n3);
        }
        return -1;
    }

    public int getLogicBox(int[] nArray, int n) {
        if (this.animation != null) {
            return this.animation.getLogicBox(nArray, n, this.actorID, this.actionID, this.frameID, this.posX, this.posY);
        }
        return -1;
    }

    public int getLogicBoxByID(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        if (this.animation != null) {
            return this.animation.getLogicBox(nArray, n, this.actorID, n4, n5, this.posX - n2, this.posY - n3);
        }
        return -1;
    }

    public int getLogicBoxByID(int[] nArray, int n, int n2, int n3) {
        if (this.animation != null) {
            return this.animation.getLogicBox(nArray, n, this.actorID, n2, n3, this.posX, this.posY);
        }
        return -1;
    }

    public byte getAttackVector(int n, int n2) {
        if (this.animation != null) {
            return this.animation.getAttackVector(this.actorID, n, n2);
        }
        return -1;
    }

    public byte getAttackVector() {
        if (this.actionID < 0 || this.frameID < 0) {
            return -1;
        }
        return this.getAttackVector(this.actionID, this.frameID);
    }
}

