/*
 * Decompiled with CFR 0.152.
 */
package script;

import java.io.DataInputStream;
import java.util.Vector;
import script.PropertyStyle;
import script.ScriptsManager;
import util.SerializeAble;

public class Property
implements SerializeAble {
    PropertyStyle style = null;
    private Vector vParams;

    public Property(PropertyStyle propertyStyle) {
        this.style = propertyStyle;
    }

    public void readObject(DataInputStream dataInputStream) throws Exception {
        this.vParams = new Vector();
        ScriptsManager.readParamsByFormats(this.vParams, dataInputStream, this.style.byteStyle);
    }

    public boolean setProperty(int n, int n2) {
        if (this.vParams == null || n < 0 || n >= this.vParams.size() || this.style == null) {
            return false;
        }
        if (this.style.byteStyle[n] != 0) {
            return false;
        }
        this.vParams.removeElementAt(n);
        Integer n3 = new Integer(n2);
        this.vParams.insertElementAt(n3, n);
        return true;
    }

    public boolean setProperty(int n, String string) {
        if (this.vParams == null || n < 0 || n >= this.vParams.size() || this.style == null) {
            return false;
        }
        if (this.style.byteStyle[n] != 0) {
            return false;
        }
        this.vParams.removeElementAt(n);
        this.vParams.insertElementAt(string, n);
        return true;
    }

    public int getIntProperty(int n) {
        if (this.vParams == null || n < 0 || n >= this.vParams.size() || this.style == null) {
            return -1;
        }
        if (this.style.byteStyle[n] != 0) {
            return -1;
        }
        Integer n2 = (Integer)this.vParams.elementAt(n);
        return n2;
    }

    public String getStringProperty(int n) {
        if (this.vParams == null || n < 0 || n >= this.vParams.size() || this.style == null) {
            return null;
        }
        if (this.style.byteStyle[n] != 1) {
            return null;
        }
        String string = (String)this.vParams.elementAt(n);
        return string;
    }

    public int getPropertyLen() {
        if (this.vParams == null) {
            return -1;
        }
        return this.vParams.size();
    }

    public void showProperty() {
        if (this.vParams == null || this.vParams.size() == 0) {
            System.out.println("no property");
            return;
        }
        for (int i = 0; i < this.vParams.size(); ++i) {
            Object e = this.vParams.elementAt(i);
            if (e instanceof Integer) {
                System.out.println("property=>[int]:" + (Integer)e);
            }
            if (!(e instanceof String)) continue;
            System.out.println("property=>[str]:" + (String)e);
        }
    }

    public void releaseRes() {
        this.style = null;
        if (this.vParams != null) {
            this.vParams.removeAllElements();
            this.vParams = null;
        }
    }
}

