/*
 * Decompiled with CFR 0.152.
 */
package com.neonplay.helper;

public class AnimItem {
    protected int x = 0;
    protected int y = 0;
    private boolean animating;
    private float animX = 0.0f;
    private float animY = 0.0f;
    private float targetX = 0.0f;
    private float targetY = 0.0f;
    private float deltaX = 0.0f;
    private float deltaY = 0.0f;

    public final void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.animating = false;
    }

    public final int currentX() {
        return this.x;
    }

    public final int currentY() {
        return this.y;
    }

    public final void animateTo(int n, int n2, float f) {
        this.animX = this.x;
        this.animY = this.y;
        this.targetX = n;
        this.targetY = n2;
        this.deltaX = (this.targetX - this.animX) / f;
        this.deltaY = (this.targetY - this.animY) / f;
        this.animating = true;
    }

    public final boolean isAnimating() {
        return this.animating;
    }

    public final boolean update(float f) {
        if (!this.animating) {
            return false;
        }
        this.animX += this.deltaX * f;
        this.animY += this.deltaY * f;
        if (this.deltaX > 0.0f && this.animX > this.targetX) {
            this.animX = this.targetX;
        }
        if (this.deltaX < 0.0f && this.animX < this.targetX) {
            this.animX = this.targetX;
        }
        if (this.deltaY > 0.0f && this.animY > this.targetY) {
            this.animY = this.targetY;
        }
        if (this.deltaY < 0.0f && this.animY < this.targetY) {
            this.animY = this.targetY;
        }
        if (this.animX == this.targetX && this.animY == this.targetY) {
            this.animating = false;
        }
        this.x = (int)this.animX;
        this.y = (int)this.animY;
        return this.animating;
    }
}

