/*
 * Decompiled with CFR 0.152.
 */
package com.neonplay.paperglider;

import com.neonplay.helper.SaveData;
import com.neonplay.paperglider.ExitListener;
import com.neonplay.paperglider.game.GameViewBase;
import com.neonplay.paperglider.game.GameViewLargePhone;
import com.neonplay.paperglider.game.GameViewSmallPhone;
import com.neonplay.paperglider.views.MenuView;
import com.neonplay.paperglider.views.MenuViewSmallPhone;
import com.neonplay.paperglider.views.SplashView;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class Main
extends MIDlet
implements ExitListener {
    private Display display;
    private static Main self;
    private GameViewBase gameView;
    private MenuView menuView;
    private boolean inGame;
    private boolean featurePhone;
    private boolean moreGamesStatus;
    private String moreGamesUrl;
    private String buyFullVersionUrl;

    public static Main getInstance() {
        return self;
    }

    public Display getDisplay() {
        return this.display;
    }

    public boolean getMoreGamesStatus() {
        return this.moreGamesStatus;
    }

    public String getMoreGamesUrl() {
        return this.moreGamesUrl;
    }

    public String getBuyFullVersionUrl() {
        return this.buyFullVersionUrl;
    }

    public void startApp() {
        System.out.println("Starting game...");
        this.moreGamesUrl = this.getAppProperty("more_games_url");
        this.moreGamesStatus = this.getAppProperty("more_games_status").equals("on");
        this.buyFullVersionUrl = this.getAppProperty("buy_full_version");
        this.featurePhone = this.getAppProperty("feature_phone").equals("yes");
        System.out.println("feature_phone = " + this.featurePhone);
        if (this.display == null) {
            this.display = Display.getDisplay((MIDlet)this);
            self = this;
            System.out.println("Show splash");
            SplashView splashView = new SplashView();
            this.display.setCurrent((Displayable)splashView);
            System.out.println("Load saved data");
            SaveData.getInstance();
            System.out.println("Launch loading thread");
            new Thread(){

                public void run() {
                    if (!Main.this.featurePhone) {
                        Main.this.gameView = new GameViewLargePhone();
                        Main.this.menuView = new MenuView();
                    } else {
                        Main.this.gameView = new GameViewSmallPhone();
                        Main.this.menuView = new MenuViewSmallPhone();
                    }
                    System.out.println("Views loaded");
                    try {
                        1.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("Waiting for splash timout");
                    Main.this.display.setCurrent((Displayable)Main.this.menuView);
                    Main.this.inGame = false;
                    System.out.println("Menu view set");
                    try {
                        this.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }.start();
            splashView = null;
            System.gc();
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        SaveData.getInstance().exit();
    }

    public void exit() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public void showWebPage(String string) {
        try {
            if (this.platformRequest(string)) {
                this.exit();
            }
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            // empty catch block
        }
    }

    public void showGameView() {
        if (this.inGame) {
            return;
        }
        this.gameView.reset();
        this.display.setCurrent((Displayable)this.gameView);
        this.inGame = true;
    }

    public void showMenuView() {
        if (!this.inGame) {
            return;
        }
        this.menuView.setCurrentMenu(0);
        this.display.setCurrent((Displayable)this.menuView);
        this.inGame = false;
    }

    public MenuView getMenuView() {
        return this.menuView;
    }

    public GameViewBase getGameView() {
        return this.gameView;
    }
}

