/*
 * Decompiled with CFR 0.152.
 */
package utils;

import utils.YTAnimation;
import utils.YTGraphics;

public class YTAniManager {
    private int m_actionId;
    protected int m_actionIndex;
    private YTAnimation m_ani = null;
    private int m_currentFrameTime;
    private boolean initialised;
    private boolean m_Animating;
    private boolean m_Loop;
    private boolean m_Reverse;

    public YTAniManager(YTAnimation ani) {
        this.m_ani = ani;
        this.m_actionId = -1;
        this.m_actionIndex = 0;
        this.m_currentFrameTime = 0;
        this.initialised = false;
        this.m_Animating = false;
        this.m_Loop = false;
        this.m_Reverse = false;
    }

    public final boolean isAnimating() {
        return this.m_Animating;
    }

    public final boolean isInitialised() {
        return this.initialised;
    }

    public void setAnimating(boolean b) {
        this.m_Animating = b;
    }

    public int getFrameWidth() {
        return this.m_ani.getFrameWidth(this.m_actionId, this.m_actionIndex);
    }

    public int getFrameHeight() {
        return this.m_ani.getFrameHeight(this.m_actionId, this.m_actionIndex);
    }

    public final void updateAnim(int interval) {
        if (!this.m_Animating && this.m_ani != null) {
            return;
        }
        this.m_currentFrameTime += interval;
        if (this.m_currentFrameTime > this.m_ani.getDelay(this.m_actionId, this.m_actionIndex)) {
            if (this.m_Reverse) {
                this.prevFrame();
            } else {
                this.nextFrame();
            }
        }
    }

    public final void updateAnimTo(int interval, int _tindex, boolean _reverse) {
        if (!this.m_Animating && this.m_ani != null) {
            return;
        }
        int ani_length = this.m_ani.getFrameNum(this.m_actionId);
        int tindex = _tindex % ani_length;
        if (tindex == this.m_actionIndex) {
            return;
        }
        this.m_currentFrameTime += interval;
        if (this.m_currentFrameTime > this.m_ani.getDelay(this.m_actionId, this.m_actionIndex)) {
            if (_reverse) {
                this.prevFrame();
            } else {
                this.nextFrame();
            }
        }
    }

    public void draw(YTGraphics g, int _x, int _y, boolean flip_x, boolean flip_y) {
        try {
            this.m_ani.draw(g, this.m_actionId, this.m_actionIndex, _x, _y, flip_x, flip_y);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void drawFrame(YTGraphics g, int _x, int _y, int _actionid, int _actionindex, boolean flip_x, boolean flip_y) {
        try {
            this.m_ani.draw(g, _actionid, _actionindex, _x, _y, flip_x, flip_y);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void nextFrame() {
        this.m_currentFrameTime -= this.m_ani.getDelay(this.m_actionId, this.m_actionIndex);
        if (this.m_currentFrameTime < 0) {
            this.m_currentFrameTime = 0;
        }
        ++this.m_actionIndex;
        if (this.m_actionIndex >= this.m_ani.getFrameNum(this.m_actionId)) {
            if (this.m_Loop) {
                this.m_actionIndex = 0;
            } else {
                this.m_actionIndex = this.m_ani.getFrameNum(this.m_actionId) - 1;
                this.m_Animating = false;
            }
        }
    }

    public final void prevFrame() {
        this.m_currentFrameTime -= this.m_ani.getDelay(this.m_actionId, this.m_actionIndex);
        if (this.m_currentFrameTime < 0) {
            this.m_currentFrameTime = 0;
        }
        --this.m_actionIndex;
        if (this.m_actionIndex < 0) {
            if (this.m_Loop) {
                this.m_actionIndex = this.m_ani.getFrameNum(this.m_actionId) - 1;
            } else {
                this.m_actionIndex = 0;
                this.m_Animating = false;
            }
        }
    }

    public int getNowActionId() {
        return this.m_actionId;
    }

    public int getNowActionIndex() {
        return this.m_actionIndex;
    }

    public final boolean isActionEnd() {
        return this.m_actionIndex == this.m_ani.getFrameNum(this.m_actionId) - 1;
    }

    public void startAnim(int animID, boolean restart, boolean isloop, boolean _reverse) {
        this.m_Reverse = _reverse;
        if (restart || this.m_actionId != animID) {
            this.m_actionId = animID;
            this.m_actionIndex = this.m_Reverse ? this.m_ani.getFrameNum(this.m_actionId) - 1 : 0;
            this.m_currentFrameTime = 0;
        } else if (this.m_actionIndex >= this.m_ani.getFrameNum(this.m_actionId)) {
            this.m_actionIndex = 0;
        } else if (this.m_actionIndex < 0) {
            this.m_actionIndex = this.m_ani.getFrameNum(this.m_actionId) - 1;
        }
        this.initialised = true;
        this.m_Animating = true;
        this.m_Loop = isloop;
    }
}

