/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.IOException;
import javax.microedition.lcdui.Image;
import utils.YTCRC;
import utils.YTUtils;

public class YTImage {
    private static int paletteOffset;
    private static int CRCOffset;
    private static int paletteColors;
    public Image m_image;
    public int m_width = 0;
    public int m_height = 0;

    public YTImage(Image _img) {
        this.m_image = _img;
        this.m_width = this.m_image.getWidth();
        this.m_height = this.m_image.getHeight();
    }

    public YTImage(String _res) {
        this.m_image = YTImage.loadImage(_res);
        this.m_width = this.m_image.getWidth();
        this.m_height = this.m_image.getHeight();
    }

    public YTImage(byte[] _data) {
        this.m_image = YTImage.loadImage(_data);
        this.m_width = this.m_image.getWidth();
        this.m_height = this.m_image.getHeight();
    }

    public static final Image loadImage(String _res) {
        try {
            return Image.createImage((String)_res);
        }
        catch (Exception ex) {
            YTUtils.printOut("load image " + _res + " error!!!");
            return null;
        }
    }

    public static final Image loadImage(byte[] _data) {
        try {
            return Image.createImage((byte[])_data, (int)0, (int)_data.length);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static final Image createTransparentImage(int _w, int _h) {
        Image _temp = null;
        try {
            _temp = Image.createImage((int)_w, (int)_h);
            int[] _data = new int[_w * _h];
            _temp.getRGB(_data, 0, _w, 0, 0, _w, _h);
            _temp = null;
            YTUtils.doGC();
            for (int i = 0; i < _data.length; ++i) {
                if ((_data[i] & 0xFFFFFF) != 0xFFFFFF) continue;
                _data[i] = _data[i] & 0xFFFFFF;
            }
            return Image.createRGBImage((int[])_data, (int)_w, (int)_h, (boolean)true);
        }
        catch (Exception ex) {
            YTUtils.printOut("create Transparent image error!!");
            return null;
        }
    }

    public static final Image createAlphaImage(Image originalImg, int alphaColor) {
        short w = (short)originalImg.getWidth();
        short h = (short)originalImg.getHeight();
        int[] imgData = new int[w * h];
        originalImg.getRGB(imgData, 0, (int)w, 0, 0, (int)w, (int)h);
        for (int i = 0; i < imgData.length; ++i) {
            if ((imgData[i] & alphaColor) != alphaColor) continue;
            imgData[i] = imgData[i] & alphaColor;
        }
        return Image.createRGBImage((int[])imgData, (int)w, (int)h, (boolean)true);
    }

    public static final Image createPalettedImageFromByteData(byte[] _data, int[] _old, int[] _new) throws IOException {
        if (_data == null) {
            YTUtils.printOut("create paletted Image error");
            return null;
        }
        YTImage.analyze(_data);
        for (int i = 0; i < _old.length; ++i) {
            YTImage.replaceColor(_data, _old[i], _new[i]);
        }
        YTImage.CRCChecksum(_data);
        return Image.createImage((byte[])_data, (int)0, (int)_data.length);
    }

    private static void analyze(byte[] _data) {
        int offset = 8;
        int chunkLen = 0;
        while (_data[offset + 4] != 80 || _data[offset + 5] != 76 || _data[offset + 6] != 84 || _data[offset + 7] != 69) {
            chunkLen = YTUtils.readInt(_data, offset);
            offset += 8 + chunkLen + 4;
        }
        chunkLen = YTUtils.readInt(_data, offset);
        paletteColors = chunkLen / 3;
        paletteOffset = offset + 8;
        CRCOffset = offset + 8 + chunkLen;
    }

    private static void replaceColor(byte[] _data, int oldColor, int newColor) {
        byte rr = (byte)(oldColor >> 16 & 0xFF);
        byte gg = (byte)(oldColor >> 8 & 0xFF);
        byte bb = (byte)(oldColor & 0xFF);
        int i = 0;
        int offset = paletteOffset;
        while (i < paletteColors) {
            if (rr == _data[offset] && gg == _data[offset + 1] && bb == _data[offset + 2]) {
                _data[offset] = (byte)(newColor >> 16 & 0xFF);
                _data[offset + 1] = (byte)(newColor >> 8 & 0xFF);
                _data[offset + 2] = (byte)(newColor & 0xFF);
                break;
            }
            ++i;
            offset += 3;
        }
    }

    private static void CRCChecksum(byte[] _data) {
        int checksum = YTCRC.sum(_data, paletteOffset - 4, paletteColors * 3 + 4);
        _data[YTImage.CRCOffset] = (byte)(checksum >> 24 & 0xFF);
        _data[YTImage.CRCOffset + 1] = (byte)(checksum >> 16 & 0xFF);
        _data[YTImage.CRCOffset + 2] = (byte)(checksum >> 8 & 0xFF);
        _data[YTImage.CRCOffset + 3] = (byte)(checksum & 0xFF);
    }
}

