/*
 * Decompiled with CFR 0.152.
 */
package com.downjoy.j2me.smspack.views;

import com.downjoy.j2me.smspack.util.RmsUtil;
import com.downjoy.j2me.smspack.util.SMSPackInfoReader;
import com.downjoy.j2me.smspack.util.SMSPackInfoVO;
import com.downjoy.j2me.smspack.util.TextAjust;
import com.downjoy.j2me.smspack.views.PayedCallback;
import java.util.Calendar;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class SMSPayCanvas
extends Canvas
implements Runnable {
    private static final boolean DEBUG = false;
    private static final int CHINA_MOBILE_TYPE = 0;
    private static final int CHINA_UNICOM_TYPE = 1;
    private static final int CHINA_TELECOM_TYPE = 2;
    private SMSPackInfoVO smsPackInfo;
    private String stringItem = null;
    private MIDlet midlet = null;
    private Displayable gameDisplayable;
    private int topIndex = 0;
    private int bootomIndex = 0;
    private String leftCommand = "\u70b9\u64ad";
    private String rigthCommand = "\u8fd4\u56de";
    private String cpId = null;
    private String gameId = null;
    private String actionId = null;
    private String eqpId = null;
    private int fee = 0;
    private String product = null;
    private String cpMemo = null;
    private String cpTel = null;
    private String title = "\u8ba2\u8d2d";
    private PayedCallback payedCallback = null;

    public SMSPayCanvas(MIDlet midlet, Displayable gameDisplayable, String cpId, String gameId, String actionId, String eqpId, int fee, String product, String cpMemo, String cpTel) {
        this.setFullScreenMode(true);
        try {
            this.midlet = midlet;
            this.gameDisplayable = gameDisplayable;
            this.cpId = cpId;
            this.gameId = gameId;
            if (actionId == null || actionId.length() == 0) {
                actionId = "00";
            }
            if (eqpId == null || eqpId.length() == 0) {
                eqpId = "000";
            }
            this.actionId = actionId;
            this.eqpId = eqpId;
            this.fee = fee;
            this.product = product;
            this.cpMemo = cpMemo;
            this.cpTel = cpTel;
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.leftCommand = "\u70b9\u64ad";
        this.rigthCommand = "\u8fd4\u56de";
        this.loadPayInfo();
    }

    private void loadPayInfo() {
        this.smsPackInfo = RmsUtil.loadFromRecordStore(this.cpId, this.gameId, this.actionId, this.fee);
        try {
            if (this.smsPackInfo != null && this.smsPackInfo.getPayedMoney() >= this.fee) {
                this.leftCommand = "";
                this.outputInfo("\u5df2\u7ecf\u652f\u4ed8\u5b8c\u6210\uff0c\u65e0\u9700\u518d\u652f\u4ed8!");
                return;
            }
            if (this.smsPackInfo != null && this.smsPackInfo.isNeedConfirm()) {
                Calendar today = Calendar.getInstance();
                today.set(11, 0);
                today.set(12, 0);
                today.set(13, 0);
                today.set(14, 0);
                if (today.getTime().getTime() > this.smsPackInfo.getLastSendFreeTime()) {
                    this.smsPackInfo = null;
                }
            }
            if (this.smsPackInfo == null) {
                this.smsPackInfo = SMSPackInfoReader.getSMSPackInfo(this.cpId, this.gameId, this.actionId, this.eqpId, this.fee);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.outputInfo(ex.toString());
            return;
        }
        this.showPayInfo();
    }

    private void showPayInfo() {
        if (this.smsPackInfo == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.cpMemo).append("\n\u9700\u53d1\u9001");
        int total = this.smsPackInfo.getFeeSMSCnt();
        if (this.smsPackInfo.getFreeSMSContent() != null && this.smsPackInfo.getFreeSMSContent().length() != 0) {
            sb.append("1\u6761\u514d\u8d39\u77ed\u4fe1\u548c");
            ++total;
        }
        sb.append(this.smsPackInfo.getFeeSMSCnt()).append("\u6761\u6536\u8d39\u77ed\u4fe1(");
        sb.append(this.smsPackInfo.getFeeSMSUnitPrice()).append("\u5143/\u6761)\uff0c\u5408\u8ba1").append(this.fee).append("\u5143\u3002\u70b9\u51fb\u201c\u70b9\u64ad\u201d\u5f00\u59cb\u4eab\u53d7\u670d\u52a1\uff0c\u8fd4\u56de\u5219\u4e0d\u6263\u8d39\u3002");
        sb.append("\u5ba2\u670d\u7535\u8bdd\uff1a").append(this.cpTel).append("\n  ");
        sb.append(this.smsPackInfo.getFeeSMSTitle()).append("\n");
        if (!this.smsPackInfo.isNeedConfirm()) {
            sb.append("\u60a8\u5df2\u7ecf\u53d1\u9001\u4e86" + this.smsPackInfo.getSendedCnt() + "\u6761\u77ed\u4fe1\uff0c\u8fd8\u9700\u53d1\u9001" + (total - this.smsPackInfo.getSendedCnt()) + "\u6761\u77ed\u4fe1");
            if (this.smsPackInfo.getFreeSMSContent() != null) {
                if (this.smsPackInfo.isNeedConfirm()) {
                    sb.append(",\u7b2c\u4e00\u6761\u514d\u8d39\u77ed\u4fe1\u662f\u7528\u4e8e\u53d1\u8d77\u652f\u4ed8\u8bf7\u6c42\u7684");
                } else {
                    sb.append(",\u7b2c\u4e00\u6761\u514d\u8d39\u77ed\u4fe1\u662f\u7528\u4e8e\u63a5\u6536\u514d\u8d39\u6e38\u620f\u4fe1\u606f\u7684");
                }
            }
            sb.append("\u3002");
        }
        this.outputInfo(sb.toString());
    }

    private void showPayInfo2() {
        int total = this.smsPackInfo.getFeeSMSCnt();
        if (this.smsPackInfo.getFreeSMSContent() != null && this.smsPackInfo.getFreeSMSContent().length() != 0) {
            ++total;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\u60a8\u5df2\u7ecf\u53d1\u9001\u4e86" + this.smsPackInfo.getSendedCnt() + "\u6761\u77ed\u4fe1\uff0c\u8fd8\u9700\u53d1\u9001" + (total - this.smsPackInfo.getSendedCnt()) + "\u6761\u77ed\u4fe1");
        if (this.smsPackInfo.getFreeSMSContent() != null && this.smsPackInfo.getFreeSMSContent().length() != 0) {
            sb.append(",\u7b2c\u4e00\u6761\u514d\u8d39\u77ed\u4fe1\u662f\u7528\u4e8e\u63a5\u6536\u514d\u8d39\u6e38\u620f\u4fe1\u606f\u7684");
        }
        sb.append("\u3002\n").append(this.smsPackInfo.getFeeSMSTitle());
        this.outputInfo(sb.toString());
    }

    private void payWithSMS() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        if (this.smsPackInfo.getFreeSMSNum() != null && this.smsPackInfo.getFreeSMSContent().length() != 0 && this.smsPackInfo.getFreeSMSContent() != null && this.smsPackInfo.getFreeSMSContent().length() != 0 && this.smsPackInfo.getLastSendFreeTime() == 0L) {
            this.outputInfo("\u6b63\u5728\u53d1\u9001\u7b2c" + (this.smsPackInfo.getSendedCnt() + 1) + "\u6761\u77ed\u4fe1\uff0c\u8bf7\u7a0d\u5019... ...");
            if (this.sendSMS(this.smsPackInfo.getFreeSMSNum(), this.smsPackInfo.getFreeSMSContent())) {
                this.smsPackInfo.setLastSendFreeTime(System.currentTimeMillis());
                this.smsPackInfo.setSendedCnt(this.smsPackInfo.getSendedCnt() + 1);
                RmsUtil.savePayResult(this.smsPackInfo, this.cpId, this.gameId, this.actionId, this.fee);
                this.leftCommand = "\u70b9\u64ad";
                this.rigthCommand = "\u8fd4\u56de";
                if (this.smsPackInfo.isNeedConfirm()) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    this.outputInfo("\u7ee7\u7eed\u70b9\u64ad\uff0c\u5373\u540c\u610f\u5411" + this.smsPackInfo.getFeeSMSNum() + "\u53d1\u9001\u77ed\u4fe1\u5b8c\u6210\u652f\u4ed8" + this.product + ",\u8d39\u7528\u4e3a\uff1a" + this.fee + "\u5143,\u5ba2\u670d\u7535\u8bdd:" + this.cpTel);
                } else {
                    this.showPayInfo2();
                }
            } else {
                this.leftCommand = "\u786e\u5b9a";
                this.rigthCommand = "\u8fd4\u56de";
                this.outputInfo("\u53d1\u9001\u7b2c" + (this.smsPackInfo.getSendedCnt() + 1) + "\u6761\u77ed\u4fe1\u5931\u8d25\uff0c\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u91cd\u65b0\u518d\u8bd5\uff0c\u70b9\u51fb\u201c\u8fd4\u56de\u201d\uff0c\u56de\u5230\u6e38\u620f\u3002");
            }
            this.repaint();
            return;
        }
        if (this.smsPackInfo.getPayedMoney() < this.fee) {
            this.outputInfo("\u6b63\u5728\u53d1\u9001\u7b2c" + (this.smsPackInfo.getSendedCnt() + 1) + "\u6761\u77ed\u4fe1\uff0c\u8bf7\u7a0d\u5019... ...");
            if (this.sendSMS(this.smsPackInfo.getFeeSMSNum(), this.smsPackInfo.getFeeSMSContent())) {
                this.smsPackInfo.setPayedMoney(this.smsPackInfo.getPayedMoney() + this.smsPackInfo.getFeeSMSUnitPrice());
                this.smsPackInfo.setSendedCnt(this.smsPackInfo.getSendedCnt() + 1);
                RmsUtil.savePayResult(this.smsPackInfo, this.cpId, this.gameId, this.actionId, this.fee);
                this.rigthCommand = "\u8fd4\u56de";
                if (this.smsPackInfo.getPayedMoney() == this.fee) {
                    this.leftCommand = "";
                    this.outputInfo("\u611f\u8c22\u60a8\u8d2d\u4e70" + this.product + "\uff0c\u8d39\u7528\u4e3a" + this.fee + "\u5143,\u5ba2\u670d\u7535\u8bdd:" + this.cpTel);
                    if (this.payedCallback != null) {
                        this.payedCallback.callback();
                    }
                } else {
                    this.leftCommand = "\u70b9\u64ad";
                    this.showPayInfo2();
                }
            } else {
                this.leftCommand = "\u786e\u5b9a";
                this.rigthCommand = "\u8fd4\u56de";
                this.outputInfo("\u53d1\u9001\u7b2c" + (this.smsPackInfo.getSendedCnt() + 1) + "\u6761\u77ed\u4fe1\u5931\u8d25\uff0c\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u91cd\u65b0\u518d\u8bd5\uff0c\u70b9\u51fb\u201c\u8fd4\u56de\u201d\uff0c\u56de\u5230\u6e38\u620f\u3002");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean sendSMS(String dest, String content) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getPhoneNetworkType() {
        String smsc = System.getProperty("wireless.messaging.sms.smsc");
        if (smsc != null) {
            if (smsc.startsWith("138") || smsc.startsWith("+138") || smsc.startsWith("+86138")) {
                return 0;
            }
            if (smsc.startsWith("+86130") || smsc.startsWith("0086130") || smsc.startsWith("130") || smsc.startsWith("+130")) {
                return 1;
            }
        }
        return 2;
    }

    private void outputInfo(String s2) {
        this.topIndex = 0;
        this.stringItem = s2;
        this.debugInfo(s2);
        this.repaint();
    }

    private void debugInfo(String s2) {
    }

    protected void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        switch (keyCode) {
            case -6: {
                if ("\u70b9\u64ad".equals(this.leftCommand) && this.smsPackInfo.getFeeSMSCnt() > 0) {
                    this.leftCommand = "";
                    this.rigthCommand = "";
                    this.payWithSMS();
                    break;
                }
                if (!"\u786e\u5b9a".equals(this.leftCommand)) break;
                this.leftCommand = "\u70b9\u64ad";
                this.rigthCommand = "\u8fd4\u56de";
                this.showPayInfo();
                break;
            }
            case -7: {
                if ("\u8fd4\u56de".equals(this.rigthCommand)) {
                    if (this.smsPackInfo.getPayedMoney() < this.fee) {
                        this.leftCommand = "\u786e\u5b9a";
                        this.rigthCommand = "\u9000\u51fa";
                        this.outputInfo("\u60a8\u8fd8\u672a\u5b8c\u6210\u4ed8\u8d39\uff0c\u5efa\u8bae\u60a8\u7ee7\u7eed\u4ed8\u8d39\u3002");
                        break;
                    }
                    Display.getDisplay((MIDlet)this.midlet).setCurrent(this.gameDisplayable);
                    break;
                }
                if (!"\u9000\u51fa".equals(this.rigthCommand)) break;
                Display.getDisplay((MIDlet)this.midlet).setCurrent(this.gameDisplayable);
                break;
            }
            case -1: {
                --this.topIndex;
                if (this.topIndex <= 0) {
                    this.topIndex = 0;
                }
                this.repaint();
                break;
            }
            case -2: {
                if (this.bootomIndex > 0) {
                    ++this.topIndex;
                }
                this.repaint();
                break;
            }
            default: {
                System.out.println(keyCode);
            }
        }
    }

    protected void keyRepeated(int keyCode) {
        super.keyRepeated(keyCode);
        this.keyPressed(keyCode);
    }

    public void paint(Graphics g2) {
        Font font = Font.getDefaultFont();
        font = Font.getFont((int)0, (int)1, (int)0);
        g2.setColor(4423868);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        int titleHeight = 30;
        g2.setColor(255, 102, 0);
        g2.fillRect(0, 0, this.getWidth(), titleHeight);
        g2.setColor(0xFFFFFF);
        int x2 = 2;
        int y2 = (titleHeight - font.getHeight()) / 2;
        g2.drawString(this.title, x2, y2, 0);
        g2.setFont(font);
        int toolBarHeight = 30;
        x2 = 5;
        y2 = titleHeight + 5;
        int[] res = TextAjust.ajustDrawString(g2, this.stringItem, font, this.getWidth() - 10, this.getHeight() - toolBarHeight - 10, this.topIndex, x2, y2, 5);
        this.bootomIndex = res[1];
        g2.setColor(255, 102, 0);
        x2 = 0;
        y2 = this.getHeight() - toolBarHeight;
        g2.fillRect(x2, y2, this.getWidth(), toolBarHeight);
        g2.setColor(0xFFFFFF);
        x2 = 2;
        y2 = this.getHeight() - toolBarHeight + font.getHeight() / 2;
        g2.drawString(this.leftCommand, x2, y2, 0);
        x2 = this.getWidth() - TextAjust.getStringWidth(this.rigthCommand, font) - x2 - 2;
        g2.drawString(this.rigthCommand, x2, y2, 0);
    }

    public PayedCallback getPayedCallback() {
        return this.payedCallback;
    }

    public void setPayedCallback(PayedCallback payedCallback) {
        this.payedCallback = payedCallback;
    }
}

