/**
 * $Id: SMSPackInfoReader.java,v 1.13 2010/06/23 02:47:31 dustcloud Exp $
 */
package com.downjoy.j2me.smspack.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.*;

/**
 * <p>ͨļлüƷѽڵعࡣ</p>
 * <p>ַͨشϢȡ͵ѡշѶݡʾ롣</p>
 * <p>(c)2010 d.cn, all rights reserved.</p>
 *
 * @author dust@downjoy.com
 * @version 1.1
 */
public class SMSPackInfoReader {

    //Ϣkey
    private static final String DJ_SMS_CODE1="DJSMSCode1";

    private static final String DJ_SMS_DEST1="DJSMSDest1";

    private static final String DJ_SMS_DESC1="DJSMSDesc1";

    private static final String DJ_SMS_CODE2="DJSMSCode2";

    private static final String DJ_SMS_DEST2="DJSMSDest2";

    private static final String DJ_SMS_DESC2="DJSMSDesc2";

    private static final String DJ_SMS_FREE_CODE="DJFreeCode";

    private static final String DJ_SMS_FREE_DEST="DJFreeDest";
    
    private static final String DJ_SMS_SHORT_CODE1="DJSMSShortCode1";
    
    private static final String DJ_SMS_SHORT_CODE2="DJSMSShortCode2";
    
    private static final int MAX_CODE_INTEGER = 916132831;

    /**
     * ͨļѺ
     *
     * @param cpId ID
     * @param gameId ϷID
     * @param actionId ID
     * @param eqpId ID
     * @param feeCode Ʒѽ
     * @return String[] ؽպ,ݵ example: {"13666666666","529CU40200100101-2"}
     */
    private static String[] getFreeSMSInfo(String cpId, String gameId, String actionId, String eqpId, String feeCode) {
        try {
            //ȡbinļԭʼ
            String info=readBinRaw();
            //õѴԭʼִ
            String freecode=decodeInfo(getFieldValue(info, DJ_SMS_FREE_CODE));
            String freedest=decodeInfo(getFieldValue(info, DJ_SMS_FREE_DEST));
            //ѭõѴ
            if(freecode.indexOf(';') > 0) {
                String[] codeArray=split(freecode, ";");
                String[] destArray=split(freedest, ";");
                int index = (int)(System.currentTimeMillis()%codeArray.length);
                freecode=codeArray[index];
                freedest=destArray[index];
            }
            int pos=freecode.indexOf('|');
            //õϢ
            String content=new StringBuffer().append(freecode.substring(0, pos)).append(cpId).append(gameId).append(actionId).
                append(eqpId).append(freecode.substring(pos + 1)).append("-").append(feeCode).toString();
            //װ
            return new String[] {freedest, content};
        } catch(Exception ex) {
            //շѴΪȷʱṩѴ
            throw new IllegalArgumentException("δҵѴ룡");
        }
    }

    /**
     * ͨļú,,ʾ,ʷѵַʾʽ
     * @param cpId ID
     * @param gameId ϷID
     * @param actionId ID
     * @param eqpId ID
     * @return String[]{,,ʷ,ʾ,Ƿȷָ} example: {"10669588", "52940200100101", "ӭʹxxx˾ҵ", "true"}
     */
    private static String[] getFeeSMSInfo(String cpId, String gameId, String actionId, String eqpId) {
        try {
            //ȡbinļԭʼ
            String packInfo=readBinRaw();
            //õշѴԭ
            String code1=getFieldValue(packInfo, DJ_SMS_CODE1);
            String code2=getFieldValue(packInfo, DJ_SMS_CODE2);
            

            if((code1 == null || code1.length() == 0) && (code2 == null || code2.length() == 0)) {
                throw new IllegalArgumentException("ṩһշѴ룡");
            }
            //ʹ2Ԫ룺
            //1. 1Ԫ벻;
            //2. 70%С7
            if((code2 != null && code2.length() > 0 && (System.currentTimeMillis() % 10 < 7)) || code1 == null ||
               code1.length() == 0) {
                code2=decodeInfo(code2);
                String dest2=decodeInfo(getFieldValue(packInfo, DJ_SMS_DEST2));
                String desc2=getFieldValue(packInfo, DJ_SMS_DESC2);
                String shortCode2Str=getFieldValue(packInfo,DJ_SMS_SHORT_CODE2);
                boolean isShortCode2 = "1".equals(shortCode2Str);
                //ڶ2Ԫ룬ѡһ
                if(code2.indexOf(';') > 0) {
                    String[] code2Array=split(code2, ";");
                    String[] dest2Array=split(dest2, ";");
                    String[] desc2Array=split(desc2, ";");
                    int index = (int)(System.currentTimeMillis() % code2Array.length);
                    if(shortCode2Str!=null && shortCode2Str.length()>0){
                    	String[] shortCode2Array=split(shortCode2Str,";");
                    	isShortCode2 = "1".equals(shortCode2Array[index]);
                    }
                    code2=code2Array[index];
                    dest2=dest2Array[index];
                    desc2=desc2Array[index];
                }

                int pos2=code2.indexOf('|');
                //ȷ
                boolean isExact=dest2.toUpperCase().startsWith("X");
                String content;
                if(isExact) {
                    content=code2.substring(0, pos2);
                } else {
                	if(isShortCode2){
                		content=new StringBuffer().append(code2.substring(0, pos2)).append(getWordsFromNumber(cpId,gameId,code2.substring(pos2 + 1))).toString();
                	}
                	else{
                		content=new StringBuffer().append(code2.substring(0, pos2)).append(cpId).append(gameId).append(actionId).append(eqpId).append(code2.substring(pos2 + 1)).toString();
                	}
                        
                }

                return new String[] {isExact ? dest2.substring(1) : dest2, content, "2", desc2, isExact ? "true" : "false"};
            }

            code1=decodeInfo(code1);
            String dest1=decodeInfo(getFieldValue(packInfo, DJ_SMS_DEST1));
            String desc1=getFieldValue(packInfo, DJ_SMS_DESC1);
            String shortCode1Str=getFieldValue(packInfo,DJ_SMS_SHORT_CODE1);
            boolean isShortCode1 = "1".equals(shortCode1Str);

            //ڶ1Ԫ,ѡһ.
            if(code1.indexOf(';') > 0) {
                String[] code1Array=split(code1, ";");
                String[] dest1Array=split(dest1, ";");
                String[] desc1Array=split(desc1, ";");
                int index = (int)(System.currentTimeMillis() % code1Array.length);
                if(shortCode1Str!=null && shortCode1Str.length()>0){
                	String[] shortCode1Array=split(shortCode1Str,";");
                	isShortCode1 = "1".equals(shortCode1Array[index]);
                }
                code1=code1Array[index];
                dest1=dest1Array[index];
                desc1=desc1Array[index];
            }

            boolean isExact=dest1.toUpperCase().startsWith("X");
            int pos1=code1.indexOf('|');
            String content;
            if(isExact){
            	content=code1.substring(0, pos1);
            }
            else{
            	if(isShortCode1){
            		content = new StringBuffer().append(code1.substring(0, pos1)).append(getWordsFromNumber(cpId,gameId,code1.substring(pos1 + 1))).toString();
            	}
            	else{
            		content = new StringBuffer().append(code1.substring(0, pos1)).append(cpId).append(gameId).append(actionId).append(eqpId).append(code1.substring(pos1 + 1)).toString();
            	}
            }
                

            return new String[] {isExact ? dest1.substring(1) : dest1, content, "1", desc1, isExact ? "true" : "false"};

        } catch(IOException ex) {
            //շѴṩ쳣
            ex.printStackTrace();
            throw new IllegalArgumentException("δҵշѴ룡");
        }
    }

    /**
     * ͨļзؼƷѽڵϢշϢݣպ룬ʾϢ
     * ǾȷָĻ,Ѷݺͺ롣
     * ÿνƷѵʱô˷
     * @param cpId ID
     * @param gameId ϷID
     * @param actionId ID
     * @param eqpId ID
     * @param feeCode Ʒѵ
     * @return SMSPackInfoVO-շϢ,պ,ʾϢ,,ǾȷָĻ,Ѷݺͺķװ.
     * @throws IllegalArgumentException
     */
    public static SMSPackInfoVO getSMSPackInfo(String cpId, String gameId, String actionId, String eqpId, String feeCode) throws
        IllegalArgumentException {
        verifyParams(cpId, gameId, actionId, eqpId, feeCode);

        SMSPackInfoVO smsPackInfo=new SMSPackInfoVO();
        eqpId=eqpId == null ? "000" : eqpId;
        actionId=actionId == null ? "00" : actionId;
        int amount=Integer.parseInt(feeCode);

        String[] feeNumInfo=getFeeSMSInfo(cpId, gameId, actionId, eqpId);
        int price=Integer.parseInt(feeNumInfo[2]);

        smsPackInfo.setFeeSMSNum(feeNumInfo[0]);
        smsPackInfo.setFeeSMSContent(feeNumInfo[1]);
        smsPackInfo.setFeeSMSUnitPrice(price);
        smsPackInfo.setFeeSMSTitle(feeNumInfo[3]);
        smsPackInfo.setFeeSMSCnt(amount / price);

        if(feeNumInfo[4].equals("true")) { //ȷָҪ
            String[] freeNumInfo=getFreeSMSInfo(cpId, gameId, actionId, eqpId, feeCode);
            smsPackInfo.setFreeSMSNum(freeNumInfo[0]);
            smsPackInfo.setFreeSMSContent(freeNumInfo[1]);
        }

        return smsPackInfo;
    }

    /**
     * Ƿ
     *
     * @param str 
     * @return true-
     */
    private static boolean isNumeric(String str) {
        try {
            int i=Integer.parseInt(str);
        } catch(Exception ex) {
            return false;
        }
        return true;
    }

    /**
     * ֤Ч
     *
     * @param cpId ID
     * @param gameId ϷID
     * @param actionId ID
     * @param eqpId ID
     * @param feeCode Ʒѽ
     * @throws IllegalArgumentException ʽȷ
     */
    private static void verifyParams(String cpId, String gameId, String actionId, String eqpId, String feeCode) throws
        IllegalArgumentException {
        //IDΪ3λ֣ϷIDΪλ֣ұ
        if(cpId == null || gameId == null || cpId.length() != 3 || gameId.length() != 3 || !isNumeric(cpId) || !isNumeric(gameId)) {
            throw new IllegalArgumentException("Ч̡ϷID");
        }

        //IDΪ2λ֣ѡ
        if(actionId != null && (actionId.length() != 2 || !isNumeric(actionId))) {
            throw new IllegalArgumentException("ЧID");
        }

        //IDΪ3λ֣ѡ
        if(eqpId != null && (eqpId.length() != 3 || !isNumeric(eqpId))) {
            throw new IllegalArgumentException("ЧID");
        }

        //Ϊ2λ֣
        if(feeCode == null || (feeCode.length() > 2 || !isNumeric(feeCode))) {
            throw new IllegalArgumentException("ЧƷѽ");
        }

        int fee=Integer.parseInt(feeCode);
        //Ϊż
        if(fee % 2 != 0) {
            throw new IllegalArgumentException("ЧƷѽ");
        }

    }

    /**
     * ȡbinļȫ
     *
     * @return ԭʼַ
     * @throws IOException
     */
    private static String readBinRaw() throws IOException {
        StringBuffer sb=new StringBuffer();
        InputStream is=null;
        try {
            is=(new Object()).getClass().getResourceAsStream("/dcn.bin");
            byte[] bytes=new byte[512];
            int len=0;
            while((len=is.read(bytes)) > 0) {
                sb.append(new String(bytes, 0, len, "UTF-8"));
            }
        } finally {
            if(is != null) {
                is.close();
            }
        }
        return sb.toString().replace('\r', ' ');
    }

    /**
     * õֶָϢ
     *
     * @param src binļϢ
     * @param key ֶkey
     * @return ֶϢ
     */
    private static String getFieldValue(String src, String key) {
        int pos=src.indexOf("\n");
        int prevPos=0;
        String line=null;
        while(pos > 0) {
            line=src.substring(prevPos, pos).trim();
            if(line.startsWith(key)) {
                return line.substring(line.indexOf(':') + 1);
            }
            prevPos=pos + 1;
            pos=src.indexOf("\n", prevPos);
        }
        return null;
    }

    /**
     * ַָ
     *
     * @param s ַ
     * @param token ָ
     * @return String[]-ַָ
     */
    private static String[] split(String s, String token) {
        //StringTokenizer is not good enough to perform this operation.
        Vector chips=new Vector();
        int len=token.length();
        int form=0;
        int start;

        while(s.indexOf(token, form) >= form) {
            start=s.indexOf(token, form);
            if(start == form) {
                chips.addElement("");
            } else {
                chips.addElement(s.substring(form, start));
            }
            form=start + len;
        }

        if(form < s.length()) {
            chips.addElement(s.substring(form));
        } else {
            chips.addElement("");
        }

        String[] strs=new String[chips.size()];
        chips.copyInto(strs);
        return strs;
    }

    /**
     * Ϣ
     *
     * @param info Ϣ
     * @return Ϣԭ
     */
    private static String decodeInfo(String info) {
        String nStr=info.substring(0, info.length() - 1);
        byte[] bytes=nStr.getBytes();
        byte[] nbytes=new byte[bytes.length];
        for(int i=0; i < bytes.length; i++) {
            byte b=bytes[i];
            if(b >= 48 && b <= 57) {
                b=(byte) (b + (b <= 50 ? 7 : ( -3)));
            } else if(b >= 65 && b <= 90) {
                b=(byte) (b + (b <= 67 ? 23 : ( -3)));
            }
            nbytes[i]=b;
        }
        return new String(nbytes);
    }
    
    /**
     * ת10Ϊ62
     * @param number
     * @return
     */
    private static String getWordsFromNumber(String cpId, String gameId, String channelId) {
    	int number = Integer.parseInt(new StringBuffer().append(cpId).append(gameId).append(channelId).toString());
    	if(number > MAX_CODE_INTEGER){
    		throw new java.lang.IllegalArgumentException("cpId:"+cpId+"gameId:"+gameId+"channelId:"+channelId+", too large! unsupports!@_@");
    	}
        byte[] bytes=new byte[200];
        int i=0;

        while(true) {
            int x=number % 62;
            byte b;
            if(x >= 10 && x < 36) {
                b=(byte)(x - 10 + 'A');
            } else if(x >= 36 && x < 62) {
                b=(byte)(x - 36 + 'a');
            } else {
                b=(byte)(x - 0 + '0');
            }
            bytes[i++] = b;

            if(number < 62) {
                break;
            }
            number = (number - x) / 62;
        }

        String retVal = new String(reverseAndTrim(bytes));
        int diff = 5-retVal.length();
        if(diff==0){
        	return retVal;
        }
        StringBuffer sb =new StringBuffer();
        for(int n=0; n<diff; n++){
        	sb.append('0');
        }
        sb.append(retVal);
        return sb.toString();
    }


    private static byte[] reverseAndTrim(byte[] bytes) {
        byte[] bytes2=new byte[bytes.length];
        int length=0;

        for(int i=0; i < bytes.length; i++) {
            byte b=bytes[i];
            if(b > 0) {
                length++;
            }
            bytes2[bytes.length - i - 1] = b;
        }

        byte[] bytes3=new byte[length];
        for(int i=0; i < length; i++) {
            bytes3[i] = bytes2[bytes2.length - length + i];
        }

        return bytes3;
    }
}
