/*
 * Decompiled with CFR 0.152.
 */
package com.auer.title;

import ObjCtrl.TouchSection;
import ObjCtrl.iPoint;
import com.auer.title.KeyCodePerformer;
import com.auer.title.MainControl;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class ErrorPage {
    KeyCodePerformer kcp;
    Graphics g;
    private long frameDelay;
    private boolean sleeping = false;
    private Image wavBG;
    private Sprite[] Y_NSprite = new Sprite[2];
    private short widthCenterPoint;
    private short heightCenterPoint;
    private boolean isOpen = false;
    private boolean tempIsOpen;
    private iPoint press = new iPoint();
    private int pressTimeCount;
    private TouchSection on;
    private TouchSection off;
    private int bgX;
    private int bgY;

    public ErrorPage(KeyCodePerformer kcp, Graphics g) {
        this.kcp = kcp;
        this.g = g;
        kcp.setFullScreenMode(true);
        if (KeyCodePerformer.DEFAULT_WIDTH == 240) {
            this.Screen240();
        } else if (KeyCodePerformer.DEFAULT_WIDTH == 176) {
            this.Screen176();
        }
        this.widthCenterPoint = (short)(kcp.getWidth() / 2);
        this.heightCenterPoint = (short)(kcp.getHeight() / 2);
        g.setClip(0, 0, kcp.getWidth(), kcp.getHeight());
        this.frameDelay = 100L;
        this.load();
    }

    private void load() {
        try {
            this.wavBG = Image.createImage((String)"/open/wav_info.png");
            this.Y_NSprite[0] = new Sprite(Image.createImage((String)"/open/yesno_1.png"), 20, 10);
            this.Y_NSprite[1] = new Sprite(Image.createImage((String)"/open/yesno_1.png"), 20, 10);
            this.on = new TouchSection(this.bgX + 0, this.bgY + 0, this.Y_NSprite[0].getWidth(), this.Y_NSprite[0].getHeight());
            this.off = new TouchSection(this.Y_NSprite[1].getX(), this.bgY + 0, this.bgX + 240, this.bgY + 273);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.Y_NSprite[0].setFrameSequence(nArray);
        this.Y_NSprite[1].setFrameSequence(new int[]{2, 3});
        this.Y_NSprite[0].setPosition(this.widthCenterPoint + this.Y_NSprite[0].getWidth(), this.heightCenterPoint - this.wavBG.getHeight() / 4);
        this.Y_NSprite[1].setPosition(this.widthCenterPoint + this.Y_NSprite[0].getWidth() * 2, this.heightCenterPoint - this.wavBG.getHeight() / 4);
        this.widthCenterPoint = (short)(this.widthCenterPoint - this.wavBG.getWidth() / 2);
        this.heightCenterPoint = (short)(this.heightCenterPoint - this.wavBG.getHeight() / 2);
    }

    private void pointerWork() {
        this.press.set(this.kcp.press);
        ++this.pressTimeCount;
        if (this.pressTimeCount >= 1000) {
            this.pressTimeCount = 0;
        }
        if (this.on.touch(this.press)) {
            System.out.println("YES");
            this.isOpen = true;
            if (this.tempIsOpen == this.isOpen) {
                this.exit();
                MainControl.flow = 6;
                MainControl.wavMode = this.isOpen;
                this.pressTimeCount = 0;
            }
            this.tempIsOpen = this.isOpen;
            this.pressTimeCount = 0;
        }
        if (this.off.touch(this.press)) {
            System.out.println("NO");
            this.isOpen = false;
            if (this.tempIsOpen == this.isOpen) {
                this.exit();
                MainControl.flow = 6;
                MainControl.wavMode = this.isOpen;
                this.pressTimeCount = 0;
            }
            this.tempIsOpen = this.isOpen;
            this.pressTimeCount = 0;
        }
        this.kcp.resetPointKey();
    }

    public void run() {
        while (!this.sleeping) {
            this.draw();
            this.pointerWork();
            this.keyWork();
            try {
                Thread.sleep(this.frameDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void draw() {
        this.g.setColor(0, 0, 0);
        this.g.fillRect(0, 0, this.kcp.getWidth(), this.kcp.getHeight());
        this.g.drawImage(this.wavBG, (int)this.widthCenterPoint, (int)this.heightCenterPoint, 20);
        if (this.isOpen) {
            this.Y_NSprite[0].setFrame(1);
            this.Y_NSprite[1].setFrame(0);
        } else {
            this.Y_NSprite[0].setFrame(0);
            this.Y_NSprite[1].setFrame(1);
        }
        this.Y_NSprite[0].paint(this.g);
        this.Y_NSprite[1].paint(this.g);
        if (MainControl.errorMsg != null) {
            this.g.drawString(MainControl.errorMsg, 0, 0, 20);
        }
        this.kcp.flushGraphics();
    }

    private void exit() {
        this.sleeping = true;
        System.gc();
    }

    private void keyWork() {
        switch (this.kcp.getKeyStates()) {
            case -3: 
            case 52: {
                this.isOpen = true;
                break;
            }
            case -4: 
            case 54: {
                this.isOpen = false;
                break;
            }
            case -5: 
            case 53: {
                this.exit();
                MainControl.flow = 3;
                MainControl.wavMode = this.isOpen;
            }
        }
    }

    public void Screen240() {
        this.bgX = KeyCodePerformer.screenX;
        this.bgY = KeyCodePerformer.screenY;
    }

    public void Screen176() {
        this.bgX = KeyCodePerformer.screenX;
        this.bgY = KeyCodePerformer.screenY;
    }
}

