/*
 * Decompiled with CFR 0.152.
 */
package kiwi.database.imagecontent;

final class CRCUtil {
    private static int[] crc_table;

    CRCUtil() {
    }

    private static void make_crc_table() {
        crc_table = new int[256];
        int n = 0;
        while (n < 256) {
            int c = n;
            int k = 0;
            while (k < 8) {
                c = (c & 1) == 1 ? 0xEDB88320 ^ c >>> 1 : (c >>>= 1);
                ++k;
            }
            CRCUtil.crc_table[n] = c;
            ++n;
        }
    }

    private static int update_crc(byte[] buf, int off, int len) {
        int c = -1;
        if (crc_table == null) {
            CRCUtil.make_crc_table();
        }
        int n = off;
        while (n < len + off) {
            c = crc_table[(c ^ buf[n]) & 0xFF] ^ c >>> 8;
            ++n;
        }
        return c;
    }

    static int checksum(byte[] buf, int off, int len) {
        return ~CRCUtil.update_crc(buf, off, len);
    }
}

