/*
 * Decompiled with CFR 0.152.
 */
package kiwi.database.newsprite;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import kiwi.database.imagecontent.FileCombo;
import kiwi.database.imagecontent.ImageContent;
import kiwi.database.newsprite.NewSpriteElement;
import kiwi.database.newsprite.NewSpriteFrame;
import kiwi.database.newsprite.NewSpriteRefElement;
import kiwi.database.newsprite.ScreenData;
import kiwi.database.newsprite.SpriteElement;

public class NewSprite {
    public short width = (short)100;
    public short height = (short)100;
    public ImageContent[] model_imagecontent;
    public NewSpriteFrame[] model_frame;
    public SpriteElement[] model_element;
    public boolean ispaintregion;
    public short[][] frameseqdata;
    public NewSprite[] refnewsprite;
    public int relative_x;
    public int relative_y;
    public int x;
    public int y;
    public int seqindex;
    public short[] frameseq;
    public boolean isVisible = true;
    public boolean isatk;
    public NewSprite beatknewsprite;
    public boolean isbeatk;
    public boolean iseffect;
    public boolean isflash;
    public boolean isalpha;
    public boolean isrgb = true;
    public byte flashtype;
    public Image flashimage;
    public Graphics flashg;
    public int[] rgb;
    public int argb = -1;
    public int trans = 0;
    public byte seqdataindex;
    byte anchor;
    short anchor_width;
    short anchor_height;
    boolean ispass;
    public int wt = 0;
    static /* synthetic */ Class class$0;

    public NewSprite(DataInputStream dis, String path, boolean iscombine) {
        this.readData(dis, path, iscombine);
        if (this.frameseqdata != null) {
            this.setFrameSequenceData(0);
            if (this.frameseq == null || this.frameseq.length == 0) {
                this.setFrameSequenceData(-1);
            }
        } else {
            this.setFrameSequenceData(-1);
        }
    }

    public NewSprite(NewSprite ns) {
        this.width = ns.width;
        this.height = ns.height;
        this.model_imagecontent = ns.model_imagecontent;
        this.model_frame = ns.model_frame;
        this.model_element = ns.model_element;
        this.ispaintregion = ns.ispaintregion;
        this.seqdataindex = ns.seqdataindex;
        this.frameseqdata = ns.frameseqdata;
        this.frameseq = ns.frameseq;
        this.seqindex = ns.seqindex;
        this.refnewsprite = ns.refnewsprite;
    }

    public void readData(DataInputStream dis, String path, boolean iscombine) {
        try {
            this.width = dis.readShort();
            this.height = dis.readShort();
            this.model_imagecontent = new ImageContent[dis.readByte()];
            int i = 0;
            while (i < this.model_imagecontent.length) {
                this.model_imagecontent[i] = iscombine ? ImageContent.getCImageContent(String.valueOf(dis.readInt()), path) : ImageContent.getImageContent(String.valueOf(dis.readInt()), path);
                ++i;
            }
            this.model_element = new SpriteElement[dis.readShort()];
            i = 0;
            while (i < this.model_element.length) {
                byte type = dis.readByte();
                switch (type) {
                    case 0: {
                        this.model_element[i] = new NewSpriteElement(dis);
                        break;
                    }
                    case 1: {
                        this.model_element[i] = new NewSpriteRefElement(dis);
                    }
                }
                ++i;
            }
            this.model_frame = new NewSpriteFrame[dis.readShort()];
            i = 0;
            while (i < this.model_frame.length) {
                this.model_frame[i] = new NewSpriteFrame(dis);
                ++i;
            }
            this.ispaintregion = dis.readBoolean();
            int count = dis.readByte();
            if (count > 0) {
                this.frameseqdata = new short[count][];
                int i2 = 0;
                while (i2 < count) {
                    dis.readUTF();
                    int cc = dis.readShort();
                    if (cc > 0) {
                        short[] c1 = new short[cc * 4];
                        int j = 0;
                        while (j < cc) {
                            c1[j * 4] = dis.readShort();
                            c1[j * 4 + 1] = dis.readShort();
                            c1[j * 4 + 2] = dis.readShort();
                            c1[j * 4 + 3] = dis.readByte();
                            ++j;
                        }
                        this.frameseqdata[i2] = c1;
                    } else {
                        this.frameseqdata[i2] = new short[4];
                    }
                    ++i2;
                }
            }
            this.refnewsprite = new NewSprite[dis.readByte()];
            this.ispass = dis.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setAnchor(int anchor, int a_w, int a_h) {
        this.anchor = (byte)anchor;
        this.anchor_width = (short)a_w;
        this.anchor_height = (short)a_h;
    }

    public void setFrameSequence(short[] temp) {
        this.frameseq = temp;
        this.seqindex = 0;
    }

    public void setFrameSequenceData(int index) {
        this.seqdataindex = (byte)index;
        if (index == -1 || index >= this.frameseqdata.length) {
            this.frameseq = new short[this.model_frame.length * 4];
            int i = 0;
            while (i < this.model_frame.length) {
                this.frameseq[i * 4] = (short)i;
                ++i;
            }
        } else if (this.frameseqdata != null) {
            this.frameseq = this.frameseqdata[index];
            this.seqindex = 0;
        }
    }

    public int getFrameSequenceData() {
        return this.seqdataindex;
    }

    public boolean nextFrame() {
        int value = this.seqindex + 1;
        this.seqindex = value % this.getFrameCount();
        return value >= this.getFrameCount();
    }

    public boolean nextFrame(long addtime) {
        this.wt = (int)((long)this.wt + addtime);
        boolean b = false;
        while (this.wt > this.getWaitTime()) {
            this.wt %= this.getWaitTime();
            this.nextFrame();
            b = true;
        }
        return b;
    }

    public boolean nextFrameToEnd(long addtime) {
        this.wt = (int)((long)this.wt + addtime);
        while (this.wt > this.getWaitTime()) {
            this.wt %= this.getWaitTime();
            if (this.getFrame() == this.getFrameCount() - 1) {
                return true;
            }
            this.nextFrame();
        }
        return false;
    }

    public int getWT() {
        return this.wt;
    }

    public void setWT(int temp) {
        this.wt = temp;
    }

    public boolean preFrame() {
        int value = this.seqindex - 1;
        this.seqindex = (value + this.getFrameCount()) % this.getFrameCount();
        return value < 0;
    }

    public int getWaitTime() {
        return this.getNewSpriteFrame().waittime;
    }

    public void setFrame(int seqindex) {
        this.seqindex = seqindex;
    }

    public int getFrame() {
        return this.seqindex;
    }

    public NewSpriteFrame getNewSpriteFrame() {
        try {
            if (this.frameseq[this.getFrame() * 4 + 3] == 2) {
                NewSpriteFrame.ismirror = true;
                NewSpriteFrame.width = this.width;
            } else {
                NewSpriteFrame.ismirror = false;
            }
            return this.model_frame[this.frameseq[this.seqindex * 4]];
        }
        catch (Exception e) {
            System.out.println(String.valueOf(this.model_frame.length) + " " + this.frameseq.length + " " + this.seqindex);
            return null;
        }
    }

    public boolean isColide(int x, int y, int w, int h) {
        return this.getNewSpriteFrame().isColide(x, y, w, h, this.getX(), this.getY());
    }

    public boolean isColideType(int x, int y, int w, int h, int type) {
        return this.getNewSpriteFrame().isColideType(x, y, w, h, this.getX(), this.getY(), type);
    }

    public boolean isColideType(int x, int y, int w, int h, int type1, int type2) {
        return this.getNewSpriteFrame().isColideType(x, y, w, h, this.getX(), this.getY(), type1, type2);
    }

    public int getFrame(int basetime, long starttime) {
        int i = 0;
        while (i < this.frameseq.length) {
            short time = this.model_frame[this.frameseq[i]].waittime;
            if (starttime >= (long)basetime && starttime < (long)(time + basetime)) {
                return this.frameseq[i];
            }
            basetime += time;
            ++i;
        }
        return -1;
    }

    public void setTransform(int trans) {
        this.trans = trans;
    }

    public void setRelativePos(int x, int y) {
        this.relative_x = x;
        this.relative_y = y;
    }

    public void setBeatkSprite(NewSprite ns) {
        this.beatknewsprite = ns;
        this.beatknewsprite.setRelativePos(this.relative_x, this.relative_y);
        this.beatknewsprite.setPosition(this.x, this.y);
    }

    public void setRefSprite(NewSprite ns, int index) {
        if (index < this.refnewsprite.length) {
            this.refnewsprite[index] = ns;
        }
    }

    public void move(int x, int y) {
        this.x += x;
        this.y += y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void paint(Graphics g, int offsetx, int offsety) {
        if (this.isVisible) {
            NewSpriteFrame nsf;
            int ttrans = SpriteElement.getTrans(this.frameseq[this.getFrame() * 4 + 3], this.trans);
            offsetx += this.getOffsetX();
            offsety += this.getOffsetY();
            int cx = g.getClipX();
            int cy = g.getClipY();
            int cw = g.getClipWidth();
            int ch = g.getClipHeight();
            if (this.ispaintregion) {
                g.setClip(offsetx + this.x, offsety + this.y, (int)this.width, (int)this.height);
            }
            if ((nsf = this.getNewSpriteFrame()) == null) {
                return;
            }
            if (this.isrgb && (nsf.isflash || this.isalpha)) {
                this.buildFlash();
                this.flashg.fillRect(0, 0, this.flashimage.getWidth(), this.flashimage.getHeight());
            }
            if (this.isrgb && (nsf.isflash || this.isalpha)) {
                nsf.paint(this.flashg, this, offsetx, offsety, ttrans);
            } else {
                nsf.paint(g, this, this.x + offsetx, this.y + offsety, ttrans);
            }
            if (this.isrgb && (nsf.isflash || this.isalpha)) {
                this.flashimage.getRGB(this.rgb, 0, (int)this.width, 0, 0, (int)this.width, (int)this.height);
                int x = 0;
                while (x < this.rgb.length) {
                    int temp = this.rgb[x];
                    if (temp == -16777216) {
                        this.rgb[x] = 0;
                    } else if (this.isflash) {
                        if (this.flashtype == 0) {
                            this.rgb[x] = this.argb | this.rgb[x];
                        } else if (this.flashtype == 1) {
                            this.rgb[x] = this.argb & this.rgb[x];
                        }
                    } else {
                        this.rgb[x] = this.argb;
                    }
                    ++x;
                }
                g.drawRGB(this.rgb, 0, this.flashimage.getWidth(), this.x, this.y, this.flashimage.getWidth(), this.flashimage.getHeight(), true);
            }
            g.setClip(cx, cy, cw, ch);
        }
    }

    public void paint(Graphics g) {
        this.paint(g, 0, 0);
    }

    public int getAnchorX() {
        if ((this.anchor & 1) != 0 || (this.anchor & 4) == 0) {
            // empty if block
        }
        return 0;
    }

    public int getAnchorY() {
        if ((this.anchor & 2) != 0 || (this.anchor & 0x10) == 0) {
            // empty if block
        }
        return 0;
    }

    public static void screenVibrate(Graphics g, Vector v) {
        int i = v.size() - 1;
        while (i >= 0) {
            ScreenData sd = (ScreenData)v.elementAt(i);
            sd.run(g);
            if (sd.isover()) {
                v.removeElementAt(i);
            }
            --i;
        }
    }

    void buildFlash() {
        if (this.flashimage == null) {
            this.flashimage = Image.createImage((int)this.width, (int)this.height);
            this.flashg = this.flashimage.getGraphics();
            this.rgb = new int[this.width * this.height];
        }
    }

    public void setIsAlpha(boolean isalpha) {
        this.isalpha = isalpha;
    }

    public void setColor(int argb) {
        this.argb = argb;
        this.buildFlash();
    }

    public int getAllTime() {
        int value = 0;
        int i = 0;
        while (i < this.getFrameCount()) {
            value += this.getTime(this.frameseq[i * 4]);
            ++i;
        }
        return value;
    }

    public int getTime(int frame) {
        return this.model_frame[frame].waittime;
    }

    public int getTime(int start, int end) {
        int value = 0;
        int i = start;
        while (i < end) {
            value += this.getTime(i);
            ++i;
        }
        return value;
    }

    public int getWidth() {
        if (this.isTranChange()) {
            return this.height;
        }
        return this.width;
    }

    public int getHeight() {
        if (this.isTranChange()) {
            return this.width;
        }
        return this.height;
    }

    private boolean isTranChange() {
        return this.trans == 4 || this.trans == 7 || this.trans == 6 || this.trans == 5;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getDrawX() {
        return this.relative_x - this.width / 2;
    }

    public int getDrawY() {
        return this.relative_y - this.height / 2;
    }

    public int getOffsetX() {
        return this.frameseq[this.getFrame() * 4 + 1];
    }

    public int getOffsetY() {
        return this.frameseq[this.getFrame() * 4 + 2];
    }

    public int getFrameCount() {
        return this.frameseq.length / 4;
    }

    public static NewSprite getNewSprite(int id) {
        return NewSprite.getNewSprite(String.valueOf(id), "/animation/newsprite/");
    }

    public static NewSprite getNewSprite(String name) {
        return NewSprite.getNewSprite(name, "/animation/newsprite/");
    }

    public static NewSprite getNewSprite(int id, String path) {
        return NewSprite.getNewSprite(String.valueOf(id), path);
    }

    public static NewSprite getNewSprite(String name, String path) {
        InputStream is;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("kiwi.database.newsprite.NewSprite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((is = clazz.getResourceAsStream(String.valueOf(path) + name)) != null) {
            DataInputStream dis = new DataInputStream(is);
            NewSprite w = new NewSprite(dis, path, false);
            try {
                dis.close();
                dis = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return w;
        }
        System.out.println("newsprite error " + name);
        return null;
    }

    public static NewSprite getCNewSprite(String name, String path) {
        InputStream is;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("kiwi.database.newsprite.NewSprite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((is = clazz.getResourceAsStream(String.valueOf(path) + "newsprite.bin")) != null) {
            FileCombo fc = new FileCombo(new DataInputStream(is), name);
            NewSprite w = new NewSprite(fc.dis, path, true);
            fc.close();
            return w;
        }
        System.out.println("newsprite error " + name);
        return null;
    }
}

