/*
 * Decompiled with CFR 0.152.
 */
package utils;

import game.Egg;
import game.SceneGame;
import java.util.Vector;
import utils.YTAStar_Node;

public class YTAStar {
    private byte canMoveIndex = (byte)-1;
    private int rows = 0;
    private int cols = 0;
    private SceneGame game;
    private final byte G_OFFSET;
    private int destinationRow;
    private int destinationCol;
    Vector closeNode = new Vector();
    Vector openNode = new Vector();

    public YTAStar() {
        this.G_OFFSET = 1;
    }

    public void setMap(SceneGame _game, int rows, int cols) {
        this.game = _game;
        this.rows = rows;
        this.cols = cols;
        this.closeNode.removeAllElements();
        this.openNode.removeAllElements();
    }

    public int[][] getPath(int startX, int StartY, int destinationX, int destinationY) {
        this.closeNode.removeAllElements();
        this.openNode.removeAllElements();
        Vector<YTAStar_Node> temp = new Vector<YTAStar_Node>();
        long timer = System.currentTimeMillis();
        this.destinationRow = destinationY;
        this.destinationCol = destinationX;
        YTAStar_Node startNode = new YTAStar_Node();
        startNode.row = StartY;
        startNode.col = startX;
        startNode.g = 0;
        startNode.h = this.getH(startNode.row, startNode.col);
        startNode.f = startNode.g + startNode.h;
        this.openNode.addElement(startNode);
        YTAStar_Node bestNode;
        while ((bestNode = this.getBesetNode()) != null) {
            if (bestNode.row == destinationY && bestNode.col == destinationX) {
                long time = System.currentTimeMillis() - timer;
                YTAStar_Node _Node = bestNode;
                while (_Node.parent != null) {
                    temp.addElement(_Node);
                    _Node = _Node.parent;
                }
                int size = temp.size();
                int[][] data = new int[size][2];
                for (int i = 0; i < size; ++i) {
                    YTAStar_Node _node = (YTAStar_Node)temp.elementAt(size - 1 - i);
                    data[i][0] = _node.col;
                    data[i][1] = _node.row;
                }
                return data;
            }
            this.seachSeccessionNode(bestNode);
        }
        return null;
    }

    private void seachSeccessionNode(YTAStar_Node bestNode) {
        int row = bestNode.row - 1;
        int col = bestNode.col;
        if (this.isCanMove(row, col)) {
            this.creatSeccessionNode(bestNode, row, col);
        }
        if (this.isCanMove(row = bestNode.row + 1, col = bestNode.col)) {
            this.creatSeccessionNode(bestNode, row, col);
        }
        if (this.isCanMove(row = bestNode.row, col = bestNode.col - 1)) {
            this.creatSeccessionNode(bestNode, row, col);
        }
        if (this.isCanMove(row = bestNode.row, col = bestNode.col + 1)) {
            this.creatSeccessionNode(bestNode, row, col);
        }
        this.closeNode.addElement(bestNode);
        for (int i = 0; i < this.openNode.size(); ++i) {
            YTAStar_Node node = (YTAStar_Node)this.openNode.elementAt(i);
            if (node.row != bestNode.row || node.col != bestNode.col) continue;
            this.openNode.removeElementAt(i);
            break;
        }
    }

    private void creatSeccessionNode(YTAStar_Node bestNode, int row, int col) {
        YTAStar_Node oldNode = null;
        int g = bestNode.g + 1;
        if (!this.isInClose(row, col)) {
            oldNode = this.checkOpen(row, col);
            if (oldNode != null) {
                if (oldNode.g < g) {
                    oldNode.parent = bestNode;
                    oldNode.g = g;
                    oldNode.f = g + oldNode.h;
                }
            } else {
                YTAStar_Node node = new YTAStar_Node();
                node.parent = bestNode;
                node.g = g;
                node.h = this.getH(row, col);
                node.f = node.g + node.h;
                node.row = row;
                node.col = col;
                this.openNode.addElement(node);
            }
        }
    }

    private YTAStar_Node checkOpen(int row, int col) {
        for (int i = 0; i < this.openNode.size(); ++i) {
            YTAStar_Node node = (YTAStar_Node)this.openNode.elementAt(i);
            if (node.row != row || node.col != col) continue;
            return node;
        }
        return null;
    }

    private boolean isInClose(int row, int col) {
        for (int i = 0; i < this.closeNode.size(); ++i) {
            YTAStar_Node node = (YTAStar_Node)this.closeNode.elementAt(i);
            if (node.row != row || node.col != col) continue;
            return true;
        }
        return false;
    }

    private YTAStar_Node getBesetNode() {
        YTAStar_Node bestNode = null;
        int index = -1;
        int f = 999999999;
        for (int i = 0; i < this.openNode.size(); ++i) {
            bestNode = (YTAStar_Node)this.openNode.elementAt(i);
            if (bestNode.f >= f) continue;
            f = bestNode.f;
            index = i;
        }
        if (index == -1) {
            return null;
        }
        return (YTAStar_Node)this.openNode.elementAt(index);
    }

    private int getH(int row, int col) {
        return Math.abs(this.destinationRow - row) + Math.abs(this.destinationCol - col);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCanMove(int row, int col) {
        if (col < 0) return false;
        if (col >= this.cols) {
            return false;
        }
        if (row < 0) return false;
        if (row >= this.rows) {
            return false;
        }
        if (this.game.m_eggs[col][row] == null) return true;
        Egg cfr_ignored_0 = this.game.m_eggs[col][row];
        if (this.game.m_eggs[col][row].m_status != 0) return false;
        return true;
    }
}

