/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class YTStore {
    private RecordStore m_records;
    private String m_recordname;

    public YTStore(String _name) {
        this.init(_name);
    }

    public void init(String strName) {
        this.m_recordname = strName;
        this.m_records = null;
    }

    public boolean save(int tagID) {
        try {
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteArrayOut);
            byte[] data = byteArrayOut.toByteArray();
            return this.write(tagID, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void get(int tagID) {
        byte[] memory = this.read(tagID);
        ByteArrayInputStream byteArrayIn = null;
        DataInputStream in = null;
        if (memory != null) {
            byteArrayIn = new ByteArrayInputStream(memory);
            in = new DataInputStream(byteArrayIn);
        }
    }

    public boolean isExist(int tagID) {
        if (this.isDatabaseExist()) {
            this.open();
            int index = this.getRecordIDByTagID((byte)tagID);
            if (index != -1) {
                return true;
            }
        }
        return false;
    }

    public boolean write(int tagID, byte[] data) {
        if (!this.isDatabaseExist()) {
            this.open();
        }
        if (!this.isDatabaseExist()) {
            return false;
        }
        byte[] tagData = new byte[data.length + 1];
        tagData[0] = (byte)tagID;
        for (int i = 0; i < data.length; ++i) {
            tagData[i + 1] = data[i];
        }
        int existingID = this.getRecordIDByTagID((byte)tagID);
        if (existingID != -1) {
            try {
                this.m_records.setRecord(existingID, tagData, 0, tagData.length);
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException e) {}
        } else {
            try {
                this.m_records.addRecord(tagData, 0, tagData.length);
            }
            catch (RecordStoreNotOpenException e) {
                e.printStackTrace();
            }
            catch (RecordStoreException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public byte[] read(int tagID) {
        if (!this.isExist(tagID)) {
            return null;
        }
        try {
            int numRecords = this.m_records.getNumRecords();
            for (int c = 0; c < numRecords; ++c) {
                try {
                    int nSize = this.m_records.getRecordSize(1 + c);
                    if (nSize <= 0) continue;
                    byte[] tagData = new byte[nSize];
                    this.m_records.getRecord(1 + c, tagData, 0);
                    if (tagData[0] != tagID) continue;
                    byte[] data = new byte[tagData.length - 1];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = tagData[i + 1];
                    }
                    return data;
                }
                catch (RecordStoreNotOpenException e) {
                    continue;
                }
                catch (InvalidRecordIDException e) {
                    continue;
                }
                catch (RecordStoreException e) {
                    // empty catch block
                }
            }
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            // empty catch block
        }
        return null;
    }

    public boolean delete(int tagID) {
        if (this.isExist(tagID)) {
            try {
                this.m_records.deleteRecord(this.getRecordIDByTagID((byte)tagID));
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (InvalidRecordIDException e) {
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void open() {
        if (this.m_records == null) {
            try {
                this.m_records = RecordStore.openRecordStore((String)this.m_recordname, (boolean)true);
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
    }

    public void close() {
        if (this.m_records != null) {
            try {
                this.m_records.closeRecordStore();
                this.m_records = null;
                this.m_recordname = null;
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
    }

    private boolean isDatabaseExist() {
        try {
            this.m_records = RecordStore.openRecordStore((String)this.m_recordname, (boolean)false);
            if (this.m_records != null) {
                return true;
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return false;
    }

    private int getRecordIDByTagID(byte tagID) {
        try {
            int numRecords = this.m_records.getNumRecords();
            for (int c = 0; c < numRecords; ++c) {
                try {
                    int nSize = this.m_records.getRecordSize(1 + c);
                    if (nSize <= 0) continue;
                    byte[] data = new byte[nSize];
                    this.m_records.getRecord(1 + c, data, 0);
                    if (data[0] != tagID) continue;
                    return 1 + c;
                }
                catch (RecordStoreNotOpenException e) {
                    continue;
                }
                catch (InvalidRecordIDException e) {
                    continue;
                }
                catch (RecordStoreException e) {
                    // empty catch block
                }
            }
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            // empty catch block
        }
        return -1;
    }
}

