/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.SceneGame;
import utils.YTAniManager;
import utils.YTAnimation;
import utils.YTGraphics;
import utils.YTMath;

public class Egg {
    private YTAniManager m_animan = null;
    private YTAniManager m_animan_appear = null;
    private YTAniManager animan_eggdis = null;
    private SceneGame m_scene = null;
    public static final byte STATUS_APPEAR = 0;
    public static final byte STATUS_WAITING = 1;
    public static final byte STATUS_READY = 2;
    public static final byte STATUS_CANCEL = 3;
    public static final byte STATUS_MOVING = 4;
    public static final byte STATUS_DISAPPEAR = 5;
    public int m_status = -1;
    private int m_direct = -1;
    private static final int DIR_UP = 0;
    private static final int DIR_DOWN = 1;
    private static final int DIR_LEFT = 2;
    private static final int DIR_RIGHT = 3;
    public int m_column = -1;
    public int m_row = -1;
    public int m_step = 0;
    public int m_type = -1;
    public boolean marked = false;
    private long apperTimer = 0L;
    public static final long APPEAR_TIME = 3000L;
    public int[][] m_path = null;
    private int m_pathIndex = -1;
    private int start_x = 0;
    private int start_y = 0;
    private int m_position_x = 0;
    private int m_position_y = 0;

    public Egg(SceneGame _scene, int type, YTAnimation _animation, int col, int row) {
        this.m_scene = _scene;
        this.m_type = type;
        this.m_animan = new YTAniManager(_animation);
        this.m_animan_appear = new YTAniManager(this.m_scene.ani_eggappear);
        this.m_animan_appear.startAnim(this.m_type * 2, true, true, false);
        this.animan_eggdis = new YTAniManager(this.m_scene.ani_eggdis);
        this.m_column = col;
        this.m_row = row;
        this.changeStatus(0);
    }

    public void startMoving(int[][] _path, int _startx, int _startY) {
        this.m_path = _path;
        this.start_x = _startx;
        this.start_y = _startY;
        this.m_position_x = this.getX(this.start_x);
        this.m_position_y = this.getY(this.start_y);
        this.m_direct = this.getDirect(this.start_x, this.start_y, this.m_path[0][0], this.m_path[0][1]);
        if (this.m_direct == 2 || this.m_direct == 3) {
            this.m_animan.startAnim(8, true, true, false);
        } else if (this.m_direct == 0) {
            this.m_animan.startAnim(7, true, true, false);
        } else if (this.m_direct == 1) {
            this.m_animan.startAnim(6, true, true, false);
        }
        this.m_pathIndex = -1;
        this.changeStatus(4);
    }

    public int getX(int _x) {
        return 5 + 52 + _x * 23 + 1 + 20 / 2;
    }

    public int getY(int _y) {
        return 1 + 42 + _y * 29 + 2 + 24;
    }

    public int getXCenter(int _x) {
        return 5 + 52 + _x * 23 + 1 + 20 / 2;
    }

    public int getYCenter(int _y) {
        return 1 + 42 + _y * 29 + 2 + 24 / 2;
    }

    public int getDirect(int _x, int _y, int _tx, int _ty) {
        if (_x > _tx) {
            return 2;
        }
        if (_x < _tx) {
            return 3;
        }
        if (_y > _ty) {
            return 0;
        }
        if (_y < _ty) {
            return 1;
        }
        return -1;
    }

    public void render(YTGraphics _render, int x, int y) {
        switch (this.m_status) {
            case 0: {
                this.m_animan_appear.draw(_render, x, y, false, false);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.m_animan.draw(_render, x, y, false, false);
                break;
            }
            case 5: {
                int _xx = this.getXCenter(this.m_column);
                int _yy = this.getYCenter(this.m_row);
                this.animan_eggdis.draw(_render, _xx, _yy, false, false);
                break;
            }
            case 4: {
                if (this.m_direct == 2) {
                    this.m_animan.draw(_render, this.m_position_x, this.m_position_y, true, false);
                    break;
                }
                this.m_animan.draw(_render, this.m_position_x, this.m_position_y, false, false);
            }
        }
    }

    public void update(int _timeStep) {
        switch (this.m_status) {
            case 0: {
                this.m_animan_appear.updateAnim(_timeStep);
                if (this.m_animan_appear.getNowActionId() == this.m_type * 2) {
                    if (System.currentTimeMillis() - this.apperTimer <= 3000L) break;
                    this.m_animan_appear.startAnim(this.m_type * 2 + 1, true, false, false);
                    break;
                }
                if (this.m_animan_appear.getNowActionId() != this.m_type * 2 + 1 || this.m_animan_appear.isAnimating()) break;
                this.m_scene.checkDisappear(this.m_column, this.m_row);
                this.changeStatus(1);
                break;
            }
            case 1: {
                this.m_animan.updateAnim(_timeStep);
                if (this.m_animan.isAnimating()) break;
                this.changeStatus(1);
                break;
            }
            case 3: {
                Egg egg;
                int i;
                this.m_animan.updateAnim(_timeStep);
                if (this.m_animan.isAnimating()) break;
                this.changeStatus(1);
                this.m_scene.checkDisappear(this.m_column, this.m_row);
                int size = this.m_scene.m_disappeararray_shuiping.size();
                if (size >= 4) {
                    for (i = 0; i < size; ++i) {
                        egg = (Egg)this.m_scene.m_disappeararray_shuiping.elementAt(i);
                        egg.changeStatus(5);
                    }
                    this.m_scene.reduceAim(size);
                }
                this.m_scene.m_disappeararray_shuiping.removeAllElements();
                size = this.m_scene.m_disappeararray_shuizhi.size();
                if (size >= 4) {
                    for (i = 0; i < size; ++i) {
                        egg = (Egg)this.m_scene.m_disappeararray_shuizhi.elementAt(i);
                        egg.changeStatus(5);
                    }
                    this.m_scene.reduceAim(size);
                }
                this.m_scene.m_disappeararray_shuizhi.removeAllElements();
                size = this.m_scene.m_disappeararray_zuoxie.size();
                if (size >= 4) {
                    for (i = 0; i < size; ++i) {
                        egg = (Egg)this.m_scene.m_disappeararray_zuoxie.elementAt(i);
                        egg.changeStatus(5);
                    }
                    this.m_scene.reduceAim(size);
                }
                this.m_scene.m_disappeararray_zuoxie.removeAllElements();
                size = this.m_scene.m_disappeararray_youxie.size();
                if (size >= 4) {
                    for (i = 0; i < size; ++i) {
                        egg = (Egg)this.m_scene.m_disappeararray_youxie.elementAt(i);
                        egg.changeStatus(5);
                    }
                    this.m_scene.reduceAim(size);
                }
                this.m_scene.m_disappeararray_youxie.removeAllElements();
                break;
            }
            case 2: {
                this.m_animan.updateAnim(_timeStep);
                break;
            }
            case 4: {
                this.moveByPath();
                break;
            }
            case 5: {
                this.animan_eggdis.updateAnim(_timeStep);
                if (this.animan_eggdis.isAnimating()) break;
                this.m_scene.m_eggs[this.m_column][this.m_row] = null;
            }
        }
    }

    public void changeStatus(int _status) {
        this.m_status = _status;
        switch (this.m_status) {
            case 0: {
                this.apperTimer = System.currentTimeMillis();
                this.m_animan.startAnim(0, true, false, false);
                break;
            }
            case 1: {
                this.m_animan.startAnim(YTMath.getRandom(0, 3), true, false, false);
                break;
            }
            case 2: {
                this.m_animan.startAnim(4, true, false, false);
                break;
            }
            case 3: {
                this.m_animan.startAnim(5, true, false, true);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.animan_eggdis.startAnim(0, true, false, false);
            }
        }
    }

    public boolean moveByPath() {
        block17: {
            block16: {
                if (this.m_path == null) {
                    return true;
                }
                switch (this.m_direct) {
                    case 2: {
                        this.m_position_x -= 23 / 2;
                        break;
                    }
                    case 3: {
                        this.m_position_x += 23 / 2;
                        break;
                    }
                    case 0: {
                        this.m_position_y -= 29 / 2;
                        break;
                    }
                    case 1: {
                        this.m_position_y += 29 / 2;
                    }
                }
                this.m_animan.nextFrame();
                if (Math.abs(this.m_position_x - this.getX(this.m_path[this.m_pathIndex + 1][0])) < 23 / 2) break block16;
                if (Math.abs(this.m_position_y - this.getY(this.m_path[this.m_pathIndex + 1][1])) >= 29 / 2) break block17;
            }
            this.m_position_x = this.getX(this.m_path[this.m_pathIndex + 1][0]);
            this.m_position_y = this.getY(this.m_path[this.m_pathIndex + 1][1]);
            ++this.m_pathIndex;
            if (this.m_pathIndex >= this.m_path.length - 1) {
                this.changeStatus(3);
                return true;
            }
            this.m_direct = this.getDirect(this.m_path[this.m_pathIndex][0], this.m_path[this.m_pathIndex][1], this.m_path[this.m_pathIndex + 1][0], this.m_path[this.m_pathIndex + 1][1]);
            if (this.m_direct == 2 || this.m_direct == 3) {
                this.m_animan.startAnim(8, true, true, false);
            } else if (this.m_direct == 0) {
                this.m_animan.startAnim(7, true, true, false);
            } else if (this.m_direct == 1) {
                this.m_animan.startAnim(6, true, true, false);
            }
        }
        return false;
    }
}

