/*
 * Decompiled with CFR 0.152.
 */
package utils;

public class YTCRC {
    private static int[] Table;

    private static void makeTable() {
        Table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            for (int k = 0; k < 8; ++k) {
                if ((c & 1) == 1) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            YTCRC.Table[n] = c;
        }
    }

    private static int update(byte[] buf, int off, int len) {
        int c = -1;
        if (Table == null) {
            YTCRC.makeTable();
        }
        for (int n = off; n < len + off; ++n) {
            c = Table[(c ^ buf[n]) & 0xFF] ^ c >>> 8;
        }
        return c;
    }

    public static int sum(byte[] buf, int off, int len) {
        return ~YTCRC.update(buf, off, len);
    }
}

