

	// ==================================================================================
	//
	//                              ASSET FILE READING
	//
	// ==================================================================================

	// Values taken from project properties (defaults) and overriden in individual targets.
	// along with trick to fool IDE's

	//#ifndef BOXIMAGE_NEVER_DEFINED
	//# final static boolean FILE_CACHE_ALWAYS_OFF = ${BOXIMAGE_FILE_CACHE_ALWAYS_OFF};
	//# final static boolean FILE_CACHE_ALWAYS_ON = ${BOXIMAGE_FILE_CACHE_ALWAYS_ON};
	//# final static boolean USE_DATAINPUTSTREAM = ${BOXIMAGE_USE_DATAINPUTSTREAM};
	//# final static boolean DONT_CLOSE_INPUTSTREAM = ${BOXIMAGE_DONT_CLOSE_INPUTSTREAM};
	//# final static int     fileReadBlockSize = ${BOXIMAGE_FILE_READ_BLOCK_SIZE};
	//#ifndef INSIDE_BOXIMAGE
	//# final static boolean USE_ARRAYCOPY = ${BOXIMAGE_USE_ARRAYCOPY};
	//#endif
	// imagelabels.SEGMENT_SIZE = # and imagelabels.SEGMENTEDIFILE = true/false are being passed in from imagelabels interface
	//#else
	final static boolean FILE_CACHE_ALWAYS_OFF = false;
	final static boolean FILE_CACHE_ALWAYS_ON = false;
	final static boolean USE_DATAINPUTSTREAM = false;
	final static boolean DONT_CLOSE_INPUTSTREAM = false;
	final static int fileReadBlockSize = 256;	// must be an integer divisor of imagelabels.SEGMENT_SIZE
	final static boolean USE_ARRAYCOPY = false;
	//#endif

	private static String images_fname = null;
	private static int segmentNumberBeingRead = 0;
	private static int segmentReadPointer = 0;
	private static char segmentNameBeingRead = 'A';
	private static InputStream fileInputStream;
	private static byte[] fileReadBlock = null;
	private static int fileReadBlockContains = -1;
	private static boolean fileIsOpen = false;

	public static byte[] fileBuffer = null;
	public static int fileInputPointer = 0; // file read counter
	public static boolean fileCacheOn = FILE_CACHE_ALWAYS_ON;



	public static void disopen(int posn)
	{
		disopen();
		disskip(posn);
	}

	//#ifdef ALLOW_EXTERNAL_RESOURCES	
	static byte[] disExternalRes = null;
	public static void disopen(byte[] ext_res)
	{
		disExternalRes = ext_res;
		fileInputPointer = 0;
	}
	//#endif

	// a good way to do this on a symbian device would be to call this without fileCacheOn to load the HandsOn screen
	// then call it again WITH fileCacheOn when the HandsOn logo is displayed.		
	public static void disopen()
	{
		// This is just used to set values when using imagelabels.SEGMENTEDIFILE and no file cache
		// normal for the try,catch on fileInputStream.read to throw nullpointer. . . .
		if (FILE_CACHE_ALWAYS_OFF || !fileCacheOn)
		{
			if (fileIsOpen) { fileInputPointer = 0; return; }
		}

		//#if USE_BOXALINF
		if (!BoxALMidlet.bInfFileCacheAlwaysOn)
		//#else
		if (!FILE_CACHE_ALWAYS_ON)
		//#endif
		{
			if ((!fileCacheOn) && (fileIsOpen)) { fileInputPointer = 0; return; }
		}
		//#if USE_BOXALINF
		if (BoxALMidlet.bInfFileCacheAlwaysOn || fileCacheOn)
		//#else
		if (FILE_CACHE_ALWAYS_ON || fileCacheOn)
		//#endif
		{
			if (!FILE_CACHE_ALWAYS_OFF)
			{
				if (fileBuffer == null)
				{
					// ----------------------------------------------------------------------
					//  Read entire file/allsegments into fileBuffer cache via fileReadBlock 
					// ----------------------------------------------------------------------

					InputStream dis;
					if (fileReadBlock == null) fileReadBlock = new byte[fileReadBlockSize];

					if (imagelabels.SEGMENTEDIFILE)
					{
						segmentNumberBeingRead = 0;
						segmentReadPointer = 0;
						segmentNameBeingRead = 'A';
						// this is uncached version
						dis = getResourceAsStream(images_fname + segmentNameBeingRead);
					}
					else
					{
						dis = getResourceAsStream(images_fname);
					}

					boolean readSizeOfFile = false; sizeOfAssetFile = 6; // set to header size until read correctly

					if (USE_DATAINPUTSTREAM)
					{
						//#ifndef JSHARP
						//# dis = new DataInputStream(dis);
						//#endif
					}
					try
					{
						for (fileInputPointer = 0; fileInputPointer < sizeOfAssetFile; fileInputPointer += fileReadBlockSize)
						{
							if (imagelabels.SEGMENTEDIFILE)
							{
								if (segmentReadPointer == imagelabels.SEGMENT_SIZE)
								{
									// imagelabels.SEGMENT_SIZE MUST be a multiple of fileReadBlockSize!!!
									segmentNumberBeingRead++;
									segmentReadPointer = 0;
									segmentNameBeingRead++;
									if (!DONT_CLOSE_INPUTSTREAM)
									{
										dis.close();	//bug fix
									}
									dis = getResourceAsStream(images_fname + segmentNameBeingRead);
								}
							}
							if(dis == null) { break; }
							dis.read(fileReadBlock);
							if (!readSizeOfFile)
							{
								// get size of file from header
								sizeOfAssetFile = makeUnsignedByte(fileReadBlock[0]);
								sizeOfAssetFile += (makeUnsignedByte(fileReadBlock[1]) << 8);
								sizeOfAssetFile += (makeUnsignedByte(fileReadBlock[2]) << 16);
								readSizeOfFile = true;
								fileBuffer = new byte[sizeOfAssetFile];
							}

							//--------------------------------------
							// copy fileReadBlock's contents (may be partially filled) into fileBuffer

							int copyLen = Math.min(fileReadBlockSize, sizeOfAssetFile - fileInputPointer);
							if (USE_ARRAYCOPY)
								System.arraycopy(fileReadBlock, 0, fileBuffer, fileInputPointer, copyLen);
							else
								for (int fileInputPointer_in_block = 0; fileInputPointer_in_block < copyLen; fileInputPointer_in_block++)
									fileBuffer[fileInputPointer + fileInputPointer_in_block] = fileReadBlock[fileInputPointer_in_block];

							//---------------------------------------

							if (imagelabels.SEGMENTEDIFILE)
							{
								segmentReadPointer += fileReadBlockSize;
							}
						}
						if (!DONT_CLOSE_INPUTSTREAM)
						{
							dis.close();
						}
						dis = null;
					}
					catch (Exception e)
					{
						String t = e.getMessage();
					}

				}
			}
		}
		else
		{
			// ----------------------------------------------------------------------
			//  File not cached in memory
			// ----------------------------------------------------------------------

			if (imagelabels.SEGMENTEDIFILE)
			{
				fileReadBlockContains = 0 - fileReadBlockSize;
				segmentNumberBeingRead = -1;
				segmentReadPointer = imagelabels.SEGMENT_SIZE;
				segmentNameBeingRead = 'A' - 1;
				//dis =  getResourceAsStream(images_fname+segmentNameBeingRead);        	
			}
			else
			{
				fileReadBlockContains = 0;
				fileInputStream = getResourceAsStream(images_fname);
			}
			if (USE_DATAINPUTSTREAM)
			{
				//#ifndef JSHARP
				//#	fileInputStream = new DataInputStream(fileInputStream);
				//#endif
			}

			fileIsOpen = true;
			if (fileReadBlock == null) fileReadBlock = new byte[fileReadBlockSize];
			try
			{
				//#if BREW_ONLY
				//  The AlcheMo j2me-to-brew tool complains about dereferencing null,
				//  even though it's contained in a try-catch block.
				//#endif
				
				//ES: that may be the case, but we are getting an exception almost every time we read this
				if (fileInputStream != null && fileReadBlock != null) {
					fileInputStream.read(fileReadBlock);
				}
			}
			catch (Exception e) { }

		}

		fileInputPointer = 0;
	}

	private static byte[] disread_buff2 = new byte[2];
	public static int disread_ushort()
	{
		// read next 2 bytes as a short
		disread_new(disread_buff2);
		// transfer unsigned to int
		return (disread_buff2[0] & 0xff) | (disread_buff2[1] & 0xff) << 8;
	}


	public static short[] disread_unsigned_bytes(short[] the_array)
	{
		if (the_array != null)
		{
			// read the bytes
			byte[] bytes = new byte[the_array.length];
			disread_new(bytes);
			// transfer unsigned to short array
			for (int co = 0; co < the_array.length; co++)
			{
				the_array[co] = (short)(bytes[co] & 0xff);
			}
		}
		return the_array;
	}


	public static byte[] disread(byte[] the_array)
	{
		if (the_array != null)
		{
			disread_new(the_array);
		}
		return the_array;
	}


	public static short[] disread_unsigned_bytes(int the_array_size)
	{
		short[] the_array = new short[the_array_size];
		return disread_unsigned_bytes(the_array);
	}

	private static byte[] disread_buff1 = new byte[1];
	public static int disread()
	{
		// read next byte
		disread_new(disread_buff1);
		// transfer unsigned to int
		return disread_buff1[0] & 0xff;  // returns ubyte
	}

	public static void disread_new(byte[] dest)
	{
		int dest_toread = dest.length;
		int dest_pos = 0;

		//#ifdef ALLOW_EXTERNAL_RESOURCES
		if (disExternalRes != null)
		{
			if (fileInputPointer >= disExternalRes.length) return;
			if (USE_ARRAYCOPY)
			{
				System.arraycopy(disExternalRes, fileInputPointer, dest, 0, dest_toread);
				fileInputPointer += dest_toread;
			}
			else
			{
				for (int b = 0; b < dest_toread; b++)
					dest[b] = disExternalRes[fileInputPointer++];
			}
		}
		else
		//#endif
		{
			//#if USE_BOXALINF
			if (fileCacheOn || BoxALMidlet.bInfFileCacheAlwaysOn)
			//#else
			if (fileCacheOn || FILE_CACHE_ALWAYS_ON)
			//#endif
			{
				if (!FILE_CACHE_ALWAYS_OFF)
				{
					// ----------------------------------------------------------------------
					//  entire file has been cached - simple copy
					// ----------------------------------------------------------------------

					if (fileInputPointer >= sizeOfAssetFile) return;
					if (USE_ARRAYCOPY)
					{
						System.arraycopy(fileBuffer, fileInputPointer, dest, 0, dest_toread);
						fileInputPointer += dest_toread;
					}
					else
					{
						for (int b = 0; b < dest_toread; b++)
							dest[b] = fileBuffer[fileInputPointer++];
					}
				}
			}
			else
			{
				// ----------------------------------------------------------------------
				//  not cached - repeat read into fileReadBlock and copy
				// ----------------------------------------------------------------------

				int fb_rel = (fileInputPointer - fileReadBlockContains);
				if (fb_rel < 0)
				{
					int ofileInputPointer = fileInputPointer;
					// this will only happen after a -ve skip, it will be slow but there will be times when it's usefull
					diskill();
					disopen(); // if the skip goes outside the current segment this WONT ACTUALLY RE-OPEN the current segment
					fileInputPointer = ofileInputPointer;
					fb_rel = (fileInputPointer - fileReadBlockContains);
				}
				do
				{
					// is data contained in fileReadBlock?
					if (fb_rel >= fileReadBlockSize)
					{
						// no - 'skip' forward by reading

						// optimisation for segmented file is to skip intermediate segments
						if (imagelabels.SEGMENTEDIFILE)
						{
							// offset of desired data relative to start of current segment
							int seg_rel = segmentReadPointer + fb_rel - fileReadBlockSize;
							if (seg_rel >= imagelabels.SEGMENT_SIZE)
							{
								// desired data is not in the current segment, so skip segment(s)
								int seg_fp = fileReadBlockContains - segmentReadPointer + fileReadBlockSize;
								do
								{
									seg_rel -= imagelabels.SEGMENT_SIZE;
									seg_fp += imagelabels.SEGMENT_SIZE;
									segmentNumberBeingRead++;
									segmentNameBeingRead++;
								}
								while (seg_rel >= imagelabels.SEGMENT_SIZE);

								// reposition pointers so 'last' read block is just before this segment
								fileReadBlockContains = seg_fp - fileReadBlockSize;
								fb_rel = fileInputPointer - fileReadBlockContains;
								segmentReadPointer = 0;

								// close current segment ...
								if (!DONT_CLOSE_INPUTSTREAM)
								{
									try { if (fileInputStream != null) fileInputStream.close(); }
									catch (Exception e) { }
								}
								// open desired segment ...
								fileInputStream = getResourceAsStream(images_fname + segmentNameBeingRead);
								if (USE_DATAINPUTSTREAM)
								{
									//#ifndef JSHARP
									//# fileInputStream = new DataInputStream(fileInputStream);
									//#endif
								}
							}
						}
						// keep forward reading into fileReadBlock until it contains the data
						do
						{
							try
							{
								fileInputStream.read(fileReadBlock);
								fileReadBlockContains += fileReadBlockSize;
								if (imagelabels.SEGMENTEDIFILE)
								{
									segmentReadPointer += fileReadBlockSize;
								}
								fb_rel -= fileReadBlockSize;
							}
							catch (Exception e) { }
						}
						while (fb_rel >= fileReadBlockSize);
					}

					// transfer largest read possible
					int n = Math.min(dest_toread, fileReadBlockSize - fb_rel);
					if (USE_ARRAYCOPY)
					{
						System.arraycopy(fileReadBlock, fb_rel, dest, dest_pos, n);
						// advance the file pointers
						fb_rel += n;
						dest_pos += n;
					}
					else
					{
						// CAN OPTIMISE
						for (int b = 0; b < n; b++)
							dest[dest_pos++] = fileReadBlock[fb_rel++];
					}
					// advance the file pointers
					fileInputPointer += n;
					// amount left to read
					dest_toread -= n;
				}
				while (dest_toread > 0);
			}
		}
	}


	//only called when we open a file.
	public static void disskip(int bytes2skip)
	{
		fileInputPointer += bytes2skip;
	}

	static boolean keep_file_open = false;

	public static void disclose()
	{
		//#ifdef ALLOW_EXTERNAL_RESOURCES		
		disExternalRes = null;
		//#endif		
		if (!keep_file_open) diskill();
	}


	public static void diskill()
	{
		if (fileInputStream != null)
		{
			if (!DONT_CLOSE_INPUTSTREAM)
			{
				try
				{
					fileInputStream.close();
				}
				catch (Exception e) { }
			}
		}
		fileInputStream = null;
		fileReadBlock = null;
		fileIsOpen = false;
		gc();
	}

	static int makeUnsignedShort(short signed_in)
	{
		//		int t = signed_in;
		//		if (t < 0) t += 65536;
		//		return t;
		return (signed_in & 0xffff);
	}

	static short makeSignedShort(int unsigned_in)
	{
		//		int t = unsigned_in;
		//		if (t > 32767) t -= 65536;
		//		return (short)t;
		return (short)unsigned_in;
	}

	static short makeUnsignedByte(byte signedbyte)
	{
		//		short t = signedbyte;
		//		if (t < 0) t += 256;
		//		return t;
		return (short)(signedbyte & 0xff);
	}

	static byte makeSignedByte(int unsignedbyte)
	{
		//		int tbyt = unsignedbyte;
		//		if (tbyt > 127) tbyt -= 256;
		//		return (byte)tbyt;
		return (byte)unsignedbyte;
	}

	
	
	static 
//#if APPLET
	java.io.BufferedInputStream
//#else
	InputStream 
//#endif	
	getResourceAsStream(String res_name)
	{
		//#if JSHARP
		return InputStream.getResourceAsStream(res_name);
		//#elif APPLET
		try {		
		String filename =BoxALCanvas.iBoxALCanvas.getCodeBase().toString()+res_name;
		java.net.URL url = new java.net.URL(filename);
		return new java.io.BufferedInputStream(url.openStream());	
		} catch (Exception e) {return null;}
		//#else
		//# return res_name.getClass().getResourceAsStream(res_name);
		//#endif
	}

	// ==================================================================================
	//
	//                              ASSET MANAGEMENT
	//
	// ==================================================================================

	private static boolean header_been_read = false;
	public static int sizeOfAssetFile = -1;
	public static int numberOfAssets = -1;
	public static int numberOfPalettes = -1;
	public static int[] pointerToAssetInFile = null;
	public static byte[] paletteOrTypeForThisAsset = null; // palette number per image asset

	static void initialiseAssetManager(String fileName)
	{
		// only read the header once
		if (header_been_read) return;
		header_been_read = true;

		// set asset file name (stub)
		images_fname = fileName;

		// open it for the first time - will cache it if fileCacheOn
		disopen();

		short[] headerData = disread_unsigned_bytes(6);
		sizeOfAssetFile = headerData[0] + (headerData[1] << 8) + (headerData[2] << 16);
		numberOfAssets = headerData[3] + (headerData[4] << 8);
		numberOfPalettes = headerData[5];

		pointerToAssetInFile = new int[numberOfAssets];
		paletteOrTypeForThisAsset = new byte[numberOfAssets];
		for (int assetCo = 0; assetCo < numberOfAssets; assetCo++)
		{
			headerData = new short[4];
			disread_unsigned_bytes(headerData);
			pointerToAssetInFile[assetCo] = headerData[0] + (headerData[1] << 8) + (headerData[2] << 16);
			paletteOrTypeForThisAsset[assetCo] = (byte)headerData[3];
		}

		header_been_read = true;
		disclose();
	}

	static final byte ASSET_TYPE_NOT_INITIALISED = 0;
	static final byte ASSET_TYPE_IMAGE = 1;
	static final byte ASSET_TYPE_IS_POLYGON = -1;
	static final byte ASSET_TYPE_IS_EMPTY = -2;
	static final byte ASSET_TYPE_IS_AUDIO = -3;
	static final byte ASSET_TYPE_IS_BINARY = -4;

	static int getAssetType(int assetnum)
	{
		if (paletteOrTypeForThisAsset == null) return 0;
		if ((paletteOrTypeForThisAsset[assetnum] < 0) && (paletteOrTypeForThisAsset[assetnum]) >= ASSET_TYPE_IS_BINARY) return paletteOrTypeForThisAsset[assetnum];
		return 1;
	}

	static int loadAsset_offset;                    // returns: offset of asset data within returned byte[]
	static int loadAsset_len;                       // returns: length of asset data
	static short loadAsset_info;					// returns: flags/type info of asset data
	static byte[] loadAsset(int assetNumber)        // returns: byte[] containing asset data
	{
		switch (getAssetType(assetNumber))
		{
			case ASSET_TYPE_IS_BINARY:
			case ASSET_TYPE_IS_AUDIO:

				loadAsset_offset = pointerToAssetInFile[assetNumber];
				disopen(loadAsset_offset);
				short[] headerData = disread_unsigned_bytes(4);
				loadAsset_offset += 4;       // offset to data after header
				loadAsset_info = headerData[0];
				loadAsset_len = headerData[1] + (headerData[2] << 8) + (headerData[3] << 16);
				//#if USE_BOXALINF
				if (BoxALMidlet.bInfFileCacheAlwaysOn || fileCacheOn)
				//#else
				if (FILE_CACHE_ALWAYS_ON || fileCacheOn)
				//#endif
				{
					if (!FILE_CACHE_ALWAYS_OFF)
					{
						// file cache is on - return start of file cache
						disclose();
						return fileBuffer;
					}
				}
				// file cache is off - create a dedicated buffer and read asset data into it
				byte[] assetBytes = disread(new byte[loadAsset_len]);
				loadAsset_offset = 0;
				disclose();
				return assetBytes;

			default:
				return null;
		}
	}

 