/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class DashEditBox {
    protected AEERect m_rect;
    protected DashImage m_imgArrows;
    protected DashFont m_pFont;
    protected StringBuffer m_text;
    protected int m_numChars;

    public DashEditBox(AEERect area, int numChars, int fontID, int imgArrowsID) {
        this.m_rect = new AEERect(area);
        this.m_numChars = numChars;
        if (this.m_numChars < 1) {
            this.m_numChars = 1;
        }
        this.m_pFont = DashResourceProvider.getFont(fontID);
        this.m_imgArrows = DashResourceProvider.getImage(imgArrowsID);
        this.m_text = new StringBuffer(numChars);
        this.m_text.append("a");
    }

    public boolean HandleEvent(int wParam) {
        char curChar = this.m_text.charAt(this.m_text.length() - 1);
        if (wParam == 2) {
            if (this.m_text.length() > 1) {
                this.m_text = this.m_text.deleteCharAt(this.m_text.length() - 1);
                return true;
            }
            return false;
        }
        if (wParam == 3) {
            if (this.m_text.length() < this.m_numChars) {
                this.m_text.append("a");
            }
            return true;
        }
        if (wParam == 0) {
            do {
                if ((curChar = (char)(curChar + '\u0001')) == '\u007f') {
                    curChar = ' ';
                }
                if (curChar == 'A') {
                    curChar = '[';
                }
                if (curChar <= 65 || curChar > 90) continue;
                curChar = (char)(curChar + 32);
            } while (!this.m_pFont.isValidChar(curChar));
            this.m_text.setCharAt(this.m_text.length() - 1, curChar);
            return true;
        }
        if (wParam == 1) {
            do {
                if ((curChar = (char)(curChar - '\u0001')) == '\u0000') {
                    curChar = '~';
                }
                if (curChar == 'Z') {
                    curChar = '@';
                }
                if (curChar < 65 || curChar > 90) continue;
                curChar = (char)(curChar + 32);
            } while (!this.m_pFont.isValidChar(curChar));
            this.m_text.setCharAt(this.m_text.length() - 1, curChar);
            return true;
        }
        return false;
    }

    public void draw(Graphics g) {
        int spacer = this.m_pFont.stringWidth("@");
        if (this.m_text.length() > 1) {
            this.m_imgArrows.draw(g, this.m_rect.x - this.m_imgArrows.getWidth() - spacer, this.m_rect.y + this.m_rect.dy / 2, 2, 6);
        }
        if (this.m_text.length() < this.m_numChars) {
            this.m_imgArrows.draw(g, this.m_rect.x + this.m_rect.dx, this.m_rect.y + this.m_rect.dy / 2, 3, 6);
        }
        for (int i = 0; i < this.m_text.length(); ++i) {
            this.m_pFont.drawString(g, "" + this.m_text.charAt(i), this.m_rect.x + spacer * i + spacer / 2, this.m_rect.y + this.m_rect.dy / 2, 3);
        }
        int cursorOffset = (this.m_text.length() - 1) * spacer + spacer / 2;
        this.m_imgArrows.draw(g, this.m_rect.x + cursorOffset, this.m_rect.y, 0, 33);
        this.m_imgArrows.draw(g, this.m_rect.x + cursorOffset, this.m_rect.y + this.m_rect.dy, 1, 17);
    }

    public String getText() {
        return this.m_text.toString();
    }

    public void setText(String txt) {
        this.m_text = new StringBuffer(this.m_numChars);
        this.m_text.append(txt);
    }

    public int getMaxChars() {
        return this.m_numChars;
    }

    public int getNumChars() {
        return this.m_text.length();
    }
}

