/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class Pack {
    public static final byte[] F_PACK_MAGIC = new byte[]{10, 11, 12, 33};
    public static final byte[] F_NOPACK_MAGIC = new byte[]{10, 11, 12, 46};
    private byte[][] fileNameByte;
    private short[] fileSize;
    public int[] offStart;
    public byte[] data;
    private int infoBytes;
    private int fileCount;
    private int size;
    public boolean isHave;
    private static final int HEAD_SIZE = 12;

    public Pack(String PackName) {
        try {
            InputStream packFile = "o".getClass().getResourceAsStream(PackName);
            this.loadPack(packFile);
            packFile.close();
            packFile = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadPack(InputStream packFile) {
        if (packFile != null) {
            try {
                byte[] b = new byte[4];
                packFile.read(b);
                this.size = Game.byteToInt(b);
                packFile.read(b);
                this.infoBytes = Game.byteToInt(b);
                packFile.read(b);
                this.fileCount = Game.byteToInt(b);
                byte[] bi = new byte[this.infoBytes];
                packFile.read(bi);
                this.getPackInfo(bi);
                this.data = new byte[this.size - this.infoBytes - 12];
                packFile.read(this.data);
                this.isHave = true;
            }
            catch (IOException e) {
                this.isHave = false;
            }
        }
    }

    public void free() {
        this.fileNameByte = null;
        this.fileSize = null;
        this.offStart = null;
        this.data = null;
        System.gc();
    }

    public Image loadImage(String ImageName) {
        Image img = null;
        int index = this.getIndex(ImageName);
        if (index == -1) {
            return null;
        }
        try {
            img = Image.createImage((byte[])this.data, (int)this.offStart[index], (int)this.fileSize[index]);
            return img;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String loadString(String FileName) {
        int index = this.getIndex(FileName);
        if (index == -1) {
            return null;
        }
        return Pack.toUTF(this.data, this.offStart[index], this.fileSize[index]);
    }

    public InputStream getInputStream(String FileName) {
        try {
            return new ByteArrayInputStream(this.getBytes(FileName));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] getBytes(String FileName) {
        int index = this.getIndex(FileName);
        byte[] b = new byte[this.fileSize[index]];
        System.arraycopy(this.data, this.offStart[index], b, 0, b.length);
        int bad = 0;
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            byte[] magic = new byte[4];
            in.read(magic);
            int i = 2;
            while (i >= 0) {
                if (magic[i] != F_PACK_MAGIC[i]) {
                    bad = 1;
                }
                --i;
            }
            if (bad == 0 && magic[3] != F_PACK_MAGIC[3]) {
                bad = magic[3] == F_NOPACK_MAGIC[3] ? 2 : 1;
            }
            if (bad == 0) {
                this.undate(in, out, 0, 1);
                b = out.toByteArray();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }

    public final int undate(ByteArrayInputStream in, ByteArrayOutputStream out, int bufi, int s) {
        int N = 4096;
        int F = 18;
        int THRESHOLD = 2;
        int state = 0;
        int flags = 0;
        int c = 0;
        int r = 0;
        int k = 0;
        int j = 0;
        int i = 0;
        byte[] text_buf = new byte[N + F - 1];
        int size = 0;
        if (state == 0) {
            r = N - F;
            flags = 0;
        }
        while (true) {
            if (state == 2 && k <= j) {
                c = text_buf[i + k & N - 1];
                text_buf[r++] = (byte)c;
                out.write((byte)c);
                ++bufi;
                r &= N - 1;
                ++k;
                ++size;
                continue;
            }
            if (((flags >>>= 1) & 0x100) == 0) {
                c = in.read();
                if (c == -1) break;
                flags = c | 0xFF00;
            }
            if ((flags & 1) == 1) {
                c = in.read();
                if (c == -1) break;
                text_buf[r++] = (byte)c;
                r &= N - 1;
                out.write((byte)c);
                ++bufi;
                ++size;
                state = 1;
                continue;
            }
            i = in.read();
            if (i == -1 || (j = in.read()) == -1) break;
            i |= (j & 0xF0) << 4;
            j = (j & 0xF) + THRESHOLD;
            k = 0;
            state = 2;
        }
        if (size == 0) {
            return -1;
        }
        return size;
    }

    public int getIndex(String FileName) {
        byte[] b = FileName.trim().getBytes();
        int i = 0;
        while (i < this.offStart.length) {
            if (this.compareFileName(i, b)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean compareFileName(int index, byte[] b) {
        if (b.length - 1 != this.fileNameByte[index].length) {
            return false;
        }
        int i = 1;
        while (i < b.length) {
            if (b[i] != this.fileNameByte[index][i - 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void getPackInfo(byte[] b) {
        this.fileNameByte = new byte[this.fileCount][];
        this.offStart = new int[this.fileCount];
        this.fileSize = new short[this.fileCount];
        int begin = 0;
        int n = 0;
        int f_offstart = 0;
        int fl = 0;
        int i = 0;
        while (i < b.length) {
            if ((b[i] == 13 || i == b.length - 1) && i - begin - 4 > 0) {
                this.fileSize[n] = (short)(b[begin] << 24 | b[begin + 1] << 16 | b[begin + 2] << 8 | b[begin + 3] & 0xFF);
                this.offStart[n] = f_offstart;
                f_offstart += this.fileSize[n];
                fl = i - begin - 4;
                this.fileNameByte[n] = new byte[fl];
                int j = 0;
                while (j < fl) {
                    this.fileNameByte[n][j] = b[begin + 4 + j];
                    ++j;
                }
                begin = i + 1;
                ++n;
            }
            ++i;
        }
    }

    public static String toUTF(byte[] serverData, int off, int len) {
        char[] infoStr = new char[len * 2];
        int i = 0;
        int charCount = 0;
        while (i < len) {
            try {
                char ch;
                if ((serverData[i + off] & 0x80) != 0) {
                    if ((serverData[i + off] & 0x20) != 0) {
                        ch = (char)((serverData[i + off] & 0xF) << 12);
                        ch = (char)(ch + ((char)(serverData[i + 1 + off] & 0x3F) << 6));
                        ch = (char)(ch + (serverData[i + 2 + off] & 0x3F));
                        i += 3;
                    } else {
                        ch = (char)((serverData[i + off] & 0x1F) << 6);
                        ch = (char)(ch + (serverData[i + 1 + off] & 0x3F));
                        i += 2;
                    }
                } else {
                    ch = (char)serverData[i + off];
                    ++i;
                }
                infoStr[charCount++] = ch;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new String(infoStr, 1, charCount);
    }
}

