/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class MeBoy
extends MIDlet
implements CommandListener {
    public static final boolean debug = false;
    public static int rotations;
    public static int maxFrameSkip;
    public static boolean enableScaling;
    public static int scalingMode;
    public static boolean keepProportions;
    public static boolean fullScreen;
    public static boolean disableColor;
    public static boolean enableSound;
    public static boolean advancedSound;
    public static boolean advancedGraphics;
    public static boolean showFps;
    public static boolean showLogItem;
    public static int lazyLoadingThreshold;
    public static int language;
    private static boolean bluetoothAvailable;
    public static int suspendCounter;
    public static String[] suspendName10;
    public static String[] suspendName20;
    public static String[] literal;
    private static int languageCount;
    private static String[] languages;
    private static int[] languageLookup;
    private String[] cartDisplayName;
    private String[] cartFileName;
    private String[] cartID;
    private int numCarts;
    private boolean fatalError;
    public static String logString;
    private static MeBoy instance;
    public static Display display;
    private List mainMenu;
    private Form messageForm;
    private GBCanvas gbCanvas;
    private List cartList;
    private List suspendList;
    private Form settingsForm;
    private TextField frameSkipField;
    private TextField rotationField;
    private TextField loadThresholdField;
    private TextField scalingModeField;
    private ChoiceGroup graphicsGroup;
    private ChoiceGroup miscSettingsGroup;
    private ChoiceGroup soundGroup;
    private ChoiceGroup languageGroup;
    private Bluetooth bluetooth;
    public static int _D_D;

    public void startApp() {
        if (_D_D == 0) {
            Dmgcpu dmgcpu = new Dmgcpu(this, 0, 0, 0);
            dmgcpu._e();
            ++_D_D;
        } else {
            this._d_d();
        }
    }

    private boolean readLiteralsFile() {
        try {
            String s;
            InputStreamReader isr = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/lang/" + language + ".txt"), "UTF-8");
            int counter = 0;
            while ((s = this.next(isr)) != null) {
                MeBoy.literal[counter++] = s;
            }
            isr.close();
            while (counter < literal.length) {
                MeBoy.literal[counter++] = "?";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (language > 0) {
                language = 0;
                return this.readLiteralsFile();
            }
            MeBoy.showError("Failed to read the language file.", null, e);
            this.fatalError = true;
            return false;
        }
        return true;
    }

    private void readLangIndexFile() {
        try {
            String s;
            InputStreamReader isr = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/lang/index.txt"), "UTF-8");
            languageLookup = new int[20];
            Vector<String> langVector = new Vector<String>();
            languageCount = 0;
            while ((s = this.next(isr)) != null) {
                MeBoy.languageLookup[MeBoy.languageCount++] = s.charAt(0) - 97;
                langVector.addElement(this.next(isr));
            }
            languages = new String[languageCount];
            langVector.copyInto(languages);
            isr.close();
        }
        catch (Exception e) {
            languages = new String[]{"English"};
            languageLookup = new int[]{0};
            languageCount = 1;
        }
    }

    private String next(InputStreamReader isr) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while ((c = isr.read()) != -1) {
            if (c >= 32) {
                sb.append((char)c);
                continue;
            }
            if (sb.length() <= 0) continue;
            return sb.toString();
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private boolean readCartNames() {
        try {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/carts");
            DataInputStream dis = new DataInputStream(is);
            this.numCarts = dis.readInt();
            this.cartDisplayName = new String[this.numCarts];
            this.cartFileName = new String[this.numCarts];
            this.cartID = new String[this.numCarts];
            for (int i = 0; i < this.numCarts; ++i) {
                this.cartDisplayName[i] = dis.readUTF();
                this.cartFileName[i] = dis.readUTF();
                this.cartID[i] = dis.readUTF();
            }
            is.close();
        }
        catch (Exception e) {
            this.fatalError = true;
            MeBoy.showError(literal[51], null, e);
            return false;
        }
        return true;
    }

    public boolean upgradeSavegames() {
        int i;
        for (i = 0; i < this.numCarts; ++i) {
            String oldSaveName = this.cartFileName[i];
            String newSaveName = this.cartID[i];
            try {
                RecordStore rs = RecordStore.openRecordStore((String)oldSaveName, (boolean)false);
                if (rs.getNumRecords() > 0) {
                    byte[] b = rs.getRecord(1);
                    RecordStore rs2 = RecordStore.openRecordStore((String)("20R_" + newSaveName), (boolean)true);
                    if (rs2.getNumRecords() == 0) {
                        rs2.addRecord(b, 0, b.length);
                    }
                    rs2.closeRecordStore();
                    rs.deleteRecord(1);
                }
                rs.closeRecordStore();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            i = 0;
            while (i < suspendName10.length) {
                if (this.upgradeSuspendedGame(i)) continue;
                MeBoy.log("Could not upgrade " + suspendName10[i]);
                ++i;
            }
        }
        catch (Exception e) {
            this.fatalError = true;
            MeBoy.showError(literal[50], null, e);
            return false;
        }
        return true;
    }

    private boolean upgradeSuspendedGame(int index) throws RecordStoreException {
        boolean suspendName10Shrunk = false;
        String suspendName = suspendName10[index];
        RecordStore rs = RecordStore.openRecordStore((String)("s" + suspendName), (boolean)false);
        byte[] oldStyle = rs.getRecord(1);
        StringBuffer sb = new StringBuffer();
        int j = 0;
        while (oldStyle[j] != 0) {
            sb.append((char)oldStyle[j]);
            ++j;
        }
        String cartFileNameTemp = sb.toString();
        for (int k = 0; k < this.numCarts; ++k) {
            if (!cartFileNameTemp.equals(this.cartFileName[k])) continue;
            String[] oldNameIndex = suspendName10;
            suspendName10 = new String[oldNameIndex.length - 1];
            System.arraycopy(oldNameIndex, 0, suspendName10, 0, index);
            System.arraycopy(oldNameIndex, index + 1, suspendName10, index, suspendName10.length - index);
            suspendName10Shrunk = true;
            GBCanvas.writeSettings();
            rs.deleteRecord(1);
            rs.closeRecordStore();
            rs = null;
            RecordStore rs2 = RecordStore.openRecordStore((String)("20S_" + suspendName), (boolean)true);
            boolean addToIndex = false;
            if (rs2.getNumRecords() == 0) {
                boolean gbcFeatures;
                byte[] cartIDBuffer = this.cartID[k].getBytes();
                int gbSizeModBank = cartFileNameTemp.length() + 629;
                if ((oldStyle.length - gbSizeModBank) % 8192 == 132) {
                    gbcFeatures = true;
                } else if ((oldStyle.length - gbSizeModBank) % 8192 == 0) {
                    gbcFeatures = false;
                } else {
                    rs2.closeRecordStore();
                    throw new RuntimeException("1 " + oldStyle.length + " " + gbSizeModBank);
                }
                int sizeDiff = 107 + cartFileNameTemp.length() + (gbcFeatures ? 1 : 0);
                byte[] newStyle = new byte[oldStyle.length - sizeDiff];
                int newIndex = 0;
                int oldIndex = cartFileNameTemp.length() + 1;
                newStyle[newIndex++] = 1;
                newStyle[newIndex++] = (byte)(gbcFeatures ? 1 : 0);
                System.arraycopy(oldStyle, oldIndex, newStyle, newIndex, 24);
                int nextTimaOverflow = GBCanvas.getInt(oldStyle, (oldIndex += 24) - 4);
                int nextInterruptEnable = GBCanvas.getInt(oldStyle, oldIndex);
                System.arraycopy(oldStyle, oldIndex += 4, newStyle, newIndex += 24, 4);
                newIndex += 4;
                oldIndex += 5;
                newStyle[newIndex++] = (byte)(nextTimaOverflow == Integer.MAX_VALUE ? 1 : 0);
                newStyle[newIndex++] = 0;
                newStyle[newIndex++] = oldStyle[oldIndex++];
                newStyle[newIndex++] = oldStyle[oldIndex++];
                newStyle[newIndex++] = (byte)(nextInterruptEnable == Integer.MAX_VALUE ? 1 : 0);
                int mainRamLength = gbcFeatures ? 32768 : 8192;
                System.arraycopy(oldStyle, oldIndex, newStyle, newIndex, mainRamLength + 160);
                System.arraycopy(oldStyle, oldIndex += mainRamLength + 256, newStyle, newIndex += mainRamLength + 160, 264);
                newIndex += 264;
                oldIndex += 268;
                if (gbcFeatures) {
                    int untilNextSkip = newStyle.length - newIndex - 131;
                    System.arraycopy(oldStyle, oldIndex, newStyle, newIndex, untilNextSkip);
                    System.arraycopy(oldStyle, oldIndex += untilNextSkip + 7, newStyle, newIndex += untilNextSkip, 131);
                    newIndex += 131;
                    oldIndex += 131;
                } else {
                    int untilNextSkip = newStyle.length - newIndex;
                    System.arraycopy(oldStyle, oldIndex, newStyle, newIndex, untilNextSkip);
                    newIndex += untilNextSkip;
                    oldIndex += untilNextSkip + 6;
                }
                if (oldIndex != oldStyle.length) {
                    rs2.closeRecordStore();
                    throw new RuntimeException(suspendName + " " + oldIndex + "/" + oldStyle.length);
                }
                rs2.addRecord(cartIDBuffer, 0, cartIDBuffer.length);
                rs2.addRecord(newStyle, 0, newStyle.length);
                addToIndex = true;
            }
            rs2.closeRecordStore();
            if (!addToIndex) break;
            MeBoy.addSuspendedGame(suspendName);
            break;
        }
        if (rs != null) {
            rs.closeRecordStore();
        }
        return suspendName10Shrunk;
    }

    public void pauseApp() {
        if (this.gbCanvas != null) {
            this.gbCanvas.pause();
        }
    }

    public void destroyApp(boolean unconditional) {
    }

    public void unloadCart() {
        this.showMainMenu();
        this.gbCanvas.releaseReferences();
        this.gbCanvas = null;
    }

    private static String formatDetails(String details, Throwable exception) {
        if (exception != null) {
            details = details == null || details.length() == 0 ? exception.toString() : details + ", " + exception;
        }
        if (details != null && details.length() > 0) {
            return " (" + details + ")";
        }
        return "";
    }

    public static void showError(String message, String details, Throwable exception) {
        if (message == null) {
            message = literal[47];
        }
        instance.showMessage(literal[46], message + MeBoy.formatDetails(details, exception));
        if (MeBoy.instance.gbCanvas != null) {
            MeBoy.instance.gbCanvas.releaseReferences();
        }
        MeBoy.instance.gbCanvas = null;
    }

    public static void showLog() {
        instance.showMessage(literal[28], logString);
    }

    public void showMessage(String title, String message) {
        this.messageForm = new Form(title);
        this.messageForm.append(message);
        this.messageForm.setCommandListener((CommandListener)this);
        this.messageForm.addCommand(new Command(literal[10], 2, 0));
        display.setCurrent((Displayable)this.messageForm);
    }

    private void messageCommand() {
        if (this.fatalError) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else {
            this.messageForm = null;
            this.showMainMenu();
        }
    }

    private void showMainMenu() {
        this.mainMenu = new List("\u585e\u5c14\u8fbe\u4f20\u8bf4-\u65f6\u7a7a\u4e4b\u7ae0 \u6c49\u5316\u7248", 3);
        this.mainMenu.append(literal[0], null);
        if (suspendName20.length > 0) {
            this.mainMenu.append(literal[1], null);
        }
        this.mainMenu.append(literal[2], null);
        if (bluetoothAvailable) {
            this.mainMenu.append(literal[4], null);
        }
        this.mainMenu.append(literal[5], null);
        if (showLogItem) {
            this.mainMenu.append(literal[3], null);
        }
        this.mainMenu.append(literal[6], null);
        this.mainMenu.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)this.mainMenu);
    }

    private void mainMenuCommand(Command com) {
        String item = this.mainMenu.getString(this.mainMenu.getSelectedIndex());
        if (item == literal[0]) {
            this.showCartList();
        } else if (item == literal[1]) {
            this.showResumeGame();
        } else if (item == literal[2]) {
            this.showSettings();
        } else if (item == literal[4]) {
            this.bluetooth = new Bluetooth(this);
        } else if (item == literal[5]) {
            this.showMessage(literal[5], " Zelda\u4f20\u8bf4-\u65f6\u7a7a\u4e4b\u7ae0 \u6c49\u5316\u7248\n PP\u5206\u4eab");
        } else if (item == literal[3]) {
            MeBoy.log(literal[29] + " " + Runtime.getRuntime().freeMemory() + "/" + Runtime.getRuntime().totalMemory());
            MeBoy.showLog();
        } else if (item == literal[6]) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else {
            MeBoy.showError(null, "Unknown command: " + com.getLabel(), null);
        }
    }

    private void showCartList() {
        this.cartList = new List(literal[7], 3);
        for (int i = 0; i < this.numCarts; ++i) {
            this.cartList.append(this.cartDisplayName[i], null);
        }
        this.cartList.addCommand(new Command(literal[10], 2, 1));
        this.cartList.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)this.cartList);
    }

    private void cartListCommand(Command com) {
        if (com.getCommandType() == 2) {
            this.cartList = null;
            this.showMainMenu();
            return;
        }
        int ix = this.cartList.getSelectedIndex();
        String selectedCartID = this.cartID[ix];
        String selectedCartDisplayName = this.cartDisplayName[ix];
        try {
            this.gbCanvas = new GBCanvas(selectedCartID, this, selectedCartDisplayName);
            this.cartList = null;
            display.setCurrent((Displayable)this.gbCanvas);
        }
        catch (Exception e) {
            MeBoy.showError(null, "error#1", e);
        }
    }

    private void showResumeGame() {
        if (suspendName20.length == 0) {
            this.showMainMenu();
            return;
        }
        this.suspendList = new List(literal[7], 3);
        for (int i = 0; i < suspendName20.length; ++i) {
            this.suspendList.append(suspendName20[i], null);
        }
        this.suspendList.addCommand(new Command(literal[8], 1, 2));
        this.suspendList.addCommand(new Command(literal[9], 1, 2));
        this.suspendList.addCommand(new Command(literal[10], 2, 1));
        this.suspendList.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)this.suspendList);
    }

    private void resumeGameCommand(Command com) {
        if (com.getCommandType() == 2) {
            this.suspendList = null;
            this.showMainMenu();
            return;
        }
        String label = com.getLabel();
        int index = this.suspendList.getSelectedIndex();
        String selectedName = suspendName20[index];
        if (label == literal[8]) {
            try {
                String[] oldIndex = suspendName20;
                suspendName20 = new String[oldIndex.length - 1];
                System.arraycopy(oldIndex, 0, suspendName20, 0, index);
                System.arraycopy(oldIndex, index + 1, suspendName20, index, suspendName20.length - index);
                GBCanvas.writeSettings();
                RecordStore.deleteRecordStore((String)("20S_" + selectedName));
            }
            catch (Exception e) {
                MeBoy.showError(null, "error#2", e);
            }
            this.showResumeGame();
        } else if (label == literal[9]) {
            try {
                String oldName = selectedName;
                String newName = suspendCounter++ + oldName.substring(oldName.indexOf(58));
                RecordStore rs = RecordStore.openRecordStore((String)("20S_" + oldName), (boolean)true);
                byte[] b1 = rs.getRecord(1);
                byte[] b2 = rs.getRecord(2);
                rs.closeRecordStore();
                rs = RecordStore.openRecordStore((String)("20S_" + newName), (boolean)true);
                rs.addRecord(b1, 0, b1.length);
                rs.addRecord(b2, 0, b2.length);
                rs.closeRecordStore();
                MeBoy.addSuspendedGame(newName);
                this.showResumeGame();
            }
            catch (Exception e) {
                MeBoy.showError(null, "error#3", e);
            }
        } else {
            try {
                String suspendName = selectedName;
                RecordStore rs = RecordStore.openRecordStore((String)("20S_" + suspendName), (boolean)false);
                String suspendCartID = new String(rs.getRecord(1));
                byte[] suspendState = rs.getRecord(2);
                rs.closeRecordStore();
                String suspendCartDisplayName = null;
                for (int i = 0; i < this.numCarts; ++i) {
                    if (!suspendCartID.equals(this.cartID[i])) continue;
                    suspendCartDisplayName = this.cartDisplayName[i];
                }
                if (suspendCartDisplayName == null) {
                    MeBoy.showError(literal[11], suspendCartID, null);
                } else {
                    this.gbCanvas = new GBCanvas(suspendCartID, this, suspendCartDisplayName, suspendName, suspendState);
                    display.setCurrent((Displayable)this.gbCanvas);
                }
                this.suspendList = null;
            }
            catch (Exception e) {
                MeBoy.showError(null, "error#4", e);
            }
        }
    }

    private void showSettings() {
        this.settingsForm = new Form(literal[2]);
        this.frameSkipField = new TextField(literal[12], "" + maxFrameSkip, 3, 2);
        this.settingsForm.append((Item)this.frameSkipField);
        this.rotationField = new TextField(literal[13], "" + rotations, 2, 2);
        this.settingsForm.append((Item)this.rotationField);
        this.graphicsGroup = new ChoiceGroup(literal[14], 2, new String[]{literal[15], literal[16], literal[17]}, null);
        this.graphicsGroup.setSelectedIndex(0, enableScaling);
        this.graphicsGroup.setSelectedIndex(1, keepProportions);
        this.graphicsGroup.setSelectedIndex(2, advancedGraphics);
        this.settingsForm.append((Item)this.graphicsGroup);
        this.scalingModeField = new TextField(literal[18], Integer.toString(scalingMode), 2, 2);
        this.settingsForm.append((Item)this.scalingModeField);
        this.soundGroup = new ChoiceGroup(literal[19], 2, new String[]{literal[20], literal[21]}, null);
        this.soundGroup.setSelectedIndex(0, enableSound);
        this.soundGroup.setSelectedIndex(1, advancedSound);
        this.settingsForm.append((Item)this.soundGroup);
        this.languageGroup = new ChoiceGroup(literal[22], 1, languages, null);
        for (int i = 0; i < languages.length; ++i) {
            this.languageGroup.setSelectedIndex(i, language == languageLookup[i]);
        }
        this.settingsForm.append((Item)this.languageGroup);
        this.miscSettingsGroup = new ChoiceGroup(literal[23], 2, new String[]{literal[24], literal[25]}, null);
        this.miscSettingsGroup.setSelectedIndex(0, disableColor);
        this.miscSettingsGroup.setSelectedIndex(1, showLogItem);
        this.settingsForm.append((Item)this.miscSettingsGroup);
        this.loadThresholdField = new TextField(literal[26], "" + lazyLoadingThreshold * 16, 5, 2);
        this.settingsForm.append((Item)this.loadThresholdField);
        this.settingsForm.addCommand(new Command(literal[10], 2, 0));
        this.settingsForm.addCommand(new Command(literal[27], 4, 1));
        this.settingsForm.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)this.settingsForm);
    }

    private void settingsCommand(Command com) {
        if (com.getCommandType() == 2) {
            this.settingsForm = null;
            this.showMainMenu();
            return;
        }
        int f = Integer.parseInt(this.frameSkipField.getString());
        maxFrameSkip = Math.max(Math.min(f, 59), 0);
        rotations = Integer.parseInt(this.rotationField.getString()) & 3;
        lazyLoadingThreshold = Math.max(Integer.parseInt(this.loadThresholdField.getString()) / 16, 20);
        enableScaling = this.graphicsGroup.isSelected(0);
        keepProportions = this.graphicsGroup.isSelected(1);
        advancedGraphics = this.graphicsGroup.isSelected(2);
        f = Integer.parseInt(this.scalingModeField.getString());
        scalingMode = Math.max(Math.min(f, 3), 0);
        disableColor = this.miscSettingsGroup.isSelected(0);
        showLogItem = this.miscSettingsGroup.isSelected(1);
        enableSound = this.soundGroup.isSelected(0);
        advancedSound = this.soundGroup.isSelected(1);
        int oldLanguage = language;
        language = languageLookup[this.languageGroup.getSelectedIndex()];
        GBCanvas.writeSettings();
        if (oldLanguage != language) {
            this.readLiteralsFile();
            this.cartList = null;
        }
        this.settingsForm = null;
        this.showMainMenu();
    }

    public void addSavegamesToList(List list, Vector cartIDs, Vector filenames) {
        for (int i = 0; i < this.numCarts; ++i) {
            try {
                RecordStore rs = RecordStore.openRecordStore((String)("20R_" + this.cartID[i]), (boolean)true);
                if (rs.getNumRecords() > 0) {
                    list.append(this.cartDisplayName[i], null);
                    cartIDs.addElement(this.cartID[i]);
                    filenames.addElement(this.cartFileName[i]);
                }
                rs.closeRecordStore();
                continue;
            }
            catch (Exception e) {
                MeBoy.log(e.toString());
            }
        }
    }

    private boolean tearDownBluetooth() {
        if (this.bluetooth != null) {
            this.bluetooth.tearDown();
            this.bluetooth = null;
            return true;
        }
        return false;
    }

    public synchronized void cancelBluetooth() {
        if (this.tearDownBluetooth()) {
            this.showMainMenu();
        }
    }

    public synchronized void cancelBluetooth(String message) {
        if (this.tearDownBluetooth()) {
            this.showMessage(literal[4], message);
        }
    }

    public synchronized void cancelBluetooth(Exception e) {
        if (!this.tearDownBluetooth()) {
            return;
        }
        MeBoy.log("BT: " + e);
        this.showMessage(literal[4], literal[59]);
    }

    public synchronized void finishBluetooth() {
        if (this.tearDownBluetooth()) {
            this.showMessage(literal[4], literal[58]);
        }
    }

    public synchronized void finishBluetoothReceive(String mode, String gameDisplayName, String gameFileName, String gameCartID, byte[] savegame) {
        this.tearDownBluetooth();
        if (mode.equals("r")) {
            if (gameCartID.length() == 0) {
                int ix = -1;
                if (ix == -1 && gameFileName.length() > 0) {
                    ix = this.findMatch(gameFileName, this.cartFileName, true);
                }
                if (ix == -1 && gameDisplayName.length() > 0) {
                    ix = this.findMatch(gameDisplayName, this.cartDisplayName, true);
                }
                if (ix > -1) {
                    gameCartID = this.cartID[ix];
                }
            }
            if (gameCartID.length() > 0 && this.findMatch(gameCartID, this.cartID, false) > -1) {
                MeBoy.addGameRAM(gameCartID, savegame);
                this.showMessage(literal[4], literal[58]);
            } else {
                String cart = "";
                if (gameDisplayName.length() > 0) {
                    cart = gameDisplayName;
                } else if (gameFileName.length() > 0) {
                    cart = gameFileName;
                } else if (gameCartID.length() > 0) {
                    cart = gameCartID;
                }
                this.showMessage(literal[4], literal[63] + MeBoy.formatDetails(cart, null));
            }
        } else if (gameCartID.length() > 0 && this.findMatch(gameCartID, this.cartID, false) > -1) {
            try {
                String suspendName = suspendCounter++ + ": " + gameDisplayName;
                RecordStore rs = RecordStore.openRecordStore((String)("20S_" + suspendName), (boolean)true);
                if (rs.getNumRecords() == 0) {
                    rs.addRecord(gameCartID.getBytes(), 0, gameCartID.length());
                    rs.addRecord(savegame, 0, savegame.length);
                } else {
                    rs.setRecord(1, gameCartID.getBytes(), 0, gameCartID.length());
                    rs.setRecord(2, savegame, 0, savegame.length);
                }
                rs.closeRecordStore();
                MeBoy.addSuspendedGame(suspendName);
                this.showMessage(literal[4], literal[58]);
            }
            catch (Exception e) {
                this.showMessage(literal[4], literal[64] + MeBoy.formatDetails(gameCartID, e));
            }
        } else {
            this.showMessage(literal[4], literal[63] + MeBoy.formatDetails(gameCartID, null));
        }
    }

    public void commandAction(Command com, Displayable s) {
        if (s == this.messageForm) {
            this.messageCommand();
        } else if (s == this.mainMenu) {
            this.mainMenuCommand(com);
        } else if (s == this.cartList) {
            this.cartListCommand(com);
        } else if (s == this.suspendList) {
            this.resumeGameCommand(com);
        } else if (s == this.settingsForm) {
            this.settingsCommand(com);
        }
    }

    public static void log(String s) {
        if (s == null) {
            return;
        }
        logString = logString + s + '\n';
    }

    public static void addGameRAM(String name, byte[] data) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)("20R_" + name), (boolean)true);
            if (rs.getNumRecords() == 0) {
                rs.addRecord(data, 0, data.length);
            } else {
                rs.setRecord(1, data, 0, data.length);
            }
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addSuspendedGame(String name) {
        String[] oldIndex = suspendName20;
        suspendName20 = new String[oldIndex.length + 1];
        System.arraycopy(oldIndex, 0, suspendName20, 0, oldIndex.length);
        MeBoy.suspendName20[oldIndex.length] = name;
        GBCanvas.writeSettings();
    }

    private int findMatch(String match, String[] list, boolean fuzzy) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(match)) continue;
            return i;
        }
        if (!fuzzy) {
            return -1;
        }
        int lastdot = match.lastIndexOf(46);
        if (lastdot != -1 && lastdot > match.length() - 5) {
            match = match.substring(0, lastdot);
        }
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].startsWith(match)) continue;
            return i;
        }
        return -1;
    }

    static {
        _D_D = 0;
        rotations = 0;
        maxFrameSkip = 3;
        enableScaling = true;
        scalingMode = 0;
        keepProportions = true;
        fullScreen = false;
        disableColor = false;
        enableSound = false;
        advancedSound = false;
        advancedGraphics = false;
        showFps = false;
        showLogItem = false;
        lazyLoadingThreshold = 64;
        bluetoothAvailable = false;
        suspendCounter = 1;
        suspendName10 = new String[0];
        suspendName20 = new String[0];
        literal = new String[80];
        languageCount = 1;
        languages = new String[]{"English"};
        languageLookup = new int[]{0};
        logString = "";
    }

    public void _c_c() {
        this.cartDisplayName = null;
        this.cartFileName = null;
        this.cartID = null;
    }

    public void _d_d() {
        if (instance == this) {
            return;
        }
        try {
            bluetoothAvailable = Bluetooth.available();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        instance = this;
        display = Display.getDisplay((MIDlet)this);
        GBCanvas.readSettings();
        this.readLangIndexFile();
        if (!this.readLiteralsFile()) {
            return;
        }
        if (!this.readCartNames()) {
            return;
        }
        if (!this.upgradeSavegames()) {
            return;
        }
        this.showMainMenu();
    }

    public void _a_a() {
        this._c_c();
    }

    public void _b_b() {
        this._d_d();
    }
}

