/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;

public class GBCanvas
extends Canvas
implements CommandListener {
    public MeBoy parent;
    private Dmgcpu cpu;
    private int w;
    private int h;
    private int l;
    private int t;
    private int sw;
    private int sh;
    private int trans;
    private int ssw;
    private int ssh;
    private int clipHeight;
    private int[] previousTime = new int[16];
    private int previousTimeIx;
    private Command pauseCommand = new Command(MeBoy.literal[30], 1, 0);
    private Command resumeCommand = new Command(MeBoy.literal[31], 1, 0);
    private Command saveCommand = new Command(MeBoy.literal[32], 1, 1);
    private Command showFpsCommand = new Command(MeBoy.literal[33], 1, 3);
    private Command fullScreenCommand = new Command(MeBoy.literal[34], 1, 4);
    private Command setButtonsCommand = new Command(MeBoy.literal[35], 1, 5);
    private Command exitCommand;
    private static int[] key = new int[]{54, 52, 50, 56, 55, 57, 35, 42};
    private String[] keyName = new String[]{MeBoy.literal[38], MeBoy.literal[39], MeBoy.literal[40], MeBoy.literal[41], MeBoy.literal[42], MeBoy.literal[43], MeBoy.literal[44], MeBoy.literal[45]};
    private int keySetCounter;
    private boolean settingKeys;
    private boolean paused;
    private String cartDisplayName;
    private String cartID;
    private String suspendName;
    private Thread cpuThread;

    private GBCanvas(MeBoy p, String cartID, String cartDisplayName) {
        this.parent = p;
        this.cartID = cartID;
        this.cartDisplayName = cartDisplayName;
        this.exitCommand = new Command(MeBoy.literal[36] + " " + cartDisplayName, 1, 6);
        this.setCommandListener(this);
        this.updateCommands();
        this.setFullScreenMode(MeBoy.fullScreen);
    }

    public GBCanvas(String cartID, MeBoy p, String cartDisplayName, String suspendName, byte[] suspendState) {
        this(p, cartID, cartDisplayName);
        this.suspendName = suspendName;
        this.cpu = new Dmgcpu(cartID, this, suspendState);
        this.setDimensions();
        this.cpuThread = new Thread(this.cpu);
        this.cpuThread.start();
    }

    public GBCanvas(String cartID, MeBoy p, String cartDisplayName) {
        this(p, cartID, cartDisplayName);
        this.cpu = new Dmgcpu(cartID, this);
        if (this.cpu.hasBattery()) {
            this.loadCartRam();
        }
        this.setDimensions();
        this.cpuThread = new Thread(this.cpu);
        this.cpuThread.start();
    }

    private void updateCommands() {
        this.removeCommand(this.pauseCommand);
        this.removeCommand(this.resumeCommand);
        this.removeCommand(this.saveCommand);
        this.removeCommand(this.showFpsCommand);
        this.removeCommand(this.fullScreenCommand);
        this.removeCommand(this.setButtonsCommand);
        this.removeCommand(this.exitCommand);
        if (this.paused) {
            this.addCommand(this.resumeCommand);
        } else {
            this.addCommand(this.pauseCommand);
        }
        this.addCommand(this.saveCommand);
        this.addCommand(this.showFpsCommand);
        this.addCommand(this.fullScreenCommand);
        this.addCommand(this.setButtonsCommand);
        this.addCommand(this.exitCommand);
    }

    public void setDimensions() {
        boolean rotate;
        this.w = this.getWidth();
        this.h = this.getHeight();
        int[] transs = new int[]{0, 5, 3, 6};
        this.trans = transs[MeBoy.rotations];
        boolean bl = rotate = (MeBoy.rotations & 1) != 0;
        if (MeBoy.enableScaling) {
            int deltah = MeBoy.showFps ? -16 : 0;
            this.cpu.setScale(rotate ? this.h + deltah : this.w, rotate ? this.w : this.h + deltah);
        }
        this.ssw = this.sw = this.cpu.graphicsChip.scaledWidth;
        this.ssh = this.sh = this.cpu.graphicsChip.scaledHeight;
        this.clipHeight = this.sh;
        if (rotate) {
            this.sw = this.ssh;
            this.clipHeight = this.sh = this.ssw;
        }
        this.l = (this.w - this.sw) / 2;
        this.t = (this.h - this.sh) / 2;
        if (MeBoy.showFps) {
            this.t -= 8;
            this.clipHeight += 16;
        }
        if (this.l < 0) {
            this.l = 0;
        }
        if (this.t < 0) {
            this.t = 0;
        }
    }

    public void keyReleased(int keyCode) {
        for (int i = 0; i < 8; ++i) {
            if (keyCode != key[i]) continue;
            this.cpu.buttonUp(i);
        }
    }

    public void keyPressed(int keyCode) {
        if (this.settingKeys) {
            GBCanvas.key[this.keySetCounter++] = keyCode;
            if (this.keySetCounter == 8) {
                GBCanvas.writeSettings();
                this.settingKeys = false;
            }
            this.repaint();
            return;
        }
        for (int i = 0; i < 8; ++i) {
            if (keyCode != key[i]) continue;
            this.cpu.buttonDown(i);
        }
    }

    public void commandAction(Command c, Displayable s) {
        try {
            String label = c.getLabel();
            if (label.startsWith(MeBoy.literal[36])) {
                if (this.cpu.hasBattery()) {
                    this.saveCartRam();
                }
                this.parent.unloadCart();
                Runtime.getRuntime().gc();
            } else if (label == MeBoy.literal[30]) {
                this.pause();
            } else if (label == MeBoy.literal[31] && !this.settingKeys) {
                this.paused = false;
                this.updateCommands();
                this.cpuThread = new Thread(this.cpu);
                this.cpuThread.start();
            } else if (label == MeBoy.literal[33]) {
                MeBoy.showFps = !MeBoy.showFps;
                this.setDimensions();
            } else if (label == MeBoy.literal[35] && !this.settingKeys) {
                this.pause();
                this.settingKeys = true;
                this.keySetCounter = 0;
            } else if (label == MeBoy.literal[32] && !this.settingKeys) {
                if (!this.cpu.isTerminated()) {
                    this.cpu.terminate();
                    while (this.cpuThread.isAlive()) {
                        Thread.yield();
                    }
                    this.suspend();
                    this.cpuThread = new Thread(this.cpu);
                    this.cpuThread.start();
                } else {
                    this.suspend();
                }
            } else if (label == MeBoy.literal[34] && !this.settingKeys) {
                MeBoy.fullScreen = !MeBoy.fullScreen;
                this.setFullScreenMode(MeBoy.fullScreen);
                this.setDimensions();
            }
        }
        catch (Throwable th) {
            MeBoy.log(th.toString());
            MeBoy.showLog();
        }
        this.repaint();
    }

    public final void pause() {
        if (this.cpuThread == null) {
            return;
        }
        this.paused = true;
        this.updateCommands();
        this.cpu.terminate();
        while (this.cpuThread.isAlive()) {
            Thread.yield();
        }
        this.cpuThread = null;
    }

    public final void redrawSmall() {
        this.repaint(this.l, this.t, this.sw, this.clipHeight);
    }

    public final void paintFps(Graphics g) {
        g.setClip(this.l, this.t + this.sh, this.sw, 16);
        g.setColor(0x999999);
        g.fillRect(this.l, this.t + this.sh, this.sw, 16);
        g.setColor(0);
        Object var4_2 = null;
        long l = 0L;
        Object var7_4 = null;
        l = Dmgcpu._n();
        int now = (int)l;
        int estfps = (32640 + now - this.previousTime[this.previousTimeIx]) / (now - this.previousTime[this.previousTimeIx]) >> 1;
        this.previousTime[this.previousTimeIx] = now;
        this.previousTimeIx = this.previousTimeIx + 1 & 0xF;
        g.drawString(estfps + " fps * " + (this.cpu.getLastSkipCount() + 1), this.l + 1, this.t + this.sh, 20);
    }

    public final void paint(Graphics g) {
        if (this.cpu == null) {
            return;
        }
        if (this.settingKeys) {
            g.setColor(0x446688);
            g.fillRect(0, 0, this.w, this.h);
            g.setColor(-1);
            int cut = MeBoy.literal[37].indexOf(32, MeBoy.literal[37].length() * 2 / 5);
            if (cut == -1) {
                cut = 0;
            }
            g.drawString(MeBoy.literal[37].substring(0, cut), this.w / 2, this.h / 2 - 18, 65);
            g.drawString(MeBoy.literal[37].substring(cut + 1), this.w / 2, this.h / 2, 65);
            g.drawString(this.keyName[this.keySetCounter], this.w / 2, this.h / 2 + 18, 65);
            return;
        }
        if (g.getClipWidth() != this.sw || g.getClipHeight() != this.clipHeight) {
            g.setColor(0x666666);
            g.fillRect(0, 0, this.w, this.h);
        }
        if (MeBoy.showFps) {
            this.paintFps(g);
        }
        g.setClip(this.l, this.t, this.sw, this.sh);
        if (this.cpu.graphicsChip.frameBufferImage == null) {
            g.setColor(0xAAAAAA);
            g.fillRect(this.l, this.t, this.sw, this.sh);
        } else if (this.trans == 0) {
            g.drawImage(this.cpu.graphicsChip.frameBufferImage, this.l, this.t, 20);
        } else {
            g.drawRegion(this.cpu.graphicsChip.frameBufferImage, 0, 0, this.ssw, this.ssh, this.trans, this.l, this.t, 20);
        }
        this.cpu.graphicsChip.notifyRepainted();
        if (this.paused) {
            g.setColor(0);
            g.drawString(MeBoy.literal[30], this.w / 2 - 1, this.h / 2, 65);
            g.drawString(MeBoy.literal[30], this.w / 2, this.h / 2 - 1, 65);
            g.drawString(MeBoy.literal[30], this.w / 2 + 1, this.h / 2, 65);
            g.drawString(MeBoy.literal[30], this.w / 2, this.h / 2 + 1, 65);
            g.setColor(0xFFFFFF);
            g.drawString(MeBoy.literal[30], this.w / 2, this.h / 2, 65);
        }
    }

    public static final void setInt(byte[] b, int i, int v) {
        b[i++] = (byte)(v >> 24);
        b[i++] = (byte)(v >> 16);
        b[i++] = (byte)(v >> 8);
        b[i++] = (byte)v;
    }

    public static final int getInt(byte[] b, int i) {
        int r = b[i++] & 0xFF;
        r = (r << 8) + (b[i++] & 0xFF);
        r = (r << 8) + (b[i++] & 0xFF);
        return (r << 8) + (b[i++] & 0xFF);
    }

    public static final void writeSettings() {
        try {
            int j;
            int i;
            int i2;
            RecordStore rs = RecordStore.openRecordStore((String)"set", (boolean)true);
            int bLength = 55;
            for (i2 = 0; i2 < MeBoy.suspendName10.length; ++i2) {
                bLength += 1 + MeBoy.suspendName10[i2].length();
            }
            for (i2 = 0; i2 < MeBoy.suspendName20.length; ++i2) {
                bLength += 1 + MeBoy.suspendName20[i2].length() * 2;
            }
            byte[] b = new byte[++bLength];
            for (int i3 = 0; i3 < 8; ++i3) {
                GBCanvas.setInt(b, i3 * 4, key[i3]);
            }
            GBCanvas.setInt(b, 32, MeBoy.maxFrameSkip);
            GBCanvas.setInt(b, 36, MeBoy.rotations);
            GBCanvas.setInt(b, 40, MeBoy.lazyLoadingThreshold);
            GBCanvas.setInt(b, 44, MeBoy.suspendCounter);
            GBCanvas.setInt(b, 48, MeBoy.suspendName10.length);
            int index = 52;
            for (i = 0; i < MeBoy.suspendName10.length; ++i) {
                String s = MeBoy.suspendName10[i];
                b[index++] = (byte)s.length();
                for (j = 0; j < s.length(); ++j) {
                    b[index++] = (byte)s.charAt(j);
                }
            }
            b[index++] = (byte)((MeBoy.enableScaling ? 1 : 0) + (MeBoy.keepProportions ? 2 : 0) + (MeBoy.fullScreen ? 4 : 0) + (MeBoy.disableColor ? 8 : 0) + (MeBoy.enableSound ? 32 : 0) + (MeBoy.advancedSound ? 64 : 0) + (MeBoy.advancedGraphics ? 128 : 0));
            b[index++] = (byte)MeBoy.language;
            b[index++] = (byte)((MeBoy.showFps ? 1 : 0) + (MeBoy.showLogItem ? 2 : 0));
            b[index++] = (byte)MeBoy.suspendName20.length;
            for (i = 0; i < MeBoy.suspendName20.length; ++i) {
                char[] chars = MeBoy.suspendName20[i].toCharArray();
                b[index++] = (byte)chars.length;
                for (j = 0; j < chars.length; ++j) {
                    b[index++] = (byte)(chars[j] >> 8);
                    b[index++] = (byte)chars[j];
                }
            }
            if (rs.getNumRecords() == 0) {
                rs.addRecord(b, 0, bLength);
            } else {
                rs.setRecord(1, b, 0, bLength);
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            MeBoy.log(e.toString());
        }
    }

    public static final void readSettings() {
        try {
            MeBoy.suspendName10 = new String[0];
            MeBoy.suspendName20 = new String[0];
            RecordStore rs = RecordStore.openRecordStore((String)"set", (boolean)true);
            if (rs.getNumRecords() > 0) {
                int slen;
                int i;
                int index;
                byte[] b = rs.getRecord(1);
                for (int i2 = 0; i2 < 8; ++i2) {
                    GBCanvas.key[i2] = GBCanvas.getInt(b, i2 * 4);
                }
                if (b.length >= 36) {
                    MeBoy.maxFrameSkip = GBCanvas.getInt(b, 32);
                }
                if (b.length >= 40) {
                    MeBoy.rotations = GBCanvas.getInt(b, 36);
                }
                if (b.length >= 44) {
                    MeBoy.lazyLoadingThreshold = GBCanvas.getInt(b, 40);
                }
                if (b.length > (index = 44)) {
                    MeBoy.suspendCounter = GBCanvas.getInt(b, index);
                    MeBoy.suspendName10 = new String[GBCanvas.getInt(b, index += 4)];
                    index += 4;
                    for (i = 0; i < MeBoy.suspendName10.length; ++i) {
                        slen = b[index++] & 0xFF;
                        MeBoy.suspendName10[i] = new String(b, index, slen);
                        index += slen;
                    }
                }
                if (b.length > index) {
                    MeBoy.enableScaling = (b[index] & 1) != 0;
                    MeBoy.keepProportions = (b[index] & 2) != 0;
                    MeBoy.fullScreen = (b[index] & 4) != 0;
                    MeBoy.disableColor = (b[index] & 8) != 0;
                    MeBoy.language = (b[index] & 0x10) != 0 ? 1 : 0;
                    MeBoy.enableSound = (b[index] & 0x20) != 0;
                    MeBoy.advancedSound = (b[index] & 0x40) != 0;
                    MeBoy.advancedGraphics = (b[index] & 0x80) != 0;
                    ++index;
                }
                if (b.length > index) {
                    MeBoy.language = b[index++];
                }
                if (b.length > index) {
                    MeBoy.showFps = (b[index] & 1) != 0;
                    MeBoy.showLogItem = (b[index] & 2) != 0;
                    ++index;
                }
                if (b.length > index) {
                    MeBoy.suspendName20 = new String[b[index++]];
                    for (i = 0; i < MeBoy.suspendName20.length; ++i) {
                        slen = b[index++] & 0xFF;
                        char[] chars = new char[slen];
                        int j = 0;
                        while (j < slen) {
                            int n = j;
                            chars[n] = (char)(chars[n] + ((b[index++] & 0xFF) << 8));
                            int n2 = j++;
                            chars[n2] = (char)(chars[n2] + (b[index++] & 0xFF));
                        }
                        MeBoy.suspendName20[i] = new String(chars);
                    }
                }
            } else {
                GBCanvas.writeSettings();
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            MeBoy.log(e.toString());
        }
    }

    private final void saveCartRam() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)("20R_" + this.cartID), (boolean)true);
            byte[][] ram = this.cpu.getCartRam();
            int bankCount = ram.length;
            int bankSize = ram[0].length;
            int size = bankCount * bankSize + 13;
            byte[] b = new byte[size];
            for (int i = 0; i < bankCount; ++i) {
                System.arraycopy(ram[i], 0, b, i * bankSize, bankSize);
            }
            System.arraycopy(this.cpu.getRtcReg(), 0, b, bankCount * bankSize, 5);
            Object var9_10 = null;
            long l = 0L;
            Object var12_12 = null;
            long now = l = Dmgcpu._n();
            GBCanvas.setInt(b, bankCount * bankSize + 5, (int)(now >> 32));
            GBCanvas.setInt(b, bankCount * bankSize + 9, (int)now);
            if (rs.getNumRecords() == 0) {
                rs.addRecord(b, 0, size);
            } else {
                rs.setRecord(1, b, 0, size);
            }
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void loadCartRam() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)("20R_" + this.cartID), (boolean)true);
            if (rs.getNumRecords() > 0) {
                byte[][] ram = this.cpu.getCartRam();
                int bankCount = ram.length;
                int bankSize = ram[0].length;
                byte[] b = rs.getRecord(1);
                for (int i = 0; i < bankCount; ++i) {
                    System.arraycopy(b, i * bankSize, ram[i], 0, bankSize);
                }
                if (b.length == bankCount * bankSize + 13) {
                    System.arraycopy(b, bankCount * bankSize, this.cpu.getRtcReg(), 0, 5);
                    long time = GBCanvas.getInt(b, bankCount * bankSize + 5);
                    time = (time << 32) + ((long)GBCanvas.getInt(b, bankCount * bankSize + 9) & 0xFFFFFFFFL);
                    Object var8_9 = null;
                    long l = 0L;
                    Object var11_11 = null;
                    l = Dmgcpu._n();
                    time = l - time;
                    this.cpu.rtcSkip((int)(time / 1000L));
                }
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            MeBoy.log(e.toString());
        }
    }

    private final void suspend() {
        try {
            boolean insertIndex = false;
            if (this.suspendName == null) {
                this.suspendName = MeBoy.suspendCounter++ + ": " + this.cartDisplayName;
                insertIndex = true;
            }
            RecordStore rs = RecordStore.openRecordStore((String)("20S_" + this.suspendName), (boolean)true);
            byte[] b = this.cpu.flatten();
            if (rs.getNumRecords() == 0) {
                rs.addRecord(this.cartID.getBytes(), 0, this.cartID.length());
                rs.addRecord(b, 0, b.length);
            } else {
                rs.setRecord(1, this.cartID.getBytes(), 0, this.cartID.length());
                rs.setRecord(2, b, 0, b.length);
            }
            rs.closeRecordStore();
            if (insertIndex) {
                MeBoy.addSuspendedGame(this.suspendName);
            }
        }
        catch (Exception e) {
            MeBoy.showError(null, "error#10", e);
        }
    }

    public void releaseReferences() {
        this.cpu.terminate();
        while (this.cpuThread != null && this.cpuThread.isAlive()) {
            Thread.yield();
        }
        this.cpu.releaseReferences();
        this.cpu = null;
        this.cartID = null;
        this.cartDisplayName = null;
        this.previousTime = null;
        this.parent = null;
        System.gc();
    }
}

