/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BitmapFont {
    protected byte BMF_CONTAINS_IMAGES = 1;
    private static final int FONT_SPACING = 1;
    private static final int FONT_SPACE = 4;
    public static final int FONT_TITLE = 0;
    public static final int FONT_SMALL = 1;
    public static final int FONT_SMALL_SPECIAL = 2;
    public static final int FONT_COUNT = 3;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_ALT = 3;
    private static final String[] fontFiles = new String[]{"title_font", "small", "small_sp"};
    private Image[] fontImage;
    private static String[] fontCharMap;
    private Boolean[] fontMixedCase;
    private static byte[][] fontCharWidths;
    private short[][] fontCharX;
    private long[] crcTable = new long[256];
    private boolean crcTableComputed = false;
    public static final String altCode = "[alt]";
    public static final String scrollCode = "[scr]";
    public DevilMayCry_J_Canvas canvas;
    private static String[] titleString;
    public static int missionHeaderScrollTime;
    public static final int ARROW_UP = 0;
    public static final int ARROW_DOWN = 1;
    public static final int ARROW_LEFT = 2;
    public static final int ARROW_RIGHT = 3;
    private static String[] buffer;

    static {
        titleString = new String[2];
    }

    BitmapFont(DevilMayCry_J_Canvas c) {
        this.canvas = c;
    }

    public static String textPrepareTitleString(String str) {
        if (titleString[0] != null && titleString[0].equals(str)) {
            return titleString[1];
        }
        BitmapFont.titleString[0] = str;
        str = str.replace('\u00c8', 'E');
        str = str.replace('\u00c9', 'E');
        str = str.replace('\u00d9', 'U');
        str = str.replace('\u00c0', 'A');
        str = str.replace('\u00dc', 'U');
        str = str.replace('\u00da', 'U');
        str = str.replace('\u00d6', 'O');
        str = str.replace('\u00d3', 'O');
        str = str.replace('\u00c1', 'A');
        str = str.replace('!', ' ');
        str = str.replace('\u00a1', ' ');
        str = str.replace('?', ' ');
        BitmapFont.titleString[1] = str = str.replace('\u00bf', ' ');
        return str;
    }

    public void drawString(Graphics g, String s, int x, int y, int width, int allignment, int font, int fontType) {
        if (font == 0) {
            s = BitmapFont.textPrepareTitleString(s);
        }
        int wordWidth = 0;
        int xOffset = 0;
        try {
            if (allignment == 1 || allignment == 8) {
                wordWidth = BitmapFont.stringWidth(s, font);
                if (allignment == 1) {
                    x += width / 2 - wordWidth / 2;
                } else if (allignment == 8) {
                    x -= wordWidth;
                }
            }
            int fontTmp = font;
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                fontTmp = font;
                if (BitmapFont.isSpecialChar(c) && font != 0) {
                    ++fontTmp;
                }
                int charPosInMap = fontCharMap[fontTmp].indexOf(c);
                if (c == ' ' || c == '\u00a0') {
                    xOffset += 4;
                } else if (c == '^' || c == '~' || c == '<' || c == '>' || c == '#' || c == '*') {
                    g.drawRegion(this.fontImage[fontTmp + fontType], (int)this.fontCharX[fontTmp][charPosInMap], 0, (int)fontCharWidths[fontTmp][charPosInMap], this.fontImage[fontTmp + fontType].getHeight(), 0, x + xOffset, y, 20);
                    xOffset += fontCharWidths[fontTmp][charPosInMap] + (font == 0 ? (byte)0 : 1);
                } else {
                    if (fontType == 0) {
                        g.setColor(0xFFFFFF);
                    } else {
                        g.setColor(128, 128, 128);
                    }
                    if (font == 0) {
                        if (c >= '0' && c <= '9' || c == ':') {
                            g.drawRegion(this.fontImage[fontTmp + fontType], (int)this.fontCharX[fontTmp][charPosInMap], 0, (int)fontCharWidths[fontTmp][charPosInMap], this.fontImage[fontTmp + fontType].getHeight(), 0, x + xOffset, y, 20);
                            xOffset += fontCharWidths[fontTmp][charPosInMap] + (font == 0 ? (byte)0 : 1);
                        } else {
                            g.setColor(235, 116, 106);
                            g.drawChar(c, x + xOffset, y - 1, 20);
                            g.drawChar(c, x + xOffset, y + 1, 20);
                            g.setColor(254, 179, 160);
                            g.drawChar(c, x + xOffset - 1, y, 20);
                            g.drawChar(c, x + xOffset + 1, y, 20);
                            g.setColor(255, 237, 213);
                            g.drawChar(c, x + xOffset, y, 20);
                            xOffset += g.getFont().charWidth(c);
                        }
                    } else {
                        if (this.canvas.getState() == 2 && s.equals("\u66f4\u591a\u6e38\u620f")) {
                            g.setColor(0xFF0000);
                        }
                        g.drawChar(c, x + xOffset, y, 20);
                        xOffset += g.getFont().charWidth(c);
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean needsWrapping(String s, int x, int width, int font) {
        return BitmapFont.stringWidth(s, font) >= width - x;
    }

    public void drawStringWrapped(Graphics g, String s, int x, int y, int width, int allignment, int font, int fontType) {
        if (this.needsWrapping(s, x, width, font)) {
            String[] str = BitmapFont.splitString(s, width - x, font);
            int i = 0;
            while (i < str.length) {
                this.drawString(g, str[i], x, y + i * 18, width, allignment, font, fontType);
                ++i;
            }
        } else {
            this.drawString(g, s, x, y, width, allignment, font, fontType);
        }
    }

    public void drawTextBox(Graphics g, int x, int y, int width, int lines, String[] text, boolean scrolled, int anchor, int startLine) {
        int line = 0;
        int i = 0;
        missionHeaderScrollTime += 2;
        if (text != null) {
            if (scrolled) {
                i = startLine;
                while (i < text.length && line < lines) {
                    if (i < text.length && text[i] != null) {
                        if (text[i].startsWith(altCode)) {
                            this.drawString(g, text[i].substring(5), x + 1, y + 4 + line * 18, width, anchor, 1, 0);
                        } else {
                            this.drawString(g, text[i], x + 1, y + 4 + line * 18, width, anchor, 1, 0);
                        }
                        ++line;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < text.length && line < lines) {
                    if (i < text.length && text[i] != null) {
                        if (text[i].startsWith(altCode)) {
                            this.drawString(g, text[i].substring(5), x + 1, y + 4 + line * 18, width, anchor, 1, 0);
                        } else if (text[i].startsWith(scrollCode)) {
                            int nameWidth = BitmapFont.stringWidth(text[i].substring(5));
                            if (nameWidth >= width) {
                                g.setClip(x + 1, y + 4 + line * 18, width, Layout.FONT_HEIGHT);
                                if (missionHeaderScrollTime > 0) {
                                    g.setClip(x + 1, y + 4 + line * 18, width, Layout.FONT_HEIGHT);
                                    int scrollLength = nameWidth + 24;
                                    this.drawString(g, text[i].substring(5), x + 1 - missionHeaderScrollTime % scrollLength, y + 4 + line * 18, width, anchor, 1, 0);
                                    this.drawString(g, text[i].substring(5), x + 1 + scrollLength - missionHeaderScrollTime % scrollLength, y + 4 + line * 18, width, anchor, 1, 0);
                                } else {
                                    this.drawString(g, text[i].substring(5), x + 1, y + 4 + line * 18, width, anchor, 1, 0);
                                }
                            } else {
                                this.drawString(g, text[i].substring(5), x + 1, y + 4 + line * 18, width, anchor, 1, 0);
                            }
                        } else {
                            this.drawString(g, text[i], x + 1, y + 4 + line * 18, width, anchor, 1, 0);
                        }
                        ++line;
                    }
                    ++i;
                }
                g.setClip(0, 0, this.canvas.screenWidth, this.canvas.screenHeight);
            }
        }
    }

    public static void resetScroll() {
        missionHeaderScrollTime = -20;
    }

    public void init() {
        try {
            this.fontImage = new Image[6];
            fontCharMap = new String[3];
            this.fontMixedCase = new Boolean[3];
            fontCharWidths = new byte[3][];
            this.fontCharX = new short[3][];
            this.fontImage[1] = Image.createImage((String)("/" + fontFiles[1] + ".png"));
            this.fontImage[2] = Image.createImage((String)("/" + fontFiles[2] + ".png"));
            this.fontImage[4] = this.createFontWithColourOrBrightness(1, 0x969696, 0);
            this.fontImage[5] = this.createFontWithColourOrBrightness(2, 0x969696, 0);
            this.addBMF(1);
            this.addBMF(2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Image createFontWithColourOrBrightness(int font, int colour, int brightness) {
        Image image = null;
        try {
            byte[] imageBytes = this.getImageAsBytes("/" + fontFiles[font] + ".png");
            int paletteStart = 0;
            int j = 0;
            while (j < imageBytes.length) {
                if (imageBytes[j] == 80 && imageBytes[j + 1] == 76 && imageBytes[j + 2] == 84 && imageBytes[j + 3] == 69) {
                    paletteStart = j + 4 + 3;
                }
                ++j;
            }
            if (brightness == 0) {
                imageBytes[paletteStart] = (byte)(colour >> 16 & 0xFF);
                imageBytes[paletteStart + 1] = (byte)(colour >> 8 & 0xFF);
                imageBytes[paletteStart + 2] = (byte)(colour & 0xFF);
            } else {
                int numEntries = this.getPaletteEntryCount(imageBytes, paletteStart - 8 - 3);
                int i = paletteStart;
                while (i < paletteStart + (numEntries - 3)) {
                    int val = imageBytes[i];
                    if (val > 0) {
                        if ((val = (byte)(val - brightness)) < 0) {
                            val = 0;
                        }
                    } else if ((val = (byte)(val - brightness)) < -128) {
                        val += 256;
                    }
                    imageBytes[i] = (byte)val;
                    ++i;
                }
            }
            this.updatePNGCRC(imageBytes, paletteStart - 8 - 3);
            image = Image.createImage((byte[])imageBytes, (int)0, (int)imageBytes.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    private void addBMF(int font) {
        try {
            InputStream in = this.getClass().getResourceAsStream("/" + fontFiles[font] + ".bmf");
            DataInputStream dis = new DataInputStream(in);
            this.fontMixedCase[font] = new Boolean(dis.readBoolean());
            BitmapFont.fontCharMap[font] = dis.readUTF();
            int noOfChars = fontCharMap[font].length();
            BitmapFont.fontCharWidths[font] = new byte[noOfChars];
            this.fontCharX[font] = new short[noOfChars];
            short xPos = 0;
            int i = 0;
            while (i < noOfChars) {
                BitmapFont.fontCharWidths[font][i] = dis.readByte();
                this.fontCharX[font][i] = xPos;
                xPos = (short)(xPos + fontCharWidths[font][i]);
                ++i;
            }
            try {
                dis.close();
            }
            catch (IOException iOException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void drawArrow(Graphics g, int x, int y, int type, int size, int colour) {
        try {
            g.setColor(colour);
            int width = 1;
            int offset = 3;
            if (type == 0) {
                int i = 0;
                while (i < size) {
                    g.fillRect(x + offset, y + i, width, 1);
                    width += 2;
                    --offset;
                    ++i;
                }
            } else if (type == 1) {
                int i = size;
                while (i > 0) {
                    g.fillRect(x + offset, y + i, width, 1);
                    width += 2;
                    --offset;
                    --i;
                }
            } else if (type == 2) {
                int i = 0;
                while (i < size) {
                    g.fillRect(x + i, y + offset - 3, 1, width);
                    width += 2;
                    --offset;
                    ++i;
                }
            } else if (type == 3) {
                int i = size;
                while (i > 0) {
                    g.fillRect(x + i, y + offset - 3, 1, width);
                    width += 2;
                    --offset;
                    --i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int stringWidth(String s) {
        return BitmapFont.stringWidth(s, 1);
    }

    public static int stringWidth(String s, int font) {
        return DevilMayCry_J_Canvas.m_font_small.stringWidth(s);
    }

    public static final String[] splitString(String msg, int width, int font) {
        String[] res;
        block10: {
            res = null;
            if (msg != null && !msg.equals("")) break block10;
            return null;
        }
        try {
            int mark = 0;
            int start = 0;
            int bufferIndex = 0;
            buffer = new String[128];
            int i = 0;
            while (i < msg.length()) {
                if (msg.charAt(i) == '\n' || msg.charAt(i) == '$') {
                    if (BitmapFont.stringWidth(msg.substring(start, i), font) >= width) {
                        BitmapFont.buffer[bufferIndex++] = msg.substring(start, mark);
                        start = mark + 1;
                    }
                    BitmapFont.buffer[bufferIndex++] = msg.substring(start, i);
                    start = i + 1;
                    mark = i;
                } else if (BitmapFont.stringWidth(msg.substring(start, i), font) >= width) {
                    BitmapFont.buffer[bufferIndex++] = msg.substring(start, mark);
                    start = mark;
                    mark = i;
                } else {
                    mark = i;
                }
                ++i;
            }
            if (BitmapFont.stringWidth(msg.substring(start, msg.length() - 1), font) >= width) {
                BitmapFont.buffer[bufferIndex++] = msg.substring(start, mark);
                start = mark + 1;
            }
            BitmapFont.buffer[bufferIndex++] = msg.substring(start);
            res = new String[bufferIndex];
            System.arraycopy(buffer, 0, res, 0, res.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public static final String[] splitString(String[] msg, int width, int font) {
        String fullString = "";
        int i = 0;
        while (i < msg.length) {
            if (!msg[i].equals("")) {
                fullString = String.valueOf(fullString) + msg[i] + (i == msg.length - 1 ? "" : "\n");
            }
            ++i;
        }
        return BitmapFont.splitString(fullString, width, font);
    }

    private static boolean isSpecialChar(char c) {
        return !(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z') && (c < 'a' || c > 'z');
    }

    private byte[] getImageAsBytes(String URI) {
        byte[] res = null;
        try {
            InputStream in = this.getClass().getResourceAsStream(URI);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int ret = in.read();
            while (ret >= 0) {
                bout.write(ret);
                ret = in.read();
            }
            res = bout.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    private int getPaletteEntryCount(byte[] imageData, int paletteChunkStart) {
        byte[] paletteLength = new byte[4];
        int i = 0;
        while (i < 4) {
            paletteLength[i] = imageData[paletteChunkStart + i];
            ++i;
        }
        return this.byteArrayToInt(paletteLength);
    }

    private void updatePNGCRC(byte[] imageData, int paletteChunkStart) {
        try {
            byte[] paletteLength = new byte[4];
            int i = 0;
            while (i < 4) {
                paletteLength[i] = imageData[paletteChunkStart + i];
                ++i;
            }
            int numberOfColours = this.byteArrayToInt(paletteLength) / 3;
            byte[] crc = this.getCRC(imageData, paletteChunkStart + 4, paletteChunkStart + 8 + numberOfColours * 3);
            int j = 0;
            while (j < 4) {
                imageData[paletteChunkStart + 8 + numberOfColours * 3 + j] = crc[j];
                ++j;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void makeCRCTable() {
        int n = 0;
        while (n < 256) {
            long c = n;
            int k = 0;
            while (k < 8) {
                c = (c & 1L) != 0L ? 0xEDB88320L ^ c >> 1 : (c >>= 1);
                ++k;
            }
            this.crcTable[n] = c;
            ++n;
        }
        this.crcTableComputed = true;
    }

    private long generateCRC(long crc, byte[] buf, int from, int len) {
        long c = crc;
        if (!this.crcTableComputed) {
            this.makeCRCTable();
        }
        int n = from;
        while (n < len) {
            c = this.crcTable[(int)((c ^ (long)buf[n]) & 0xFFL)] ^ c >> 8;
            ++n;
        }
        return c;
    }

    private byte[] getCRC(byte[] buf, int from, int to) {
        long l = this.generateCRC(0xFFFFFFFFL, buf, from, to) ^ 0xFFFFFFFFL;
        byte[] byteArray = new byte[4];
        byteArray[3] = (byte)l;
        byteArray[2] = (byte)(l >> 8);
        byteArray[1] = (byte)(l >> 16);
        byteArray[0] = (byte)(l >> 24);
        return byteArray;
    }

    public int byteArrayToInt(byte[] bytes) {
        int value = 0;
        int i = 0;
        while (i < 4) {
            int shift = (3 - i) * 8;
            value += (bytes[i] & 0xFF) << shift;
            ++i;
        }
        return value;
    }

    public static void printException(String str) {
    }
}

