/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class DotFont {
    public static boolean hasRead = false;
    public static final int[] verify = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    public static byte[] un2gbmap = null;
    public static int color = 0xFFFFFF;
    public static int dotWidth;
    public static short SINGLE_END_INDEX;
    public static String stringIndex;

    public static void loadFont() {
        if (un2gbmap == null) {
            try {
                DataInputStream ds = new DataInputStream("s".getClass().getResourceAsStream("/font12"));
                dotWidth = ds.readInt();
                SINGLE_END_INDEX = ds.readShort();
                un2gbmap = new byte[ds.readInt()];
                ds.read(un2gbmap);
                ds.close();
                ds = null;
            }
            catch (IOException ds) {
                // empty catch block
            }
            try {
                InputStream inputstream1 = "s".getClass().getResourceAsStream("/txt.txt");
                byte[] abyte = new byte[inputstream1.available()];
                inputstream1.read(abyte);
                stringIndex = new String(abyte, "UTF-8");
                inputstream1.close();
                inputstream1 = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.gc();
    }

    private static void drawEnglish(Graphics g2, int index, int x, int y) {
        int[] ai = new int[dotWidth * dotWidth / 2];
        DotFont.checkEn(index, ai, 0);
        int i2 = 0;
        while (i2 < dotWidth) {
            int j2 = 0;
            while (j2 < dotWidth / 2) {
                if (ai[i2 * dotWidth / 2 + j2] != 0) {
                    g2.setColor(ai[i2 * dotWidth / 2 + j2]);
                    g2.fillRect(x + j2, y + i2, 1, 1);
                }
                ++j2;
            }
            ++i2;
        }
    }

    private static void drawChinese(Graphics g2, int index, int x, int y) {
        int[] ai = new int[dotWidth * dotWidth];
        DotFont.checkCn(index, ai, 0);
        int i2 = 0;
        while (i2 < dotWidth) {
            int j2 = 0;
            while (j2 < dotWidth) {
                if (ai[i2 * dotWidth + j2] != 0) {
                    g2.setColor(ai[i2 * dotWidth + j2]);
                    g2.fillRect(x + j2, y + i2, 1, 1);
                }
                ++j2;
            }
            ++i2;
        }
    }

    public static void drawChars(Graphics g1, char[] ac1, int offset, int len, int x, int y, int alignment) {
        if ((alignment & 0x40) != 0) {
            y -= DotFont.getBaselinePosition();
        } else if ((alignment & 0x20) != 0) {
            y -= DotFont.getFontHeight();
        }
        if ((alignment & 9) != 0) {
            x -= DotFont.charsWidth(ac1, offset, len) >> (alignment & 1);
        }
        int i2 = offset;
        while (i2 < offset + len) {
            int index = DotFont.getStringIndex(ac1[i2]);
            if (index >= SINGLE_END_INDEX * dotWidth) {
                DotFont.drawChinese(g1, index, x, y);
            } else {
                DotFont.drawEnglish(g1, index, x, y);
            }
            x += DotFont.charWidth(ac1[i2]);
            ++i2;
        }
    }

    public static void drawChar(Graphics g1, char c2, int x, int y, int alignment) {
        int index;
        if ((alignment & 0x40) != 0) {
            y -= DotFont.getBaselinePosition();
        } else if ((alignment & 0x20) != 0) {
            y -= DotFont.getFontHeight();
        }
        if ((alignment & 9) != 0) {
            x -= DotFont.charWidth(c2) >> (alignment & 1);
        }
        if ((index = DotFont.getStringIndex(c2)) >= SINGLE_END_INDEX * dotWidth) {
            DotFont.drawChinese(g1, index, x, y);
        } else {
            DotFont.drawEnglish(g1, index, x, y);
        }
    }

    public static void drawSubString(Graphics g2, String string, int offset, int len, int x, int y, int alignment) {
        char[] c2 = new char[len];
        int k1 = 0;
        while (k1 < len) {
            c2[k1] = string.charAt(offset + k1);
            ++k1;
        }
        DotFont.drawChars(g2, c2, 0, len, x, y + 4, alignment);
    }

    public static void drawString(Graphics g2, String string, int x, int y, int alignment) {
        DotFont.drawString(color, g2, string, x, y, alignment);
    }

    public static void drawString(int color, Graphics g2, String string, int x, int y, int alignment) {
        DotFont.setFontColor(color);
        DotFont.drawSubString(g2, string, 0, string.length(), x, y, alignment);
    }

    private static void checkEn(int index, int[] ai, int i2) {
        int j1 = 0;
        while (j1 < dotWidth) {
            byte byte1 = un2gbmap[index++];
            int k1 = 0;
            while (k1 < dotWidth / 2) {
                ai[i2 + k1] = (byte1 & verify[k1]) == verify[k1] ? 0xFF000000 | color : 0;
                ++k1;
            }
            i2 += dotWidth / 2;
            ++j1;
        }
    }

    private static void checkCn(int index, int[] ai, int i2) {
        int k1 = 0;
        while (k1 < dotWidth) {
            byte byte2 = un2gbmap[index++];
            int l1 = 0;
            while (l1 < 8) {
                ai[i2 + l1] = (byte2 & verify[l1]) == verify[l1] ? 0xFF000000 | color : 0;
                ++l1;
            }
            byte2 = un2gbmap[index++];
            int i22 = 0;
            while (i22 < 8 - (dotWidth - 8)) {
                ai[i2 + 8 + i22] = (byte2 & verify[i22]) == verify[i22] ? 0xFF000000 | color : 0;
                ++i22;
            }
            i2 += dotWidth;
            ++k1;
        }
    }

    public static int getBaselinePosition() {
        return DotFont.getFontHeight() - DotFont.getFontHeight() / 3;
    }

    private static int getStringIndex(char c2) {
        int j1 = stringIndex.indexOf(c2);
        if (j1 == -1) {
            return 0;
        }
        if (j1 < SINGLE_END_INDEX) {
            return j1 * dotWidth;
        }
        return (j1 - SINGLE_END_INDEX) * dotWidth * 2 + SINGLE_END_INDEX * dotWidth;
    }

    public static void setFontColor(int c2) {
        color = c2;
    }

    public static int charWidth(char c1) {
        return (c1 < '\u0100' ? dotWidth / 2 : dotWidth) + 2;
    }

    public static int charsWidth(char[] c1, int offset, int len) {
        int width = 0;
        int i2 = offset;
        while (i2 < offset + len) {
            width += DotFont.charWidth(c1[i2]);
            ++i2;
        }
        return width;
    }

    public static int stringWidth(String s) {
        int width = 0;
        int length = s.length();
        int i2 = 0;
        while (i2 < length) {
            char c2 = s.charAt(i2);
            width += DotFont.charWidth(c2);
            ++i2;
        }
        return width;
    }

    public static int subStringWidth(String s, int offset, int len) {
        int width = 0;
        int i2 = offset;
        while (i2 < offset + len) {
            char c2 = s.charAt(i2);
            width += DotFont.charWidth(c2);
            ++i2;
        }
        return width;
    }

    public static int getFontHeight() {
        return dotWidth + 2;
    }
}

