/*
 * Decompiled with CFR 0.152.
 */
package wolverine;

import javax.microedition.lcdui.Graphics;
import net.jscience.math.kvm.MathFP;
import wolverine.World;

public abstract class Actor {
    private static final int FP_2PI = MathFP.mul(MathFP.PI, MathFP.toFP(2));
    private static final int FP_DEGS_PER_RAD = MathFP.div(MathFP.toFP(360), FP_2PI);
    private static int sinFP = MathFP.sin(Actor.getRadiansFromAngle(270));
    private static int cosFP = MathFP.cos(Actor.getRadiansFromAngle(270));
    public int id;
    public int x;
    public int y;
    public int xVel;
    public int yVel;
    public int startX;
    public int startY;
    public int xFP;
    public int yFP;
    public int lastXFP;
    public int lastYFP;
    private int xVelFP;
    private int yVelFP;
    private int xAccFP;
    private int yAccFP;
    private int thrustFP;
    private int maxVelFP;
    private int bounceFP;
    private long fluff = 0L;
    private Actor nextLinked;
    private Actor prevLinked;
    public Actor owner;
    public World world;
    public boolean collide;
    public boolean visible;
    public int actorLibPos;
    public long lastInitTime;
    public boolean startCycle;
    public int w;
    public int d;
    public int h;
    public boolean actorMoveWin;

    public Actor(World world) {
        this.world = world;
    }

    public void ini(Actor actor, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.owner = actor;
        this.setPos(n, n2);
        this.startX = this.x;
        this.startY = this.y;
        this.setThrust(n3);
        this.setVel(n4, n5);
        this.maxVelFP = MathFP.div(MathFP.toFP(n6), MathFP.toFP(10));
        this.bounceFP = MathFP.toFP(n7);
        this.collide = true;
        this.visible = true;
        this.lastInitTime = System.currentTimeMillis();
        this.startCycle = false;
    }

    public void reset() {
        this.setPos(this.startX, this.startY);
        this.setVel(0, 0);
    }

    public final Actor getNextLinked() {
        return this.nextLinked;
    }

    public final void setNextLinked(Actor actor) {
        this.nextLinked = actor;
    }

    public final Actor getPrevLinked() {
        return this.prevLinked;
    }

    public final void setPrevLinked(Actor actor) {
        this.prevLinked = actor;
    }

    public final void deactivate() {
        this.collide = false;
        this.visible = false;
    }

    public abstract void render(Graphics var1, int var2, int var3);

    public final void setPos(int n, int n2) {
        this.xFP = MathFP.toFP(n);
        this.x = n;
        this.yFP = MathFP.toFP(n2);
        this.y = n2;
    }

    public final void setVel(int n, int n2) {
        this.xVelFP = MathFP.div(MathFP.toFP(n), MathFP.toFP(10));
        this.yVelFP = MathFP.div(MathFP.toFP(n2), MathFP.toFP(10));
        if (this.xVelFP > this.maxVelFP) {
            this.xVelFP = this.maxVelFP;
        } else if (this.xVelFP < -this.maxVelFP) {
            this.xVelFP = -this.maxVelFP;
        }
        if (this.yVelFP > this.maxVelFP) {
            this.yVelFP = this.maxVelFP;
        } else if (this.yVelFP < -this.maxVelFP) {
            this.yVelFP = -this.maxVelFP;
        }
    }

    public final void setVelX(int n) {
        this.xVelFP = MathFP.div(MathFP.toFP(n), MathFP.toFP(10));
        if (this.xVelFP > this.maxVelFP) {
            this.xVelFP = this.maxVelFP;
        } else if (this.xVelFP < -this.maxVelFP) {
            this.xVelFP = -this.maxVelFP;
        }
    }

    public final void setVelY(int n) {
        this.yVelFP = MathFP.div(MathFP.toFP(n), MathFP.toFP(10));
        if (this.yVelFP > this.maxVelFP) {
            this.yVelFP = this.maxVelFP;
        } else if (this.yVelFP < -this.maxVelFP) {
            this.yVelFP = -this.maxVelFP;
        }
    }

    public final int getVelX() {
        return MathFP.toInt(this.xVelFP) * 10;
    }

    public final int getVelY() {
        return MathFP.toInt(this.yVelFP) * 10;
    }

    public final void setThrust(int n) {
        this.thrustFP = MathFP.div(n, MathFP.toFP(10));
    }

    public final int getThrust() {
        return MathFP.toInt(this.thrustFP);
    }

    public final boolean actionCollideWith(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return false;
        }
        return this.x + this.w >= n && this.x - this.w <= n + n3 && this.y >= n2 && this.y - this.h <= n2 + n4;
    }

    public final boolean motionCollideWith(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return false;
        }
        return this.x + this.w >= n && this.x - this.w <= n + n3 && this.y >= n2 && this.y - this.d <= n2 + n4;
    }

    public void suicide() {
    }

    public void cycle(long l) {
        int n = (int)(l + this.fluff) / 50;
        this.fluff += l - (long)(n * 50);
        if (n > 0) {
            int n2 = MathFP.toFP(n);
            if (this.thrustFP != 0) {
                this.xAccFP = MathFP.mul(this.thrustFP, cosFP);
                this.yAccFP = MathFP.mul(this.thrustFP, -sinFP);
                this.xVelFP = MathFP.add(this.xVelFP, this.xAccFP);
                this.yVelFP = MathFP.add(this.yVelFP, this.yAccFP);
            }
            if (this.xVelFP > this.maxVelFP) {
                this.xVelFP = this.maxVelFP;
            } else if (this.xVelFP < -this.maxVelFP) {
                this.xVelFP = -this.maxVelFP;
            }
            if (this.yVelFP > this.maxVelFP) {
                this.yVelFP = this.maxVelFP;
            } else if (this.yVelFP < -this.maxVelFP) {
                this.yVelFP = -this.maxVelFP;
            }
            this.lastXFP = this.xFP;
            this.lastYFP = this.yFP;
            this.xFP = MathFP.add(this.xFP, MathFP.mul(this.xVelFP, n2));
            this.x = MathFP.toInt(this.xFP);
            if (this.world.checkMotionCol(this, this.x - this.w, this.y - this.d, this.w * 2, this.d)) {
                this.xFP = this.lastXFP;
                this.x = MathFP.toInt(this.xFP);
            }
            this.yFP = MathFP.add(this.yFP, MathFP.mul(this.yVelFP, n2));
            this.y = MathFP.toInt(this.yFP);
            if (this.world.checkMotionCol(this, this.x - this.w, this.y - this.d, this.w * 2, this.d)) {
                this.yFP = this.lastYFP;
                this.y = MathFP.toInt(this.yFP);
            }
            if (this.actorMoveWin) {
                int n3 = 0;
                int n4 = 0;
                if (this.xVelFP > 0) {
                    n3 = 1;
                } else if (this.xVelFP < 0) {
                    n3 = 2;
                }
                if (this.yVelFP > 0) {
                    n4 = 3;
                } else if (this.yVelFP < 0) {
                    n4 = 4;
                }
                if (n3 == 0 && n4 == 0) {
                    this.world.moveWin(this);
                } else {
                    this.world.moveWin(this.x, this.y, n3, n4);
                }
            }
        }
    }

    public final boolean isPlayer() {
        return this.id > 0 && this.id < 101;
    }

    public final boolean isEnemy() {
        return this.id > 100 && this.id < 10001;
    }

    public final boolean isEnemyFish() {
        return this.id > 100 && this.id < 10001 && this.id % 100 < 51;
    }

    public final boolean isEnemyHead() {
        return this.id > 100 && this.id < 10001 && this.id % 100 > 50 && this.id % 100 < 81;
    }

    public final boolean isEnemyBoss() {
        return this.id > 100 && this.id < 10001 && this.id % 100 > 80;
    }

    public final boolean isMobileGoblin() {
        return this.id > 20000 && this.id < 21001;
    }

    public final boolean isMobileMobile() {
        return this.id > 21000 && this.id < 22001;
    }

    public final boolean isMobileChest() {
        return this.id > 22000 && this.id < 23001;
    }

    public final boolean isMobileGate() {
        return this.id > 23000 && this.id < 25001;
    }

    public final boolean isMobileThorn() {
        return this.id > 25000 && this.id < 26001;
    }

    public final boolean isMobileMach() {
        return this.id > 26000 && this.id < 27001;
    }

    public final boolean isMobileFloat() {
        return this.id > 27000 && this.id < 28001;
    }

    public static final int getRadiansFromAngle(int n) {
        return MathFP.div(MathFP.toFP(n), FP_DEGS_PER_RAD);
    }
}

