/*
 * Decompiled with CFR 0.152.
 */
package wolverine;

import javax.microedition.lcdui.Graphics;
import wolverine.Actor;
import wolverine.Battle;
import wolverine.Box;
import wolverine.Goblin;
import wolverine.InfoLib;
import wolverine.Reborn;
import wolverine.Screen;
import wolverine.World;

public class Role
extends Actor {
    public InfoLib infoLib;
    public Goblin roleGoblin;
    public boolean showShadow;
    public Goblin shadowGoblin;
    public boolean showStrike;
    public Goblin strikeGoblin;
    public boolean rageState;
    public Goblin rageGoblin;
    public boolean isActing;
    public int curFace;
    public int xFace;
    public int yFace;
    public static final int FACE2R = 1;
    public static final int FACE2L = 2;
    public static final int FACE2D = 3;
    public static final int FACE2U = 4;
    public int xMove;
    public int yMove;
    public static final int MOVE2R = 1;
    public static final int MOVE2L = 2;
    public static final int MOVE2D = 3;
    public static final int MOVE2U = 4;
    public static final int MOVEXN = 5;
    public static final int MOVEYN = 6;
    public int roleState;
    public static final int STATE_STOP = 1;
    public static final int STATE_MOVE = 2;
    public static final int STATE_HIT = 3;
    public static final int STATE_HOV = 4;
    public static final int STATE_FLY = 5;
    public static final int STATE_LIE = 6;
    public static final int STATE_DIE = 7;
    public static final int STATE_TAKE = 8;
    public static final int STATE_COMBO = 11;
    public static final int STATE_SKILL = 12;
    public static final int STATE_FOCUS = 13;
    public static final int STATE_MUSOU = 14;
    public static final int STATE_CLASH = 15;
    public static final int STATE_RUN = 21;
    public static final int STATE_EFLY = 22;
    public static final int STATE_FFLY = 23;
    public static final int STATE_RIGOR = 24;
    public static final int STATE_SACTION = 101;
    public static final int STATE_SFLY = 111;
    public static final int STATE_SFOCUS = 112;
    public static final int STATE_SCHANGE = 113;
    public static final int STATE_SFADEIN = 114;
    public static final int STATE_SFADEOUT = 115;
    public static final int STATE_SLOSE = 121;
    public static final int STATE_SWAIT = 122;
    public static final int STATE_SFLASH = 123;
    public int roleAction;
    public static final int ACTION_STOP = 0;
    public static final int ACTION_MOVE = 1;
    public static final int ACTION_HIT = 2;
    public static final int ACTION_HOV = 3;
    public static final int ACTION_FLY = 4;
    public static final int ACTION_LIE = 5;
    public static final int ACTION_DIE = 6;
    public static final int ACTION_RUN = 7;
    public static final int ACTION_COMBO1 = 10;
    public static final int ACTION_COMBO2 = 11;
    public static final int ACTION_COMBO3 = 12;
    public static final int ACTION_COMBO4 = 13;
    public static final int ACTION_COMBO5 = 14;
    public static final int ACTION_COMBO6 = 15;
    public static final int ACTION_COMBO7 = 16;
    public static final int ACTION_MUSOU1 = 10;
    public static final int ACTION_MUSOU2 = 11;
    public static final int ACTION_MUSOU3 = 12;
    public static final int ACTION_MUSOU4 = 13;
    public static final int ACTION_MUSOU5 = 14;
    public static final int ACTION_MUSOU6 = 15;
    public static final int ACTION_MUSOU7 = 17;
    public static final int ACTION_MUSOU8 = 18;
    public static final int ACTION_MUSOU9 = 21;
    public static final int ACTION_CLASH = 24;
    public int msPerDamage;
    public long msSinceLastDamage;
    public int msPerAIUpdate;
    public long msSinceLastAIUpdate;
    public int hp;
    public int sp;
    public static int[][] combos = new int[][]{{10, 11, 12, 13, 14, 15, 13, 16, 0}};
    public int[] combo;
    public int comboIdx;
    public int comboOldIdx;
    public static int[][] musous = new int[][]{{21, 15, 17, 15, 17, 11, 12, 13, 12, 11, 17, 17, 17, 18, 0}};
    public int[] musou = musous[0];
    public int musouIdx;
    public int musouOldIdx;
    public int skillIdx;
    private Screen screen;
    public int takePosX;
    public int takePosY;
    public int subAnima;
    public int fly2;
    public int flyVelX = 60;
    public int flyVelY1 = 20;
    public int flyVelY2 = 30;
    public int musou2;
    public Role atter;
    public int damageIdx;
    public int roleHead;
    public boolean clashing;
    public int clashVel = 80;
    public boolean harming;
    public long harmTime;
    public long harmDura = 2000L;
    public boolean holding;
    public long holdTime;
    public long holdDura = 2000L;
    public boolean traceSkill;
    public long traceTime;
    public long traceDura = 6000L;
    public boolean rangeSkill;
    public int comboH = 15;
    public int musouH = 30;
    public boolean strikeState;
    public Battle battle;
    public boolean showAlert;
    public Goblin alertGoblin;
    public int xVelSave;
    public int yVelSave;
    public int preAction;
    public int scriptDone;
    public boolean showPick;
    public Goblin pickGoblin;
    public boolean breakCombo;
    public boolean afterPress;
    public boolean showUpgrade;

    public Role(Screen screen, World world) {
        super(world);
        this.screen = screen;
        this.shadowGoblin = new Goblin(this.screen.addSpriteData, 0, 0);
        this.strikeGoblin = new Goblin(this.screen.comboSpriteData, 23, 0);
        this.alertGoblin = new Goblin(this.screen.alertSpriteData, 0, 0);
        this.pickGoblin = new Goblin(this.screen.pickSpriteData, 0, 0);
        this.hp = -1;
        this.sp = -1;
        this.msPerDamage = 200;
    }

    public final void ini(int n, int n2, int n3, int n4) {
        this.showShadow = true;
        this.showStrike = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 1000;
        int n9 = 0;
        if (n == 0 && n2 == 0) {
            if (this.infoLib == null) {
                this.infoLib = this.world.roleInfoLibs[n];
            }
            if (this.roleGoblin == null) {
                this.roleGoblin = new Goblin(this.world.roleImageLibs[n2], 0, 0, true);
            }
            this.w = this.world.roleMainW;
            this.d = this.world.roleMainD;
            this.h = this.world.roleMainH;
            this.xVel = this.world.roleMainVelX;
            this.yVel = this.world.roleMainVelY;
            this.actorMoveWin = true;
        } else {
            this.infoLib = null;
            this.roleGoblin = null;
            this.id = this.world.roleInfoLibs[n].id;
            if (this.isEnemyFish()) {
                this.infoLib = this.world.roleInfoLibs[n];
                this.w = this.world.roleFishW;
                this.d = this.world.roleFishD;
                this.h = this.world.roleFishH;
                this.xVel = this.world.roleFishVelX;
                this.yVel = this.world.roleFishVelY;
            } else if (this.isEnemyHead()) {
                this.infoLib = new InfoLib(this.world.roleInfoLibs[n]);
                this.w = this.world.roleHeadW;
                this.d = this.world.roleHeadD;
                this.h = this.world.roleHeadH;
                this.xVel = this.world.roleHeadVelX;
                this.yVel = this.world.roleHeadVelY;
            } else if (this.isEnemyBoss()) {
                this.infoLib = new InfoLib(this.world.roleInfoLibs[n]);
                this.w = this.world.roleBossW;
                this.d = this.world.roleBossD;
                this.h = this.world.roleBossH;
                this.xVel = this.world.roleBossVelX;
                this.yVel = this.world.roleBossVelY;
            }
            this.roleGoblin = new Goblin(this.world.roleImageLibs[n2], 0, 0);
            this.actorMoveWin = false;
        }
        this.id = this.infoLib.id;
        if (this.isPlayer()) {
            this.xFace = 1;
            this.yFace = 3;
            this.xMove = 1;
            this.yMove = 6;
            this.curFace = this.xFace;
            this.world.playerUpdate();
            this.hp = this.infoLib.hpMax;
            this.sp = this.infoLib.spMax;
        } else {
            if (n3 > this.world.player.x) {
                this.xFace = 2;
                this.yFace = 3;
                this.xMove = 2;
                this.yMove = 6;
                this.curFace = this.xFace;
            } else {
                this.xFace = 1;
                this.yFace = 3;
                this.xMove = 1;
                this.yMove = 6;
                this.curFace = this.xFace;
            }
            this.hp = this.infoLib.hp * this.screen.menuHardLvs[this.screen.menuHardIdx];
            this.sp = this.infoLib.sp * this.screen.menuHardLvs[this.screen.menuHardIdx];
        }
        this.setAction(0, true);
        this.roleState = 1;
        this.isActing = false;
        this.msPerAIUpdate = 500;
        if (this.rageGoblin == null) {
            this.rageGoblin = new Goblin(this.screen.addSpriteData, 1, 0);
        }
        if (this.id % 100 == 85) {
            this.world.senBattle = true;
            this.world.senBodyGoblin = new Goblin(this.world.roleImageLibs[this.world.roleImageLibs.length - 1], 0, 0, true);
            this.world.senArmsGoblin = new Goblin(this.world.roleImageLibs[this.world.roleImageLibs.length - 1], 0, 0, true);
            this.world.senPosX = this.x;
            this.world.senPosY = this.y;
            this.showShadow = false;
        }
        super.ini(null, n3, n4, n5, n6, n7, n8, n9);
    }

    public final void takeDamage() {
        int n;
        if (this.hp == 0) {
            return;
        }
        int n2 = 0;
        if (this.atter.isPlayer()) {
            int n3;
            n = 0;
            if (this.atter.roleState == 11 || this.atter.roleState == 15) {
                n2 = this.screen.playerComboDamageBase + this.screen.playerComboDamageStep * this.screen.playerLv;
                n = n2 / this.screen.playerComboDamageMod;
            } else if (this.atter.roleState == 12) {
                n2 = this.screen.playerSkillDamageBase + this.screen.playerSkillDamageStep * this.screen.playerLv;
                n = n2 / this.screen.playerSkillDamageMod;
            } else if (this.atter.roleState == 14) {
                n2 = this.screen.playerMusouDamageBase + this.screen.playerMusouDamageStep * this.screen.playerLv;
                n = n2 / this.screen.playerMusouDamageMod;
            }
            if (this.atter.damageIdx == 1) {
                n2 += n;
            } else if (this.atter.damageIdx == 2) {
                n2 -= n;
            }
            ++this.atter.damageIdx;
            if (this.atter.damageIdx > 2) {
                this.atter.damageIdx = 0;
            }
            if (this.atter.strikeState) {
                this.showStrike = true;
                n3 = 0;
                n3 = this.world.playerStrikeDamageBase + (this.screen.roleLvs[0] - 1) * this.world.playerStrikeDamageStep;
                n2 = n2 * n3 / 100;
            }
            if (this.atter.rageState) {
                n2 *= 2;
            }
            if (this.atter.roleState == 11 || this.atter.roleState == 15) {
                n3 = n2 / this.world.playerSPGain;
                this.world.player.sp += n3;
                if (this.world.player.sp > this.world.player.infoLib.spMax) {
                    this.world.player.sp = this.world.player.infoLib.spMax;
                }
                this.screen.updateShowPress();
            }
            if (this.battle.state == 0) {
                for (n3 = 0; n3 < this.world.mapBattles.length && this.world.mapBattleEnable; ++n3) {
                    Object object;
                    if (this.battle.guardArea.add != this.world.mapBattles[n3].guardArea.add) continue;
                    boolean bl = true;
                    if (this.world.mapBattles[n3].reborns.length > 0) {
                        object = this.world.mapBattles[n3].reborns[0];
                        if (((Reborn)object).trigDone[((Reborn)object).trigIdx] == 0) {
                            if (((Reborn)object).trigInfo[((Reborn)object).trigIdx] > 0) {
                                for (int i = 0; i < ((Reborn)object).trigInfo[((Reborn)object).trigIdx]; ++i) {
                                    if (this.world.mapBattles[n3].scripts.length > 0) {
                                        bl = false;
                                        break;
                                    }
                                    this.world.reborn(this.world.mapBattles[n3]);
                                }
                            }
                            ++((Reborn)object).trigIdx;
                            if (!bl) {
                                --((Reborn)object).trigIdx;
                            }
                        }
                    }
                    for (object = this.world.enemyPool.getFirstUsed(); object != null; object = ((Actor)object).getNextLinked()) {
                        Role role = (Role)object;
                        if (role.battle.guardArea.add != this.world.mapBattles[n3].guardArea.add) continue;
                        role.showAlert = true;
                        bl = false;
                    }
                    if (bl) {
                        this.world.mapBattleState[n3] = 3;
                        this.world.mapBattles[n3].state = 3;
                    } else {
                        this.world.mapBattleState[n3] = 2;
                        this.world.mapBattles[n3].state = 2;
                        this.world.shutGates();
                    }
                    if (this.world.mapBattles[n3].scripts.length <= 0) continue;
                    this.screen.startScript(this.world.mapBattles[n3].scripts[0].info);
                    this.screen.rebornSave = n3;
                }
            }
        } else {
            n2 = this.atter.infoLib.skills[this.atter.skillIdx].skillDamage;
            this.screen.scoreDamage += (n2 *= this.screen.menuHardLvs[this.screen.menuHardIdx]);
            n = n2 * 2 / this.world.playerSPGain;
            if (this.rageState) {
                n *= 2;
            }
            this.sp += n;
            if (this.sp > this.infoLib.spMax) {
                this.sp = this.infoLib.spMax;
            }
            this.screen.updateShowPress();
        }
        this.hp -= n2;
        if (this.hp < 0) {
            n2 += this.hp;
            this.hp = 0;
        }
        if (this.hp > 0) {
            if (this.atter.isPlayer() && this.isEnemyFish() && !this.screen.showFishInf) {
                this.screen.showFishInf = true;
                this.screen.roleInfType = 1;
                this.screen.showInf = true;
                this.screen.roleInfName = this.infoLib.name;
                this.screen.roleInfHP = this.hp;
                this.screen.roleHead = this.roleHead;
                this.screen.roleInfHPMax = this.infoLib.hp * this.screen.menuHardLvs[this.screen.menuHardIdx];
                this.screen.showDone = false;
            }
            if (this.atter.isPlayer() && this.isEnemyHead() && !this.screen.showHeadInf) {
                this.screen.showHeadInf = true;
                this.screen.showFishInf = true;
                this.screen.roleInfType = 2;
                this.screen.showInf = true;
                this.screen.roleInfName = this.infoLib.name;
                this.screen.roleInfHP = this.hp;
                this.screen.roleHead = this.roleHead;
                this.screen.roleInfHPMax = this.infoLib.hp * this.screen.menuHardLvs[this.screen.menuHardIdx];
                this.screen.showDone = false;
            }
            if (this.atter.isPlayer() && this.isEnemyBoss() && !this.screen.showBossInf) {
                this.screen.showBossInf = true;
                this.screen.showHeadInf = true;
                this.screen.showFishInf = true;
                this.screen.roleInfType = 3;
                if (this.id == 981 || this.id == 982) {
                    this.screen.roleInfType = 4;
                }
                this.screen.showInf = true;
                this.screen.roleInfName = this.infoLib.name;
                this.screen.roleInfHP = this.hp;
                this.screen.roleHead = this.roleHead;
                this.screen.roleInfHPMax = this.infoLib.hp * this.screen.menuHardLvs[this.screen.menuHardIdx];
                this.screen.showDone = false;
            }
        } else {
            if (this.atter.isPlayer() && this.isEnemyFish() && !this.screen.showFishInf) {
                this.screen.showFishInf = true;
                this.screen.roleInfType = 1;
                this.screen.showInf = true;
                this.screen.roleInfName = this.infoLib.name;
                this.screen.roleInfHP = this.hp;
                this.screen.roleHead = this.roleHead;
                this.screen.roleInfHPMax = this.infoLib.hp * this.screen.menuHardLvs[this.screen.menuHardIdx];
                this.screen.showDone = true;
                this.screen.roleDoneTime = System.currentTimeMillis();
            }
            if (this.atter.isPlayer() && this.isEnemyHead() && !this.screen.showHeadInf) {
                this.screen.showHeadInf = true;
                this.screen.showFishInf = true;
                this.screen.roleInfType = 2;
                this.screen.showInf = true;
                this.screen.roleInfName = this.infoLib.name;
                this.screen.roleInfHP = this.hp;
                this.screen.roleHead = this.roleHead;
                this.screen.roleInfHPMax = this.infoLib.hp * this.screen.menuHardLvs[this.screen.menuHardIdx];
                this.screen.showDone = true;
                this.screen.roleDoneTime = System.currentTimeMillis();
            }
            if (this.atter.isPlayer() && this.isEnemyBoss() && !this.screen.showBossInf) {
                this.screen.showBossInf = true;
                this.screen.showHeadInf = true;
                this.screen.showFishInf = true;
                this.screen.roleInfType = 3;
                if (this.id == 981 || this.id == 982) {
                    this.screen.roleInfType = 4;
                }
                this.screen.showInf = true;
                this.screen.roleInfName = this.infoLib.name;
                this.screen.roleInfHP = this.hp;
                this.screen.roleHead = this.roleHead;
                this.screen.roleInfHPMax = this.infoLib.hp * this.screen.menuHardLvs[this.screen.menuHardIdx];
                this.screen.showDone = true;
                this.screen.roleDoneTime = System.currentTimeMillis();
            }
            if (this.roleState != 5) {
                this.roleState = 5;
                this.isActing = false;
            }
            if (this.atter.isPlayer()) {
                ++this.screen.scoreEnemyDone;
                if (this.isEnemyBoss()) {
                    Actor actor;
                    this.world.noMoreBoss = true;
                    for (actor = this.world.enemyPool.getFirstUsed(); actor != null; actor = actor.getNextLinked()) {
                        if (actor.id == this.id || !actor.isEnemyBoss()) continue;
                        Role role = (Role)actor;
                        if (role.hp <= 0) continue;
                        this.world.noMoreBoss = false;
                        break;
                    }
                    if (this.world.noMoreBoss) {
                        this.world.player.breakCombo = true;
                        this.screen.pending = true;
                        this.screen.pendDura = 2000;
                        this.screen.pendTime = System.currentTimeMillis();
                        this.screen.pause();
                        this.screen.waiting = true;
                        for (actor = this.world.enemyPool.getFirstUsed(); actor != null; actor = actor.getNextLinked()) {
                            Role role = (Role)actor;
                            role.atter = this.world.player;
                            if (role.roleState != 5) {
                                role.roleState = 5;
                                role.isActing = false;
                            }
                            if (role.hp > 0) {
                                role.hp = 0;
                                ++this.screen.scoreEnemyDone;
                            }
                            if (this.id % 100 != 85) continue;
                            this.roleState = 7;
                            System.out.println("\u54e8\u5175\u6253\u98de\u53d8\u6210\u5012\u5730\u6b7b\u4ea1");
                        }
                        for (int i = 0; i < this.world.mapBattles.length; ++i) {
                            this.world.mapBattleState[i] = 3;
                            this.world.mapBattles[i].state = 3;
                        }
                    }
                }
            } else {
                this.screen.pending = true;
                this.screen.pendDura = 2000;
                this.screen.pendTime = System.currentTimeMillis();
                this.screen.pause();
                this.screen.waiting = true;
            }
        }
        if (this.atter.isPlayer() && this.world.roleScenaId == this.id && this.world.roleScenaTrig >= this.hp) {
            this.screen.startScript(this.world.roleScenaScript);
            this.world.roleScenaId = 0;
            this.world.roleScenaTrig = -1;
            this.world.roleScenaScript = 0;
            this.roleState = 1;
            if (this.world.noMoreBoss) {
                this.screen.waiting = false;
                this.battle.state = 2;
                for (int i = 0; i < this.world.mapBattles.length; ++i) {
                    if (this.battle.guardArea.add != this.world.mapBattles[i].guardArea.add) continue;
                    this.world.mapBattleState[i] = 2;
                    this.world.mapBattles[i].state = 2;
                }
            }
        }
        this.msSinceLastDamage = System.currentTimeMillis();
    }

    public final void cycle(long l) {
        int n;
        int n2;
        super.cycle(l);
        this.roleGoblin.cycle(l);
        if (this.roleGoblin.isMovFrame) {
            n2 = this.x;
            if (this.xFace == 1) {
                if (this.roleGoblin.dirMove == 1) {
                    this.x += this.roleGoblin.disMove;
                } else if (this.roleGoblin.dirMove == 2) {
                    this.x -= this.roleGoblin.disMove;
                }
            } else if (this.xFace == 2) {
                if (this.roleGoblin.dirMove == 1) {
                    this.x -= this.roleGoblin.disMove;
                } else if (this.roleGoblin.dirMove == 2) {
                    this.x += this.roleGoblin.disMove;
                }
            }
            if (this.world.checkMotionCol(this, this.x - this.w, this.y - this.d, 2 * this.w, this.d)) {
                this.x = n2;
            }
            this.setPos(this.x, this.y);
        }
        if (this.id % 100 == 85) {
            this.world.senPosX = this.x;
            this.world.senPosY = this.y;
        }
        if (this.isPlayer()) {
            if (this.isActing && this.roleGoblin.getCycleTotal() > 0) {
                switch (this.roleState) {
                    case 1: 
                    case 3: 
                    case 6: {
                        this.roleState = 1;
                        this.isActing = false;
                        if (this.scriptDone != 1) break;
                        this.screen.scriptDone = true;
                        break;
                    }
                    case 4: {
                        this.setVel(0, 0);
                        this.roleState = 6;
                        this.isActing = false;
                        break;
                    }
                    case 5: 
                    case 22: 
                    case 23: 
                    case 111: {
                        this.setVel(0, 0);
                        this.roleState = this.hp == 0 ? 7 : 6;
                        this.isActing = false;
                        break;
                    }
                    case 7: {
                        this.suicide();
                        break;
                    }
                    case 11: {
                        if (this.combo[this.comboIdx] != 0 && this.comboIdx != this.comboOldIdx) {
                            this.setAction(this.combo[this.comboIdx], true);
                            this.comboOldIdx = this.comboIdx;
                            this.afterPress = false;
                        } else {
                            this.comboIdx = 0;
                            this.comboOldIdx = 0;
                            this.roleState = 1;
                            this.isActing = false;
                            this.setVel(0, 0);
                            this.breakCombo = false;
                        }
                        if (!this.clashing) break;
                        this.clashing = false;
                        this.roleState = 15;
                        this.isActing = false;
                        this.setVel(0, 0);
                        break;
                    }
                    case 13: {
                        this.roleState = 14;
                        this.isActing = false;
                        this.setVel(0, 0);
                        break;
                    }
                    case 14: {
                        if (this.musou[this.musouIdx] != 0 && this.musouIdx != this.musouOldIdx) {
                            this.curFace = this.musou2;
                            this.setAction(this.musou[this.musouIdx], true);
                            this.musouOldIdx = this.musouIdx;
                            this.musouIdx = this.musouOldIdx + 1;
                            break;
                        }
                        this.musouIdx = 0;
                        this.musouOldIdx = 0;
                        this.setVel(0, 0);
                        this.roleState = 1;
                        this.isActing = false;
                        this.collide = true;
                        break;
                    }
                    case 12: 
                    case 15: {
                        this.setVel(0, 0);
                        this.roleState = 1;
                        this.isActing = false;
                        this.collide = true;
                        break;
                    }
                    case 2: 
                    case 8: 
                    case 21: {
                        break;
                    }
                    case 101: {
                        this.roleState = this.preAction;
                        this.isActing = false;
                        if (this.scriptDone != 1) break;
                        this.screen.scriptDone = true;
                        break;
                    }
                    case 112: {
                        this.roleState = 113;
                        this.isActing = false;
                        this.setVel(0, 0);
                        break;
                    }
                    case 113: {
                        this.roleState = 1;
                        this.isActing = false;
                        this.setVel(0, 0);
                        this.screen.scriptDone = true;
                        break;
                    }
                    case 121: {
                        break;
                    }
                }
            }
            switch (this.roleState) {
                case 1: {
                    this.collide = true;
                    this.setAction(0, false);
                    this.setVel(0, 0);
                    break;
                }
                case 2: {
                    if (this.isActing) break;
                    this.switchAction(1, true);
                    switch (this.xMove) {
                        case 1: {
                            this.setVel(this.xVel, 0);
                            break;
                        }
                        case 2: {
                            this.setVel(-this.xVel, 0);
                        }
                    }
                    switch (this.yMove) {
                        case 3: {
                            this.setVel(0, this.yVel);
                            break;
                        }
                        case 4: {
                            this.setVel(0, -this.yVel);
                        }
                    }
                    break;
                }
                case 21: {
                    if (this.isActing) break;
                    this.collide = true;
                    this.setAction(7, false);
                    switch (this.xMove) {
                        case 1: {
                            this.setVel(this.xVel, 0);
                            break;
                        }
                        case 2: {
                            this.setVel(-this.xVel, 0);
                        }
                    }
                    switch (this.yMove) {
                        case 3: {
                            this.setVel(0, this.yVel);
                            break;
                        }
                        case 4: {
                            this.setVel(0, -this.yVel);
                        }
                    }
                    break;
                }
                case 3: {
                    if (this.isActing) break;
                    this.switchAction(2, true);
                    this.takeDamage();
                    break;
                }
                case 4: {
                    if (this.isActing) break;
                    this.switchAction(3, true);
                    this.takeDamage();
                    break;
                }
                case 5: {
                    if (this.isActing) break;
                    this.switchAction(4, false);
                    this.takeDamage();
                    n2 = 0;
                    n = 0;
                    if (this.curFace == 1) {
                        n2 = -this.flyVelX;
                    } else if (this.curFace == 2) {
                        n2 = this.flyVelX;
                    }
                    if (this.fly2 == 3) {
                        n = this.flyVelY1;
                    } else if (this.fly2 == 4) {
                        n = -this.flyVelY1;
                    } else if (this.fly2 == 1) {
                        n = this.flyVelY2;
                    } else if (this.fly2 == 2) {
                        n = -this.flyVelY2;
                    }
                    this.setVel(n2, n);
                    break;
                }
                case 6: {
                    this.switchAction(5, false);
                    break;
                }
                case 7: {
                    this.switchAction(6, false);
                    this.setVel(0, 0);
                    break;
                }
                case 8: {
                    if (!this.isActing) {
                        this.switchAction(7, false);
                        switch (this.xMove) {
                            case 1: {
                                this.setVelX(this.xVel);
                                break;
                            }
                            case 2: {
                                this.setVelX(-this.xVel);
                            }
                        }
                        switch (this.yMove) {
                            case 3: {
                                this.setVelY(this.yVel);
                                break;
                            }
                            case 4: {
                                this.setVelY(-this.yVel);
                            }
                        }
                        this.holdTime = System.currentTimeMillis();
                        break;
                    }
                    if (System.currentTimeMillis() - this.holdTime > this.holdDura) {
                        if (this.xFP == this.lastXFP && this.yFP == this.lastYFP) {
                            this.roleTaken();
                            return;
                        }
                        this.holdTime = System.currentTimeMillis();
                    }
                    switch (this.xMove) {
                        case 1: {
                            if (this.x <= this.takePosX) break;
                            this.setVelX(0);
                            break;
                        }
                        case 2: {
                            if (this.x >= this.takePosX) break;
                            this.setVelX(0);
                        }
                    }
                    switch (this.yMove) {
                        case 3: {
                            if (this.y <= this.takePosY) break;
                            this.setVelY(0);
                            break;
                        }
                        case 4: {
                            if (this.y >= this.takePosY) break;
                            this.setVelY(0);
                        }
                    }
                    if (this.getVelX() != 0 || this.getVelY() != 0) break;
                    this.roleTaken();
                    break;
                }
                case 11: {
                    if (!this.isActing) {
                        this.comboIdx = 0;
                        this.comboOldIdx = 0;
                        this.switchAction(this.combo[this.comboIdx], true);
                        this.breakCombo = false;
                        this.afterPress = false;
                        this.clashing = false;
                        break;
                    }
                    if (this.roleGoblin.isActFrame) {
                        this.roleGoblin.isActFrame = false;
                        this.roleGoblin.gplayer.isActFrame = false;
                        this.screen.showFishInf = false;
                        this.screen.showHeadInf = false;
                        this.screen.showBossInf = false;
                        this.world.checkActionCol(this, this.comboH);
                        if (this.screen.slowing && this.screen.slowFree) {
                            this.screen.slowDura = 0;
                        }
                    }
                    if (!this.breakCombo) {
                        if (!this.roleGoblin.isInaFrame) break;
                        this.roleGoblin.isInaFrame = false;
                        this.roleGoblin.gplayer.isInaFrame = false;
                        this.comboIdx = this.comboOldIdx + 1;
                        this.setAction(this.combo[this.comboIdx], true);
                        this.comboOldIdx = this.comboIdx;
                        break;
                    }
                    if (!this.roleGoblin.isInaFrame) break;
                    this.roleGoblin.isInaFrame = false;
                    this.roleGoblin.gplayer.isInaFrame = false;
                    if (this.comboIdx != this.comboOldIdx) {
                        this.roleGoblin.gplayer.cycleTotal = 1;
                    }
                    this.afterPress = true;
                    break;
                }
                case 12: {
                    if (!this.isActing) {
                        this.switchAction(19, false);
                        break;
                    }
                    if (!this.roleGoblin.isActFrame) break;
                    this.roleGoblin.isActFrame = false;
                    this.roleGoblin.gplayer.isActFrame = false;
                    this.screen.showFishInf = false;
                    this.screen.showHeadInf = false;
                    this.screen.showBossInf = false;
                    this.world.checkGroundCol(this, (this.screen.roleLvs[1] - 1) * this.world.playerSkillRangeStep, this.screen.roleLvs[1] - 1);
                    break;
                }
                case 13: {
                    if (this.isActing) break;
                    this.switchAction(20, false);
                    this.screen.pending = true;
                    this.screen.pendTime = System.currentTimeMillis();
                    this.screen.pendDura = 5000;
                    this.screen.pendFree = true;
                    this.screen.pause();
                    this.screen.comboTime += 5000L;
                    if (!this.screen.slowing || !this.screen.slowFree) break;
                    this.screen.slowDura = 0;
                    break;
                }
                case 14: {
                    if (!this.isActing) {
                        this.musouIdx = 0;
                        this.musouOldIdx = 0;
                        this.switchAction(this.musou[this.musouIdx], false);
                        this.musouIdx = this.musouOldIdx + 1;
                        this.musou2 = this.curFace;
                        if (!this.screen.pending || !this.screen.pendFree) break;
                        this.screen.pendDura = 0;
                        break;
                    }
                    if (this.roleGoblin.isActFrame) {
                        this.roleGoblin.isActFrame = false;
                        this.roleGoblin.gplayer.isActFrame = false;
                        this.screen.showFishInf = false;
                        this.screen.showHeadInf = false;
                        this.screen.showBossInf = false;
                        if (this.musouIdx == 1) {
                            this.world.checkGroundCol(this, (this.screen.roleLvs[2] - 1) * this.world.playerMusouRangeStep, this.screen.roleLvs[2] - 1);
                        } else {
                            this.world.checkActionCol(this, this.musouH);
                        }
                    }
                    if (!this.roleGoblin.isInaFrame) break;
                    this.roleGoblin.isInaFrame = false;
                    this.roleGoblin.gplayer.isInaFrame = false;
                    this.curFace = this.musou2;
                    this.setAction(this.musou[this.musouIdx], true);
                    this.musouOldIdx = this.musouIdx;
                    this.musouIdx = this.musouOldIdx + 1;
                    break;
                }
                case 15: {
                    if (!this.isActing) {
                        this.switchAction(16, true);
                        break;
                    }
                    if (!this.roleGoblin.isActFrame) break;
                    this.roleGoblin.isActFrame = false;
                    this.screen.showFishInf = false;
                    this.screen.showHeadInf = false;
                    this.screen.showBossInf = false;
                    this.world.checkActionCol(this, this.comboH);
                    break;
                }
                case 22: {
                    if (this.isActing) break;
                    this.switchAction(8, false);
                    this.takeDamage();
                    n2 = 0;
                    n = 0;
                    if (this.curFace == 1) {
                        n2 = -this.flyVelX;
                    } else if (this.curFace == 2) {
                        n2 = this.flyVelX;
                    }
                    if (this.fly2 == 3) {
                        n = this.flyVelY1;
                    } else if (this.fly2 == 4) {
                        n = -this.flyVelY1;
                    } else if (this.fly2 == 1) {
                        n = this.flyVelY2;
                    } else if (this.fly2 == 2) {
                        n = -this.flyVelY2;
                    }
                    this.setVel(n2, n);
                    break;
                }
                case 23: {
                    if (this.isActing) break;
                    this.switchAction(9, false);
                    this.takeDamage();
                    n2 = 0;
                    n = 0;
                    if (this.curFace == 1) {
                        n2 = -this.flyVelX;
                    } else if (this.curFace == 2) {
                        n2 = this.flyVelX;
                    }
                    if (this.fly2 == 3) {
                        n = this.flyVelY1;
                    } else if (this.fly2 == 4) {
                        n = -this.flyVelY1;
                    } else if (this.fly2 == 1) {
                        n = this.flyVelY2;
                    } else if (this.fly2 == 2) {
                        n = -this.flyVelY2;
                    }
                    this.setVel(n2, n);
                    break;
                }
                case 101: {
                    this.switchAction(this.roleAction, false);
                    break;
                }
                case 112: {
                    if (this.isActing) break;
                    this.switchAction(20, false);
                    this.screen.pending = true;
                    this.screen.pendTime = System.currentTimeMillis();
                    this.screen.pendDura = 5000;
                    this.screen.pendFree = true;
                    this.screen.pause();
                    break;
                }
                case 113: {
                    if (!this.isActing) {
                        this.switchAction(21, false);
                        if (!this.screen.pending || !this.screen.pendFree) break;
                        this.screen.pendDura = 0;
                        break;
                    }
                    if (!this.roleGoblin.isActFrame) break;
                    this.roleGoblin.isActFrame = false;
                    this.roleGoblin.gplayer.isActFrame = false;
                    this.screen.showFishInf = false;
                    this.screen.showHeadInf = false;
                    this.screen.showBossInf = false;
                    this.world.checkGroundCol(this, 200, 200);
                    break;
                }
                case 111: {
                    if (this.isActing) break;
                    this.switchAction(4, false);
                    n2 = 0;
                    n = 0;
                    if (this.curFace == 1) {
                        n2 = -this.flyVelX;
                    } else if (this.curFace == 2) {
                        n2 = this.flyVelX;
                    }
                    if (this.fly2 == 3) {
                        n = this.flyVelY1;
                    } else if (this.fly2 == 4) {
                        n = -this.flyVelY1;
                    } else if (this.fly2 == 1) {
                        n = this.flyVelY2;
                    } else if (this.fly2 == 2) {
                        n = -this.flyVelY2;
                    }
                    this.setVel(n2, n);
                    break;
                }
                case 121: {
                    this.switchAction(22, false);
                    break;
                }
                case 122: {
                    this.switchAction(25, false);
                }
            }
            if (this.harming && System.currentTimeMillis() - this.harmTime > this.harmDura) {
                this.harming = false;
                this.collide = true;
                this.roleGoblin.flashing = false;
            }
        } else {
            if (this.traceSkill) {
                if (System.currentTimeMillis() - this.traceTime > this.traceDura) {
                    this.traceSkill = false;
                    switch (this.roleState) {
                        case 12: {
                            if (this.infoLib.skills[this.skillIdx].skillDura != 0L) {
                                this.infoLib.skills[this.skillIdx].enabled = false;
                                this.infoLib.skills[this.skillIdx].skillTime = System.currentTimeMillis();
                            }
                            this.setVel(0, 0);
                            this.roleState = 1;
                            this.isActing = false;
                        }
                    }
                } else {
                    this.enemyUpdateAI(l);
                }
                if (this.isActing && this.roleGoblin.getCycleTotal() > 0) {
                    this.isActing = false;
                    switch (this.roleState) {
                        case 12: {
                            this.switchAction(this.infoLib.skills[this.skillIdx].skillAction, true);
                        }
                    }
                }
            } else if (this.isActing && this.roleGoblin.getCycleTotal() > 0) {
                switch (this.roleState) {
                    case 1: 
                    case 3: 
                    case 6: {
                        this.roleState = 1;
                        this.isActing = false;
                        if (this.id % 100 != 85 || this.world.senState != 3) break;
                        this.roleState = 24;
                        this.isActing = false;
                        break;
                    }
                    case 4: {
                        this.setVel(0, 0);
                        this.roleState = 6;
                        this.isActing = false;
                        break;
                    }
                    case 5: {
                        this.setVel(0, 0);
                        this.roleState = this.hp == 0 ? 7 : 6;
                        this.isActing = false;
                        break;
                    }
                    case 7: {
                        this.suicide();
                        if (this.scriptDone == 1) {
                            this.screen.scriptDone = true;
                        }
                        if (this.id % 100 != 85) break;
                        this.world.senBattle = false;
                        this.world.senBodyGoblin = null;
                        this.world.senArmsGoblin = null;
                        break;
                    }
                    case 2: 
                    case 8: {
                        break;
                    }
                    case 12: {
                        if (this.infoLib.skills[this.skillIdx].skillDura != 0L) {
                            this.infoLib.skills[this.skillIdx].enabled = false;
                            this.infoLib.skills[this.skillIdx].skillTime = System.currentTimeMillis();
                        }
                        this.setVel(0, 0);
                        this.roleState = 1;
                        this.isActing = false;
                        if (this.infoLib.skills[this.skillIdx].id % 1000 != 851 || !this.world.rigorChange) break;
                        this.world.rigorChange = false;
                        this.world.rigorTime = System.currentTimeMillis();
                        if (this.infoLib.skills[this.skillIdx].id == 1851) {
                            this.world.rigorDura = 2000L;
                        } else if (this.infoLib.skills[this.skillIdx].id == 8851) {
                            this.world.rigorDura = 1000L;
                        }
                        this.world.senState = 3;
                        this.roleState = 24;
                        this.isActing = false;
                        break;
                    }
                    case 24: {
                        if (this.infoLib.skills[this.skillIdx].skillDura != 0L) {
                            this.infoLib.skills[this.skillIdx].enabled = false;
                            this.infoLib.skills[this.skillIdx].skillTime = System.currentTimeMillis();
                        }
                        this.setVel(0, 0);
                        this.roleState = 1;
                        this.isActing = false;
                        break;
                    }
                    case 101: {
                        this.roleState = 1;
                        this.isActing = false;
                        if (this.scriptDone != 1) break;
                        this.screen.scriptDone = true;
                        break;
                    }
                    case 111: {
                        this.setVel(0, 0);
                        this.roleState = 7;
                        this.isActing = false;
                        break;
                    }
                    case 114: {
                        this.roleState = 1;
                        this.isActing = false;
                        if (this.scriptDone != 1) break;
                        this.screen.scriptDone = true;
                        break;
                    }
                    case 115: {
                        this.suicide();
                        if (this.scriptDone != 1) break;
                        this.screen.scriptDone = true;
                        break;
                    }
                    case 121: 
                    case 123: {
                        if (this.scriptDone != 1) break;
                        this.screen.scriptDone = true;
                    }
                }
            }
            switch (this.roleState) {
                case 1: {
                    this.collide = true;
                    this.setAction(0, false);
                    this.setVel(0, 0);
                    this.enemyUpdateAI(l);
                    if (this.id % 100 != 85) break;
                    this.world.senState = 2;
                    break;
                }
                case 2: {
                    this.switchAction(1, true);
                    this.enemyUpdateAI(l);
                    break;
                }
                case 3: {
                    if (this.isActing) break;
                    this.switchAction(2, true);
                    this.takeDamage();
                    break;
                }
                case 4: {
                    if (this.isActing) break;
                    this.switchAction(3, true);
                    this.takeDamage();
                    break;
                }
                case 5: {
                    if (this.isActing) break;
                    this.switchAction(4, false);
                    this.takeDamage();
                    n2 = 0;
                    n = 0;
                    if (this.curFace == 1) {
                        n2 = -this.flyVelX;
                    } else if (this.curFace == 2) {
                        n2 = this.flyVelX;
                    }
                    if (this.fly2 == 3) {
                        n = this.flyVelY1;
                    } else if (this.fly2 == 4) {
                        n = -this.flyVelY1;
                    } else if (this.fly2 == 1) {
                        n = this.flyVelY2;
                    } else if (this.fly2 == 2) {
                        n = -this.flyVelY2;
                    }
                    this.setVel(n2, n);
                    break;
                }
                case 6: {
                    this.switchAction(5, false);
                    break;
                }
                case 7: {
                    if (this.isActing) break;
                    this.switchAction(6, false);
                    if (this.id % 100 != 85) break;
                    this.world.senState = 1;
                    break;
                }
                case 8: {
                    if (!this.isActing) {
                        this.switchAction(1, false);
                        switch (this.xMove) {
                            case 1: {
                                this.setVelX(this.xVel);
                                break;
                            }
                            case 2: {
                                this.setVelX(-this.xVel);
                            }
                        }
                        switch (this.yMove) {
                            case 3: {
                                this.setVelY(this.yVel);
                                break;
                            }
                            case 4: {
                                this.setVelY(-this.yVel);
                            }
                        }
                        this.holdTime = System.currentTimeMillis();
                        break;
                    }
                    if (System.currentTimeMillis() - this.holdTime > this.holdDura) {
                        if (this.xFP == this.lastXFP && this.yFP == this.lastYFP) {
                            this.roleTaken();
                            return;
                        }
                        this.holdTime = System.currentTimeMillis();
                    }
                    switch (this.xMove) {
                        case 1: {
                            if (this.x <= this.takePosX) break;
                            this.setVelX(0);
                            break;
                        }
                        case 2: {
                            if (this.x >= this.takePosX) break;
                            this.setVelX(0);
                        }
                    }
                    switch (this.yMove) {
                        case 3: {
                            if (this.y <= this.takePosY) break;
                            this.setVelY(0);
                            break;
                        }
                        case 4: {
                            if (this.y >= this.takePosY) break;
                            this.setVelY(0);
                        }
                    }
                    if (this.getVelX() != 0 || this.getVelY() != 0) break;
                    this.roleTaken();
                    break;
                }
                case 12: {
                    this.skill();
                    break;
                }
                case 24: {
                    this.switchAction(8, true);
                    break;
                }
                case 101: {
                    if (this.isActing) break;
                    this.switchAction(this.roleAction, false);
                    if (this.id % 100 != 85 || this.roleAction != 12) break;
                    this.world.senState = 1;
                    break;
                }
                case 111: {
                    if (this.isActing) break;
                    this.switchAction(4, false);
                    n2 = 0;
                    n = 0;
                    if (this.curFace == 1) {
                        n2 = -this.flyVelX;
                    } else if (this.curFace == 2) {
                        n2 = this.flyVelX;
                    }
                    if (this.fly2 == 3) {
                        n = this.flyVelY1;
                    } else if (this.fly2 == 4) {
                        n = -this.flyVelY1;
                    } else if (this.fly2 == 1) {
                        n = this.flyVelY2;
                    } else if (this.fly2 == 2) {
                        n = -this.flyVelY2;
                    }
                    this.setVel(n2, n);
                    break;
                }
                case 114: {
                    switch (this.id) {
                        case 382: 
                        case 682: 
                        case 691: 
                        case 692: {
                            this.switchAction(10, false);
                            break;
                        }
                        case 483: {
                            this.switchAction(11, false);
                        }
                    }
                    break;
                }
                case 115: {
                    switch (this.id) {
                        case 382: 
                        case 682: 
                        case 691: 
                        case 692: {
                            this.switchAction(10, false);
                            break;
                        }
                        case 483: {
                            this.switchAction(11, false);
                        }
                    }
                    break;
                }
                case 121: {
                    this.switchAction(11, false);
                    break;
                }
                case 123: {
                    this.switchAction(2, false);
                }
            }
            for (n2 = 0; n2 < this.infoLib.skills.length; ++n2) {
                if (this.infoLib.skills[n2].enabled || System.currentTimeMillis() - this.infoLib.skills[n2].skillTime <= this.infoLib.skills[n2].skillDura) continue;
                this.infoLib.skills[n2].enabled = true;
            }
            if (this.id % 100 == 85 && this.roleState == 24 && System.currentTimeMillis() - this.world.rigorTime > this.world.rigorDura) {
                this.setVel(0, 0);
                this.roleState = 1;
                this.isActing = false;
            }
        }
        if (this.roleGoblin != null) {
            if (this.roleGoblin.isEffFrame) {
                this.world.winShaX = 0;
                this.world.winShaY = 0;
                this.world.showBack = false;
                if (this.roleGoblin.effShake) {
                    switch (this.roleGoblin.shakeT) {
                        case 1: {
                            this.world.winShaY = -this.roleGoblin.shakeD;
                            break;
                        }
                        case 2: {
                            this.world.winShaY = this.roleGoblin.shakeD;
                            break;
                        }
                        case 3: {
                            this.world.winShaX = -this.roleGoblin.shakeD;
                            break;
                        }
                        case 4: {
                            this.world.winShaX = this.roleGoblin.shakeD;
                            break;
                        }
                        case 5: {
                            this.world.winShaY = -this.roleGoblin.shakeD;
                            this.world.winShaX = -this.roleGoblin.shakeD;
                            break;
                        }
                        case 6: {
                            this.world.winShaY = -this.roleGoblin.shakeD;
                            this.world.winShaX = this.roleGoblin.shakeD;
                            break;
                        }
                        case 7: {
                            this.world.winShaY = this.roleGoblin.shakeD;
                            this.world.winShaX = -this.roleGoblin.shakeD;
                            break;
                        }
                        case 8: {
                            this.world.winShaY = this.roleGoblin.shakeD;
                            this.world.winShaX = this.roleGoblin.shakeD;
                        }
                    }
                }
                if (this.roleGoblin.effColor) {
                    this.world.showBack = true;
                    switch (this.roleGoblin.colorT) {
                        case 11: {
                            this.world.backColor = 0xBB0000;
                            break;
                        }
                        case 12: {
                            this.world.backColor = 0xFFFFFF;
                        }
                    }
                }
                this.world.scrFrame = true;
            }
            if (this.roleGoblin.isSloFrame) {
                this.roleGoblin.isSloFrame = false;
                this.roleGoblin.gplayer.isSloFrame = false;
                this.screen.slowing = true;
                this.screen.slowTime = System.currentTimeMillis();
                this.screen.slowDura = this.roleGoblin.sloDura * 1000;
                this.screen.slowTimes = 3;
                if (this.roleGoblin.sloInfo == 1) {
                    this.world.player.xVel = this.world.roleMainVelX / this.screen.slowTimes;
                    this.world.player.yVel = this.world.roleMainVelY / this.screen.slowTimes;
                    this.world.player.flyVelX = this.world.roleFlyVelX / this.screen.slowTimes;
                    this.world.player.flyVelY1 = this.world.roleFlyVelY1 / this.screen.slowTimes;
                    this.world.player.flyVelY2 = this.world.roleFlyVelY2 / this.screen.slowTimes;
                    this.world.player.roleGoblin.gplayer.slowTimes = this.screen.slowTimes;
                    this.screen.slowFree = false;
                } else {
                    this.screen.slowFree = true;
                }
                for (Actor actor = this.world.enemyPool.getFirstUsed(); actor != null; actor = actor.getNextLinked()) {
                    Role role = (Role)actor;
                    if (role.roleState == 8) continue;
                    role.xVel = this.world.roleFishVelX / this.screen.slowTimes;
                    role.yVel = this.world.roleFishVelX / this.screen.slowTimes;
                    role.flyVelX = this.world.roleFlyVelX / this.screen.slowTimes;
                    role.flyVelY1 = this.world.roleFlyVelY1 / this.screen.slowTimes;
                    role.flyVelY2 = this.world.roleFlyVelY2 / this.screen.slowTimes;
                    role.roleGoblin.gplayer.slowTimes = this.screen.slowTimes;
                }
            }
        }
        if (this.showAlert) {
            this.alertGoblin.cycle(l);
            if (this.alertGoblin.getCycleTotal() > 0) {
                this.alertGoblin.reset();
                this.showAlert = false;
            }
        }
        if (this.showStrike) {
            this.strikeGoblin.cycle(l);
            if (this.strikeGoblin.getCycleTotal() > 0) {
                this.strikeGoblin.reset();
                this.showStrike = false;
            }
        }
        if (this.showPick) {
            this.pickGoblin.cycle(l);
            if (this.pickGoblin.getCycleTotal() > 0) {
                this.pickGoblin.reset();
                this.showPick = false;
            }
        }
        if (this.rageState) {
            this.rageGoblin.cycle(l);
        }
        if (this.showUpgrade) {
            this.world.upgradeGoblin.cycle(l);
            if (this.world.upgradeGoblin.getCycleTotal() > 0) {
                this.world.upgradeGoblin.reset();
                this.showUpgrade = false;
            }
        }
    }

    public final void suicide() {
        if (this.isPlayer()) {
            this.deactivate();
            if (this.screen.riseChance) {
                this.screen.riseChance = false;
                this.world.player.hp = this.world.player.infoLib.hpMax;
                this.world.player.sp = this.world.player.infoLib.spMax;
                this.world.player.roleState = 1;
                this.world.player.visible = true;
                this.world.player.collide = false;
                this.world.player.roleGoblin.flashing = true;
                this.world.player.harming = true;
                this.world.player.harmTime = System.currentTimeMillis();
                this.world.player.harmDura = 5000L;
            } else if (this.screen.buyLogs[1] > 3) {
                this.world.player.hp = this.world.player.infoLib.hpMax;
                this.world.player.sp = this.world.player.infoLib.spMax;
                this.world.player.roleState = 1;
                this.world.player.visible = true;
                this.world.player.collide = false;
                this.world.player.roleGoblin.flashing = true;
                this.world.player.harming = true;
                this.world.player.harmTime = System.currentTimeMillis();
                this.world.player.harmDura = 5000L;
            } else {
                this.screen.pause();
                this.screen.goMenu(Screen.MENU_STATE_RISENOW, 0);
            }
            if (this.screen.optionSound == 1 && this.screen.mplayer.mediaPlayer.getState() == 400) {
                this.screen.mplayer.stop();
            }
        } else {
            this.world.battle(this);
        }
    }

    public final void reset() {
        super.reset();
    }

    public final void render(Graphics graphics, int n, int n2) {
        if (this.showShadow) {
            this.shadowGoblin.draw(graphics, this.x - n + this.world.winOffX + this.world.winShaX, this.y - n2 + this.world.winOffY + this.world.winShaY);
        }
        this.roleGoblin.draw(graphics, this.x - n + this.world.winOffX + this.world.winShaX, this.y - n2 + this.world.winOffY + this.world.winShaY);
        if (this.showAlert) {
            this.alertGoblin.draw(graphics, this.x - n + this.world.winOffX + this.world.winShaX, this.y - n2 + this.world.winOffY + this.world.winShaY);
        }
        if (this.showStrike) {
            this.strikeGoblin.draw(graphics, this.x - n + this.world.winOffX + this.world.winShaX, this.y - n2 + this.world.winOffY + this.world.winShaY);
        }
        if (this.showPick) {
            this.pickGoblin.draw(graphics, this.x - n + this.world.winOffX + this.world.winShaX, this.y - n2 + this.world.winOffY + this.world.winShaY);
        }
        if (this.rageState) {
            this.rageGoblin.draw(graphics, this.x - n + this.world.winOffX + this.world.winShaX, this.y - n2 + this.world.winOffY + this.world.winShaY);
        }
        if (this.showUpgrade) {
            this.world.upgradeGoblin.draw(graphics, this.x - n + this.world.winOffX + this.world.winShaX, this.y - n2 + this.world.winOffY + this.world.winShaY);
        }
    }

    public final void setAction(int n, boolean bl) {
        if (this.subAnima > 0 && n < 3) {
            n += this.subAnima * 7;
        }
        if (this.id % 100 == 83 && n > 2 && n < 7) {
            n += this.subAnima * 7;
        }
        if (this.isPlayer()) {
            if (this.xFace == 1) {
                this.roleGoblin.setAction(n, bl, true);
            } else if (this.xFace == 2) {
                this.roleGoblin.setAction(n, bl, false);
            }
        } else if (this.id % 100 == 55) {
            if (this.curFace == 1) {
                this.roleGoblin.setAction(n, bl, true);
            } else if (this.curFace == 2) {
                this.roleGoblin.setAction(n, bl, false);
            }
        } else if (this.curFace == 1) {
            this.roleGoblin.setAction(n, bl, false);
        } else if (this.curFace == 2) {
            this.roleGoblin.setAction(n, bl, true);
        }
        this.roleAction = n;
    }

    public final void enemyUpdateAI(long l) {
        if (this.msSinceLastAIUpdate < (long)this.msPerAIUpdate) {
            this.msSinceLastAIUpdate += l;
            return;
        }
        this.msSinceLastAIUpdate -= (long)this.msPerAIUpdate;
        if (this.screen.gameState != Screen.GAME_STATE_PLAYING) {
            return;
        }
        if (this.screen.showGTip || this.screen.showETip || this.screen.showSTip || this.screen.showBTip) {
            return;
        }
        if (this.battle.state == 3) {
            return;
        }
        if (this.infoLib.skills == null) {
            return;
        }
        int n = this.world.player.x;
        int n2 = this.world.player.y;
        this.xFace = this.x > n ? 2 : 1;
        this.curFace = this.xFace;
        if (this.traceSkill) {
            int n3 = Box.getRand(1, 100);
            if (n3 < 51) {
                int n4 = 0;
                n4 = this.x > n ? -this.xVel : this.xVel;
                this.setVel(n4, 0);
            } else {
                int n5 = 0;
                if (this.y > n2) {
                    n5 = -this.yVel;
                } else if (this.y < n2) {
                    n5 = this.yVel;
                }
                this.setVel(0, n5);
            }
            return;
        }
        if (this.id % 100 == 85) {
            if (this.battle.state == 2) {
                int n6;
                int n7 = Math.abs(this.x - n);
                int n8 = this.infoLib.skills.length;
                int[] nArray = new int[n8];
                int[] nArray2 = new int[n8];
                for (n6 = 0; n6 < n8; ++n6) {
                    nArray[n6] = this.infoLib.skills[n6].skillDistance;
                    nArray2[n6] = this.infoLib.skills[n6].skillPercent;
                }
                if (n7 < 100) {
                    int n9;
                    n6 = Box.getRand(1, 100);
                    if (n6 < (n9 = 50)) {
                        this.enemyMotionX(this.x, n, false);
                    } else {
                        this.roleState = 1;
                    }
                } else if (n7 > 160) {
                    int n10;
                    n6 = Box.getRand(1, 100);
                    if (n6 < (n10 = 50)) {
                        this.enemyMotionX(this.x, n, true);
                    } else {
                        this.roleState = 1;
                    }
                } else {
                    n6 = Box.getRand(1, 100);
                    if (n6 < 80) {
                        this.skillIdx = 0;
                        this.enemySkill(this.skillIdx);
                    } else {
                        this.roleState = 1;
                    }
                }
            }
        } else if (this.battle.state == 0 && this.world.mapPatrol) {
            if (Box.isRectWithinRect(this.x - this.w, this.y - this.d, this.w * 2, this.d, this.battle.patrolArea.x, this.battle.patrolArea.y, this.battle.patrolArea.w, this.battle.patrolArea.h)) {
                int n11 = 10;
                int n12 = 10;
                int n13 = 10;
                int n14 = 10;
                this.enemyMotionRound(this.battle.patrolArea.x + this.battle.patrolArea.w / 2, this.battle.patrolArea.y + this.battle.patrolArea.h / 2, n11, n12, n13, n14);
            } else {
                int n15 = 40;
                int n16 = 40;
                this.enemyMotionClose(this.battle.patrolArea.x + this.battle.patrolArea.w / 2, this.battle.patrolArea.y + this.battle.patrolArea.h / 2, n15, n16);
            }
        } else if (this.battle.state == 2) {
            int n17;
            int n18 = Math.abs(this.x - n);
            int n19 = this.infoLib.skills.length;
            int[] nArray = new int[n19 + 1];
            int[] nArray3 = new int[n19 + 1];
            for (n17 = 0; n17 < n19; ++n17) {
                nArray[n17] = this.infoLib.skills[n17].skillDistance;
                nArray3[n17] = this.infoLib.skills[n17].skillPercent;
            }
            nArray[n19] = this.world.disPeace;
            nArray3[n19] = 0;
            for (n17 = 0; n17 < n19 + 1 && n18 <= nArray[n17]; ++n17) {
            }
            if (n17 == 0) {
                int n20 = 40;
                int n21 = 40;
                this.enemyMotionClose(n, n2, n20, n21);
            } else if (n17 < n19 + 1) {
                int n22 = 40;
                int n23 = 20;
                int n24 = 20;
                this.enemyAction(n, n2, n17 - 1, nArray3[n17 - 1], n22, n23, n24);
            } else {
                int n25 = 10;
                int n26 = 40;
                int n27 = 10;
                int n28 = 20;
                this.enemyMotionRound(n, n2, n25, n26, n27, n28);
            }
        }
    }

    public final void enemyMotionRound(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Box.getRand(1, 100);
        if (n7 < n3) {
            this.enemyMotionX(this.x, n, true);
            this.xFace = this.x > n ? 2 : 1;
            this.curFace = this.xFace;
        } else if (n7 < n3 + n4) {
            this.enemyMotionX(this.x, n, false);
            this.xFace = this.x > n ? 1 : 2;
            this.curFace = this.xFace;
        } else if (n7 < n3 + n4 + n5) {
            this.enemyMotionY(this.y, n2, true);
        } else if (n7 < n3 + n4 + n5 + n6) {
            this.enemyMotionY(this.y, n2, false);
        } else {
            this.roleState = 1;
        }
    }

    public final void enemyMotionClose(int n, int n2, int n3, int n4) {
        int n5 = Box.getRand(1, 100);
        if (n5 < n3) {
            this.enemyMotionX(this.x, n, true);
        } else if (n5 < n3 + n4) {
            this.enemyMotionY(this.y, n2, true);
        } else {
            this.roleState = 1;
        }
    }

    public final void enemyMotionX(int n, int n2, boolean bl) {
        if (this.roleState == 12) {
            return;
        }
        int n3 = 0;
        n3 = n > n2 ? -this.xVel : this.xVel;
        if (!bl) {
            n3 = -n3;
        }
        this.isActing = false;
        this.roleState = 2;
        this.setVel(n3, 0);
    }

    public final void enemyMotionY(int n, int n2, boolean bl) {
        if (this.roleState == 12) {
            return;
        }
        int n3 = 0;
        if (n > n2) {
            n3 = -this.yVel;
        } else if (n < n2) {
            n3 = this.yVel;
        }
        if (!bl) {
            n3 = -n3;
        }
        this.isActing = false;
        this.roleState = 2;
        this.setVel(0, n3);
    }

    public final void enemyAction(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 12;
        int n9 = Box.getRand(1, 100);
        if (this.y < n2 - n8 || this.y > n2 + n8) {
            if (n9 < n5) {
                this.enemyMotionY(this.y, n2, true);
            } else if (n9 < n5 + n6) {
                this.enemyMotionX(this.x, n, true);
            } else {
                this.roleState = 1;
            }
        } else if (n9 < n4) {
            this.enemySkill(n3);
        } else if (n9 <= n4 + n7) {
            this.enemyMotionX(this.x, n, true);
        } else {
            this.roleState = 1;
        }
    }

    public final void enemySkill(int n) {
        if (this.world.player.roleState != 6 && this.world.player.roleState != 7 && (this.roleState == 1 || this.roleState == 2) && this.infoLib.skills[n].enabled) {
            this.skillIdx = n;
            this.roleState = 12;
            this.isActing = false;
            this.setVel(0, 0);
        }
    }

    public final void switchAction(int n, boolean bl) {
        if (!this.isActing) {
            this.isActing = true;
            this.collide = bl;
            this.setAction(n, true);
        }
    }

    public final void skill() {
        if (!this.isActing) {
            int n = this.infoLib.skills[this.skillIdx].skillAction;
            this.switchAction(n, true);
            int n2 = this.infoLib.skills[this.skillIdx].skillSpeed;
            if (n2 > 0) {
                if (this.curFace == 1) {
                    this.setVel(n2, 0);
                } else if (this.curFace == 2) {
                    this.setVel(-n2, 0);
                }
            }
            this.rangeSkill = false;
            switch (this.infoLib.skills[this.skillIdx].id % 1000) {
                case 522: {
                    this.traceSkill = true;
                    this.traceTime = System.currentTimeMillis();
                }
            }
            if (this.infoLib.skills[this.skillIdx].id % 1000 == 851) {
                this.world.rigorChange = false;
            }
        } else if (this.roleGoblin.isActFrame) {
            this.roleGoblin.isActFrame = false;
            this.roleGoblin.gplayer.isActFrame = false;
            if (this.rangeSkill) {
                if (this.world.player.harming || !this.world.player.collide) {
                    return;
                }
                if (this.world.player.x > this.x) {
                    this.world.player.xFace = 2;
                } else if (this.world.player.x < this.x) {
                    this.world.player.xFace = 1;
                }
                this.world.player.curFace = this.xFace;
                if (this.roleGoblin.actType == 1) {
                    this.world.player.roleState = this.world.player.roleState == 4 ? 5 : 3;
                } else if (this.roleGoblin.actType == 2) {
                    this.world.player.roleState = 4;
                } else if (this.roleGoblin.actType == 3) {
                    this.world.player.roleState = 5;
                } else if (this.roleGoblin.actType == 4) {
                    this.world.player.roleState = 22;
                } else if (this.roleGoblin.actType == 5) {
                    this.world.player.roleState = 23;
                }
                this.world.player.isActing = false;
                this.world.player.setVel(0, 0);
                int n = 0;
                if (this.world.player.y < this.y - 5) {
                    n = 2;
                } else if (this.world.player.y < this.y - 1) {
                    n = 4;
                } else if (this.world.player.y > this.y + 1) {
                    n = 3;
                } else if (this.world.player.y > this.y + 5) {
                    n = 1;
                }
                this.world.player.fly2 = n;
                this.world.player.atter = this;
                return;
            }
            int n = this.comboH;
            if (this.infoLib.skills[this.skillIdx].id % 1000 == 851 || this.infoLib.skills[this.skillIdx].id % 1000 == 852) {
                n = Screen.scrH;
            }
            if (this.world.player.y > this.y - n && this.world.player.y < this.y + n) {
                if (this.world.player.harming || !this.world.player.collide) {
                    return;
                }
                int n3 = this.roleGoblin.gplayer.getNumberOfPositionRect();
                for (int i = 0; i < n3; ++i) {
                    int[] nArray = this.roleGoblin.gplayer.getPositionRect(i);
                    int n4 = this.x + nArray[0];
                    int n5 = this.y + nArray[1];
                    int n6 = nArray[2];
                    int n7 = nArray[3];
                    if (this.infoLib.skills[this.skillIdx].id % 1000 == 851 || this.infoLib.skills[this.skillIdx].id % 1000 == 852) {
                        if (!this.world.player.motionCollideWith(n4, 0, n6, 320)) continue;
                        if (Math.abs(this.world.player.x - this.x) < 120) {
                            if (this.world.player.x > this.x) {
                                this.world.player.xFace = 1;
                            } else if (this.world.player.x < this.x) {
                                this.world.player.xFace = 2;
                            }
                        } else if (this.world.player.x > this.x) {
                            this.world.player.xFace = 2;
                        } else if (this.world.player.x < this.x) {
                            this.world.player.xFace = 1;
                        }
                        this.world.player.curFace = this.world.player.xFace;
                        if (this.roleGoblin.actType == 4) {
                            this.world.player.roleState = 22;
                        } else if (this.roleGoblin.actType == 5) {
                            this.world.player.roleState = 23;
                        }
                        this.world.player.isActing = false;
                        this.world.player.setVel(0, 0);
                        this.world.player.fly2 = 3;
                        this.world.player.atter = this;
                        continue;
                    }
                    if (!this.world.player.actionCollideWith(n4, n5, n6, n7)) continue;
                    if (this.world.player.x > this.x) {
                        this.world.player.xFace = 2;
                    } else if (this.world.player.x < this.x) {
                        this.world.player.xFace = 1;
                    }
                    this.world.player.curFace = this.world.player.xFace;
                    if (this.roleGoblin.actType == 1) {
                        this.world.player.roleState = this.world.player.roleState == 4 ? 5 : 3;
                    } else if (this.roleGoblin.actType == 2) {
                        this.world.player.roleState = 4;
                    } else if (this.roleGoblin.actType == 3) {
                        this.world.player.roleState = 5;
                    } else if (this.roleGoblin.actType == 4) {
                        this.world.player.roleState = 22;
                    } else if (this.roleGoblin.actType == 5) {
                        this.world.player.roleState = 23;
                    }
                    this.world.player.isActing = false;
                    this.world.player.setVel(0, 0);
                    int n8 = 0;
                    if (this.world.player.y < this.y - 3) {
                        n8 = 4;
                    } else if (this.world.player.y > this.y + 3) {
                        n8 = 3;
                    }
                    this.world.player.fly2 = n8;
                    this.world.player.atter = this;
                }
            }
            if (this.infoLib.skills[this.skillIdx].id % 1000 == 851) {
                this.world.rigorChange = this.world.player.roleState != 22 && this.world.player.roleState != 23;
            }
        }
    }

    public final void roleTaken() {
        this.roleState = 1;
        if (this.scriptDone == 1) {
            this.screen.scriptDone = true;
        }
    }
}

